/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.python.actions;

import ai.grazie.model.task.library.v2.data.DataframeInfo;
import com.intellij.ml.llm.core.chat.session.ChatSourceAction;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.ExplainDataframeTaskCallBuilder;
import com.intellij.ml.llm.grazie.adapters.tasksFacade.PrivacySafeTaskCall;
import com.intellij.ml.llm.jupyter.common.actions.AbstractChatActionOnDataFrameAction;
import com.intellij.ml.llm.jupyter.common.utils.ExtensionsKt;
import com.intellij.ml.llm.jupyter.python.PyDataFramePromptUtils;
import com.intellij.ml.llm.jupyter.python.actions.UtilsKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.scientific.tables.api.DSDataFrameInfo;
import com.intellij.scientific.tables.api.DSPanelInfo;
import com.intellij.scientific.tables.api.DSTableDataRetrieverFromDataSource;
import com.intellij.scientific.tables.api.DSTableDataType;
import com.intellij.scientific.tables.panel.DSTable;
import com.intellij.scientific.tables.panel.DSTableKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0014\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/jupyter/python/actions/PyExplainDataFrameAction;", "Lcom/intellij/ml/llm/jupyter/common/actions/AbstractChatActionOnDataFrameAction;", "<init>", "()V", "getVariableData", "Lcom/intellij/ml/llm/jupyter/common/actions/AbstractChatActionOnDataFrameAction$Companion$VariableData;", "panelInfo", "Lcom/intellij/scientific/tables/api/DSPanelInfo;", "getActionNameForChatSessionStorage", "Lcom/intellij/ml/llm/core/chat/session/ChatSourceAction;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getDisplayText", "Lcom/intellij/ml/llm/privacy/PSString;", "dataFrameVariableName", "dataframeTypeShortName", "getTask", "Lcom/intellij/ml/llm/grazie/adapters/tasksFacade/PrivacySafeTaskCall;", "dataframeVariableName", "dataFrameInfo", "Lcom/intellij/scientific/tables/api/DSDataFrameInfo;", "getLegacyInternalText", "intellij.ml.llm.jupyter.python"})
final class PyExplainDataFrameAction
extends AbstractChatActionOnDataFrameAction {
    @Override
    @Nullable
    protected AbstractChatActionOnDataFrameAction.Companion.VariableData getVariableData(@NotNull DSPanelInfo panelInfo) {
        Intrinsics.checkNotNullParameter((Object)panelInfo, (String)"panelInfo");
        return UtilsKt.getVariableData(panelInfo);
    }

    @Override
    @NotNull
    protected ChatSourceAction getActionNameForChatSessionStorage() {
        return ChatSourceAction.PYTHON_EXPLAIN_DATA_FRAME;
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.checkAIAssistantAuthedAndAllowed(e) || ExtensionsKt.isJupyterAiIgnoredBlocked(e)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DSTable dSTable = (DSTable)e.getData(DSTableKt.getDS_TABLE_DATA_KEY());
        Object tableDataRetriever = dSTable != null ? dSTable.getTableDataRetrieverFromDataSource() : null;
        DSTableDataRetrieverFromDataSource dSTableDataRetrieverFromDataSource = tableDataRetriever;
        boolean isPythonNotebook = (dSTableDataRetrieverFromDataSource != null && (dSTableDataRetrieverFromDataSource = dSTableDataRetrieverFromDataSource.getDataFrameInfo()) != null ? dSTableDataRetrieverFromDataSource.getTableType() : null) != DSTableDataType.KOTLIN_DATAFRAME;
        e.getPresentation().setEnabledAndVisible(tableDataRetriever != null && tableDataRetriever.isDynamicTable() && isPythonNotebook);
    }

    @Override
    @NotNull
    protected PSString getDisplayText(@NotNull PSString dataFrameVariableName, @NotNull PSString dataframeTypeShortName) {
        Intrinsics.checkNotNullParameter((Object)dataFrameVariableName, (String)"dataFrameVariableName");
        Intrinsics.checkNotNullParameter((Object)dataframeTypeShortName, (String)"dataframeTypeShortName");
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{dataframeTypeShortName, dataFrameVariableName};
        return ConstantsKt.getPrivacyConst((String)"Explain Python %s: %s").format(pSStringConvertibleArray);
    }

    @Override
    @NotNull
    protected PrivacySafeTaskCall getTask(@NotNull PSString dataframeVariableName2, @NotNull DSDataFrameInfo dataFrameInfo) {
        Intrinsics.checkNotNullParameter((Object)dataframeVariableName2, (String)"dataframeVariableName");
        Intrinsics.checkNotNullParameter((Object)dataFrameInfo, (String)"dataFrameInfo");
        DataframeInfo dataframeInfo = PyDataFramePromptUtils.INSTANCE.getTaskDataframeInfo(dataframeVariableName2, dataFrameInfo);
        return new ExplainDataframeTaskCallBuilder(dataframeInfo).build();
    }

    @Override
    @NotNull
    protected PSString getLegacyInternalText(@NotNull PSString dataframeVariableName2, @NotNull DSDataFrameInfo dataFrameInfo) {
        Intrinsics.checkNotNullParameter((Object)dataframeVariableName2, (String)"dataframeVariableName");
        Intrinsics.checkNotNullParameter((Object)dataFrameInfo, (String)"dataFrameInfo");
        throw new IllegalStateException("Backend Task API should be called for the task");
    }
}

