/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.perforce;

import com.intellij.ml.llm.mcp.client.McpClientSystemRegistry;
import com.intellij.ml.llm.mcp.client.McpServerCommandDescriptor;
import com.intellij.ml.llm.mcp.client.McpServerDescriptor;
import com.intellij.ml.llm.mcp.perforce.PerforceMcpBundle;
import com.intellij.ml.llm.mcp.perforce.PerforceMcpConfigurable;
import com.intellij.ml.llm.mcp.perforce.PerforceMcpEnvSource;
import com.intellij.ml.llm.mcp.perforce.PerforceMcpSettings;
import com.intellij.ml.llm.mcp.perforce.PerforceMcpToolset;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4ConfigFields;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceLocalConnection;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J\b\u0010\u0014\u001a\u00020\u0007H\u0002J\b\u0010\u0015\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/mcp/perforce/PerforceMcpProvider;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tryRegister", "", "getConnectionParametersFromActiveConnections", "", "", "mcpSettings", "Lcom/intellij/ml/llm/mcp/perforce/PerforceMcpSettings;", "addIfNotExists", "descriptor", "Lcom/intellij/ml/llm/mcp/client/McpServerDescriptor;", "removeIfExists", "notificationShown", "", "updateMcpSettings", "performRegistration", "tryToShowNotification", "Companion", "intellij.ml.llm.mcp.perforce"})
@SourceDebugExtension(value={"SMAP\nPerforceMcpProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerforceMcpProvider.kt\ncom/intellij/ml/llm/mcp/perforce/PerforceMcpProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,188:1\n1#2:189\n1761#3,3:190\n504#4,7:193\n24#5:200\n*S KotlinDebug\n*F\n+ 1 PerforceMcpProvider.kt\ncom/intellij/ml/llm/mcp/perforce/PerforceMcpProvider\n*L\n113#1:190,3\n126#1:193,7\n51#1:200\n*E\n"})
public final class PerforceMcpProvider {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    private boolean notificationShown;
    @NotNull
    private static final String PERFORCE = "Perforce";
    @NotNull
    private static final String PERFORCE_MCP_ITEM_NAME = "Perforce MCP";
    @NotNull
    private static final String AI_NOTIFICATION_GROUP = "AI notification group";
    @NotNull
    private static final Logger logger;

    public PerforceMcpProvider(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    public final void tryRegister() {
        boolean exe;
        PerforceSettings p4 = PerforceSettings.getSettings((Project)this.project);
        boolean enabled = p4.ENABLED;
        if (!enabled) {
            return;
        }
        PerforceMcpSettings mcpSettings = PerforceMcpSettings.Companion.getInstance(this.project);
        String exePath = StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)mcpSettings.getMcpExecutablePath())).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        boolean bl = exe = ((CharSequence)exePath).length() > 0;
        if (exe) {
            Set<PerforceMcpToolset> ts;
            List list;
            Map env = switch (WhenMappings.$EnumSwitchMapping$0[mcpSettings.getEnvSource().ordinal()]) {
                case 1 -> MapsKt.emptyMap();
                case 2 -> this.getConnectionParametersFromActiveConnections(mcpSettings);
                case 3 -> {
                    String var12_11;
                    Map var9_6;
                    Map $this$tryRegister_u24lambda_u246 = var9_6 = MapsKt.createMapBuilder();
                    boolean $i$a$-buildMap-PerforceMcpProvider$tryRegister$env$1 = false;
                    String it = var12_11 = ((Object)StringsKt.trim((CharSequence)mcpSettings.getP4port())).toString();
                    boolean $i$a$-takeIf-PerforceMcpProvider$tryRegister$env$1$1 = false;
                    String v2 = ((CharSequence)it).length() > 0 ? var12_11 : null;
                    if (v2 != null) {
                        it = v2;
                        boolean $i$a$-let-PerforceMcpProvider$tryRegister$env$1$2 = false;
                        String v3 = P4ConfigFields.P4PORT.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
                        $this$tryRegister_u24lambda_u246.put(v3, it);
                    }
                    it = var12_11 = ((Object)StringsKt.trim((CharSequence)mcpSettings.getP4user())).toString();
                    boolean $i$a$-takeIf-PerforceMcpProvider$tryRegister$env$1$3 = false;
                    String v4 = ((CharSequence)it).length() > 0 ? var12_11 : null;
                    if (v4 != null) {
                        it = v4;
                        boolean $i$a$-let-PerforceMcpProvider$tryRegister$env$1$4 = false;
                        String v5 = P4ConfigFields.P4USER.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getName(...)");
                        $this$tryRegister_u24lambda_u246.put(v5, it);
                    }
                    it = var12_11 = ((Object)StringsKt.trim((CharSequence)mcpSettings.getP4client())).toString();
                    boolean $i$a$-takeIf-PerforceMcpProvider$tryRegister$env$1$5 = false;
                    String v6 = ((CharSequence)it).length() > 0 ? var12_11 : null;
                    if (v6 != null) {
                        it = v6;
                        boolean $i$a$-let-PerforceMcpProvider$tryRegister$env$1$6 = false;
                        String v7 = P4ConfigFields.P4CLIENT.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getName(...)");
                        $this$tryRegister_u24lambda_u246.put(v7, it);
                    }
                    yield MapsKt.build((Map)var9_6);
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            List $this$tryRegister_u24lambda_u248 = list = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            if (mcpSettings.getReadonly()) {
                $this$tryRegister_u24lambda_u248.add("--readonly");
            }
            if (mcpSettings.getAllowUsage()) {
                $this$tryRegister_u24lambda_u248.add("--allow-usage");
            }
            if ((ts = mcpSettings.getToolsets()) != null && !((Collection)ts).isEmpty()) {
                $this$tryRegister_u24lambda_u248.add("--toolsets");
                $this$tryRegister_u24lambda_u248.add(CollectionsKt.joinToString$default((Iterable)ts, (CharSequence)",", null, null, (int)0, null, PerforceMcpProvider::tryRegister$lambda$8$lambda$7, (int)30, null));
            }
            List args = CollectionsKt.build((List)list);
            McpServerCommandDescriptor descriptor2 = new McpServerCommandDescriptor(PERFORCE_MCP_ITEM_NAME, exePath, args, env, "");
            this.addIfNotExists(descriptor2);
        }
    }

    private final Map<String, String> getConnectionParametersFromActiveConnections(PerforceMcpSettings mcpSettings) {
        Map map2;
        block6: {
            String it;
            String chosenRoot = mcpSettings.getP4root();
            PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance((Project)this.project);
            Map map3 = connectionManager.getAllConnections();
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getAllConnections(...)");
            Map.Entry entry = (Map.Entry)SequencesKt.singleOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)MapsKt.asSequence((Map)map3), PerforceMcpProvider::getConnectionParametersFromActiveConnections$lambda$9), arg_0 -> PerforceMcpProvider.getConnectionParametersFromActiveConnections$lambda$10(chosenRoot, arg_0)));
            if (entry == null) {
                return MapsKt.emptyMap();
            }
            P4Connection connection2 = (P4Connection)entry.getValue();
            ConnectionKey connectionKey = connection2.getConnectionKey();
            Intrinsics.checkNotNullExpressionValue((Object)connectionKey, (String)"getConnectionKey(...)");
            ConnectionKey key = connectionKey;
            Map $this$getConnectionParametersFromActiveConnections_u24lambda_u2414 = map2 = MapsKt.createMapBuilder();
            boolean bl = false;
            String string = key.getServer();
            if (string != null) {
                it = string;
                boolean bl2 = false;
                if (!StringsKt.isBlank((CharSequence)it)) {
                    String string2 = P4ConfigFields.P4PORT.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    $this$getConnectionParametersFromActiveConnections_u24lambda_u2414.put(string2, it);
                }
            }
            String string3 = key.getUser();
            if (string3 != null) {
                it = string3;
                boolean bl3 = false;
                if (!StringsKt.isBlank((CharSequence)it)) {
                    String string4 = P4ConfigFields.P4USER.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
                    $this$getConnectionParametersFromActiveConnections_u24lambda_u2414.put(string4, it);
                }
            }
            String string5 = key.getClient();
            if (string5 == null) break block6;
            it = string5;
            boolean bl4 = false;
            if (!StringsKt.isBlank((CharSequence)it)) {
                String string6 = P4ConfigFields.P4CLIENT.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getName(...)");
                $this$getConnectionParametersFromActiveConnections_u24lambda_u2414.put(string6, it);
            }
        }
        return MapsKt.build((Map)map2);
    }

    private final void addIfNotExists(McpServerDescriptor descriptor2) {
        block7: {
            Object object;
            boolean existing;
            McpClientSystemRegistry registry;
            block6: {
                registry = McpClientSystemRegistry.Companion.getInstance();
                Iterable $this$any$iv = registry.getConfigurations(this.project).values();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        McpServerDescriptor it = (McpServerDescriptor)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)descriptor2.getName())) continue;
                        v0 = true;
                        break block6;
                    }
                    v0 = existing = false;
                }
            }
            if (existing) {
                return;
            }
            Object object2 = this;
            try {
                PerforceMcpProvider $this$addIfNotExists_u24lambda_u2416 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)registry.addConfiguration(descriptor2, $this$addIfNotExists_u24lambda_u2416.project));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block7;
            Object e = object = throwable;
            boolean bl = false;
            logger.error("Failed to add Perforce MCP configuration '" + descriptor2.getName() + "'", (Throwable)e);
        }
    }

    public final void removeIfExists() {
        block4: {
            Object object;
            McpClientSystemRegistry registry = McpClientSystemRegistry.Companion.getInstance();
            Map<Integer, McpServerDescriptor> $this$filterValues$iv = registry.getConfigurations(this.project);
            boolean $i$f$filterValues = false;
            LinkedHashMap<Integer, McpServerDescriptor> result$iv = new LinkedHashMap<Integer, McpServerDescriptor>();
            for (Map.Entry<Integer, McpServerDescriptor> entry$iv : $this$filterValues$iv.entrySet()) {
                McpServerDescriptor it = entry$iv.getValue();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)PERFORCE_MCP_ITEM_NAME)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Integer mcpServerItemId = (Integer)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).keySet());
            if (mcpServerItemId == null) {
                return;
            }
            Object object2 = this;
            try {
                PerforceMcpProvider $this$removeIfExists_u24lambda_u2419 = object2;
                boolean bl = false;
                registry.removeConfiguration(mcpServerItemId, $this$removeIfExists_u24lambda_u2419.project);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block4;
            Object e = object = throwable;
            boolean bl = false;
            logger.error("Failed to remove Perforce MCP configuration 'Perforce MCP'", (Throwable)e);
        }
    }

    public final void updateMcpSettings() {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        boolean isPerforceActive = vcsManager.checkVcsIsActive(PERFORCE);
        if (isPerforceActive) {
            this.removeIfExists();
            this.performRegistration();
        } else {
            this.removeIfExists();
        }
    }

    private final void performRegistration() {
        PerforceMcpSettings mcpSettings = PerforceMcpSettings.Companion.getInstance(this.project);
        if (StringsKt.isBlank((CharSequence)mcpSettings.getMcpExecutablePath())) {
            this.tryToShowNotification();
        } else {
            this.tryRegister();
        }
    }

    private final void tryToShowNotification() {
        if (this.notificationShown) {
            return;
        }
        NotificationGroupManager notificationGroupManager = NotificationGroupManager.getInstance();
        NotificationGroup notificationGroup = notificationGroupManager.getNotificationGroup(AI_NOTIFICATION_GROUP);
        Notification notification2 = notificationGroup.createNotification(PerforceMcpBundle.message("notification.perforce.mcp.detected.message", new Object[0]), NotificationType.INFORMATION);
        notification2.setTitle(PerforceMcpBundle.message("notification.perforce.mcp.detected.title", new Object[0]));
        notification2.addAction((AnAction)NotificationAction.createSimpleExpiring((String)PerforceMcpBundle.message("notification.perforce.mcp.detected.open.settings", new Object[0]), () -> PerforceMcpProvider.tryToShowNotification$lambda$21(this)));
        notification2.notify(this.project);
        this.notificationShown = true;
    }

    private static final CharSequence tryRegister$lambda$8$lambda$7(PerforceMcpToolset it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getValue();
    }

    private static final boolean getConnectionParametersFromActiveConnections$lambda$9(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !(it instanceof PerforceLocalConnection);
    }

    private static final boolean getConnectionParametersFromActiveConnections$lambda$10(String $chosenRoot, Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((P4Connection)it.getValue()).isConnected() && (StringsKt.isBlank((CharSequence)$chosenRoot) || Intrinsics.areEqual((Object)((VirtualFile)it.getKey()).getPath(), (Object)$chosenRoot));
    }

    private static final void tryToShowNotification$lambda$21(PerforceMcpProvider this$0) {
        ShowSettingsUtil.getInstance().showSettingsDialog(this$0.project, PerforceMcpConfigurable.class);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PerforceMcpProvider.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/mcp/perforce/PerforceMcpProvider$Companion;", "", "<init>", "()V", "PERFORCE", "", "PERFORCE_MCP_ITEM_NAME", "AI_NOTIFICATION_GROUP", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.ml.llm.mcp.perforce"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PerforceMcpEnvSource.values().length];
            try {
                nArray[PerforceMcpEnvSource.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PerforceMcpEnvSource.Project.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PerforceMcpEnvSource.Override.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

