/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.client.task;

import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.llm.nextEdits.client.task.NextEditTaskClientContext;
import com.intellij.ml.llm.nextEdits.client.task.NextEditTaskClientSuggestionTransformer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fJ\f\u0010\r\u001a\u00020\u000e*\u00020\u0005H\u0002J\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0005H\u0002J\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/nextEdits/client/task/TrimExtraBackticksSuggestionTransformer;", "Lcom/intellij/ml/llm/nextEdits/client/task/NextEditTaskClientSuggestionTransformer;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "transform", "suggestion", "context", "Lcom/intellij/ml/llm/nextEdits/client/task/NextEditTaskClientContext;", "(Ljava/lang/String;Lcom/intellij/ml/llm/nextEdits/client/task/NextEditTaskClientContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "endsWithBackticksOnNewLine", "", "takeLastBackticksWithWhitespaces", "newLinesAsRawSymbols", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "intellij.ml.llm.nextEdits"})
@SourceDebugExtension(value={"SMAP\nNextEditTaskClientSuggestionTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditTaskClientSuggestionTransformer.kt\ncom/intellij/ml/llm/nextEdits/client/task/TrimExtraBackticksSuggestionTransformer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,71:1\n621#2,6:72\n42#3:78\n14#4:79\n*S KotlinDebug\n*F\n+ 1 NextEditTaskClientSuggestionTransformer.kt\ncom/intellij/ml/llm/nextEdits/client/task/TrimExtraBackticksSuggestionTransformer\n*L\n64#1:72,6\n69#1:78\n69#1:79\n*E\n"})
final class TrimExtraBackticksSuggestionTransformer
implements NextEditTaskClientSuggestionTransformer {
    @NotNull
    public static final TrimExtraBackticksSuggestionTransformer INSTANCE;
    @NotNull
    private static final MLCompletionLogger LOG;

    private TrimExtraBackticksSuggestionTransformer() {
    }

    @Override
    @NotNull
    public String getId() {
        return "raw_suggestion_trim_extra_backticks";
    }

    @Override
    @Nullable
    public Object transform(@NotNull String suggestion, @NotNull NextEditTaskClientContext context2, @NotNull Continuation<? super String> $completion) {
        if (!Registry.Companion.is("llm.nextEdit.transformer.trim.extra.backticks")) {
            return suggestion;
        }
        if (!this.endsWithBackticksOnNewLine(suggestion)) {
            return suggestion;
        }
        String editableRegion = context2.getParams().getEditableRegionPrefix() + context2.getParams().getEditableRegionSuffix();
        if (this.endsWithBackticksOnNewLine(editableRegion)) {
            return suggestion;
        }
        String endToTrim = this.takeLastBackticksWithWhitespaces(suggestion);
        String newEnd = this.takeLastBackticksWithWhitespaces(editableRegion);
        LOG.debug(() -> TrimExtraBackticksSuggestionTransformer.transform$lambda$0(endToTrim, newEnd));
        return StringsKt.removeSuffix((String)suggestion, (CharSequence)endToTrim) + this.takeLastBackticksWithWhitespaces(editableRegion);
    }

    private final boolean endsWithBackticksOnNewLine(String $this$endsWithBackticksOnNewLine) {
        return StringsKt.endsWith$default((String)((Object)StringsKt.trimEnd((CharSequence)$this$endsWithBackticksOnNewLine)).toString(), (String)"\n```", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String takeLastBackticksWithWhitespaces(String $this$takeLastBackticksWithWhitespaces) {
        String string;
        block1: {
            void var2_2;
            String $this$takeLastWhile$iv = $this$takeLastBackticksWithWhitespaces;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '`' || CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string3 = string2.substring(n);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var2_2;
        }
        return string;
    }

    private final String newLinesAsRawSymbols(String $this$newLinesAsRawSymbols) {
        return StringsKt.replace$default((String)$this$newLinesAsRawSymbols, (String)"\n", (String)"\\n", (boolean)false, (int)4, null);
    }

    private static final String transform$lambda$0(String $endToTrim, String $newEnd) {
        return "Extra backticks were replaced: '" + INSTANCE.newLinesAsRawSymbols($endToTrim) + "' -> '" + INSTANCE.newLinesAsRawSymbols($newEnd) + "'";
    }

    static {
        TrimExtraBackticksSuggestionTransformer $this$thisNextEditLogger$iv = INSTANCE = new TrimExtraBackticksSuggestionTransformer();
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TrimExtraBackticksSuggestionTransformer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
    }
}

