/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.context;

import com.intellij.ml.llm.nextEdits.context.Excerpt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007\u001a\u001c\u0010\b\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\f\u001a\u00020\t*\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002\u001a\u001c\u0010\u000e\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\t*\u00020\u00032\u0006\u0010\n\u001a\u00020\tH\u0002\u001a!\u0010\u0012\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0013*\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0000\u001a\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u001b\u001a\u00020\u0005*\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0005H\u0002\u00a8\u0006\u001c"}, d2={"buildExcerpt", "Lcom/intellij/ml/llm/nextEdits/context/Excerpt;", "document", "Lcom/intellij/openapi/editor/Document;", "editableRegionTokenLimit", "", "contextTokenLimit", "caretOffset", "findRange", "Lkotlin/ranges/IntRange;", "initialRange", "remainingTokens", "atLeast", "range", "expandRange", "estimateTokenCount", "", "trimBlank", "getText", "Lcom/intellij/openapi/util/NlsSafe;", "fromIndex", "toIndex", "isBlankLine", "", "lineNumber", "lineStartOffset", "offset", "lineEndOffset", "intellij.ml.llm.nextEdits"})
public final class ExcerptKt {
    @RequiresReadLock
    @ApiStatus.Internal
    @NotNull
    public static final Excerpt buildExcerpt(@NotNull Document document2, int editableRegionTokenLimit, int contextTokenLimit, int caretOffset) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        IntRange initialRange = new IntRange(caretOffset, caretOffset);
        IntRange editableRange = ExcerptKt.findRange(document2, initialRange, editableRegionTokenLimit);
        IntRange contextRange = ExcerptKt.findRange(document2, editableRange, contextTokenLimit);
        return new Excerpt(contextRange.getFirst(), editableRange.getFirst(), editableRange.getLast(), contextRange.getLast());
    }

    private static final IntRange findRange(Document $this$findRange, IntRange initialRange, int remainingTokens) {
        return ExcerptKt.atLeast(ExcerptKt.trimBlank($this$findRange, ExcerptKt.expandRange($this$findRange, initialRange, remainingTokens)), initialRange);
    }

    private static final IntRange atLeast(IntRange $this$atLeast, IntRange range) {
        return new IntRange(Math.min($this$atLeast.getFirst(), range.getFirst()), Math.max($this$atLeast.getLast(), range.getLast()));
    }

    private static final IntRange expandRange(Document $this$expandRange, IntRange initialRange, int remainingTokens) {
        int tokensLeft = remainingTokens;
        int start2 = ExcerptKt.lineStartOffset($this$expandRange, initialRange.getFirst());
        int end = ExcerptKt.lineEndOffset($this$expandRange, initialRange.getLast());
        tokensLeft -= ExcerptKt.estimateTokenCount(ExcerptKt.getText($this$expandRange, start2, end));
        while (tokensLeft > 0) {
            int lineTokens;
            boolean expanded = false;
            if (start2 > 0) {
                int prevLineStart = ExcerptKt.lineStartOffset($this$expandRange, start2 - 1);
                String string = $this$expandRange.getText(new TextRange(prevLineStart, start2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                lineTokens = ExcerptKt.estimateTokenCount(string);
                if (tokensLeft >= lineTokens) {
                    start2 = prevLineStart;
                    tokensLeft -= lineTokens;
                    expanded = true;
                }
            }
            if (tokensLeft > 0 && end < $this$expandRange.getTextLength()) {
                int nextLineEnd = ExcerptKt.lineEndOffset($this$expandRange, end + 1);
                String string = $this$expandRange.getText(new TextRange(end, nextLineEnd));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                lineTokens = ExcerptKt.estimateTokenCount(string);
                if (tokensLeft >= lineTokens) {
                    end = nextLineEnd;
                    tokensLeft -= lineTokens;
                    expanded = true;
                }
            }
            if (expanded) continue;
        }
        return new IntRange(start2, end);
    }

    private static final int estimateTokenCount(String $this$estimateTokenCount) {
        return RangesKt.coerceAtLeast((int)($this$estimateTokenCount.length() / 3), (int)1);
    }

    private static final IntRange trimBlank(Document $this$trimBlank, IntRange initialRange) {
        if (initialRange.isEmpty()) {
            return initialRange;
        }
        int start2 = initialRange.getFirst();
        int end = initialRange.getLast();
        int lineNumber = $this$trimBlank.getLineNumber(start2);
        int lastLine = $this$trimBlank.getLineNumber(end);
        while (lineNumber < lastLine && ExcerptKt.isBlankLine($this$trimBlank, lineNumber)) {
            start2 = $this$trimBlank.getLineStartOffset(++lineNumber);
        }
        lineNumber = lastLine;
        int firstLine = $this$trimBlank.getLineNumber(start2);
        while (lineNumber > firstLine && ExcerptKt.isBlankLine($this$trimBlank, lineNumber)) {
            end = $this$trimBlank.getLineEndOffset(--lineNumber);
        }
        return new IntRange(start2, end);
    }

    @NotNull
    public static final String getText(@NotNull Document $this$getText, int fromIndex, int toIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getText, (String)"<this>");
        String string = $this$getText.getText(new TextRange(fromIndex, toIndex));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    private static final boolean isBlankLine(Document $this$isBlankLine, int lineNumber) {
        int lineStart = $this$isBlankLine.getLineStartOffset(lineNumber);
        int lineEnd = $this$isBlankLine.getLineEndOffset(lineNumber);
        return StringsKt.isBlank((CharSequence)ExcerptKt.getText($this$isBlankLine, lineStart, lineEnd));
    }

    private static final int lineStartOffset(Document $this$lineStartOffset, int offset) {
        return DocumentUtil.getLineStartOffset((int)offset, (Document)$this$lineStartOffset);
    }

    private static final int lineEndOffset(Document $this$lineEndOffset, int offset) {
        return DocumentUtil.getLineEndOffset((int)offset, (Document)$this$lineEndOffset);
    }
}

