/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.pipeline;

import ai.grazie.nlp.utils.RangesKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.llm.nextEdits.pipeline.diff.NextEditDiff;
import com.intellij.ml.llm.nextEdits.pipeline.iterationFilter.NextEditFileIterationFilter;
import com.intellij.ml.llm.nextEdits.session.NextEditFileIteration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002*+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\u0014\u0010 \u001a\u00020\u000b*\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J\f\u0010#\u001a\u00020\u0012*\u00020\u0005H\u0002J\f\u0010$\u001a\u00020\u000b*\u00020\u0016H\u0002J\u0014\u0010$\u001a\u00020\u000b*\u00020%2\u0006\u0010&\u001a\u00020'H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0012X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter;", "Lcom/intellij/ml/llm/nextEdits/pipeline/iterationFilter/NextEditFileIterationFilter;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "description", "getDescription", "check", "", "iteration", "Lcom/intellij/ml/llm/nextEdits/session/NextEditFileIteration;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/ml/llm/nextEdits/session/NextEditFileIteration;Lcom/intellij/openapi/editor/Editor;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "SINGLE_LINE_LENGTH_TO_BE_CONSIDERED_AS_LONG_REPETITION", "", "MAX_LINES_TO_ANALYZE", "containsRepetition", "diff", "Lcom/intellij/ml/llm/nextEdits/pipeline/diff/NextEditDiff;", "getTextAroundRange", "Lcom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter$TextAround;", "text", "startOffset", "endOffset", "MAX_SYMBOLS_TO_SEARCH_FOR_END_OR_START_LINE", "findLineStart", "startIndex", "findLineEnd", "contains", "Lkotlin/ranges/IntRange;", "other", "meaningfulLength", "containsNewLine", "Lcom/intellij/ml/llm/nextEdits/pipeline/diff/NextEditDiff$Change;", "contentUpdate", "Lcom/intellij/ml/llm/nextEdits/pipeline/diff/NextEditDiff$ContentUpdate;", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "TextAround", "EqualityChecker", "intellij.ml.llm.nextEdits"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nDirectCodeRepetitionNextEditFileIterationFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectCodeRepetitionNextEditFileIterationFilter.kt\ncom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,251:1\n2746#2,3:252\n2746#2,3:255\n1563#2:264\n1634#2,3:265\n1563#2:268\n1634#2,3:269\n1761#2,3:275\n1104#3,3:258\n1104#3,3:261\n1104#3,3:272\n1104#3,3:278\n1104#3,3:281\n42#4:284\n14#5:285\n*S KotlinDebug\n*F\n+ 1 DirectCodeRepetitionNextEditFileIterationFilter.kt\ncom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter\n*L\n35#1:252,3\n49#1:255,3\n78#1:264\n78#1:265,3\n85#1:268\n85#1:269,3\n193#1:275,3\n70#1:258,3\n73#1:261,3\n186#1:272,3\n201#1:278,3\n202#1:281,3\n249#1:284\n249#1:285\n*E\n"})
public final class DirectCodeRepetitionNextEditFileIterationFilter
implements NextEditFileIterationFilter {
    @NotNull
    public static final DirectCodeRepetitionNextEditFileIterationFilter INSTANCE;
    private static final int SINGLE_LINE_LENGTH_TO_BE_CONSIDERED_AS_LONG_REPETITION = 25;
    private static final int MAX_LINES_TO_ANALYZE = 30;
    private static final int MAX_SYMBOLS_TO_SEARCH_FOR_END_OR_START_LINE = 200;
    @NotNull
    private static final MLCompletionLogger LOG;

    private DirectCodeRepetitionNextEditFileIterationFilter() {
    }

    @Override
    @NotNull
    public String getId() {
        return "iter_direct_code_repetition";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "One of the diffs' changes contains a repetition of the code around";
    }

    @Override
    @Nullable
    public Object check(@NotNull NextEditFileIteration iteration, @NotNull Editor editor2, @NotNull Continuation<? super Boolean> $completion) {
        boolean bl;
        block4: {
            if (!Registry.Companion.is("llm.nextEdit.filter.repetitions")) {
                return Boxing.boxBoolean((boolean)true);
            }
            Iterable $this$none$iv = iteration.getDiffs();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    NextEditDiff it = (NextEditDiff)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.containsRepetition(iteration, it)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return Boxing.boxBoolean((boolean)bl);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsRepetition(NextEditFileIteration iteration, NextEditDiff diff2) {
        int n;
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        int element$iv4;
        boolean bl;
        block18: {
            Iterable $this$none$iv = diff2.getContentUpdate().getChanges();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv2 : $this$none$iv) {
                    NextEditDiff.Change it = (NextEditDiff.Change)element$iv2;
                    boolean bl2 = false;
                    if (!(it instanceof NextEditDiff.Change.Insert)) continue;
                    bl = false;
                    break block18;
                }
                bl = true;
            }
        }
        if (bl) {
            LOG.debug("Skipping repetition check for a diff without insertions.");
            return false;
        }
        if (!this.containsNewLine(diff2)) {
            LOG.debug("Skipping repetition check for a diff without new lines.");
            return false;
        }
        if (diff2.getFragment().getEndLine2() - diff2.getFragment().getStartLine2() > 30) {
            LOG.debug("Skipping repetition check for a diff with too many lines: " + diff2.getFragment() + ". It may affect performance.");
            return false;
        }
        TextAround textAroundDiff = this.getTextAroundRange(iteration.getFileAfter(), diff2.getFragment().getStartOffset2(), diff2.getFragment().getEndOffset2());
        String text2 = textAroundDiff.getText();
        CharSequence $this$count$iv = StringsKt.take((String)text2, (int)textAroundDiff.getRelativeStartOffset());
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            int it = element$iv4 = $this$count$iv.charAt(i);
            boolean bl3 = false;
            if (!(it == 10)) continue;
            ++count$iv;
        }
        int diffStartLine = count$iv;
        CharSequence $this$count$iv2 = StringsKt.take((String)text2, (int)Math.max(textAroundDiff.getRelativeStartOffset(), textAroundDiff.getRelativeEndOffset() - 1));
        boolean $i$f$count2 = false;
        int count$iv2 = 0;
        for (element$iv4 = 0; element$iv4 < $this$count$iv2.length(); ++element$iv4) {
            char element$iv3;
            char it = element$iv3 = $this$count$iv2.charAt(element$iv4);
            boolean bl4 = false;
            if (!(it == '\n')) continue;
            ++count$iv2;
        }
        int diffEndLine = count$iv2;
        Iterable $this$map$iv = StringsKt.lines((CharSequence)text2);
        boolean $i$f$map = false;
        Iterable element$iv4 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        List textLines = (List)destination$iv$iv;
        if (diffStartLine > textLines.size() || diffEndLine > textLines.size()) {
            LOG.error("Skipping repetition check because offsets are out of bounds: " + diffStartLine + ", " + diffEndLine + ", " + textLines.size() + ".");
            return false;
        }
        Iterable $this$map$iv2 = textLines;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String bl5 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl6 = false;
            collection.add(INSTANCE.meaningfulLength((String)it));
        }
        List linesMeaningfulLength = (List)destination$iv$iv2;
        EqualityChecker equalityChecker = new EqualityChecker(textLines);
        IntRange diffRange = new IntRange(diffStartLine, diffEndLine);
        int suspiciousStartLine = diffRange.getFirst();
        if (suspiciousStartLine <= (n = diffRange.getLast())) {
            block5: do {
                int suspiciousEndLine;
                int currentMeaningfulLength = 0;
                int nonBlankLines = 0;
                if ((suspiciousEndLine = ++suspiciousStartLine) > diffEndLine) continue;
                while (true) {
                    currentMeaningfulLength += ((Number)linesMeaningfulLength.get(suspiciousEndLine)).intValue();
                    if (((Number)linesMeaningfulLength.get(suspiciousEndLine)).intValue() > 0) {
                        ++nonBlankLines;
                    }
                    if (nonBlankLines > 1 || currentMeaningfulLength >= 25) {
                        IntRange currentRange = new IntRange(suspiciousStartLine, suspiciousEndLine);
                        int linesLength = RangesKt.getLength((IntRange)currentRange);
                        if (suspiciousStartLine >= linesLength && DirectCodeRepetitionNextEditFileIterationFilter.containsRepetition$isRepetition(diffRange, equalityChecker, currentRange, kotlin.ranges.RangesKt.until((int)(suspiciousStartLine - linesLength), (int)suspiciousStartLine))) {
                            return true;
                        }
                        if (suspiciousEndLine + linesLength < textLines.size() && DirectCodeRepetitionNextEditFileIterationFilter.containsRepetition$isRepetition(diffRange, equalityChecker, currentRange, new IntRange(suspiciousEndLine + 1, suspiciousEndLine + linesLength))) {
                            return true;
                        }
                    }
                    if (suspiciousEndLine == diffEndLine) continue block5;
                    ++suspiciousEndLine;
                }
            } while (suspiciousStartLine != n);
        }
        return false;
    }

    private final TextAround getTextAroundRange(String text2, int startOffset, int endOffset) {
        int length = endOffset - startOffset;
        int aroundStartOffset = this.findLineStart(text2, Math.max(0, startOffset - length));
        int aroundEndOffset = this.findLineEnd(text2, Math.min(text2.length(), endOffset + length));
        if (aroundStartOffset < 0 || aroundEndOffset > text2.length() || aroundStartOffset > aroundEndOffset) {
            LOG.error("Invalid offsets: " + aroundStartOffset + ", " + aroundEndOffset + ", " + text2.length());
            aroundStartOffset = kotlin.ranges.RangesKt.coerceIn((int)aroundStartOffset, (int)0, (int)text2.length());
            aroundEndOffset = kotlin.ranges.RangesKt.coerceIn((int)aroundEndOffset, (int)aroundStartOffset, (int)text2.length());
        }
        int relativeStart = startOffset - aroundStartOffset;
        int relativeEnd = endOffset - aroundStartOffset;
        String string = text2.substring(aroundStartOffset, aroundEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String aroundText = string;
        return new TextAround(aroundText, relativeStart, relativeEnd);
    }

    private final int findLineStart(String text2, int startIndex) {
        int result2;
        for (result2 = startIndex; result2 > 0 && text2.charAt(result2 - 1) != '\n' && startIndex - result2 < 200; --result2) {
        }
        return result2;
    }

    private final int findLineEnd(String text2, int startIndex) {
        if (startIndex == text2.length() || text2.charAt(startIndex) == '\n') {
            return startIndex;
        }
        int result2 = startIndex;
        while (result2 + 1 < text2.length() && text2.charAt(result2 + 1) != '\n' && result2 - startIndex < 200) {
            ++result2;
        }
        return result2;
    }

    private final boolean contains(IntRange $this$contains, IntRange other) {
        return $this$contains.getFirst() <= other.getFirst() && other.getLast() <= $this$contains.getLast();
    }

    private final int meaningfulLength(String $this$meaningfulLength) {
        CharSequence $this$count$iv = $this$meaningfulLength;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(!CharsKt.isWhitespace((char)it))) continue;
            ++count$iv;
        }
        return count$iv;
    }

    private final boolean containsNewLine(NextEditDiff $this$containsNewLine) {
        boolean bl;
        block4: {
            if ($this$containsNewLine.getFragment().getEndLine2() - $this$containsNewLine.getFragment().getStartLine2() > $this$containsNewLine.getFragment().getEndLine1() - $this$containsNewLine.getFragment().getStartLine1()) {
                return true;
            }
            Iterable $this$any$iv = $this$containsNewLine.getContentUpdate().getChanges();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NextEditDiff.Change it = (NextEditDiff.Change)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.containsNewLine(it, $this$containsNewLine.getContentUpdate())) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsNewLine(NextEditDiff.Change $this$containsNewLine, NextEditDiff.ContentUpdate contentUpdate) {
        boolean bl;
        NextEditDiff.Change change = $this$containsNewLine;
        if (change instanceof NextEditDiff.Change.Delete) {
            bl = false;
        } else if (change instanceof NextEditDiff.Change.Insert) {
            bl = StringsKt.contains$default((CharSequence)((NextEditDiff.Change.Insert)$this$containsNewLine).getNewContent(), (char)'\n', (boolean)false, (int)2, null);
        } else if (change instanceof NextEditDiff.Change.Replace) {
            void $this$count$iv;
            String string = contentUpdate.getBefore().substring(((NextEditDiff.Change.Replace)$this$containsNewLine).getStartOffset(), ((NextEditDiff.Change.Replace)$this$containsNewLine).getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            CharSequence charSequence = string;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == '\n')) continue;
                ++count$iv;
            }
            int beforeLines = count$iv;
            CharSequence $this$count$iv2 = ((NextEditDiff.Change.Replace)$this$containsNewLine).getNewContent();
            boolean $i$f$count2 = false;
            int count$iv2 = 0;
            for (int i = 0; i < $this$count$iv2.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv2.charAt(i);
                boolean bl3 = false;
                if (!(it == '\n')) continue;
                ++count$iv2;
            }
            int afterLines = count$iv2;
            bl = afterLines > beforeLines;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private static final boolean containsRepetition$isRepetition(IntRange diffRange, EqualityChecker equalityChecker, IntRange currentRange, IntRange candidate) {
        return !INSTANCE.contains(diffRange, candidate) && equalityChecker.isEqual(candidate, currentRange);
    }

    static {
        DirectCodeRepetitionNextEditFileIterationFilter $this$thisNextEditLogger$iv = INSTANCE = new DirectCodeRepetitionNextEditFileIterationFilter();
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DirectCodeRepetitionNextEditFileIterationFilter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.NextEdit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter$EqualityChecker;", "", "items", "", "<init>", "(Ljava/util/List;)V", "cache", "", "", "[[Ljava/lang/Boolean;", "isEqual", "range1", "Lkotlin/ranges/IntRange;", "range2", "index1", "", "index2", "intellij.ml.llm.nextEdits"})
    @SourceDebugExtension(value={"SMAP\nDirectCodeRepetitionNextEditFileIterationFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectCodeRepetitionNextEditFileIterationFilter.kt\ncom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter$EqualityChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,251:1\n1740#2,3:252\n1#3:255\n*S KotlinDebug\n*F\n+ 1 DirectCodeRepetitionNextEditFileIterationFilter.kt\ncom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter$EqualityChecker\n*L\n233#1:252,3\n*E\n"})
    private static final class EqualityChecker {
        @NotNull
        private final List<Object> items;
        @NotNull
        private final Boolean[][] cache;

        public EqualityChecker(@NotNull List<? extends Object> items2) {
            Intrinsics.checkNotNullParameter(items2, (String)"items");
            this.items = items2;
            int n = this.items.size();
            Boolean[][] booleanArrayArray = new Boolean[n][];
            EqualityChecker equalityChecker = this;
            for (int i = 0; i < n; ++i) {
                int n2 = i;
                int n3 = 0;
                Boolean[] booleanArray = new Boolean[n2];
                int n4 = n2;
                Boolean[][] booleanArrayArray2 = booleanArrayArray;
                while (n3 < n2) {
                    int n5 = n3++;
                    booleanArray[n5] = null;
                }
                booleanArrayArray2[n4] = booleanArray;
            }
            equalityChecker.cache = booleanArrayArray;
        }

        public final boolean isEqual(@NotNull IntRange range1, @NotNull IntRange range2) {
            boolean bl;
            block5: {
                Intrinsics.checkNotNullParameter((Object)range1, (String)"range1");
                Intrinsics.checkNotNullParameter((Object)range2, (String)"range2");
                if (RangesKt.getLength((IntRange)range1) != RangesKt.getLength((IntRange)range2)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)range1, (Object)range2)) {
                    return true;
                }
                Iterable $this$all$iv = CollectionsKt.zip((Iterable)((Iterable)range1), (Iterable)((Iterable)range2));
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        int index2;
                        Pair pair = (Pair)element$iv;
                        boolean bl2 = false;
                        int index1 = ((Number)pair.component1()).intValue();
                        if (this.isEqual(index1, index2 = ((Number)pair.component2()).intValue())) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }

        private final boolean isEqual(int index1, int index2) {
            int actualIndex2;
            if (index1 == index2) {
                return true;
            }
            int actualIndex1 = Math.max(index1, index2);
            Boolean bl = this.cache[actualIndex1][actualIndex2 = Math.min(index1, index2)];
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                return it;
            }
            boolean result2 = Intrinsics.areEqual((Object)this.items.get(actualIndex1), (Object)this.items.get(actualIndex2));
            this.cache[actualIndex1][actualIndex2] = result2;
            return result2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/nextEdits/pipeline/DirectCodeRepetitionNextEditFileIterationFilter$TextAround;", "", "text", "", "relativeStartOffset", "", "relativeEndOffset", "<init>", "(Ljava/lang/String;II)V", "getText", "()Ljava/lang/String;", "getRelativeStartOffset", "()I", "getRelativeEndOffset", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "intellij.ml.llm.nextEdits"})
    private static final class TextAround {
        @NotNull
        private final String text;
        private final int relativeStartOffset;
        private final int relativeEndOffset;

        public TextAround(@NotNull String text2, int relativeStartOffset, int relativeEndOffset) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            this.text = text2;
            this.relativeStartOffset = relativeStartOffset;
            this.relativeEndOffset = relativeEndOffset;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final int getRelativeStartOffset() {
            return this.relativeStartOffset;
        }

        public final int getRelativeEndOffset() {
            return this.relativeEndOffset;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        public final int component2() {
            return this.relativeStartOffset;
        }

        public final int component3() {
            return this.relativeEndOffset;
        }

        @NotNull
        public final TextAround copy(@NotNull String text2, int relativeStartOffset, int relativeEndOffset) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            return new TextAround(text2, relativeStartOffset, relativeEndOffset);
        }

        public static /* synthetic */ TextAround copy$default(TextAround textAround, String string, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = textAround.text;
            }
            if ((n3 & 2) != 0) {
                n = textAround.relativeStartOffset;
            }
            if ((n3 & 4) != 0) {
                n2 = textAround.relativeEndOffset;
            }
            return textAround.copy(string, n, n2);
        }

        @NotNull
        public String toString() {
            return "TextAround(text=" + this.text + ", relativeStartOffset=" + this.relativeStartOffset + ", relativeEndOffset=" + this.relativeEndOffset + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.relativeStartOffset);
            result2 = result2 * 31 + Integer.hashCode(this.relativeEndOffset);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TextAround)) {
                return false;
            }
            TextAround textAround = (TextAround)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)textAround.text)) {
                return false;
            }
            if (this.relativeStartOffset != textAround.relativeStartOffset) {
                return false;
            }
            return this.relativeEndOffset == textAround.relativeEndOffset;
        }
    }
}

