/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.request;

import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditTriggerReason;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001/B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010 \u001a\u00020!H\u0007J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\u0007H\u00c6\u0003J\t\u0010%\u001a\u00020\tH\u00c6\u0003J\t\u0010&\u001a\u00020\u000bH\u00c6\u0003J\t\u0010'\u001a\u00020\rH\u00c6\u0003J\t\u0010(\u001a\u00020\u000fH\u00c6\u0003JO\u0010)\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0013\u0010*\u001a\u00020!2\b\u0010+\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010,\u001a\u00020\tH\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00060"}, d2={"Lcom/intellij/ml/llm/nextEdits/request/NextEditRequest;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "language", "Lcom/intellij/lang/Language;", "caretOffset", "", "snapshot", "Lcom/intellij/ml/llm/nextEdits/request/NextEditRequest$LightweightEditorSnapshot;", "timestamp", "", "triggerReason", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditTriggerReason;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/lang/Language;ILcom/intellij/ml/llm/nextEdits/request/NextEditRequest$LightweightEditorSnapshot;JLcom/intellij/ml/inline/completion/impl/diagnostic/NextEditTriggerReason;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getLanguage", "()Lcom/intellij/lang/Language;", "getCaretOffset", "()I", "getSnapshot", "()Lcom/intellij/ml/llm/nextEdits/request/NextEditRequest$LightweightEditorSnapshot;", "getTimestamp", "()J", "getTriggerReason", "()Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditTriggerReason;", "isValid", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "LightweightEditorSnapshot", "intellij.ml.llm.nextEdits"})
public final class NextEditRequest {
    @NotNull
    private final Editor editor;
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final Language language;
    private final int caretOffset;
    @NotNull
    private final LightweightEditorSnapshot snapshot;
    private final long timestamp;
    @NotNull
    private final NextEditTriggerReason triggerReason;

    public NextEditRequest(@NotNull Editor editor2, @NotNull PsiFile psiFile, @NotNull Language language, int caretOffset, @NotNull LightweightEditorSnapshot snapshot, long timestamp, @NotNull NextEditTriggerReason triggerReason) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)triggerReason, (String)"triggerReason");
        this.editor = editor2;
        this.psiFile = psiFile;
        this.language = language;
        this.caretOffset = caretOffset;
        this.snapshot = snapshot;
        this.timestamp = timestamp;
        this.triggerReason = triggerReason;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    public final int getCaretOffset() {
        return this.caretOffset;
    }

    @NotNull
    public final LightweightEditorSnapshot getSnapshot() {
        return this.snapshot;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final NextEditTriggerReason getTriggerReason() {
        return this.triggerReason;
    }

    @RequiresReadLock
    public final boolean isValid() {
        if (this.editor.isDisposed()) {
            return false;
        }
        if (this.editor.getCaretModel().getCaretCount() != 1) {
            return false;
        }
        LogicalPosition logicalPosition = this.editor.getCaretModel().getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        LogicalPosition currentCaretPosition = logicalPosition;
        long modificationStamp = this.editor.getDocument().getModificationStamp();
        return this.snapshot.getModificationStamp() == modificationStamp && this.snapshot.getCaretPosition().line == currentCaretPosition.line;
    }

    @NotNull
    public final Editor component1() {
        return this.editor;
    }

    @NotNull
    public final PsiFile component2() {
        return this.psiFile;
    }

    @NotNull
    public final Language component3() {
        return this.language;
    }

    public final int component4() {
        return this.caretOffset;
    }

    @NotNull
    public final LightweightEditorSnapshot component5() {
        return this.snapshot;
    }

    public final long component6() {
        return this.timestamp;
    }

    @NotNull
    public final NextEditTriggerReason component7() {
        return this.triggerReason;
    }

    @NotNull
    public final NextEditRequest copy(@NotNull Editor editor2, @NotNull PsiFile psiFile, @NotNull Language language, int caretOffset, @NotNull LightweightEditorSnapshot snapshot, long timestamp, @NotNull NextEditTriggerReason triggerReason) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)triggerReason, (String)"triggerReason");
        return new NextEditRequest(editor2, psiFile, language, caretOffset, snapshot, timestamp, triggerReason);
    }

    public static /* synthetic */ NextEditRequest copy$default(NextEditRequest nextEditRequest, Editor editor2, PsiFile psiFile, Language language, int n, LightweightEditorSnapshot lightweightEditorSnapshot, long l, NextEditTriggerReason nextEditTriggerReason, int n2, Object object) {
        if ((n2 & 1) != 0) {
            editor2 = nextEditRequest.editor;
        }
        if ((n2 & 2) != 0) {
            psiFile = nextEditRequest.psiFile;
        }
        if ((n2 & 4) != 0) {
            language = nextEditRequest.language;
        }
        if ((n2 & 8) != 0) {
            n = nextEditRequest.caretOffset;
        }
        if ((n2 & 0x10) != 0) {
            lightweightEditorSnapshot = nextEditRequest.snapshot;
        }
        if ((n2 & 0x20) != 0) {
            l = nextEditRequest.timestamp;
        }
        if ((n2 & 0x40) != 0) {
            nextEditTriggerReason = nextEditRequest.triggerReason;
        }
        return nextEditRequest.copy(editor2, psiFile, language, n, lightweightEditorSnapshot, l, nextEditTriggerReason);
    }

    @NotNull
    public String toString() {
        return "NextEditRequest(editor=" + this.editor + ", psiFile=" + this.psiFile + ", language=" + this.language + ", caretOffset=" + this.caretOffset + ", snapshot=" + this.snapshot + ", timestamp=" + this.timestamp + ", triggerReason=" + this.triggerReason + ")";
    }

    public int hashCode() {
        int result2 = this.editor.hashCode();
        result2 = result2 * 31 + this.psiFile.hashCode();
        result2 = result2 * 31 + this.language.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.caretOffset);
        result2 = result2 * 31 + this.snapshot.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.timestamp);
        result2 = result2 * 31 + this.triggerReason.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NextEditRequest)) {
            return false;
        }
        NextEditRequest nextEditRequest = (NextEditRequest)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)nextEditRequest.editor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.psiFile, (Object)nextEditRequest.psiFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.language, (Object)nextEditRequest.language)) {
            return false;
        }
        if (this.caretOffset != nextEditRequest.caretOffset) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.snapshot, (Object)nextEditRequest.snapshot)) {
            return false;
        }
        if (this.timestamp != nextEditRequest.timestamp) {
            return false;
        }
        return this.triggerReason == nextEditRequest.triggerReason;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/request/NextEditRequest$LightweightEditorSnapshot;", "", "modificationStamp", "", "caretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "<init>", "(JLcom/intellij/openapi/editor/LogicalPosition;)V", "getModificationStamp", "()J", "getCaretPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "intellij.ml.llm.nextEdits"})
    public static final class LightweightEditorSnapshot {
        private final long modificationStamp;
        @NotNull
        private final LogicalPosition caretPosition;

        public LightweightEditorSnapshot(long modificationStamp, @NotNull LogicalPosition caretPosition) {
            Intrinsics.checkNotNullParameter((Object)caretPosition, (String)"caretPosition");
            this.modificationStamp = modificationStamp;
            this.caretPosition = caretPosition;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final LogicalPosition getCaretPosition() {
            return this.caretPosition;
        }
    }
}

