/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.session;

import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionEventsReporter;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.listeners.CaretEventType;
import com.intellij.ml.llm.nextEdits.session.NextEditSession;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionListener;
import com.intellij.ml.llm.nextEdits.session.NextEditSessionProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\b\u0010\u001b\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/nextEdits/session/NextEditSessionManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "session", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ml/llm/nextEdits/session/NextEditSession;", "getSession", "finishSession", "", "finishType", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionFinishType;", "onDocumentEvent", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "onCaretEvent", "type", "Lcom/intellij/ml/llm/nextEdits/listeners/CaretEventType;", "tryToInitSession", "sessionProgress", "Lcom/intellij/ml/llm/nextEdits/session/NextEditSessionProgress;", "reporter", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter;", "dispose", "Companion", "intellij.ml.llm.nextEdits"})
@ApiStatus.Internal
public final class NextEditSessionManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private AtomicReference<NextEditSession> session;
    @NotNull
    private static final Key<NextEditSessionManager> KEY = new Key("next.edit.session.manager");

    private NextEditSessionManager(Editor editor2, Project project2) {
        this.editor = editor2;
        this.project = project2;
        this.session = new AtomicReference<Object>(null);
    }

    @Nullable
    public final NextEditSession getSession() {
        return this.session.get();
    }

    @RequiresEdt
    public final void finishSession(@NotNull NextEditSessionFinishType finishType) {
        Intrinsics.checkNotNullParameter((Object)finishType, (String)"finishType");
        ThreadingAssertions.assertEventDispatchThread();
        NextEditSession nextEditSession = this.session.get();
        if (nextEditSession == null) {
            return;
        }
        NextEditSession currentSession = nextEditSession;
        currentSession.reportSessionFinished(finishType);
        Disposer.dispose((Disposable)currentSession);
        this.session.compareAndSet(currentSession, null);
        ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterSessionFinished(this.editor, currentSession, finishType);
    }

    @RequiresEdt
    public final void onDocumentEvent(@NotNull DocumentEvent event) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSession nextEditSession = this.session.get();
            if (nextEditSession == null) break block0;
            nextEditSession.onDocumentEvent(event);
        }
    }

    @RequiresEdt
    public final void onCaretEvent(@NotNull CaretEventType type2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSession nextEditSession = this.session.get();
            if (nextEditSession == null) break block0;
            nextEditSession.onCaretEvent(type2);
        }
    }

    @RequiresEdt
    public final void tryToInitSession(@NotNull NextEditSessionProgress sessionProgress, @NotNull NextEditSessionEventsReporter reporter) {
        NextEditSession newSession;
        Intrinsics.checkNotNullParameter((Object)sessionProgress, (String)"sessionProgress");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ThreadingAssertions.assertEventDispatchThread();
        NextEditSession currentSession = this.session.get();
        if (currentSession != null) {
            if (currentSession.isActive()) {
                return;
            }
            this.finishSession(NextEditSessionFinishType.NEW_SESSION);
        }
        if (this.session.compareAndSet(null, newSession = new NextEditSession(this.editor, this.project, sessionProgress, reporter, (Function1<? super NextEditSessionFinishType, Unit>)((Function1)arg_0 -> NextEditSessionManager.tryToInitSession$lambda$0(this, arg_0))))) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterSessionStarted(this.editor, newSession);
        } else {
            Disposer.dispose((Disposable)newSession);
        }
    }

    public void dispose() {
        this.finishSession(NextEditSessionFinishType.MANAGER_DISPOSED);
    }

    private static final Unit tryToInitSession$lambda$0(NextEditSessionManager this$0, NextEditSessionFinishType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.finishSession(it);
        return Unit.INSTANCE;
    }

    public /* synthetic */ NextEditSessionManager(Editor editor2, Project project2, DefaultConstructorMarker $constructor_marker) {
        this(editor2, project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/session/NextEditSessionManager$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/nextEdits/session/NextEditSessionManager;", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "uninstall", "getInstance", "intellij.ml.llm.nextEdits"})
    @SourceDebugExtension(value={"SMAP\nNextEditSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSessionManager.kt\ncom/intellij/ml/llm/nextEdits/session/NextEditSessionManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void install(@NotNull Editor editor2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSessionManager manager = new NextEditSessionManager(editor2, project2, null);
            editor2.putUserData(KEY, (Object)manager);
            EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.install$lambda$0(editor2));
        }

        @RequiresEdt
        public final void uninstall(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSessionManager nextEditSessionManager = (NextEditSessionManager)editor2.getUserData(KEY);
            if (nextEditSessionManager != null) {
                NextEditSessionManager it = nextEditSessionManager;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            editor2.putUserData(KEY, null);
        }

        @Nullable
        public final NextEditSessionManager getInstance(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (NextEditSessionManager)editor2.getUserData(KEY);
        }

        private static final void install$lambda$0(Editor $editor) {
            Companion.uninstall($editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

