/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.ui.diff;

import com.intellij.ml.llm.nextEdits.session.step.NextEditDeletionDiffModel;
import com.intellij.ml.llm.nextEdits.ui.NextEditColors;
import com.intellij.ml.llm.nextEdits.ui.diff.NextEditStepView;
import com.intellij.ml.llm.nextEdits.ui.inlay.NextEditInlineShortcutInlaysKt;
import com.intellij.ml.llm.nextEdits.ui.inlay.NextEditShortcutHint;
import com.intellij.ml.llm.nextEdits.ui.util.NextEditRenderingUtils;
import com.intellij.ml.llm.nextEdits.ui.view.NextEditShortcutHintType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditDeletionView;", "Lcom/intellij/ml/llm/nextEdits/ui/diff/NextEditStepView;", "editor", "Lcom/intellij/openapi/editor/Editor;", "diff", "Lcom/intellij/ml/llm/nextEdits/session/step/NextEditDeletionDiffModel;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/nextEdits/session/step/NextEditDeletionDiffModel;)V", "startLine", "", "endLine", "show", "", "hintType", "Lcom/intellij/ml/llm/nextEdits/ui/view/NextEditShortcutHintType;", "doRenderShortcutHint", "chooseLineNumberForShortcut", "getAffectedLines", "", "", "dispose", "intellij.ml.llm.nextEdits"})
@SourceDebugExtension(value={"SMAP\nNextEditDeletionView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditDeletionView.kt\ncom/intellij/ml/llm/nextEdits/ui/diff/NextEditDeletionView\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1088#2,2:83\n1563#3:85\n1634#3,3:86\n*S KotlinDebug\n*F\n+ 1 NextEditDeletionView.kt\ncom/intellij/ml/llm/nextEdits/ui/diff/NextEditDeletionView\n*L\n59#1:83,2\n73#1:85\n73#1:86,3\n*E\n"})
public final class NextEditDeletionView
implements NextEditStepView {
    @NotNull
    private final Editor editor;
    @NotNull
    private final NextEditDeletionDiffModel diff;
    private final int startLine;
    private final int endLine;

    public NextEditDeletionView(@NotNull Editor editor2, @NotNull NextEditDeletionDiffModel diff2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        this.editor = editor2;
        this.diff = diff2;
        this.startLine = this.editor.getDocument().getLineNumber(this.diff.getOrigin().getFragment().getStartOffset1());
        this.endLine = this.editor.getDocument().getLineNumber(Math.max(this.diff.getOrigin().getFragment().getStartOffset1(), this.diff.getOrigin().getFragment().getEndOffset1() - 1));
    }

    @Override
    public void show(@NotNull NextEditShortcutHintType hintType) {
        Intrinsics.checkNotNullParameter((Object)((Object)hintType), (String)"hintType");
        NextEditColors.BackgroundColor red = NextEditColors.BackgroundColor.RED;
        for (NextEditDeletionDiffModel.Deletion deletion : this.diff.getDeletions()) {
            NextEditRenderingUtils.INSTANCE.drawBackground(this.editor, red, deletion.getStartOffset(), deletion.getEndOffset(), true, this);
        }
        this.doRenderShortcutHint(hintType);
    }

    private final void doRenderShortcutHint(NextEditShortcutHintType hintType) {
        int shortcutLineNumber = this.chooseLineNumberForShortcut();
        int shortcutOffset = this.editor.getDocument().getLineStartOffset(shortcutLineNumber);
        NextEditShortcutHint shortcutHint = switch (WhenMappings.$EnumSwitchMapping$0[hintType.ordinal()]) {
            case 1 -> null;
            case 2 -> NextEditShortcutHint.Jump.INSTANCE;
            case 3 -> NextEditShortcutHint.Remove.INSTANCE;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (shortcutHint != null) {
            NextEditInlineShortcutInlaysKt.renderShortcutHint(this.editor, shortcutOffset, shortcutHint, this);
        }
    }

    private final int chooseLineNumberForShortcut() {
        String line;
        int lineNumber;
        List<String> lines2 = this.getAffectedLines();
        Iterator iterator = ((Iterable)lines2).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            boolean bl;
            block3: {
                lineNumber = n++;
                line = (String)iterator.next();
                CharSequence $this$any$iv = line;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!Character.isLetterOrDigit(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) continue;
            return lineNumber + this.startLine;
        }
        iterator = ((Iterable)lines2).iterator();
        n = 0;
        while (iterator.hasNext()) {
            lineNumber = n++;
            line = (String)iterator.next();
            if (!(!StringsKt.isBlank((CharSequence)line))) continue;
            return lineNumber + this.startLine;
        }
        return this.startLine;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAffectedLines() {
        void $this$mapTo$iv$iv;
        Document document2 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
        Document document3 = document2;
        Iterable $this$map$iv = (Iterable)new IntRange(this.startLine, this.endLine);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void lineNumber;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int lineStart = document3.getLineStartOffset((int)lineNumber);
            int lineEnd = document3.getLineEndOffset((int)lineNumber);
            collection.add(document3.getText(new TextRange(lineStart, lineEnd)));
        }
        return (List)destination$iv$iv;
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NextEditShortcutHintType.values().length];
            try {
                nArray[NextEditShortcutHintType.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditShortcutHintType.JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditShortcutHintType.ACCEPT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

