/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.performanceTesting.name.suggestion;

import com.intellij.ml.llm.refactorings.NameSuggestionListener;
import com.intellij.ml.llm.refactorings.NameSuggestionListenerKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0003\u0016\u0017\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\fJ$\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "results", "", "Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Location;", "Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Session;", "listeners", "Lkotlin/Function0;", "", "startBenchmark", "onFinish", "file", "", "offset", "", "f", "stopBenchmark", "reportPath", "Location", "Session", "Companion", "intellij.ml.llm.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nNameSuggestionBenchmarkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameSuggestionBenchmarkService.kt\ncom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n126#2:75\n153#2,3:76\n*S KotlinDebug\n*F\n+ 1 NameSuggestionBenchmarkService.kt\ncom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService\n*L\n55#1:75\n55#1:76,3\n*E\n"})
public final class NameSuggestionBenchmarkService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Map<Location, Session> results;
    @NotNull
    private final Map<Location, Function0<Unit>> listeners;

    public NameSuggestionBenchmarkService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.results = new LinkedHashMap();
        this.listeners = new LinkedHashMap();
    }

    public final void startBenchmark() {
        this.results.clear();
        ApplicationManager.getApplication().getMessageBus().connect(this.coroutineScope).subscribe(NameSuggestionListenerKt.getNameSuggestionTopic(), (Object)new NameSuggestionListener(this){
            final /* synthetic */ NameSuggestionBenchmarkService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onStart(VirtualFile file, int offset, String originalName) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
                Map map2 = NameSuggestionBenchmarkService.access$getResults$p(this.this$0);
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Location location = new Location(string, offset);
                Session session = new Session(originalName, new Date().getTime(), null, CollectionsKt.emptyList());
                map2.put(location, session);
            }

            public void onFinish(VirtualFile file, int offset, String originalName, Collection<String> suggestedNames) {
                block1: {
                    Session session;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
                    Intrinsics.checkNotNullParameter(suggestedNames, (String)"suggestedNames");
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    Location location = new Location(string, offset);
                    Session session2 = (Session)NameSuggestionBenchmarkService.access$getResults$p(this.this$0).get(location);
                    if (session2 != null) {
                        Session it = session = session2;
                        boolean bl = false;
                        it.setEndTime(new Date().getTime());
                        it.setNames(suggestedNames);
                    }
                    Function0 function0 = (Function0)NameSuggestionBenchmarkService.access$getListeners$p(this.this$0).get(location);
                    if (function0 == null) break block1;
                    session = function0;
                    NameSuggestionBenchmarkService nameSuggestionBenchmarkService = this.this$0;
                    Session it = session;
                    boolean bl = false;
                    NameSuggestionBenchmarkService.access$getListeners$p(nameSuggestionBenchmarkService).remove(location);
                    it.invoke();
                }
            }
        });
    }

    public final void onFinish(@NotNull String file, int offset, @NotNull Function0<Unit> f) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter(f, (String)"f");
            Location location = new Location(file, offset);
            this.listeners.put(location, f);
            Session session = this.results.get(location);
            if ((session != null ? session.getEndTime() : null) == null) break block1;
            Function0<Unit> function0 = this.listeners.get(location);
            if (function0 != null) {
                Function0<Unit> it = function0;
                boolean bl = false;
                this.listeners.remove(location);
                it.invoke();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void stopBenchmark(@NotNull String reportPath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)reportPath, (String)"reportPath");
        File file = new File(reportPath);
        if (!file.exists()) {
            file.createNewFile();
        }
        Map<Location, Session> $this$map$iv = this.results;
        boolean $i$f$map = false;
        Map<Location, Session> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Location location = (Location)entry.getKey();
            Session session = (Session)entry.getValue();
            collection.add(location.getFile() + ";" + location.getOffset() + ";" + session.getOriginalName() + ";" + session.getStartTime() + ";" + session.getEndTime() + ";" + CollectionsKt.joinToString$default((Iterable)session.getNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ";");
        }
        String text2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        FilesKt.appendText$default((File)file, (String)text2, null, (int)2, null);
    }

    public static final /* synthetic */ Map access$getResults$p(NameSuggestionBenchmarkService $this) {
        return $this.results;
    }

    public static final /* synthetic */ Map access$getListeners$p(NameSuggestionBenchmarkService $this) {
        return $this.listeners;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Companion;", "", "<init>", "()V", "parseReport", "", "Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Location;", "Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Session;", "data", "", "intellij.ml.llm.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nNameSuggestionBenchmarkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NameSuggestionBenchmarkService.kt\ncom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n1563#2:75\n1634#2,3:76\n1193#2,2:79\n1267#2,4:81\n*S KotlinDebug\n*F\n+ 1 NameSuggestionBenchmarkService.kt\ncom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Companion\n*L\n68#1:75\n68#1:76,3\n69#1:79,2\n69#1:81,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<Location, Session> parseReport(@NotNull String data) {
            void $this$associateTo$iv$iv;
            String[] stringArray;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Iterable $this$map$iv = StringsKt.lines((CharSequence)data);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void line;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                stringArray = new String[]{";"};
                collection.add(StringsKt.split$default((CharSequence)((CharSequence)line), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                List values = (List)element$iv$iv;
                boolean bl = false;
                String[] stringArray2 = new String[]{","};
                stringArray = TuplesKt.to((Object)new Location((String)values.get(0), Integer.parseInt((String)values.get(1))), (Object)new Session((String)values.get(2), Long.parseLong((String)values.get(3)), Long.parseLong((String)values.get(4)), StringsKt.split$default((CharSequence)((CharSequence)values.get(5)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null)));
                map2.put(stringArray.getFirst(), stringArray.getSecond());
            }
            return destination$iv$iv2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Location;", "", "file", "", "offset", "", "<init>", "(Ljava/lang/String;I)V", "getFile", "()Ljava/lang/String;", "getOffset", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.ml.llm.performanceTesting"})
    public static final class Location {
        @NotNull
        private final String file;
        private final int offset;

        public Location(@NotNull String file, int offset) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.file = file;
            this.offset = offset;
        }

        @NotNull
        public final String getFile() {
            return this.file;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String component1() {
            return this.file;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final Location copy(@NotNull String file, int offset) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return new Location(file, offset);
        }

        public static /* synthetic */ Location copy$default(Location location, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = location.file;
            }
            if ((n2 & 2) != 0) {
                n = location.offset;
            }
            return location.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Location(file=" + this.file + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            int result2 = this.file.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.offset);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Location)) {
                return false;
            }
            Location location = (Location)other;
            if (!Intrinsics.areEqual((Object)this.file, (Object)location.file)) {
                return false;
            }
            return this.offset == location.offset;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0010J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J>\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Session;", "", "originalName", "", "startTime", "", "endTime", "names", "", "<init>", "(Ljava/lang/String;JLjava/lang/Long;Ljava/util/Collection;)V", "getOriginalName", "()Ljava/lang/String;", "getStartTime", "()J", "getEndTime", "()Ljava/lang/Long;", "setEndTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getNames", "()Ljava/util/Collection;", "setNames", "(Ljava/util/Collection;)V", "component1", "component2", "component3", "component4", "copy", "(Ljava/lang/String;JLjava/lang/Long;Ljava/util/Collection;)Lcom/intellij/ml/llm/performanceTesting/name/suggestion/NameSuggestionBenchmarkService$Session;", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.performanceTesting"})
    public static final class Session {
        @NotNull
        private final String originalName;
        private final long startTime;
        @Nullable
        private Long endTime;
        @NotNull
        private Collection<String> names;

        public Session(@NotNull String originalName, long startTime, @Nullable Long endTime, @NotNull Collection<String> names) {
            Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
            Intrinsics.checkNotNullParameter(names, (String)"names");
            this.originalName = originalName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.names = names;
        }

        public /* synthetic */ Session(String string, long l, Long l2, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                l2 = null;
            }
            this(string, l, l2, collection);
        }

        @NotNull
        public final String getOriginalName() {
            return this.originalName;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        @Nullable
        public final Long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(@Nullable Long l) {
            this.endTime = l;
        }

        @NotNull
        public final Collection<String> getNames() {
            return this.names;
        }

        public final void setNames(@NotNull Collection<String> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.names = collection;
        }

        @NotNull
        public final String component1() {
            return this.originalName;
        }

        public final long component2() {
            return this.startTime;
        }

        @Nullable
        public final Long component3() {
            return this.endTime;
        }

        @NotNull
        public final Collection<String> component4() {
            return this.names;
        }

        @NotNull
        public final Session copy(@NotNull String originalName, long startTime, @Nullable Long endTime, @NotNull Collection<String> names) {
            Intrinsics.checkNotNullParameter((Object)originalName, (String)"originalName");
            Intrinsics.checkNotNullParameter(names, (String)"names");
            return new Session(originalName, startTime, endTime, names);
        }

        public static /* synthetic */ Session copy$default(Session session, String string, long l, Long l2, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                string = session.originalName;
            }
            if ((n & 2) != 0) {
                l = session.startTime;
            }
            if ((n & 4) != 0) {
                l2 = session.endTime;
            }
            if ((n & 8) != 0) {
                collection = session.names;
            }
            return session.copy(string, l, l2, collection);
        }

        @NotNull
        public String toString() {
            return "Session(originalName=" + this.originalName + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", names=" + this.names + ")";
        }

        public int hashCode() {
            int result2 = this.originalName.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.startTime);
            result2 = result2 * 31 + (this.endTime == null ? 0 : ((Object)this.endTime).hashCode());
            result2 = result2 * 31 + ((Object)this.names).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Session)) {
                return false;
            }
            Session session = (Session)other;
            if (!Intrinsics.areEqual((Object)this.originalName, (Object)session.originalName)) {
                return false;
            }
            if (this.startTime != session.startTime) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.endTime, (Object)session.endTime)) {
                return false;
            }
            return Intrinsics.areEqual(this.names, session.names);
        }
    }
}

