/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.php.chat;

import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.php.lang.PhpLanguage;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\"#\u0010\u0000\u001a\u0017\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\u0006\u001a\u0017\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\u0002\b\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0002\b\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"phpStormLanguages", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "Lkotlin/jvm/internal/EnhancedNullability;", "allSupportedLanguages", "isChatCreationContextSupported", "", "chatSession", "Lcom/intellij/ml/llm/core/chat/session/ChatSession;", "popularPackages", "intellij.ml.llm.php"})
public final class PhpTechnologiesChatContextProviderKt {
    @NotNull
    private static final Set<String> phpStormLanguages;
    @NotNull
    private static final Set<String> allSupportedLanguages;
    @NotNull
    private static final Set<String> popularPackages;

    @RequiresReadLock
    public static final boolean isChatCreationContextSupported(@NotNull ChatSession chatSession) {
        Intrinsics.checkNotNullParameter((Object)chatSession, (String)"chatSession");
        PsiFile sourceFile = chatSession.getCreationContext().getSourceFile();
        if (PlatformUtils.isPhpStorm()) {
            if (sourceFile == null) {
                return true;
            }
            return allSupportedLanguages.contains(sourceFile.getLanguage().getID());
        }
        PsiFile psiFile = sourceFile;
        return CollectionsKt.contains((Iterable)phpStormLanguages, psiFile != null && (psiFile = psiFile.getLanguage()) != null ? psiFile.getID() : null);
    }

    public static final /* synthetic */ Set access$getPopularPackages$p() {
        return popularPackages;
    }

    static {
        Object[] objectArray = new String[]{PhpLanguage.INSTANCE.getID(), "Blade", "Twig"};
        phpStormLanguages = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"JSON", "XML", "yaml"};
        allSupportedLanguages = SetsKt.plus(phpStormLanguages, (Iterable)SetsKt.setOf((Object[])objectArray));
        objectArray = new String[]{"psr/log", "guzzlehttp/guzzle", "symfony/console", "monolog/monolog", "myclabs/deep-copy", "symfony/routing", "doctrine/annotations", "aws/aws-sdk-php", "mockery/mockery", "dragonmantank/cron-expression", "firebase/php-jwt", "fakerphp/faker", "laravel/framework", "symfony/config", "symfony/mailer", "twig/twig", "laravel/tinker", "phpstan/phpdoc-parser", "phpspec/prophecy", "google/auth", "lcobucci/jwt", "doctrine/orm", "symfony/twig-bundle", "laravel/sanctum", "laravel/sail", "symfony/twig-bridge"};
        popularPackages = SetsKt.setOf((Object[])objectArray);
    }
}

