/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.qodana.inspectionKts;

import com.intellij.ml.llm.qodana.inspectionKts.llmApi.LlmFakeApiNamesMappings;
import com.intellij.ml.llm.qodana.inspectionKts.llmApi.LlmKotlinApi;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.inspectionKts.examples.InspectionKtsExample;
import org.jetbrains.qodana.inspectionKts.templates.InspectionKtsTemplate;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\b\u0010\n\u001a\u00020\u0001H\u0000\u001a\b\u0010\f\u001a\u00020\u0001H\u0002\u001a*\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\"\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"promptGenerateLlmInspectionSpecification", "", "description", "promptGenerateInspection", "llmKotlinApi", "Lcom/intellij/ml/llm/qodana/inspectionKts/llmApi/LlmKotlinApi;", "llmFakeApiNamesMappings", "Lcom/intellij/ml/llm/qodana/inspectionKts/llmApi/LlmFakeApiNamesMappings;", "ignoredTemplates", "", "examples", "ignoredExamples", "moreExamples", "promptFailedCompilation", "notCompilingCode", "failure", "Ljava/lang/Exception;", "Lkotlin/Exception;", "originalPrompt", "intellij.ml.llm.qodana.inspectionKts"})
@SourceDebugExtension(value={"SMAP\nprompt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 prompt.kt\ncom/intellij/ml/llm/qodana/inspectionKts/PromptKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n774#2:161\n865#2,2:162\n1563#2:164\n1634#2,3:165\n774#2:168\n865#2,2:169\n1563#2:171\n1634#2,3:172\n*S KotlinDebug\n*F\n+ 1 prompt.kt\ncom/intellij/ml/llm/qodana/inspectionKts/PromptKt\n*L\n98#1:161\n98#1:162,2\n99#1:164\n99#1:165,3\n116#1:168\n116#1:169,2\n119#1:171\n119#1:172,3\n*E\n"})
public final class PromptKt {
    @NotNull
    private static final Set<String> ignoredTemplates;
    @NotNull
    private static final Set<String> ignoredExamples;

    @NotNull
    public static final String promptGenerateLlmInspectionSpecification(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String prompt2 = StringsKt.trimIndent((String)("\n<Instructions>\nYour role is to be a reliable and proficient AI-powered software development assistant in JAVA inspection generaration. \nYou are given a description of an static analysis inspection provided by the user. It's provided in `DescriptionFromUser` section!!!! \nYour task is to generate a inspection specification, that includes:\n1. The id of inspection (use camelCase like this) (id field in json output)\n2. Complete description of the inspection. Here describe the meaning of the inspection: motivation behind it, which cases in checks. This text will be later used in documentation. (description field in json output)\n3. Code snippet - text of valid java file that will be used to test the quality inspection. The snippet must be one valid file file not using 3-rd party libraries. \nThe snippet MUST contain all possible cases which inspection should cover. \nIt's used to validate the quality of inspection. The file must contain the examples of True Positives and True Negatives. Mark these places using comments. File should be short and NOT CONTAIN code not related to inspection.\nSO IT SHOULD CONTAIN CODE ONLY RELATED TO INSPECTION. \nWhen generating, first think about all possible language features which can be used and tested for this inspection. Including generics, anonymous classes and nested classes. Important! Think about these features also.\nThe file must contain AT LEAST 10 examples of true positives and 10 examples of true negatives. Generate WITHOUT package statement. (javaFileForTesting field in json output) \n\nThe response must STRICTLY follow the JSON format, PROVIDE OUTPUT ONLY IN THIS JSON FORMAT:\n{\n  \"id\": \"MyInspectionId\",\n  \"description\": \"The description of the inspection\"\n  \"javaFileForTesting\": \"the content of java file that will be used to test the quality inspection\"\n}\n</Instructions>\n\n<DescriptionFromUser>\n" + description + "\n</DescriptionFromUser>\n\n"));
        return prompt2;
    }

    @NotNull
    public static final String promptGenerateInspection(@NotNull String description, @NotNull LlmKotlinApi llmKotlinApi2, @NotNull LlmFakeApiNamesMappings llmFakeApiNamesMappings) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)llmKotlinApi2, (String)"llmKotlinApi");
        Intrinsics.checkNotNullParameter((Object)llmFakeApiNamesMappings, (String)"llmFakeApiNamesMappings");
        String originalPrompt = StringsKt.trimIndent((String)("\n<Role>\nYour role is to be a reliable and proficient AI-powered software development assistant.\nYou are proficient with Java, Kotlin and work ONLY with methods and classes declared in api.kt file below, this API allows to write source code inspections\n</Role>\n\n<Examples>\n" + PromptKt.examples() + "\n</Examples>\n\n<Rules>\nWhile responding you must ensure that you strictly follow these rules:\n1. Respond only with the necessary code, written in Kotlin, similar to the examples above\n2. Always use reasonable IDs and names for inspections, containing only latin characters\n3. Use ONLY methods and classes described in api.kt file in API section, no any others at all!.\n4. Do not generate fixes\n5. Place all inspection logic code inside `localInspection { ... }` block!!! Use inner functions inside `localInspections` block! All helper functions MUST be defined inside it. NOT outside!!! IT'S CRITICAL!!! Also when defining helper functions inside localInspection, declare them before their usage, otherwise it's a compilation error.\n6. DON'T FORGET TO ADD IMPORTS TO THE GENERATED CODE!!!, including `import org.intellij.lang.annotations.Language` and `import com.intellij.psi.*`\n7. Don't include in the response your thoughts. The output should be code of inspection \u2013 kotlin code.\n</Rules>\n\n<API>\nCode below is the api.kt file: the only available classes and methods which you can use inside inspection code. ONLY IT!!!\n\n<api.kt>\n" + llmKotlinApi2.stubApi() + "\n</api.kt>\n\n</API>\n\n<Instructions>\n" + description + "\n</Instructions>\n"));
        String fakedPrompt = llmFakeApiNamesMappings.substituteWithLlmFakeApiNames(originalPrompt);
        return fakedPrompt;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String examples() {
        void var3_3;
        void $this$mapTo$iv$iv;
        InspectionKtsTemplate it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = InspectionKtsTemplate.Provider.Companion.templates();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InspectionKtsTemplate)element$iv$iv;
            boolean bl = false;
            if (!(!ignoredTemplates.contains(it.getUiDescriptor().getId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InspectionKtsTemplate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getTemplateContent().invoke((Object)"AnExampleFileName.ReplaceMe"));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)var3_3), (CharSequence)"\n", null, null, (int)0, null, PromptKt::examples$lambda$2, (int)30, null) + PromptKt.moreExamples();
    }

    /*
     * WARNING - void declaration
     */
    private static final String moreExamples() {
        void var3_3;
        void $this$mapTo$iv$iv;
        InspectionKtsExample it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = InspectionKtsExample.Provider.Companion.examples();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (InspectionKtsExample)element$iv$iv;
            boolean bl = false;
            if (!(!ignoredExamples.contains(it.getText()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (InspectionKtsExample)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            URL uRL = it.getResourceUrl();
            Charset charset = Charsets.UTF_8;
            byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
            String content2 = new String(byArray, charset);
            String comment = "// Only Code of localInspection { ... }\n";
            collection.add(comment + content2);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)var3_3), (CharSequence)"\n", null, null, (int)0, null, PromptKt::moreExamples$lambda$5, (int)30, null);
    }

    @NotNull
    public static final String promptFailedCompilation(@NotNull String notCompilingCode, @NotNull Exception failure, @NotNull String originalPrompt, @NotNull LlmFakeApiNamesMappings llmFakeApiNamesMappings) {
        Intrinsics.checkNotNullParameter((Object)notCompilingCode, (String)"notCompilingCode");
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        Intrinsics.checkNotNullParameter((Object)originalPrompt, (String)"originalPrompt");
        Intrinsics.checkNotNullParameter((Object)llmFakeApiNamesMappings, (String)"llmFakeApiNamesMappings");
        String prompt2 = StringsKt.trimIndent((String)("\nSadly your last result didn't compile - could you please fix the error? Please only respond with the necessary code of the check.\nYour last result was:\n```\n" + notCompilingCode + "\n```\nThe compile error is:\n" + llmFakeApiNamesMappings.substituteWithLlmFakeApiNames(ExceptionsKt.stackTraceToString((Throwable)failure)) + "\n\nAlso, there could be a possibility that the compilation failed due to the fact that returned value in API you used was actually array.\nIn such cases, you can fix it by additionally calling .toList() on the value (to transform the returned array to list, in such cases it should help)\nTypically such errors have \"Array<out TypeVariable(T)>\" in error message.\n\nIf the error is related to \"unresolved reference\" to your helper function located in `localCheck`, make sure that you define\n these helper functions before their usage \u2013 otherwise it's a compilation error.\n\nMy original prompt was:\n" + originalPrompt + "\n"));
        return prompt2;
    }

    private static final CharSequence examples$lambda$2(String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        String example = StringsKt.trimIndent((String)("\n<Example>\n" + content2 + "\n</Example>\n"));
        return example;
    }

    private static final CharSequence moreExamples$lambda$5(String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        String example = StringsKt.trimIndent((String)("\n<Example>\n" + content2 + "\n</Example>\n"));
        return example;
    }

    static {
        Object[] objectArray = new String[]{"ANY_LANGUAGE_GLOBAL", "ANY_LANGUAGE", "KOTLIN"};
        ignoredTemplates = SetsKt.setOf((Object[])objectArray);
        ignoredExamples = SetsKt.setOf((Object)"JSON and YAML");
    }
}

