/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.git.junie;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.ml.llm.matterhorn.ShellExecutor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/git/junie/WindowsGitShellExecutor;", "Lcom/intellij/ml/llm/matterhorn/ShellExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "createProcess", "Ljava/lang/Process;", "executeCommand", "Lcom/intellij/ml/llm/matterhorn/ShellExecutor$CommandResult;", "command", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.riderNext.latest.git"})
@SourceDebugExtension(value={"SMAP\nWindowsGitShellExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsGitShellExecutor.kt\ncom/intellij/ml/llm/riderNext/latest/git/junie/WindowsGitShellExecutor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,45:1\n14#2:46\n*S KotlinDebug\n*F\n+ 1 WindowsGitShellExecutor.kt\ncom/intellij/ml/llm/riderNext/latest/git/junie/WindowsGitShellExecutor\n*L\n21#1:46\n*E\n"})
public final class WindowsGitShellExecutor
extends ShellExecutor {
    @NotNull
    private final Project project;

    public WindowsGitShellExecutor(@NotNull Project project2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(scope, 0, 0L, 0L, 0L, 30, null);
        this.project = project2;
    }

    @NotNull
    protected Process createProcess() {
        GitExecutable gitExecutable = GitExecutableManager.getInstance().getExecutable(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)gitExecutable, (String)"getExecutable(...)");
        GitExecutable gitExe = gitExecutable;
        String bashExePath = GitExecutableDetector.getBashExecutablePath((Project)this.project, (String)gitExe.getExePath());
        if (bashExePath == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(WindowsGitShellExecutor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot find bash.exe, install Git for Windows");
            throw new ExecutionException("Cannot find bash.exe, install Git for Windows");
        }
        Object[] objectArray = new String[]{bashExePath, "--noprofile", "--norc"};
        GeneralCommandLine commandLine = new GeneralCommandLine(CollectionsKt.listOf((Object[])objectArray));
        commandLine.withEnvironment("TERM", "dumb");
        commandLine.withEnvironment("BASH_SILENCE_DEPRECATION_WARNING", "1");
        commandLine.withEnvironment("GIT_PAGER", "cat");
        commandLine.withEnvironment("PATH", "C:\\Program Files\\Git\\usr\\bin;" + System.getenv("PATH"));
        Process process2 = commandLine.createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"createProcess(...)");
        return process2;
    }

    @Nullable
    public Object executeCommand(@NotNull String command, @NotNull Continuation<? super ShellExecutor.CommandResult> $completion) {
        char[] cArray = new char[]{' '};
        String commandLine = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)command, (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, WindowsGitShellExecutor::executeCommand$lambda$0, (int)30, null);
        return super.executeCommand(commandLine, $completion);
    }

    private static final CharSequence executeCommand$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = CommandLineUtil.posixQuote((String)it);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"posixQuote(...)");
        return string;
    }
}

