/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.insight.impl.view.common;

import com.intellij.ml.llm.core.ui.XNextThemeHelper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/insight/impl/view/common/AIInsightLineMarkerRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "shortened", "", "<init>", "(Z)V", "getShortened", "()Z", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "getWidth", "", "intellij.ml.llm.riderNext.latest"})
public final class AIInsightLineMarkerRenderer
implements LineMarkerRenderer {
    private final boolean shortened;

    public AIInsightLineMarkerRenderer(boolean shortened) {
        this.shortened = shortened;
    }

    public final boolean getShortened() {
        return this.shortened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Editor editor2, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Paint paint = XNextThemeHelper.INSTANCE.getButtonAiXNextDoubleColorBorder().getGradientPaint(r);
        EditorGutterComponentEx editorGutterComponentEx = ((EditorEx)editor2).getGutterComponentEx();
        Intrinsics.checkNotNullExpressionValue((Object)editorGutterComponentEx, (String)"getGutterComponentEx(...)");
        EditorGutterComponentEx gutter = editorGutterComponentEx;
        int endX = gutter.getWhitespaceSeparatorOffset();
        int y_padding = 1;
        int y = r.y - ((EditorEx)editor2).getLineHeight() + y_padding;
        int x_shift = 1;
        int width = this.getWidth();
        double arc = width;
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            GraphicsUtil.setupAAPainting((Graphics)g2);
            g2.setPaint(paint);
            double height = this.shortened ? (double)r.height * 3.0 / 4.0 : (double)(r.height + ((EditorEx)editor2).getLineHeight() - y_padding);
            RectanglePainter2D.FILL.paint(g2, (double)(endX - width + x_shift), (double)y, (double)width, height, (Object)arc);
        }
        finally {
            g2.dispose();
        }
    }

    private final int getWidth() {
        float ratio = 0.5f;
        int vcsLineWidth = JBUIScale.scale((int)JBUI.getInt((String)"Gutter.VcsChanges.width", (int)5));
        return (int)((float)vcsLineWidth * ratio);
    }
}

