/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.riderNext.latest.recap.ui.components;

import com.intellij.ml.llm.riderNext.latest.recap.ui.components.LoadableComponent;
import com.intellij.ml.llm.riderNext.latest.recap.ui.components.RecapTextComponentsManager;
import com.intellij.ui.components.JBHtmlPane;
import com.intellij.ui.components.JBHtmlPaneConfiguration;
import com.intellij.ui.components.JBHtmlPaneStyleConfiguration;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/riderNext/latest/recap/ui/components/recapTextViewComponent;", "Lcom/intellij/ui/components/JBHtmlPane;", "Lcom/intellij/ml/llm/riderNext/latest/recap/ui/components/LoadableComponent;", "content", "", "<init>", "(Ljava/lang/String;)V", "isLoading", "", "manager", "Lcom/intellij/ml/llm/riderNext/latest/recap/ui/components/RecapTextComponentsManager;", "startLoading", "", "componentsManager", "stopLoading", "paintComponent", "g", "Ljava/awt/Graphics;", "intellij.ml.llm.riderNext.latest"})
public final class recapTextViewComponent
extends JBHtmlPane
implements LoadableComponent {
    private boolean isLoading;
    @Nullable
    private RecapTextComponentsManager manager;

    public recapTextViewComponent(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        super(new JBHtmlPaneStyleConfiguration(recapTextViewComponent::_init_$lambda$0), new JBHtmlPaneConfiguration());
        this.setOpaque(false);
        this.setText(content2);
    }

    @Override
    public void startLoading(@NotNull RecapTextComponentsManager componentsManager) {
        Intrinsics.checkNotNullParameter((Object)componentsManager, (String)"componentsManager");
        this.isLoading = true;
        this.manager = componentsManager;
        this.repaint();
    }

    @Override
    public void stopLoading() {
        this.isLoading = false;
        this.manager = null;
        this.repaint();
    }

    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (!this.isLoading) {
            super.paintComponent(g);
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int arc = 16;
        g2.setColor(new Color(50, 50, 60, 120));
        g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arc, arc);
        RoundRectangle2D.Float clipShape = new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), arc, arc);
        Shape oldClip = g2.getClip();
        g2.setClip(clipShape);
        int shimmerWidth = (int)((double)this.getWidth() * 0.6);
        int shimmerHeight = this.getHeight();
        int cycleWidth = this.getWidth() + shimmerWidth * 2;
        RecapTextComponentsManager recapTextComponentsManager = this.manager;
        double normalizedOffset = (recapTextComponentsManager != null ? recapTextComponentsManager.getShimmerPosition() : 0.0) % 100.0;
        int startX = (int)((double)(-shimmerWidth) + normalizedOffset / 100.0 * (double)cycleWidth);
        GradientPaint gradient = new GradientPaint(startX, 0.0f, new Color(80, 80, 100, 80), startX + shimmerWidth, shimmerHeight, new Color(150, 150, 170, 100));
        g2.setPaint(gradient);
        g2.fillRoundRect(startX, 0, shimmerWidth, shimmerHeight, arc, arc);
        g2.setClip(oldClip);
    }

    private static final Unit _init_$lambda$0(JBHtmlPaneStyleConfiguration.Builder $this$JBHtmlPaneStyleConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$JBHtmlPaneStyleConfiguration, (String)"$this$JBHtmlPaneStyleConfiguration");
        $this$JBHtmlPaneStyleConfiguration.setSpaceBeforeParagraph(-3);
        $this$JBHtmlPaneStyleConfiguration.setSpaceAfterParagraph(6);
        return Unit.INSTANCE;
    }
}

