/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ruby.refactoring;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.ruby.privacy.ExtensionsKt;
import com.intellij.ml.llm.ruby.privacy.RMethodPrivacyWrapper;
import com.intellij.ml.llm.ruby.refactoring.RubyClassModuleContextUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0005\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/llm/ruby/refactoring/RubyMethodContextUtil;", "", "<init>", "()V", "createFunctionContext", "Lcom/intellij/ml/llm/privacy/PSString;", "method", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/RMethod;", "namePlaceholder", "createMethodContext", "container", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/holders/RContainer;", "appendCompoundStatementBody", "", "compoundStatement", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/blocks/RCompoundStatement;", "buffer", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "prefix", "intellij.ml.llm.ruby"})
public final class RubyMethodContextUtil {
    @NotNull
    public static final RubyMethodContextUtil INSTANCE = new RubyMethodContextUtil();

    private RubyMethodContextUtil() {
    }

    @NotNull
    public final PSString createFunctionContext(@NotNull RMethod method, @NotNull PSString namePlaceholder) {
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)namePlaceholder, (String)"namePlaceholder");
        ConcatenateBuilder buffer = new ConcatenateBuilder(null, 1, null);
        RubyClassModuleContextUtil.appendElementDocumentation$default(RubyClassModuleContextUtil.INSTANCE, (RPsiElement)method, buffer, null, 4, null);
        if (method instanceof RSingletonMethod) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{namePlaceholder};
            pSString = ConstantsKt.getPrivacyConst((String)"self.%s").format(pSStringConvertibleArray);
        } else {
            pSString = namePlaceholder;
        }
        PSString functionName = pSString;
        PSString arguments = PSStringKt.joinToString$default((Iterable)RMethodPrivacyWrapper.parameters$default(ExtensionsKt.getPrivacySafe(method), null, 1, null), null, null, null, (int)0, null, (int)31, null);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"def ")).append(functionName).append(ConstantsKt.getPrivacyConst((String)"(")).append(arguments).append(ConstantsKt.getPrivacyConst((String)")")), null, (int)1, null);
        RCompoundStatement rCompoundStatement = method.getCompoundStatement();
        Intrinsics.checkNotNullExpressionValue((Object)rCompoundStatement, (String)"getCompoundStatement(...)");
        this.appendCompoundStatementBody(rCompoundStatement, buffer, ConstantsKt.getPrivacyConst((String)"  "));
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"end")), null, (int)1, null);
        return buffer.toPSString();
    }

    @NotNull
    public final PSString createMethodContext(@NotNull RContainer container2, @NotNull RMethod method, @NotNull PSString namePlaceholder) {
        PSString pSString;
        PSString visibility;
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)namePlaceholder, (String)"namePlaceholder");
        ConcatenateBuilder buffer = new ConcatenateBuilder(null, 1, null);
        PSString containerType = container2 instanceof RClass ? ConstantsKt.getPrivacyConst((String)"class") : ConstantsKt.getPrivacyConst((String)"module");
        PSString containerFqn = ExtensionsKt.getPrivacySafe(container2).getHumanizedFqnWithNesting();
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(containerType).append(ConstantsKt.getPrivacyConst((String)" ")).append(containerFqn), null, (int)1, null);
        RubyClassModuleContextUtil.INSTANCE.appendElementDocumentation((RPsiElement)method, buffer, ConstantsKt.getPrivacyConst((String)"  "));
        Visibility visibility2 = method.getVisibility();
        switch (visibility2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[visibility2.ordinal()]) {
            case 1: {
                PSString pSString2 = ConstantsKt.getPrivacyConst((String)"protected ");
                break;
            }
            case 2: {
                PSString pSString2 = ConstantsKt.getPrivacyConst((String)"private ");
                break;
            }
            default: {
                PSString pSString2 = visibility = ConstantsKt.getPrivacyConst((String)"");
            }
        }
        if (method instanceof RSingletonMethod) {
            PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{namePlaceholder};
            pSString = ConstantsKt.getPrivacyConst((String)"self.%s").format(pSStringConvertibleArray);
        } else {
            pSString = namePlaceholder;
        }
        PSString methodName = pSString;
        PSString arguments = PSStringKt.joinToString$default((Iterable)RMethodPrivacyWrapper.parameters$default(ExtensionsKt.getPrivacySafe(method), null, 1, null), null, null, null, (int)0, null, (int)31, null);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"  ")).append(visibility).append(ConstantsKt.getPrivacyConst((String)"def ")).append(methodName).append(ConstantsKt.getPrivacyConst((String)"(")).append(arguments).append(ConstantsKt.getPrivacyConst((String)")")), null, (int)1, null);
        RCompoundStatement rCompoundStatement = method.getCompoundStatement();
        Intrinsics.checkNotNullExpressionValue((Object)rCompoundStatement, (String)"getCompoundStatement(...)");
        this.appendCompoundStatementBody(rCompoundStatement, buffer, ConstantsKt.getPrivacyConst((String)"    "));
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"  ")).append(ConstantsKt.getPrivacyConst((String)"end")), null, (int)1, null);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"end")), null, (int)1, null);
        return buffer.toPSString();
    }

    public final void appendCompoundStatementBody(@NotNull RCompoundStatement compoundStatement, @NotNull ConcatenateBuilder buffer, @NotNull PSString prefix) {
        Intrinsics.checkNotNullParameter((Object)compoundStatement, (String)"compoundStatement");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        PSString text2 = ExtensionsKt.getPrivacySafe((RPsiElement)compoundStatement).getText();
        PSString firstLine = PSString.substringBefore$default((PSString)text2, (String)"\n", null, (int)2, null).trimIndent();
        PSString otherLines = text2.substringAfter("\n", "").trimIndent();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{firstLine, otherLines};
        PSString unindentedText = ConstantsKt.getPrivacyConst((String)"%s\n%s").format(pSStringConvertibleArray).trimEnd();
        PSString indentedText = unindentedText.prependIndent(prefix);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(indentedText), null, (int)1, null);
    }

    public static /* synthetic */ void appendCompoundStatementBody$default(RubyMethodContextUtil rubyMethodContextUtil, RCompoundStatement rCompoundStatement, ConcatenateBuilder concatenateBuilder, PSString pSString, int n, Object object) {
        if ((n & 4) != 0) {
            pSString = ConstantsKt.getPrivacyConst((String)"");
        }
        rubyMethodContextUtil.appendCompoundStatementBody(rCompoundStatement, concatenateBuilder, pSString);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Visibility.values().length];
            try {
                nArray[Visibility.PROTECTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Visibility.PRIVATE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

