/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ruby.refactoring;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.ruby.privacy.ExtensionsKt;
import com.intellij.ml.llm.ruby.privacy.RArgumentListPrivacyWrapper;
import com.intellij.ml.llm.ruby.refactoring.RubyClassModuleContextUtil;
import com.intellij.ml.llm.ruby.refactoring.RubyMethodContextUtil;
import com.intellij.ml.llm.ruby.refactoring.UtilKt;
import com.intellij.psi.PsiElement;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.ArgumentInfoPresentation;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RBlockArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssignmentExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RLambdaCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J&\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005J&\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/ruby/refactoring/RubyVariableContextUtil;", "", "<init>", "()V", "createLocalVariableContext", "Lcom/intellij/ml/llm/privacy/PSString;", "variable", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/variables/RIdentifier;", "assignment", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/expressions/RAssignmentExpression;", "namePlaceholder", "createFunctionArgumentContext", "method", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/RMethod;", "argument", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/controlStructures/methods/RArgument;", "createMethodArgumentContext", "container", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/holders/RContainer;", "appendCodeBlockText", "", "block", "Lorg/jetbrains/plugins/ruby/ruby/lang/psi/iterators/RCodeBlock;", "buffer", "Lcom/intellij/ml/llm/privacy/trustedStringBuilders/ConcatenateBuilder;", "appendAssignmentText", "intellij.ml.llm.ruby"})
public final class RubyVariableContextUtil {
    @NotNull
    public static final RubyVariableContextUtil INSTANCE = new RubyVariableContextUtil();

    private RubyVariableContextUtil() {
    }

    @NotNull
    public final PSString createLocalVariableContext(@NotNull RIdentifier variable, @NotNull RAssignmentExpression assignment, @NotNull PSString namePlaceholder) {
        ScopeHolder scopeHolder;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        Intrinsics.checkNotNullParameter((Object)namePlaceholder, (String)"namePlaceholder");
        ConcatenateBuilder buffer = new ConcatenateBuilder(null, 1, null);
        ScopeHolder scopeHolder2 = ScopeUtilCore.findScopeHolder((PsiElement)((PsiElement)variable));
        while (scopeHolder2 instanceof RCodeBlock) {
            PsiElement psiElement = (PsiElement)variable;
            String string = variable.getName();
            Intrinsics.checkNotNull((Object)string);
            if (ScopeUtilCore.getLocalVariable((ScopeHolder)scopeHolder2, (PsiElement)psiElement, (String)string, (Map)((RCodeBlock)scopeHolder2).getVariableDeclarations()) != null) break;
            scopeHolder2 = ScopeUtilCore.findScopeHolder((PsiElement)((PsiElement)scopeHolder2));
        }
        if ((scopeHolder = scopeHolder2) instanceof RMethod) {
            buffer.append(RubyVariableContextUtil.createFunctionArgumentContext$default(this, (RMethod)scopeHolder2, null, null, 6, null));
        } else if (scopeHolder instanceof RCodeBlock) {
            this.appendCodeBlockText((RCodeBlock)scopeHolder2, buffer);
        } else {
            this.appendAssignmentText(variable, assignment, buffer);
        }
        PSString result2 = buffer.toPSString();
        String name = variable.getName();
        if (name != null) {
            return UtilKt.replaceWord(result2, name, namePlaceholder);
        }
        return result2;
    }

    @NotNull
    public final PSString createFunctionArgumentContext(@NotNull RMethod method, @Nullable RArgument argument, @Nullable PSString namePlaceholder) {
        String name;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        ConcatenateBuilder buffer = new ConcatenateBuilder(null, 1, null);
        RubyClassModuleContextUtil.appendElementDocumentation$default(RubyClassModuleContextUtil.INSTANCE, (RPsiElement)method, buffer, null, 4, null);
        PSString methodName = ExtensionsKt.getPrivacySafe(method).getName();
        PSString arguments = PSStringKt.joinToString$default((Iterable)ExtensionsKt.getPrivacySafe(method).parameters(ArgumentInfoPresentation.FULL), null, null, null, (int)0, null, (int)31, null);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"def ")).append(methodName).append(ConstantsKt.getPrivacyConst((String)"(")).append(arguments).append(ConstantsKt.getPrivacyConst((String)")")), null, (int)1, null);
        RCompoundStatement rCompoundStatement = method.getCompoundStatement();
        Intrinsics.checkNotNullExpressionValue((Object)rCompoundStatement, (String)"getCompoundStatement(...)");
        RubyMethodContextUtil.INSTANCE.appendCompoundStatementBody(rCompoundStatement, buffer, ConstantsKt.getPrivacyConst((String)"  "));
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"end")), null, (int)1, null);
        PSString result2 = buffer.toPSString();
        RArgument rArgument = argument;
        String string = name = rArgument != null ? rArgument.getName() : null;
        if (name != null && namePlaceholder != null) {
            return UtilKt.replaceWord(result2, name, namePlaceholder);
        }
        return result2;
    }

    public static /* synthetic */ PSString createFunctionArgumentContext$default(RubyVariableContextUtil rubyVariableContextUtil, RMethod rMethod, RArgument rArgument, PSString pSString, int n, Object object) {
        if ((n & 2) != 0) {
            rArgument = null;
        }
        if ((n & 4) != 0) {
            pSString = null;
        }
        return rubyVariableContextUtil.createFunctionArgumentContext(rMethod, rArgument, pSString);
    }

    @NotNull
    public final PSString createMethodArgumentContext(@NotNull RContainer container2, @NotNull RMethod method, @NotNull RArgument argument, @NotNull PSString namePlaceholder) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"container");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)namePlaceholder, (String)"namePlaceholder");
        ConcatenateBuilder buffer = new ConcatenateBuilder(null, 1, null);
        PSString containerType = container2 instanceof RClass ? ConstantsKt.getPrivacyConst((String)"class") : ConstantsKt.getPrivacyConst((String)"module");
        PSString containerFqn = ExtensionsKt.getPrivacySafe(container2).getHumanizedFqnWithNesting();
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(containerType).append(ConstantsKt.getPrivacyConst((String)" ")).append(containerFqn), null, (int)1, null);
        RubyClassModuleContextUtil.INSTANCE.appendElementDocumentation((RPsiElement)method, buffer, ConstantsKt.getPrivacyConst((String)"  "));
        PSString methodName = ExtensionsKt.getPrivacySafe(method).getName();
        PSString arguments = PSStringKt.joinToString$default((Iterable)ExtensionsKt.getPrivacySafe(method).parameters(ArgumentInfoPresentation.FULL), null, null, null, (int)0, null, (int)31, null);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"  ")).append(ConstantsKt.getPrivacyConst((String)"def ")).append(methodName).append(ConstantsKt.getPrivacyConst((String)"(")).append(arguments).append(ConstantsKt.getPrivacyConst((String)")")), null, (int)1, null);
        RCompoundStatement rCompoundStatement = method.getCompoundStatement();
        Intrinsics.checkNotNullExpressionValue((Object)rCompoundStatement, (String)"getCompoundStatement(...)");
        RubyMethodContextUtil.INSTANCE.appendCompoundStatementBody(rCompoundStatement, buffer, ConstantsKt.getPrivacyConst((String)"    "));
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"  ")).append(ConstantsKt.getPrivacyConst((String)"end")), null, (int)1, null);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"end")), null, (int)1, null);
        PSString pSString = buffer.toPSString();
        String string = argument.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return UtilKt.replaceWord(pSString, string, namePlaceholder);
    }

    private final void appendCodeBlockText(RCodeBlock block, ConcatenateBuilder buffer) {
        RBlockCall it;
        RBlockCall rBlockCall = block.getBlockCall();
        if (rBlockCall != null) {
            it = rBlockCall;
            boolean bl = false;
            RPossibleCall rPossibleCall = it.getCall();
            Intrinsics.checkNotNullExpressionValue((Object)rPossibleCall, (String)"getCall(...)");
            buffer.append(ExtensionsKt.getPrivacySafe((RPsiElement)rPossibleCall).getText()).append(ConstantsKt.getPrivacyConst((String)" "));
        }
        RLambdaCall rLambdaCall = block.getLambdaCall();
        if (rLambdaCall != null) {
            it = rLambdaCall;
            boolean bl = false;
            buffer.append(ConstantsKt.getPrivacyConst((String)"lambda "));
        }
        buffer.append(ConstantsKt.getPrivacyConst((String)"do"));
        RBlockArgumentList rBlockArgumentList = block.getBlockArguments();
        if (rBlockArgumentList != null) {
            it = rBlockArgumentList;
            boolean bl = false;
            buffer.append(ConstantsKt.getPrivacyConst((String)" |")).append(PSStringKt.joinToString$default((Iterable)RArgumentListPrivacyWrapper.parameters$default(ExtensionsKt.getPrivacySafe((RArgumentList)it), null, 1, null), null, null, null, (int)0, null, (int)31, null)).append(ConstantsKt.getPrivacyConst((String)"|"));
        }
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer, null, (int)1, null);
        RCompoundStatement rCompoundStatement = block.getCompoundStatement();
        Intrinsics.checkNotNullExpressionValue((Object)rCompoundStatement, (String)"getCompoundStatement(...)");
        RubyMethodContextUtil.INSTANCE.appendCompoundStatementBody(rCompoundStatement, buffer, ConstantsKt.getPrivacyConst((String)"  "));
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ConstantsKt.getPrivacyConst((String)"end")), null, (int)1, null);
    }

    private final void appendAssignmentText(RIdentifier variable, RAssignmentExpression assignment, ConcatenateBuilder buffer) {
        RubyClassModuleContextUtil.appendElementDocumentation$default(RubyClassModuleContextUtil.INSTANCE, (RPsiElement)variable, buffer, null, 4, null);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)buffer.append(ExtensionsKt.getPrivacySafe((RPsiElement)assignment).getText()), null, (int)1, null);
    }
}

