/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.rust.context;

import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.PrivacySafe;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.PSStringOperatorsKt;
import com.intellij.ml.llm.rust.privacy.CargoTopMessagePrivacyWrapperKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.rust.cargo.project.model.CargoProject;
import org.rust.cargo.project.settings.RsExternalLinterProjectSettingsServiceKt;
import org.rust.cargo.project.settings.RustProjectSettingsServiceKt;
import org.rust.cargo.project.workspace.CargoWorkspace;
import org.rust.cargo.project.workspace.PackageOrigin;
import org.rust.cargo.toolchain.ExternalLinter;
import org.rust.cargo.toolchain.RsToolchainBase;
import org.rust.cargo.toolchain.impl.CargoTopMessage;
import org.rust.cargo.toolchain.impl.RustcSpan;
import org.rust.cargo.toolchain.tools.CargoCheckArgs;
import org.rust.ide.annotator.external.RsExternalLinterResult;
import org.rust.ide.annotator.external.RsExternalLinterService;
import org.rust.lang.core.psi.RsFile;
import org.rust.lang.core.psi.ext.RsElementKt;
import org.rust.openapiext.UtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"collectExternalLinterErrors", "", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lorg/rust/lang/core/psi/RsFile;", "seekingTextRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.ml.llm.rust"})
@SourceDebugExtension(value={"SMAP\nRsCodeContextProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsCodeContextProvider.kt\ncom/intellij/ml/llm/rust/context/RsCodeContextProviderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1617#2,9:93\n1869#2:102\n1870#2:105\n1626#2:106\n1#3:103\n1#3:104\n*S KotlinDebug\n*F\n+ 1 RsCodeContextProvider.kt\ncom/intellij/ml/llm/rust/context/RsCodeContextProviderKt\n*L\n60#1:93,9\n60#1:102\n60#1:105\n60#1:106\n60#1:104\n*E\n"})
public final class RsCodeContextProviderKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ChatAttachment> collectExternalLinterErrors(@NotNull Project project2, @NotNull RsFile file, @NotNull TextRange seekingTextRange) {
        PSStringConvertible[] $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        RsExternalLinterResult externalLinterResult;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)seekingTextRange, (String)"seekingTextRange");
        if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, (PsiFile)file)) {
            return CollectionsKt.emptyList();
        }
        RsToolchainBase rsToolchainBase = RustProjectSettingsServiceKt.getToolchain((Project)project2);
        if (rsToolchainBase == null) {
            return CollectionsKt.emptyList();
        }
        RsToolchainBase toolchain = rsToolchainBase;
        Document document2 = UtilsKt.getDocument((PsiFile)((PsiFile)file));
        if (document2 == null) {
            return CollectionsKt.emptyList();
        }
        Document document3 = document2;
        CargoWorkspace.Target target = RsElementKt.getContainingCargoTarget((PsiElement)((PsiElement)file));
        if (target == null) {
            return CollectionsKt.emptyList();
        }
        CargoWorkspace.Target cargoTarget = target;
        VirtualFile virtualFile2 = file.getVirtualFile();
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile virtualFile3 = virtualFile2;
        if (cargoTarget.getPkg().getOrigin() != PackageOrigin.WORKSPACE) {
            return CollectionsKt.emptyList();
        }
        RsExternalLinterResult rsExternalLinterResult = externalLinterResult = RsExternalLinterService.Companion.getInstance(project2).getResultIfCompleted(toolchain, CargoCheckArgs.Companion.forTarget(project2, cargoTarget));
        List list = rsExternalLinterResult != null ? rsExternalLinterResult.getMessages() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var11_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RustcSpan span;
            PSString pSString;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            CargoTopMessage it = (CargoTopMessage)element$iv$iv;
            boolean bl2 = false;
            if (it.getMessage().getMainSpan() == null) {
                pSString = null;
            } else if (span.getFile_name() == null) {
                pSString = null;
            } else {
                TextRange errorTextRange;
                String fileName;
                String spanFilePath = PathUtil.toSystemIndependentName((String)fileName);
                String string = virtualFile3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Intrinsics.checkNotNull((Object)spanFilePath);
                if (!StringsKt.endsWith$default((String)string, (String)spanFilePath, (boolean)false, (int)2, null)) {
                    pSString = null;
                } else if (span.toTextRange(document3) == null) {
                    pSString = null;
                } else if (!seekingTextRange.intersects(errorTextRange)) {
                    pSString = null;
                } else if (file.getCargoProject() != null) {
                    CargoProject cargoProject;
                    boolean bl3 = false;
                    pSString = CargoTopMessagePrivacyWrapperKt.privacySafe(it.getMessage(), project2, cargoProject).rendered(true);
                } else {
                    pSString = null;
                }
            }
            if (pSString == null) continue;
            PSString it$iv$iv = pSString;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List relevantExternalLinterMessages = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        if (relevantExternalLinterMessages.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        PSString linterName = switch (WhenMappings.$EnumSwitchMapping$0[RsExternalLinterProjectSettingsServiceKt.getExternalLinterSettings((Project)project2).getTool().ordinal()]) {
            case 1 -> ConstantsKt.getPrivacyConst((String)"Cargo Check");
            case 2 -> ConstantsKt.getPrivacyConst((String)"Clippy");
            default -> throw new NoWhenBranchMatchedException();
        };
        $this$mapNotNullTo$iv$iv = new PSStringConvertible[]{linterName};
        PSString attachmentHeading = ConstantsKt.getPrivacyConst((String)"Relevant %s output attachment ").format($this$mapNotNullTo$iv$iv).plus(ConstantsKt.getPrivacyConst((String)"(note that the user does not see this output, so do not quote it directly):\n"));
        PSString externalLinterMessagesText = PSStringKt.joinToString$default((Iterable)relevantExternalLinterMessages, (PrivacySafe)((PrivacySafe)ConstantsKt.getPrivacyConst((String)"")), null, null, (int)0, null, (int)30, null);
        PSString text2 = PSStringOperatorsKt.wrapCodeIntoMarkdownSnippet((PSString)ConstantsKt.getPrivacyConst((String)"txt"), (PSString)externalLinterMessagesText);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{linterName};
        PSString pSString = ConstantsKt.getPrivacyConst((String)"Relevant %s output").format(pSStringConvertibleArray);
        pSStringConvertibleArray = new PSStringConvertible[]{attachmentHeading, text2};
        return CollectionsKt.listOf((Object)new ChatAttachment(pSString, ConstantsKt.getPrivacyConst((String)"%s%s").format(pSStringConvertibleArray), ChatAttachment.Kind.Visible, (VirtualFilePointer)new LightFilePointer((VirtualFile)new LightVirtualFile(linterName + " output.txt", (CharSequence)externalLinterMessagesText)), null, null, null, 112, null));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExternalLinter.values().length];
            try {
                nArray[ExternalLinter.CARGO_CHECK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExternalLinter.CLIPPY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

