/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.inspections;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.sql.SqlLLMBundle;
import com.intellij.ml.llm.sql.inspections.SqlPsiBasedFixProblemIntentionBase;
import com.intellij.ml.llm.sql.inspections.UtilsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00038TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/sql/inspections/SqlFixProblemIntention;", "Lcom/intellij/ml/llm/sql/inspections/SqlPsiBasedFixProblemIntentionBase;", "inspectionMessage", "Lcom/intellij/ml/llm/privacy/PSString;", "<init>", "(Lcom/intellij/ml/llm/privacy/PSString;)V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findStatement", "Lcom/intellij/sql/psi/SqlStatement;", "file", "errorDescription", "getErrorDescription", "()Lcom/intellij/ml/llm/privacy/PSString;", "intellij.ml.llm.sql"})
@SourceDebugExtension(value={"SMAP\nSqlFixProblemIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlFixProblemIntention.kt\ncom/intellij/ml/llm/sql/inspections/SqlFixProblemIntention\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,28:1\n66#2,2:29\n*S KotlinDebug\n*F\n+ 1 SqlFixProblemIntention.kt\ncom/intellij/ml/llm/sql/inspections/SqlFixProblemIntention\n*L\n23#1:29,2\n*E\n"})
public final class SqlFixProblemIntention
extends SqlPsiBasedFixProblemIntentionBase {
    @Nullable
    private PSString inspectionMessage;

    public SqlFixProblemIntention(@Nullable PSString inspectionMessage) {
        this.inspectionMessage = inspectionMessage;
    }

    public /* synthetic */ SqlFixProblemIntention(PSString pSString, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pSString = null;
        }
        this(pSString);
    }

    @NotNull
    public String getFamilyName() {
        return SqlLLMBundle.message("fix.problem.action.family.text", new Object[0]);
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!super.isAvailable(project2, editor2, psiFile)) {
            return false;
        }
        SqlStatement sqlStatement = this.findStatement(editor2, psiFile);
        if (sqlStatement == null) {
            return false;
        }
        this.setStatement(sqlStatement);
        PSString pSString = UtilsKt.extractInspectionMessageAtCaret(project2, editor2);
        if (pSString == null) {
            return false;
        }
        this.inspectionMessage = pSString;
        return true;
    }

    private final SqlStatement findStatement(Editor editor2, PsiFile file) {
        SqlStatement sqlStatement;
        PsiElement psiElement = file.findElementAt(editor2.getCaretModel().getOffset());
        if (psiElement != null) {
            PsiElement $this$parentOfType_u24default$iv = psiElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            sqlStatement = (SqlStatement)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, SqlStatement.class, (boolean)true);
        } else {
            sqlStatement = null;
        }
        return sqlStatement;
    }

    @Override
    @NotNull
    protected PSString getErrorDescription() {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{this.inspectionMessage};
        return ConstantsKt.getPrivacyConst((String)"\"%s\"").format(pSStringConvertibleArray);
    }

    public SqlFixProblemIntention() {
        this(null, 1, null);
    }
}

