/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.textmate;

import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeSnippetLanguage;
import com.intellij.ml.llm.core.chat.ui.codeSnippet.CodeSnippetLanguageProvider;
import com.intellij.ml.llm.textmate.TextMateCodeSnippetLanguage;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0006H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/textmate/TextMateCodeSnippetLanguageProvider;", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguageProvider;", "<init>", "()V", "languageIdentifierToFileExtensionMapping", "", "", "languageIdentifierToDisplayNameMapping", "createCodeSnippetLanguage", "Lcom/intellij/ml/llm/core/chat/ui/codeSnippet/CodeSnippetLanguage;", "languageId", "findTextMateLanguage", "Lcom/intellij/ml/llm/textmate/TextMateCodeSnippetLanguage;", "intellij.ml.llm.textmate"})
@SourceDebugExtension(value={"SMAP\nTextMateCodeSnippetLanguageProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextMateCodeSnippetLanguageProvider.kt\ncom/intellij/ml/llm/textmate/TextMateCodeSnippetLanguageProvider\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n488#2,7:128\n478#2:135\n424#2:136\n1252#3,4:137\n1056#3:141\n1#4:142\n*S KotlinDebug\n*F\n+ 1 TextMateCodeSnippetLanguageProvider.kt\ncom/intellij/ml/llm/textmate/TextMateCodeSnippetLanguageProvider\n*L\n109#1:128,7\n110#1:135\n110#1:136\n110#1:137,4\n111#1:141\n*E\n"})
public final class TextMateCodeSnippetLanguageProvider
implements CodeSnippetLanguageProvider {
    @NotNull
    private final Map<String, String> languageIdentifierToFileExtensionMapping;
    @NotNull
    private final Map<String, String> languageIdentifierToDisplayNameMapping;

    public TextMateCodeSnippetLanguageProvider() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"csharp", (Object)"cs"), TuplesKt.to((Object)"objective-c", (Object)"m"), TuplesKt.to((Object)"objective-c++", (Object)"mm")};
        this.languageIdentifierToFileExtensionMapping = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"bibtex", (Object)"BibTeX"), TuplesKt.to((Object)"csharp", (Object)"C#"), TuplesKt.to((Object)"cpp", (Object)"C++"), TuplesKt.to((Object)"fsharp", (Object)"F#"), TuplesKt.to((Object)"objc", (Object)"Objective-C"), TuplesKt.to((Object)"objective-c", (Object)"Objective-C"), TuplesKt.to((Object)"objc++", (Object)"Objective-C++"), TuplesKt.to((Object)"objective-c++", (Object)"Objective-C++"), TuplesKt.to((Object)"php", (Object)"PHP")};
        this.languageIdentifierToDisplayNameMapping = MapsKt.mapOf((Pair[])pairArray);
    }

    @Nullable
    public CodeSnippetLanguage createCodeSnippetLanguage(@Nullable String languageId) {
        if (languageId == null) {
            return null;
        }
        return this.findTextMateLanguage(languageId);
    }

    /*
     * WARNING - void declaration
     */
    private final TextMateCodeSnippetLanguage findTextMateLanguage(String languageId) {
        void $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map $this$filterKeys$iv;
        TextMateService textMateService = TextMateService.getInstance();
        String string = this.languageIdentifierToFileExtensionMapping.get(languageId);
        if (string != null) {
            String fileExtension = string;
            boolean bl = false;
            TextMateLanguageDescriptor textMateLanguageDescriptor = textMateService.getLanguageDescriptorByExtension((CharSequence)fileExtension);
            if (textMateLanguageDescriptor != null) {
                TextMateLanguageDescriptor it = textMateLanguageDescriptor;
                boolean bl2 = false;
                return new TextMateCodeSnippetLanguage(fileExtension, TextMateCodeSnippetLanguageProvider.findTextMateLanguage$convertLanguageIdentifierToDisplayName(this, languageId));
            }
        }
        TextMateLanguageDescriptor textMateLanguageDescriptor = textMateService.getLanguageDescriptorByExtension((CharSequence)languageId);
        if (textMateLanguageDescriptor != null) {
            TextMateLanguageDescriptor it = textMateLanguageDescriptor;
            boolean bl = false;
            String string2 = languageId.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return new TextMateCodeSnippetLanguage(string2, TextMateCodeSnippetLanguageProvider.findTextMateLanguage$convertLanguageIdentifierToDisplayName(this, languageId));
        }
        Map map2 = textMateService.getFileNameMatcherToScopeNameMapping();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getFileNameMatcherToScopeNameMapping(...)");
        Map map3 = map2;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            TextMateFileNameMatcher it = (TextMateFileNameMatcher)entry$iv.getKey();
            boolean bl = false;
            if (!(it instanceof TextMateFileNameMatcher.Extension)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        $this$filterKeys$iv = result$iv;
        boolean $i$f$mapKeys = false;
        result$iv = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            TextMateFileNameMatcher key = (TextMateFileNameMatcher)entry.getKey();
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher.Extension");
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TextMateFileNameMatcher.Extension extension = (TextMateFileNameMatcher.Extension)key;
            Map map5 = map4;
            boolean bl3 = false;
            entry = it$iv$iv.getValue();
            map5.put(extension, entry);
        }
        Iterable $this$sortedBy$iv = destination$iv$iv.entrySet();
        boolean $i$f$sortedBy = false;
        List mapping = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((TextMateFileNameMatcher.Extension)it.getKey()).getExtension().length());
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((TextMateFileNameMatcher.Extension)it.getKey()).getExtension().length()));
            }
        });
        for (Map.Entry entry : mapping) {
            TextMateFileNameMatcher.Extension matcher = (TextMateFileNameMatcher.Extension)entry.getKey();
            CharSequence scopeName = (CharSequence)entry.getValue();
            String scopeNameAsString = ((Object)scopeName).toString();
            if (!StringsKt.equals((String)scopeNameAsString, (String)("source." + languageId), (boolean)true) && !StringsKt.equals((String)scopeNameAsString, (String)("text." + languageId), (boolean)true)) continue;
            return new TextMateCodeSnippetLanguage(matcher.getExtension(), TextMateCodeSnippetLanguageProvider.findTextMateLanguage$convertLanguageIdentifierToDisplayName(this, languageId));
        }
        return null;
    }

    private static final String findTextMateLanguage$convertLanguageIdentifierToDisplayName(TextMateCodeSnippetLanguageProvider this$0, String languageId) {
        String string = this$0.languageIdentifierToDisplayNameMapping.get(languageId);
        if (string == null) {
            boolean bl = false;
            string = StringsKt.capitalize((String)languageId);
        }
        return string;
    }
}

