/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.std.FilePathPrivacyWrapperKt;
import com.intellij.ml.llm.privacy.extensions.std.StringWriterPrivacyWrapper;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.UnifiedDiffWriter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.project.ProjectKt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JC\u0010\n\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u000f2\b\b\u0002\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0013\u001a\u00020\u000fH\u0002J\u0016\u0010\u001a\u001a\u00020\u00162\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002J\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/vcs/LLMVcsPatchBuilder;", "Lcom/intellij/ml/llm/privacy/extensions/std/StringWriterPrivacyWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "basePath", "Ljava/nio/file/Path;", "getBasePath", "()Ljava/nio/file/Path;", "addPatches", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "includeTooLargeOrBinary", "", "changesLimit", "", "honorExcludedFromCommit", "shortenDeletedFiles", "(Ljava/util/Collection;ZLjava/lang/Integer;ZZ)Lcom/intellij/ml/llm/vcs/LLMVcsPatchBuilder;", "writePatches", "", "patches", "", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "writeDiffForBinaryFiles", "relativePath", "Lcom/intellij/ml/llm/privacy/PSString;", "patchBasePath", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "Companion", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nLLMVcsPatchBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMVcsPatchBuilder.kt\ncom/intellij/ml/llm/vcs/LLMVcsPatchBuilder\n+ 2 ControlFlow.kt\nai/grazie/utils/ControlFlowKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n4#2,4:126\n12#2,4:130\n2813#3,10:134\n1869#4,2:144\n1869#4,2:146\n*S KotlinDebug\n*F\n+ 1 LLMVcsPatchBuilder.kt\ncom/intellij/ml/llm/vcs/LLMVcsPatchBuilder\n*L\n41#1:126,4\n42#1:130,4\n44#1:134,10\n59#1:144,2\n76#1:146,2\n*E\n"})
public final class LLMVcsPatchBuilder
extends StringWriterPrivacyWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final String LINE_SEPARATOR = "\n";

    public LLMVcsPatchBuilder(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }

    private final Path getBasePath() {
        return ProjectKt.getStateStore((Project)this.project).getProjectBasePath();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final LLMVcsPatchBuilder addPatches(@NotNull Collection<? extends Change> changes2, boolean includeTooLargeOrBinary, @Nullable Integer changesLimit, boolean honorExcludedFromCommit, boolean shortenDeletedFiles) {
        void changesToProcess;
        Sequence sequence;
        Sequence sequence2;
        void $this$chainIf$iv;
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        Sequence sequence3 = SequencesKt.filterNot((Sequence)CollectionsKt.asSequence((Iterable)changes2), arg_0 -> LLMVcsPatchBuilder.addPatches$lambda$0(this, arg_0));
        boolean condition$iv = !includeTooLargeOrBinary;
        boolean $i$f$chainIf = false;
        if (condition$iv) {
            void $this$addPatches_u24lambda_u242 = $this$chainIf$iv;
            boolean bl = false;
            sequence2 = SequencesKt.filterNot((Sequence)$this$addPatches_u24lambda_u242, LLMVcsPatchBuilder::addPatches$lambda$2$lambda$1);
        } else {
            sequence2 = $this$chainIf$iv;
        }
        $this$chainIf$iv = sequence2;
        Integer value$iv = changesLimit;
        boolean $i$f$chainIfNotNull = false;
        if (value$iv != null) {
            void limit;
            int $this$addPatches_u24lambda_u242 = ((Number)value$iv).intValue();
            void $this$addPatches_u24lambda_u243 = $this$chainIfNotNull$iv;
            boolean bl = false;
            sequence = SequencesKt.take((Sequence)$this$addPatches_u24lambda_u243, (int)limit);
        } else {
            sequence = $this$chainIfNotNull$iv;
        }
        void $this$partition$iv = changesToProcess = sequence;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Change it = (Change)element$iv;
            boolean bl = false;
            boolean bl2 = LLMVcsPatchBuilder.Companion.isBinaryOrTooLarge(it) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        sequence3 = new Pair(first$iv, second$iv);
        List noPatchChanges = (List)sequence3.component1();
        List textFilesChanges = (List)sequence3.component2();
        if (!((Collection)textFilesChanges).isEmpty()) {
            List list = IdeaTextPatchBuilder.buildPatch((Project)this.project, (Collection)textFilesChanges, (Path)this.getBasePath(), (boolean)false, (boolean)honorExcludedFromCommit);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"buildPatch(...)");
            List patches = list;
            this.writePatches(patches, shortenDeletedFiles);
        }
        if (includeTooLargeOrBinary) {
            this.writeDiffForBinaryFiles(noPatchChanges);
        }
        return this;
    }

    public static /* synthetic */ LLMVcsPatchBuilder addPatches$default(LLMVcsPatchBuilder lLMVcsPatchBuilder, Collection collection, boolean bl, Integer n, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        return lLMVcsPatchBuilder.addPatches(collection, bl, n, bl2, bl3);
    }

    private final void writePatches(List<? extends FilePatch> patches, boolean shortenDeletedFiles) {
        Iterable $this$forEach$iv = patches;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FilePatch patch = (FilePatch)element$iv;
            boolean bl = false;
            if (patch instanceof TextFilePatch && ((TextFilePatch)patch).isDeletedFile() && shortenDeletedFiles) {
                PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{SharedExtensionsKtKt.getPrivacySafe((FilePath)((FilePath)new LocalFilePath(((TextFilePatch)patch).getBeforeName(), false))).getPath()};
                this.write(ConstantsKt.getPrivacyConst((String)"\n            deleted file %s\n        ").format(pSStringConvertibleArray).trimIndent().plus(ConstantsKt.getPrivacyConst((String)LINE_SEPARATOR)));
                continue;
            }
            UnifiedDiffWriter.writeBeforePath((Writer)this.getWriter(), (FilePatch)patch, (String)LINE_SEPARATOR, (boolean)false);
            UnifiedDiffWriter.writeAfterPath((Writer)this.getWriter(), (FilePatch)patch, (String)LINE_SEPARATOR, (boolean)false);
            if (!(patch instanceof TextFilePatch)) continue;
            UnifiedDiffWriter.writeHunk((Writer)this.getWriter(), (TextFilePatch)((TextFilePatch)patch), (String)LINE_SEPARATOR, (String)LINE_SEPARATOR);
        }
    }

    private final void writeDiffForBinaryFiles(List<? extends Change> changes2) {
        Iterable $this$forEach$iv = changes2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PSStringConvertible[] fileStatus;
            Change change = (Change)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)change.getFileStatus(), (String)"getFileStatus(...)");
            ContentRevision contentRevision = change.getBeforeRevision();
            PSString beforeFilePath = this.relativePath(this.getBasePath(), (FilePath)(contentRevision != null ? contentRevision.getFile() : null));
            ContentRevision contentRevision2 = change.getAfterRevision();
            PSString afterFilePath = this.relativePath(this.getBasePath(), (FilePath)(contentRevision2 != null ? contentRevision2.getFile() : null));
            PSStringConvertible[] pSStringConvertibleArray = fileStatus;
            PSString whatIsHappened = Intrinsics.areEqual((Object)pSStringConvertibleArray, (Object)FileStatus.ADDED) ? ConstantsKt.getPrivacyConst((String)"new file") : (Intrinsics.areEqual((Object)pSStringConvertibleArray, (Object)FileStatus.DELETED) ? ConstantsKt.getPrivacyConst((String)"deleted file") : (Intrinsics.areEqual((Object)pSStringConvertibleArray, (Object)FileStatus.MODIFIED) ? (!Intrinsics.areEqual((Object)beforeFilePath, (Object)afterFilePath) ? ConstantsKt.getPrivacyConst((String)"renamed file") : ConstantsKt.getPrivacyConst((String)"changed file")) : ConstantsKt.getPrivacyConst((String)"")));
            pSStringConvertibleArray = new PSStringConvertible[]{beforeFilePath, afterFilePath, whatIsHappened};
            this.write(ConstantsKt.getPrivacyConst((String)"\n            diff %s %s\n            %s\n        ").format(pSStringConvertibleArray).trimIndent().plus(ConstantsKt.getPrivacyConst((String)LINE_SEPARATOR)));
        }
    }

    private final PSString relativePath(Path patchBasePath, FilePath filePath) {
        if (filePath == null) {
            return ConstantsKt.getPrivacyConst((String)"/dev/null");
        }
        if (patchBasePath == null) {
            return SharedExtensionsKtKt.getPrivacySafe((FilePath)filePath).getPath();
        }
        File file = patchBasePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        PSString relativePath = FilePathPrivacyWrapperKt.getRelativePathPrivacySafe((File)file, (File)new File(filePath.getPath()));
        if (relativePath == null) {
            return SharedExtensionsKtKt.getPrivacySafe((FilePath)filePath).getPath();
        }
        return relativePath;
    }

    private static final boolean addPatches$lambda$0(LLMVcsPatchBuilder this$0, Change it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Companion.isPrivate(it, this$0.project);
    }

    private static final boolean addPatches$lambda$2$lambda$1(Change it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return LLMVcsPatchBuilder.Companion.isBinaryOrTooLarge(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\f\u0010\f\u001a\u00020\u0007*\u00020\tH\u0002J\u000e\u0010\f\u001a\u00020\u0007*\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/llm/vcs/LLMVcsPatchBuilder$Companion;", "", "<init>", "()V", "LINE_SEPARATOR", "", "isPrivate", "", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "project", "Lcom/intellij/openapi/project/Project;", "isBinaryOrTooLarge", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "intellij.ml.llm.vcs"})
    @SourceDebugExtension(value={"SMAP\nLLMVcsPatchBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLMVcsPatchBuilder.kt\ncom/intellij/ml/llm/vcs/LLMVcsPatchBuilder$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,125:1\n1#2:126\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RequiresReadLock
        public final boolean isPrivate(@NotNull Change change, @NotNull Project project2) {
            boolean bl;
            ContentRevision it;
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ContentRevision contentRevision = change.getBeforeRevision();
            if (contentRevision != null) {
                it = contentRevision;
                boolean bl2 = false;
                FilePath filePath = it.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFile(...)");
                if (PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, filePath)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return true;
            ContentRevision contentRevision2 = change.getAfterRevision();
            if (contentRevision2 == null) return false;
            it = contentRevision2;
            boolean bl3 = false;
            FilePath filePath = it.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFile(...)");
            if (!PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, filePath)) return false;
            return true;
        }

        private final boolean isBinaryOrTooLarge(Change $this$isBinaryOrTooLarge) {
            return this.isBinaryOrTooLarge($this$isBinaryOrTooLarge.getBeforeRevision()) || this.isBinaryOrTooLarge($this$isBinaryOrTooLarge.getAfterRevision());
        }

        private final boolean isBinaryOrTooLarge(ContentRevision $this$isBinaryOrTooLarge) {
            if (IdeaTextPatchBuilder.isBinaryRevision((ContentRevision)$this$isBinaryOrTooLarge)) {
                return true;
            }
            if ($this$isBinaryOrTooLarge instanceof CurrentContentRevision) {
                VirtualFile virtualFile2 = ((CurrentContentRevision)$this$isBinaryOrTooLarge).getVirtualFile();
                return virtualFile2 != null && VirtualFileUtil.isTooLarge((VirtualFile)virtualFile2);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

