/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.context;

import com.intellij.icons.AllIcons;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.vcs.context.CommitChatAttachment;
import com.intellij.ml.llm.vcs.context.GitCommitPrivacyWrapper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010-\u001a\u0004\u0018\u00010.H\u0096@\u00a2\u0006\u0002\u0010/J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u0018\u001a\u000f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0019\u00a2\u0006\u0002\b\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0019\u0010\u001d\u001a\u00070\t\u00a2\u0006\u0002\b\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0014\u0010\"\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R$\u0010$\u001a\u0012\u0012\u000e\u0012\f0%\u00a2\u0006\u0002\b&\u00a2\u0006\u0002\b'0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0017R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/vcs/context/CommitContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "project", "Lcom/intellij/openapi/project/Project;", "vcsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "message", "", "diff", "Lcom/intellij/ml/llm/privacy/PSString;", "commitHash", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/ml/llm/privacy/PSString;Ljava/lang/String;Lcom/intellij/ml/llm/context/ContextEntitySource;)V", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "id", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/AtomicProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/AtomicProperty;", "hint", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Lcom/intellij/openapi/util/NlsSafe;", "getHint", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "text", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getIcon", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nCommitsContextPopupContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitsContextPopupContributor.kt\ncom/intellij/ml/llm/vcs/context/CommitContextAttachment\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n30#2,2:133\n*S KotlinDebug\n*F\n+ 1 CommitsContextPopupContributor.kt\ncom/intellij/ml/llm/vcs/context/CommitContextAttachment\n*L\n114#1:133,2\n*E\n"})
final class CommitContextAttachment
extends ContextAttachmentBase {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile vcsRoot;
    @NotNull
    private final String message;
    @NotNull
    private final PSString diff;
    @NotNull
    private final String commitHash;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final String id;
    @NotNull
    private final AtomicProperty<String> name;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final PSString text;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final AtomicProperty<Icon> icon;
    @NotNull
    private final ContextEntityPrivacy privacy;

    public CommitContextAttachment(@NotNull Project project2, @NotNull VirtualFile vcsRoot, @NotNull String message, @NotNull PSString diff2, @NotNull String commitHash, @NotNull ContextEntitySource attachedBy) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
        Intrinsics.checkNotNullParameter((Object)attachedBy, (String)"attachedBy");
        this.project = project2;
        this.vcsRoot = vcsRoot;
        this.message = message;
        this.diff = diff2;
        this.commitHash = commitHash;
        this.attachedBy = attachedBy;
        this.id = "PROJECT_COMMIT_" + this.commitHash;
        this.name = new AtomicProperty((Object)this.message);
        this.text = ConstantsKt.getPrivacyConst((String)"");
        this.tooltipText = this.message;
        this.popupPresentationText = this.message;
        this.icon = new AtomicProperty((Object)AllIcons.Vcs.CommitNode);
        this.privacy = ContextEntityPrivacy.Unrelated.INSTANCE;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public AtomicProperty<String> getName() {
        return this.name;
    }

    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public AtomicProperty<Icon> getIcon() {
        return this.icon;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        if (StringsKt.isBlank((CharSequence)((CharSequence)this.diff))) {
            return null;
        }
        GitCommitPrivacyWrapper wrapper = new GitCommitPrivacyWrapper(this.message, this.commitHash);
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{wrapper.getSubject(), this.diff};
        PSString attachmentText = ConstantsKt.getPrivacyConst((String)"\n      Commit \"%s\" attached by the user:\n      ---START---\n      %s\n      ---END-----\n      ").trimIndent().format(pSStringConvertibleArray);
        return new CommitChatAttachment(this.project, this.vcsRoot, this.message, ConstantsKt.getPrivacyConst((String)"Git Commit: ").plus(wrapper.getHash()), attachmentText, this.diff, this.commitHash, this.getAttachedBy(), ChatAttachment.Kind.Visible);
    }

    public void performAction(boolean isInMessage) {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<VcsLogObjectsFactory> serviceClass$iv = VcsLogObjectsFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        VcsLogObjectsFactory factory = (VcsLogObjectsFactory)object;
        Hash hash = factory.createHash(this.commitHash);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"createHash(...)");
        Hash hash2 = hash;
        VcsLogNavigationUtil.jumpToRevisionAsync((Project)this.project, (VirtualFile)this.vcsRoot, (Hash)hash2, null);
    }
}

