/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.selfReview.agent;

import ai.grazie.code.agents.core.event.AgentHandlerContext;
import ai.grazie.code.agents.core.event.ErrorHandler;
import ai.grazie.code.agents.core.event.EventHandler;
import ai.grazie.code.agents.core.event.ResultHandler;
import ai.grazie.code.agents.core.event.ToolCallListener;
import ai.grazie.code.agents.core.model.agent.AIAgentStrategy;
import ai.grazie.code.agents.core.model.agent.AgentSystemPrompt;
import ai.grazie.code.agents.core.tools.Tool;
import ai.grazie.code.agents.core.tools.ToolRegistry;
import ai.grazie.code.agents.core.tools.ToolStage;
import ai.grazie.code.agents.ideformer.IdeFormerAgent;
import ai.grazie.code.agents.ideformer.connection.IdeFormerClient;
import ai.grazie.code.agents.ideformer.model.agent.IdeFormerAgentStrategy;
import ai.grazie.code.agents.ideformer.model.agent.configs.IdeFormerAgentConfig;
import ai.grazie.code.agents.ideformer.model.agent.configs.simple.GrazieSimpleAgentConfig;
import ai.grazie.code.agents.ideformer.model.llm.GrazieLLMConfig;
import ai.grazie.code.files.model.FileSystemProvider;
import ai.grazie.code.files.model.filter.TraversalFilter;
import ai.grazie.code.files.sandbox.FileSystemSandbox;
import ai.grazie.code.files.vfs.VirtualPath;
import ai.grazie.model.llm.profile.LLMProfileID;
import com.intellij.ml.llm.codeEngine.IJFileSystemProvider;
import com.intellij.ml.llm.codeEngine.IJVirtualPathKt;
import com.intellij.ml.llm.core.LLMPromptsKt;
import com.intellij.ml.llm.core.models.LlmProfileService;
import com.intellij.ml.llm.core.models.api.AiaLlmProfileID;
import com.intellij.ml.llm.grazie.GrazieUtilsKt;
import com.intellij.ml.llm.ideFormer.IdeFormerAgentService;
import com.intellij.ml.llm.vcs.LLMVcsBundle;
import com.intellij.ml.llm.vcs.selfReview.agent.FileSystemReadTools;
import com.intellij.ml.llm.vcs.selfReview.agent.VcsAISelfReviewAgent;
import com.intellij.ml.llm.vcs.selfReview.agent.VcsAISelfReviewStateHandler;
import com.intellij.ml.llm.vcs.selfReview.agent.VcsAISelfReviewUtilsKt;
import com.intellij.ml.llm.vcs.selfReview.agent.model.VcsAISelfReviewResult;
import com.intellij.ml.llm.vcs.selfReview.agent.tools.GetFileDiffTool;
import com.intellij.ml.llm.vcs.selfReview.agent.tools.GetFileTool;
import com.intellij.ml.llm.vcs.selfReview.agent.tools.GetProjectReviewRulesTool;
import com.intellij.ml.llm.vcs.selfReview.agent.tools.ListReviewChangesTool;
import com.intellij.ml.llm.vcs.selfReview.agent.tools.NoteProblemTool;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TaskCancellation;
import com.intellij.platform.ide.progress.TasksKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0001\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ*\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0082@\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u00192\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/VcsAISelfReviewAgent;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "canRun", "", "execute", "Lkotlinx/coroutines/Job;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "stateHandler", "Lcom/intellij/ml/llm/vcs/selfReview/agent/VcsAISelfReviewStateHandler;", "afterCancel", "Lkotlin/Function0;", "", "getLlmProfileIfLoaded", "Lai/grazie/model/llm/profile/LLMProfileID;", "getLlmProfileIfAvailable", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "calculateTotalLinesInChangedFiles", "", "determineMaxAgentIterations", "toolsCount", "totalInputSize", "Companion", "intellij.ml.llm.vcs"})
@SourceDebugExtension(value={"SMAP\nVcsAISelfReviewAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsAISelfReviewAgent.kt\ncom/intellij/ml/llm/vcs/selfReview/agent/VcsAISelfReviewAgent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,195:1\n1617#2,9:196\n1869#2:205\n1870#2:207\n1626#2:208\n1#3:206\n1#3:209\n14#4:210\n*S KotlinDebug\n*F\n+ 1 VcsAISelfReviewAgent.kt\ncom/intellij/ml/llm/vcs/selfReview/agent/VcsAISelfReviewAgent\n*L\n177#1:196,9\n177#1:205\n177#1:207\n177#1:208\n177#1:206\n43#1:210\n*E\n"})
public final class VcsAISelfReviewAgent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String AGENT_NAME = "vcs-ai-self-review";
    @NotNull
    private static final String AGENT_VERSION = "1.0";

    public VcsAISelfReviewAgent(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project2;
        this.cs = cs;
    }

    public final boolean canRun() {
        return this.getLlmProfileIfLoaded() != null;
    }

    @NotNull
    public final Job execute(@NotNull List<? extends Change> changes2, @NotNull VcsAISelfReviewStateHandler stateHandler, @NotNull Function0<Unit> afterCancel) {
        VirtualFile projectDir;
        Intrinsics.checkNotNullParameter(changes2, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)stateHandler, (String)"stateHandler");
        Intrinsics.checkNotNullParameter(afterCancel, (String)"afterCancel");
        VirtualFile virtualFile2 = projectDir = ProjectUtil.guessProjectDir((Project)this.project);
        Path projectRoot = virtualFile2 != null ? virtualFile2.toNioPath() : null;
        Object object = projectDir;
        if (object == null || (object = IJVirtualPathKt.toVirtualPath(object)) == null) {
            throw new IllegalStateException("Cannot find project root".toString());
        }
        FileSystemSandbox.ReadOnly fsSandbox = FileSystemSandbox.INSTANCE.create(object, VirtualPath.Companion.getROOT(), TraversalFilter.Companion.Any(), (FileSystemProvider.ReadOnly)IJFileSystemProvider.ReadOnly.INSTANCE);
        ToolRegistry toolRegistry = ToolRegistry.Companion.invoke(arg_0 -> VcsAISelfReviewAgent.execute$lambda$2(this, projectRoot, changes2, stateHandler, fsSandbox, arg_0));
        String prompt2 = "              You are an AI assistant that is helping developers review their code.\n              You are given a number of tools to view the changes that the user has asked you to review.\n              \n              AT FIRST, USE 'get-project-review-rules-path' TOOL TO GET 'PATH' AND THEN READ THE GIVEN 'PATH' BY USING 'read_file' TOOL TO LOAD \"REVIEW PROJECT RULES\".\n              IF \"REVIEW PROJECT RULES\" PRESENT, FOLLOW THE INSTRUCTIONS IN THE PROJECT RULES TO REVIEW THE CHANGES.\n              \n              If \"REVIEW PROJECT RULES\" not present, then pay close attention to:\n               - Possible security vulnerabilities\n               - Hard-to-notice bugs\n               - Code that may not be intended to be committed, such as local debugging prints or gibberish\n               - Notably bad code style\n               - Anything else that may have been missed by static analysis tooling\n              \n              In your review, you do not need to note every formatting issue. If you find a formatting issue, please note it only once.\n              \n              When you have found a problem, report it through the provided tool.\n              You can report multiple problems, only finish after you have reported all.\n              \n              ONLY ANSWER WITH A CALL TO A TOOL!\n              DO NOT HALLUCINATE!";
        EventHandler eventHandler2 = EventHandler.Companion.invoke$default((EventHandler.Companion)EventHandler.Companion, null, arg_0 -> VcsAISelfReviewAgent.execute$lambda$3(stateHandler, arg_0), (int)1, null);
        return BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, afterCancel, stateHandler, prompt2, changes2, toolRegistry, eventHandler2, null){
            Object L$0;
            int label;
            final /* synthetic */ VcsAISelfReviewAgent this$0;
            final /* synthetic */ Function0<Unit> $afterCancel;
            final /* synthetic */ VcsAISelfReviewStateHandler $stateHandler;
            final /* synthetic */ String $prompt;
            final /* synthetic */ List<Change> $changes;
            final /* synthetic */ ToolRegistry $toolRegistry;
            final /* synthetic */ EventHandler $eventHandler;
            {
                this.this$0 = $receiver;
                this.$afterCancel = $afterCancel;
                this.$stateHandler = $stateHandler;
                this.$prompt = $prompt;
                this.$changes = $changes;
                this.$toolRegistry = $toolRegistry;
                this.$eventHandler = $eventHandler;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        TaskCancellation.Cancellable taskCancellation = TaskCancellation.Companion.cancellable().withTooltipText(LLMVcsBundle.message("selfReview.problems.analyzing.stop", new Object[0]));
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)taskCancellation);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)VcsAISelfReviewAgent.access$getProject$p(this.this$0), (String)LLMVcsBundle.message("selfReview.problems.analyzing", new Object[0]), (TaskCancellation)((TaskCancellation)taskCancellation), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$prompt, this.$changes, this.$toolRegistry, this.$eventHandler, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            int label;
                            final /* synthetic */ VcsAISelfReviewAgent this$0;
                            final /* synthetic */ String $prompt;
                            final /* synthetic */ List<Change> $changes;
                            final /* synthetic */ ToolRegistry $toolRegistry;
                            final /* synthetic */ EventHandler $eventHandler;
                            {
                                this.this$0 = $receiver;
                                this.$prompt = $prompt;
                                this.$changes = $changes;
                                this.$toolRegistry = $toolRegistry;
                                this.$eventHandler = $eventHandler;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = VcsAISelfReviewAgent.access$getLlmProfileIfAvailable(this.this$0, (Continuation)this);
                                        if (v0 == var7_2) {
                                            return var7_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        if ((llmProfileId = (LLMProfileID)v0) == null) {
                                            VcsAISelfReviewAgent.access$getLOG$cp().warn("No LLM profile available for AI self-review");
                                            return Unit.INSTANCE;
                                        }
                                        agentConfig = new GrazieSimpleAgentConfig(new GrazieLLMConfig(llmProfileId, "vcs-ai-self-review", "1.0", 0, 0.0, 24, null), new AgentSystemPrompt(this.$prompt), VcsAISelfReviewAgent.access$determineMaxAgentIterations(this.this$0, 5, VcsAISelfReviewAgent.access$calculateTotalLinesInChangedFiles(this.this$0, this.$changes)));
                                        agent = IdeFormerAgentStrategy.Simple.Grazie.Universal.INSTANCE;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)llmProfileId);
                                        this.L$1 = agentConfig;
                                        this.L$2 = agent;
                                        this.label = 2;
                                        v1 = IdeFormerAgentService.Companion.getInstance(VcsAISelfReviewAgent.access$getProject$p(this.this$0)).getAgentClient((Continuation)this);
                                        if (v1 == var7_2) {
                                            return var7_2;
                                        }
                                        ** GOTO lbl32
                                    }
                                    case 2: {
                                        agent = (IdeFormerAgentStrategy.Simple.Grazie.Universal)this.L$2;
                                        agentConfig = (GrazieSimpleAgentConfig)this.L$1;
                                        llmProfileId = (LLMProfileID)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl32:
                                        // 2 sources

                                        client = (IdeFormerClient)v1;
                                        runner = new IdeFormerAgent((AIAgentStrategy)agent, (IdeFormerAgentConfig)agentConfig, client, this.$toolRegistry, this.$eventHandler);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)llmProfileId);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)agentConfig);
                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)agent);
                                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)client);
                                        this.L$4 = SpillingKt.nullOutSpilledVariable((Object)runner);
                                        this.label = 3;
                                        v2 = runner.run("Start reviewing provided changes", (Continuation)this);
                                        if (v2 == var7_2) {
                                            return var7_2;
                                        }
                                        ** GOTO lbl52
                                    }
                                    case 3: {
                                        runner = (IdeFormerAgent)this.L$4;
                                        client = (IdeFormerClient)this.L$3;
                                        agent = (IdeFormerAgentStrategy.Simple.Grazie.Universal)this.L$2;
                                        agentConfig = (GrazieSimpleAgentConfig)this.L$1;
                                        llmProfileId = (LLMProfileID)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl52:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object2;
                        TaskCancellation.Cancellable taskCancellation = (TaskCancellation.Cancellable)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Exception e) {
                            if (e instanceof CancellationException) {
                                this.$afterCancel.invoke();
                                throw e;
                            }
                            this.$stateHandler.setErrorState(e, null);
                            VcsAISelfReviewAgent.access$getLOG$cp().warn("Failed to execute AI self-review agent", (Throwable)e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final LLMProfileID getLlmProfileIfLoaded() {
        AiaLlmProfileID aiaLlmProfileID = LlmProfileService.Companion.getInstance().getLlmProfileIdIfLoaded(LLMPromptsKt.getAI_SELF_REVIEW());
        return aiaLlmProfileID != null ? GrazieUtilsKt.toLLMProfileID((AiaLlmProfileID)aiaLlmProfileID) : null;
    }

    /*
     * Unable to fully structure code
     */
    private final Object getLlmProfileIfAvailable(Continuation<? super LLMProfileID> $completion) {
        if (!($completion instanceof getLlmProfileIfAvailable.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ VcsAISelfReviewAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VcsAISelfReviewAgent.access$getLlmProfileIfAvailable(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = LlmProfileService.Companion.getInstance().getLlmProfileIdIfAvailable(LLMPromptsKt.getAI_SELF_REVIEW(), (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                v1 = (AiaLlmProfileID)v0;
                return v1 != null ? GrazieUtilsKt.toLLMProfileID((AiaLlmProfileID)v1) : null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int calculateTotalLinesInChangedFiles(List<? extends Change> changes2) {
        int n;
        try {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = changes2;
            int $i$f$mapNotNull = 0;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv$iv$iv.iterator();
            while (object.hasNext()) {
                Path it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = object.next();
                boolean bl = false;
                Change p0 = (Change)element$iv$iv;
                boolean bl2 = false;
                if (VcsAISelfReviewUtilsKt.getFile(p0) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            $i$f$mapNotNull = 0;
            for (Object e : iterable2) {
                int n2;
                void file;
                Path $i$f$mapNotNullTo2 = (Path)e;
                int n3 = $i$f$mapNotNull;
                boolean bl = false;
                object = Files.newBufferedReader((Path)file, Charsets.UTF_8);
                Throwable throwable = null;
                try {
                    BufferedReader bufferedReader = (BufferedReader)object;
                    Intrinsics.checkNotNull((Object)bufferedReader);
                    Sequence line = TextStreamsKt.lineSequence((BufferedReader)bufferedReader);
                    boolean bl4 = false;
                    n2 = SequencesKt.count((Sequence)line);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                int n4 = n2;
                $i$f$mapNotNull = n3 + n4;
            }
            n = $i$f$mapNotNull;
        }
        catch (IOException e) {
            LOG.warn("Failed to calculate total number of lines", (Throwable)e);
            n = 0;
        }
        return n;
    }

    private final int determineMaxAgentIterations(int toolsCount, int totalInputSize) {
        int maxIterationCount = Registry.Companion.intValue("vcs.llm.self.review.agent.max.iterations");
        if (maxIterationCount > 0) {
            return maxIterationCount;
        }
        int coefficient = 10;
        int defaultMaxAgentIterations = 50;
        return Math.max(toolsCount * (totalInputSize / coefficient), defaultMaxAgentIterations);
    }

    private static final Unit execute$lambda$2$lambda$1(VcsAISelfReviewAgent this$0, Path $projectRoot, List $changes, VcsAISelfReviewStateHandler $stateHandler, FileSystemSandbox.ReadOnly $fsSandbox, ToolStage.Builder $this$stage) {
        Intrinsics.checkNotNullParameter((Object)$this$stage, (String)"$this$stage");
        FileSystemReadTools $this$execute_u24lambda_u242_u24lambda_u241_u24lambda_u240 = FileSystemReadTools.INSTANCE;
        boolean bl = false;
        $this$execute_u24lambda_u242_u24lambda_u241_u24lambda_u240.all($this$stage, (FileSystemProvider.ReadOnly)$fsSandbox);
        $this$stage.tool((Tool)new GetProjectReviewRulesTool(this$0.project));
        $this$stage.tool((Tool)new ListReviewChangesTool($projectRoot, $changes));
        $this$stage.tool((Tool)new GetFileDiffTool(this$0.project, $changes));
        $this$stage.tool((Tool)new GetFileTool(this$0.project, $projectRoot, $changes));
        $this$stage.tool((Tool)new NoteProblemTool($stateHandler));
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$2(VcsAISelfReviewAgent this$0, Path $projectRoot, List $changes, VcsAISelfReviewStateHandler $stateHandler, FileSystemSandbox.ReadOnly $fsSandbox, ToolRegistry.Builder $this$ToolRegistry) {
        Intrinsics.checkNotNullParameter((Object)$this$ToolRegistry, (String)"$this$ToolRegistry");
        ToolRegistry.Builder.stage$default((ToolRegistry.Builder)$this$ToolRegistry, (String)"default", null, arg_0 -> VcsAISelfReviewAgent.execute$lambda$2$lambda$1(this$0, $projectRoot, $changes, $stateHandler, $fsSandbox, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit execute$lambda$3(VcsAISelfReviewStateHandler $stateHandler, EventHandler.Builder $this$EventHandler) {
        Intrinsics.checkNotNullParameter((Object)$this$EventHandler, (String)"$this$EventHandler");
        $this$EventHandler.handleError(new ErrorHandler($stateHandler){
            final /* synthetic */ VcsAISelfReviewStateHandler $stateHandler;
            {
                this.$stateHandler = $stateHandler;
            }

            public final Object handle(AgentHandlerContext $this$handleError, Throwable e, Continuation<? super Boolean> $completion) {
                this.$stateHandler.setErrorState(e, null);
                if (e instanceof IllegalArgumentException) {
                    VcsAISelfReviewAgent.access$getLOG$cp().warn("Exception during communication with AI agent", e);
                } else {
                    VcsAISelfReviewAgent.access$getLOG$cp().warn("Unhandled exception", e);
                }
                return Boxing.boxBoolean((boolean)true);
            }
        });
        $this$EventHandler.handleResult(new ResultHandler($stateHandler){
            final /* synthetic */ VcsAISelfReviewStateHandler $stateHandler;
            {
                this.$stateHandler = $stateHandler;
            }

            public final Object handle(AgentHandlerContext $this$handleResult, String value2, Continuation<? super Unit> $completion) {
                VcsAISelfReviewAgent.access$getLOG$cp().debug("Result received: " + value2);
                if (value2 == null) {
                    this.$stateHandler.setErrorState(null, null);
                } else {
                    this.$stateHandler.setFullReviewState(new VcsAISelfReviewResult(this.$stateHandler.getCurrentRequest(), null, 2, null));
                }
                return Unit.INSTANCE;
            }
        });
        $this$EventHandler.onToolCall((ToolCallListener)execute.eventHandler.1.3.INSTANCE);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Project access$getProject$p(VcsAISelfReviewAgent $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$getLlmProfileIfAvailable(VcsAISelfReviewAgent $this, Continuation $completion) {
        return $this.getLlmProfileIfAvailable((Continuation<? super LLMProfileID>)$completion);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ int access$determineMaxAgentIterations(VcsAISelfReviewAgent $this, int toolsCount, int totalInputSize) {
        return $this.determineMaxAgentIterations(toolsCount, totalInputSize);
    }

    public static final /* synthetic */ int access$calculateTotalLinesInChangedFiles(VcsAISelfReviewAgent $this, List changes2) {
        return $this.calculateTotalLinesInChangedFiles(changes2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsAISelfReviewAgent.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/vcs/selfReview/agent/VcsAISelfReviewAgent$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "AGENT_NAME", "", "AGENT_VERSION", "intellij.ml.llm.vcs"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

