/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PunctuationTypos {
    private static final Pattern rightPartPattern = Pattern.compile("^[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]{1,}([\\[;,][\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]{1,})*");
    private static final Pattern leftPartPattern = Pattern.compile("[\\[;,\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]*[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]$");

    private static String escapeChars(String input) {
        return input.replaceAll("([\\[\\]{}()?*])", "\\\\$1");
    }

    public static NodePattern findCommonTypos(String message, Map<String, String> symbolReplacement, @Nullable String allowedBeforeSymbols) {
        String symbolString = PunctuationTypos.escapeChars(String.join((CharSequence)"", symbolReplacement.keySet()));
        NodePattern correctBeforeSymbols = allowedBeforeSymbols != null ? NodePattern.N.noSpaceBefore().directlyAfter(NodePattern.N.form(allowedBeforeSymbols)).andNot(NodePattern.N.form("\\[").spaceBefore()) : NodePattern.not(NodePattern.N);
        return NodePattern.or(NodePattern.N.form("[" + symbolString + "]").andOr(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.letterWord).andNot(NodePattern.N.form("\\[").spaceBefore()), correctBeforeSymbols), NodePattern.N.form("[\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]{1,}[" + symbolString + "][\u00c4\u00dc\u00d6\u00e4\u00fc\u00f6\u00df\\w]{1,}")).andNot(NodePattern.N.form("\\[").before(NodePattern.N.form("]"))).and(NodePattern.custom((typo, match) -> {
            String token;
            String text2 = typo.tree().text();
            int startOffset = typo.form().length() > 1 ? typo.startOffset() + StringUtils.indexOfAny((CharSequence)typo.form(), (char[])symbolString.toCharArray()) : typo.startOffset();
            int endOffset = typo.form().length() > 1 ? typo.endOffset() : startOffset + 1;
            Matcher matcher = rightPartPattern.matcher(text2.substring(endOffset));
            if (matcher.find()) {
                endOffset += matcher.end();
            }
            if ((matcher = leftPartPattern.matcher(text2.substring(0, startOffset))).find()) {
                startOffset = matcher.start();
            }
            String string = token = startOffset != endOffset ? text2.substring(startOffset, endOffset) : typo.form();
            if (token.length() < 3 || typo.tree().treeSupport().isAcceptedBySpellchecker(token.substring(1))) {
                return null;
            }
            for (Map.Entry entry2 : symbolReplacement.entrySet()) {
                token = token.replace((CharSequence)entry2.getKey(), (CharSequence)entry2.getValue());
            }
            if (!typo.tree().treeSupport().isAcceptedBySpellchecker(token)) {
                return null;
            }
            return match.withCorrector(NodeCorrector.rawReplace(startOffset, endOffset, token)).withMessage(String.format(message, token));
        }));
    }
}

