/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.regex.Regex;
import ai.grazie.rules.util.regex.RegexMatcher;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.intellij.lang.annotations.Language;

public abstract class TreeDisambiguator {
    protected Tree tree;
    private static final Map<String, RegexMatcher> patternCache = new ConcurrentHashMap<String, RegexMatcher>();

    protected TreeDisambiguator(Tree tree) {
        this.tree = tree;
    }

    public abstract Tree disambiguateByTree();

    protected Iterable<Node> currentNodes() {
        return new AbstractList<Node>(){

            @Override
            public Node get(int index) {
                return TreeDisambiguator.this.tree.nodes().get(index);
            }

            @Override
            public int size() {
                return TreeDisambiguator.this.tree.nodes().size();
            }
        };
    }

    protected Node removeIfPossible(Node node, @Language(value="RegExp") String posPattern) {
        return this.removeIfPossible(node, TreeDisambiguator.filterReadings(node, posPattern));
    }

    protected Node removeIfPossible(Node node, List<Tree.Reading> toRemove) {
        if (toRemove.size() < node.tokenReadings().size()) {
            return this.removeReadings(node, toRemove);
        }
        return node;
    }

    protected Node removeReadings(Node node, List<Tree.Reading> toRemove) {
        this.tree = this.tree.withoutReadings(node, toRemove);
        return this.tree.nodes().get(node.index);
    }

    private static RegexMatcher cachedPattern(String regexp) {
        RegexMatcher pattern = patternCache.get(regexp);
        if (pattern == null) {
            pattern = Regex.parse(regexp).caseSensitiveMatcher();
            patternCache.put(regexp, pattern);
        }
        return pattern;
    }

    protected static List<Tree.Reading> filterReadings(Node node, String posRegexp) {
        RegexMatcher pattern = TreeDisambiguator.cachedPattern(posRegexp);
        ArrayList<Tree.Reading> list = new ArrayList<Tree.Reading>();
        for (Tree.Reading t : node.tokenReadings()) {
            if (t.pos() == null || !pattern.matches(t.pos())) continue;
            list.add(t);
        }
        return list;
    }
}

