/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.de.DigraphNormalization;
import ai.grazie.rules.de.GermanCrazyParseDetector;
import ai.grazie.rules.de.GermanParameters;
import ai.grazie.rules.de.GermanTreeDisambiguator;
import ai.grazie.rules.de.PunctuationRules;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNullByDefault;

@NotNullByDefault
public class GermanTreeSupport
extends TreeSupport {
    private static final NodePattern lowerCase = NodePattern.N.anyPos().noPos("SUB.*|EIG.*");
    private static final NodePattern noun = NodePattern.N.pos("SUB.*").noPos(".*ADJ");

    public GermanTreeSupport(org.languagetool.Language language) {
        super(language);
        assert (language.getShortCode().equals("de"));
    }

    @Override
    public String getCloudTreeModelName() {
        return "gml-all-trf-v4-exp";
    }

    @Override
    public List<String> getCloudParserOptions() {
        return EXP_CLOUD_PARSER_TOKENIZER_V2_OPTIONS;
    }

    @Override
    public boolean needsNer() {
        return true;
    }

    @Override
    public Tree buildTree(String text2, List<SentenceWithTreeDependencies.Node> conllu) {
        return new GermanTreeDisambiguator(super.buildTree(text2, conllu)).disambiguateByTree();
    }

    @Override
    public boolean isTrulyLowerCase(Node node) {
        return lowerCase.matches(node);
    }

    @Override
    protected Tagger createTagger() {
        return GermanTreeSupport.createTagger(this.language());
    }

    static LTTagger createTagger(org.languagetool.Language language) {
        return new LTTagger(language){

            @Override
            public String normalizeToken(String token) {
                if (!token.contains("\u0308")) {
                    return token;
                }
                return token.replaceAll("a\u0308", "\u00e4").replaceAll("A\u0308", "\u00c4").replaceAll("o\u0308", "\u00f6").replaceAll("O\u0308", "\u00d6").replaceAll("u\u0308", "\u00fc").replaceAll("U\u0308", "\u00dc");
            }
        };
    }

    @Override
    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        String lowLemma;
        List<String> result2 = super.synthesize(form, lemma, srcPos, targetPos);
        if (lemma.equals("Mensch") && !targetPos.matches(".*NOM:SIN.*")) {
            return List.of("Menschen");
        }
        if (lemma.equals("Eindruck") && targetPos.matches(".*PLU.*")) {
            result2.removeIf(s -> s.startsWith("Eindruck"));
        }
        if (lemma.contains(" ")) {
            return List.of();
        }
        if ("dies".equals(lemma) && !"dies".equalsIgnoreCase(form)) {
            result2.remove("dies");
        }
        if ("niemand".equals(lemma) && targetPos.matches(".*(GEN|DAT|AKK).*")) {
            result2.remove("niemand");
        }
        if ("eigen".equals(lemma)) {
            result2.removeIf(s -> s.contains("eign"));
        }
        if (lemma.contains("schliessen") || lemma.contains("schlie\u00dfen")) {
            result2.removeIf(s -> s.contains("schlo\u00df"));
        }
        if (lemma.endsWith("schlu\u00df")) {
            return List.of();
        }
        if (lemma.equals("wissen") || lemma.equals("wi\u00dfen")) {
            result2.removeIf(s -> s.contains("wi\u00dft") || s.contains("wu\u00dft"));
        }
        if (lemma.contains("fassen") || lemma.equals("fa\u00dfen")) {
            result2.removeIf(s -> s.contains("fa\u00dft"));
        }
        if ((lowLemma = lemma.toLowerCase(Locale.ROOT)).endsWith("land")) {
            result2.removeIf(s -> s.toLowerCase(Locale.ROOT).matches(".*landen?"));
        }
        if (lowLemma.endsWith("gang") && !lowLemma.matches("(street|jugend)gang") && targetPos.matches(".*PLU.*")) {
            result2.removeIf(s -> s.toLowerCase(Locale.ROOT).matches(".+gangs"));
        }
        if (lowLemma.endsWith("thema")) {
            result2.removeIf(s -> s.toLowerCase(Locale.ROOT).endsWith("themata"));
        }
        if (lowLemma.matches("(lese)?eck")) {
            return List.of();
        }
        String lowForm = form.toLowerCase(Locale.ROOT);
        if (lowForm.matches("ich|mi(r|ch)")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("ich|mi(r|ch)"));
        }
        if (lowForm.matches("du|di(r|ch)")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("du|di(r|ch)"));
            if (result2.contains("dir")) {
                result2.remove("Dir");
            }
        }
        if (lowForm.matches("e[rs]|ih[mn]")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("e[rs]|ih[mn]"));
        }
        if (lowForm.matches("sie|ihnen")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("sie|i(hr|hnen)"));
        }
        if (lowForm.matches("wir|uns")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("wir|uns"));
        }
        if (lowForm.matches("euch")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).matches("ihr|euch"));
        }
        if (lowForm.matches("mein(e[mnsr]?)?")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("mein"));
        }
        if (lowForm.matches("dein(e[mnsr]?)?")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("dein"));
        }
        if (lowForm.matches("sein(e[mnsr]?)?") && targetPos.matches("PRO.*")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("sein"));
        }
        if (lowForm.matches("unser(e[mnsr]?)?")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("unser"));
        }
        if (lowForm.matches("eue?r(e[mnsr]?)?")) {
            result2.removeIf(s -> !s.toLowerCase(Locale.ROOT).startsWith("eu"));
        }
        if (form.matches("Ihr(e[mnsr])?")) {
            result2.removeIf(s -> !s.startsWith("Ihr"));
        }
        if (form.matches("ihr")) {
            result2.removeIf(s -> !s.matches("ihnen|sie|ihr(e[mnsr]?)?"));
        }
        if (form.matches("(?iu)all(e.?)?") && !"all".equals(lemma)) {
            result2.addAll(super.synthesize(form, "all", srcPos, targetPos));
        }
        if (form.matches("eur(e.?)?")) {
            result2.removeIf(s -> s.startsWith("euer"));
        }
        if (targetPos.matches(".*DAT:SIN.*")) {
            result2.removeIf(s -> s.equals(lemma + "e") || lemma.endsWith("s") && s.equals(lemma + "se"));
        }
        if (targetPos.matches("VER.*:1:SIN:PR\u00c4.*") && !lemma.matches("sein|wissen|m\u00fcssen|d\u00fcrfen|sollen|m\u00f6gen|k\u00f6nnen|wollen")) {
            result2.removeIf(s -> !s.endsWith("e"));
        }
        if (lemma.equals("Ideale")) {
            return List.of();
        }
        if (lemma.endsWith("erer")) {
            if (targetPos.matches(".*GEN:SIN.*")) {
                return List.of(lemma + "s");
            }
            if (targetPos.matches(".*DAT:PLU.*")) {
                return List.of(lemma + "n");
            }
            return List.of(lemma);
        }
        if (lemma.matches(".*[Mm]odul")) {
            if (srcPos.endsWith("NEU")) {
                if (targetPos.contains("DAT:PLU")) {
                    return List.of(lemma + "en");
                }
                if (targetPos.contains(":PLU")) {
                    return List.of(lemma + "e");
                }
            }
            if (srcPos.endsWith("MAS") && targetPos.contains("PLU")) {
                return List.of(lemma + "n");
            }
        }
        result2.remove("Lohnn");
        return result2;
    }

    @Override
    public CrazyParseDetector crazyParseDetector() {
        return GermanCrazyParseDetector.INSTANCE;
    }

    @Override
    public String quote(String text2) {
        return "\u201e" + text2 + "\u201c";
    }

    @Override
    public Quotes getAllQuotes() {
        return PunctuationRules.genericQuotes;
    }

    @Override
    protected boolean shouldPreserveCase(TextChange.Replacement change, Tree tree, String prevText) {
        Node firstNode = tree.findNodeAt(change.range().start());
        return super.shouldPreserveCase(change, tree, prevText) && !noun.matches(firstNode) && (firstNode == null || firstNode.form().length() >= prevText.length() || !prevText.equalsIgnoreCase(change.replacement()));
    }

    @Override
    public List<String> inflectNode(Node node, @Language(value="RegExp") String posRegex, String posReplacement) {
        String variant;
        Pattern posPattern = Pattern.compile(posRegex);
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        Tree.Token readings = this.tagToken(node.form());
        boolean isSwiss = GermanParameters.VARIANT.getValue(node.tree()).equals("CH");
        if (readings.tokenReadings().isEmpty() && isSwiss && (variant = (String)DigraphNormalization.generateCombinations(node.form(), Map.of("ss", "\u00df")).stream().filter(c -> node.tree().treeSupport().isAcceptedBySpellchecker((String)c)).findFirst().orElse(null)) != null && !variant.equals(node.form())) {
            readings = this.tagToken(variant);
        }
        for (Tree.Reading reading : readings.tokenReadings()) {
            Matcher matcher;
            String posTag = reading.pos();
            String lemma = reading.lemma();
            if (posTag == null || lemma == null || !(matcher = posPattern.matcher(posTag)).matches()) continue;
            String targetPos = matcher.replaceAll(posReplacement);
            result2.addAll(this.synthesize(node.form(), lemma, posTag, targetPos).stream().map(v -> isSwiss ? v.replaceAll("\u00df", "ss") : v).toList());
        }
        return new ArrayList<String>(result2);
    }

    @Override
    protected Tree disambiguateWithParameters(Tree tree) {
        if (!GermanParameters.VARIANT.getValue(tree).equals("CH")) {
            return tree;
        }
        TreeSupport support = tree.treeSupport();
        for (Node dep : tree.nodes()) {
            String variant;
            if (!dep.lemmaReadings().isEmpty() || !dep.form().contains("ss") || (variant = (String)DigraphNormalization.generateCombinations(dep.form(), Map.of("ss", "\u00df")).stream().filter(c -> support.isAcceptedBySpellchecker((String)c)).findFirst().orElse(null)) == null || variant.equals(dep.form())) continue;
            tree = tree.withReadings(dep, tree.treeSupport().tagToken(variant).tokenReadings());
        }
        return tree;
    }
}

