/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.LemmaChanges;
import ai.grazie.rules.de.SpellingRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import java.util.List;
import org.languagetool.tools.StringTools;

class Redundancy {
    private static final String REDUNDANCY_MSG = "Vermeiden Sie die Verwendung von \u00fcberfl\u00fcssigen Ausdr\u00fccken";
    private static final String UND_SOWIE_MSG = "\u201eSowie\u201c ist eine Variante von \u201eund\u201c in Aufz\u00e4hlungen";
    private static final String UND_ETC_MSG = "Das \u201eet\u201c in \u201eet cetera\u201c hat bereits die Bedeutung von \u201eund\u201c";
    private static final String EXPLIZIT_BETONEN_MSG = "\u201eExplizit\u201c ist redundant, da \u201e$Verb\u201c bereits eine Hervorhebung impliziert";
    private static final String ZUNEHMEND_COMPARATIVE_ADJ_MSG = "Vermeiden Sie die doppelte Steigerung";
    private static final String WENN_DANN_MSG = "\u201eDann\u201c ist redundant, da der Hauptsatz bereits die Konsequenz impliziert";
    private static final String TAEGLICHER_ALLTAG_MSG = "\u201eT\u00e4glich\u201c und \u201eAlltag\u201c haben eine \u00e4hnliche Bedeutung";
    private static final String WORDS_REPEATED_DIFFERENT_MEANING = "Die doppelte Erw\u00e4hnung des Zeitpunkts \u201emorgen\u201c und \u201eam Morgen\u201c ist redundant";
    private static final NodePattern reaktivieren = NodePattern.N.form("reaktivier(e|en|t|st|te|test|ten|tet)?");
    static final NodePattern antworten = NodePattern.N.lemma("antworten|erwidern");
    static final NodePattern zurueck = NodePattern.N.form("zur(ue?|\u00fc)ck");
    private static final NodePattern obligatoryFirstPlace = NodePattern.or(CommonPatterns.firstToken.inPhrase(GermanTreePatterns.clause), NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("cc|punct").andNot(CommonPatterns.parenthesis)).directlyBefore(GermanTreePatterns.clause).andNot(NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.pos("PA2.*").withHeadRelation("acl"))), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("cop|aux.*").beforeHead()));
    public static final String verbPrefix = "(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?)";
    public static final String prefixedVerbWithZu = "(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?)zu.{3,}";
    public static final String prefixedVerb = "(r?(ab|an|auf|aus(einander)?|unter)|bei|da(bei)?|dar(an|zwischen)?|ein|empor|ent(gegen|lang|zwei)?|fehl|fern|fest|fort|frei|gegen\u00fcber|gleich|heim|her(ab|an|auf|aus|bei|ein|um|unter|vor|\u00fcber)?|hin(ab|auf|aus|ein|terher|unter|weg|zu)?|hoch|los|mit|nach|nebenher|nieder|statt|vor(an|aus|bei|weg|\u00fcber)?|weg|weiter|zu(recht|r\u00fcck|sammen)?).{3,}";

    Redundancy() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.REDUNDANCY", "Verwendung von \u00fcberfl\u00fcssigen Ausdr\u00fccken", "Die Verwendung von beiden W\u00f6rtern nebeneinander ist \u00fcberfl\u00fcssig, da sie denselben Sachverhalt ausdr\u00fccken.", "https://www.concisum.de/redundanz/", NodePattern.or(Redundancy.vonWoher(), Redundancy.zentralerKernbaustein(), Redundancy.ehemaligerEx(), Redundancy.entstammenAus(), Redundancy.redundantFirstPartCompoundPattern(), Redundancy.undSowie(), Redundancy.undEtc(), Redundancy.ebenfallsAuch(), Redundancy.adverbNoch(), Redundancy.wiederErneuern(), Redundancy.zusammenMiteinader(), Redundancy.zunehmendComparativeAdj(), Redundancy.explizitBetonen(), Redundancy.zurueckAntworten(), Redundancy.mitEinbeziehen(), Redundancy.weiterFortschreiten(), Redundancy.einzelnSeparatGetrennt(), Redundancy.zuletztAbschliessend(), Redundancy.exemplarischesBeispiel(), Redundancy.ergaenzenderZusatz(), Redundancy.kommunikativeMitteilung(), Redundancy.darueberHinausEbenfalls(), Redundancy.nurBeschraenkenAuf(), Redundancy.strukturellerAufbau(), Redundancy.restriktiveBeschraenkung(), Redundancy.zunehmendSteigern(), Redundancy.moeglichesPotenzial(), Redundancy.taeglicherAlltag(), Redundancy.zeitlichSynchron(), Redundancy.scheintAnscheinend(), Redundancy.innenHohl(), Redundancy.exaktGenau(), Redundancy.alsoFolglich(), Redundancy.ploetzlichAufEinmal(), Redundancy.zusaetzlchHinzu(), Redundancy.ungefaehrFast(), Redundancy.baeuerlichRustikal(), Redundancy.moeglicherweiseKann(), Redundancy.freiwilligGewollt(), Redundancy.weltweitDerWelt(), Redundancy.einanderGegenseitig(), Redundancy.twoAdverbs(), Redundancy.faehigkeitZuKoennen(), Redundancy.sameMeaningAdjNoun(), Redundancy.rechtlichLegal(), Redundancy.waehrendDesVerlaufs(), Redundancy.sameMeaningHyphenatedNounPattern()), new Example("Wer greift auf das Netzwerk zu und <b>von woher</b>?", "\u201evon\u201c ist redundant, da \u201ewoher\u201c bereits den Ursprung, die Herkunft oder den Grund signalisiert", "Wer greift auf das Netzwerk zu und <b>woher</b>?"), new Example("Ende 2019 fl\u00fcchtet der <b>ehemalige Ex</b>-Pr\u00e4sident Ghosn in einem gro\u00dfen Instrumentenkoffer", REDUNDANCY_MSG, "Ende 2019 fl\u00fcchtet der <b>Ex</b>-Pr\u00e4sident Ghosn in einem gro\u00dfen Instrumentenkoffer", "Ende 2019 fl\u00fcchtet der <b>ehemalige Pr\u00e4sident</b> Ghosn in einem gro\u00dfen Instrumentenkoffer"), new Example("Alle vier Gr\u00fcndungsmitglieder <b>entstammen aus</b> derselbigen Ortschaft", REDUNDANCY_MSG, "Alle vier Gr\u00fcndungsmitglieder <b>entstammen</b> derselbigen Ortschaft", "Alle vier Gr\u00fcndungsmitglieder <b>stammen</b> aus derselbigen Ortschaft", "Alle vier Gr\u00fcndungsmitglieder <b>kommen</b> aus derselbigen Ortschaft"), new Example("Die <b>Hauptprotagonistin</b> wohnt in der Domstadt nahe beim Hauptbahnhof", "\u201eProtagonistin\u201c impliziert bereits \u201eHaupt\u201c", "Die <b>Protagonistin</b> wohnt in der Domstadt nahe beim Hauptbahnhof", "Die <b>Hauptfigur</b> wohnt in der Domstadt nahe beim Hauptbahnhof")).styleFlavor(StyleFlavor.Readability), new Rule.PatternRule("Style.REDUNDANT_DANN", "Verwendung von \u00fcberfl\u00fcssigen Ausdr\u00fccken", "Beim formellen Schreiben k\u00f6nnen unn\u00f6tige W\u00f6rter oder Redundanzen weggelassen werden.", "https://learngerman.dw.com/de/nebens\u00e4tze-mit-wenn/l-40888861/gr-42070431", Redundancy.wennDann(), new Example("<i>Wenn</i> ich abnehme, <b>dann</b> werde ich schlank sein.", WENN_DANN_MSG, "<i>Wenn</i> ich abnehme, <b>werde</b> ich schlank sein.")).styleFlavor(StyleFlavor.Readability), new Rule.PatternRule("Style.AWKWARD_WORDING", "Doppelter Gebrauch eines Wortes mit unterschiedlicher Bedeutung", "Durch die doppelte Verwendung des Wortes klingt der Satz stilistisch redundant.", null, Redundancy.morgenAmMorgen(), new Example("Ich komme <b>morgen am Morgen</b> wieder", WORDS_REPEATED_DIFFERENT_MEANING, "Ich komme <b>morgen Vormittag</b> wieder", "Ich komme <b>morgen fr\u00fch</b> wieder")).styleFlavor(StyleFlavor.Readability));
    }

    private static NodePattern vonWoher() {
        NodePattern herHin = NodePattern.N.form("her|hin");
        return NodePattern.N.form("(da|wo)h(in|er)").includeIntoReport().markAs("Adverb").andOptionally(NodePattern.N.directlyAfter(NodePattern.N.form("von").includeIntoReport().markAs("Von"))).andOptionally(CommonPatterns.possiblyConj(NodePattern.N.withHead("obl|mark|advmod", NodePattern.N.pos("VER.*").andOr(NodePattern.N.lemma("(her|hin).*").noLemma("(hin|her)(aus|auf|unter|\u00fcber|ein|nach|um|weg|zu|tereinander).*|herstellen").noDependents("advcl").markAs("PrefixedVerb").includeIntoReport(), NodePattern.N.after("Adverb").markAs("VerbWithoutPrefix").andOptionally(NodePattern.N.directlyAfter(NodePattern.N.form("zu").markAs("Zu"))).includeIntoReport().withOptionalDependent("compound:prt|advmod", herHin.markAs("Prefix").includeIntoReport().withOptionalDependent("conj", herHin.markAs("ConjHerHin"))))))).and((node, match) -> {
            String msgRemoveVon;
            Node von = match.findMarkedNode("Von");
            Node verbWithPrefix = match.findMarkedNode("PrefixedVerb");
            Node conjHerHin = match.findMarkedNode("ConjHerHin");
            Node verbWithoutPrefix = match.findMarkedNode("VerbWithoutPrefix");
            Node separatedPrefix = match.findMarkedNode("Prefix");
            Node zu = match.findMarkedNode("Zu");
            String woDa = node.lowForm().substring(0, 2);
            String messageWithoutVon = von == null && node.hasForm("hin(.*)") || separatedPrefix != null && separatedPrefix.hasForm("hin") ? "\u201ehin\u201c ist redundant, da \u201e" + node.lowForm() + "\u201c bereits die Richtung signalisiert" : "\u201eher\u201c ist redundant, da \u201e" + node.lowForm() + "\u201c bereits den Ursprungsort oder die Herkunft signalisiert";
            String string = msgRemoveVon = von != null && verbWithPrefix != null ? "\u201evon\u201c, \u201e" + node.lowForm() + "\u201c sowie das Verbpr\u00e4fix sind redundant, da sie alle den Ursprung, die Herkunft oder den Grund signalisieren" : "\u201evon\u201c ist redundant, da \u201e" + node.lowForm() + "\u201c bereits den Ursprung, die Herkunft oder den Grund signalisiert";
            if (von == null && separatedPrefix != null && conjHerHin == null) {
                return match.withCorrector(NodeCorrector.replace(node, woDa)).withCorrector(NodeCorrector.removeNode(separatedPrefix)).withMessage(messageWithoutVon);
            }
            if (verbWithPrefix != null) {
                String newVerb = verbWithPrefix.lowForm().substring(3);
                if (!verbWithPrefix.tree().treeSupport().tagToken(newVerb).hasPos("VER.*")) {
                    return null;
                }
                if (von == null) {
                    return match.withCorrector(NodeCorrector.replace(verbWithPrefix, newVerb)).withCorrector(NodeCorrector.replace(node, woDa)).withMessage(messageWithoutVon);
                }
                return match.withCorrector(NodeCorrector.replace(verbWithPrefix, newVerb).join(NodeCorrector.removeNode(von))).withCorrector(NodeCorrector.replace(node, woDa).join(NodeCorrector.removeNode(von))).withMessage(msgRemoveVon);
            }
            if (von != null && conjHerHin != null) {
                return match.withCorrector(NodeCorrector.removeNode(von)).withMessage(msgRemoveVon);
            }
            if (conjHerHin == null) {
                if (von != null && separatedPrefix == null && verbWithoutPrefix != null && zu == null) {
                    Node verbEndOfClause;
                    if (verbWithoutPrefix.hasForm(prefixedVerb)) {
                        return match.withCorrector(NodeCorrector.removeNode(von)).withMessage(msgRemoveVon);
                    }
                    NodeCorrector removeVon = NodeCorrector.removeNode(von);
                    NodeCorrector corrector = NodeCorrector.replaceNodes(von, node, woDa);
                    boolean subordinateClauseTagsForVerb = verbWithoutPrefix.hasHeadRelation("parataxis|conj|csubj");
                    Node verbPhraseEnd = verbWithoutPrefix.phraseEnd();
                    Node node2 = verbEndOfClause = !subordinateClauseTagsForVerb && (verbWithoutPrefix == verbPhraseEnd.prevNode() || verbWithoutPrefix.hasDependent("conj")) ? verbWithoutPrefix : verbPhraseEnd;
                    NodeCorrector insertHer = verbWithoutPrefix == verbEndOfClause ? NodeCorrector.replace(verbWithoutPrefix, "her" + verbWithoutPrefix.lowForm()) : (subordinateClauseTagsForVerb && verbWithoutPrefix.hasDependent("nsubj") ? NodeCorrector.insertAfter(verbPhraseEnd, " her") : NodeCorrector.insertBefore(verbPhraseEnd, " her"));
                    return match.withCorrector(removeVon).withCorrector(corrector.join(insertHer)).withMessage(msgRemoveVon);
                }
                if (separatedPrefix != null) {
                    return match.withCorrector(NodeCorrector.removeNode(von).join(NodeCorrector.removeNode(separatedPrefix))).withCorrector(NodeCorrector.replaceNodes(von, node, woDa)).withMessage(msgRemoveVon);
                }
                if (von != null) {
                    return match.withCorrector(NodeCorrector.removeNode(von)).withMessage(msgRemoveVon);
                }
            }
            return null;
        });
    }

    private static NodePattern zentralerKernbaustein() {
        return NodePattern.N.lemma("(Grund|Kern|Basis)(baustein|bereich|frage|punkt|aussage|thema|aufgabe|botschaft|begriff|problem|gedanke|komponente|prinzip|aktivit\u00e4t|merkmal|disziplin|fach|ereignis|aspekt|funktion|f\u00e4higkeit|idee|forschungsfrage|fragestellung|anliegen|t\u00e4tigkeit|inhalt|kategorie|ph\u00e4nomen|kompetenz|voraussetzung|wissen)").markAs("Noun").includeIntoReport().withDependent("amod", NodePattern.N.lemma("zentral|wesentlich|fundamental|grundlegend|prim\u00e4r").includeIntoReport().and((node, match) -> {
            Node noun = match.getMarkedNode("Noun");
            int nounSubstring = noun.hasLemma("Grund(.*)|Basis(.*)") ? 5 : 4;
            NodeCorrector removeGrundOrKern = NodeCorrector.replace(noun, StringTools.uppercaseFirstChar((String)noun.lowForm().substring(nounSubstring)));
            String prefix = noun.lowForm().substring(0, nounSubstring);
            String message = "Das Adjektiv und das Substantiv auf \u201e" + StringTools.uppercaseFirstChar((String)prefix) + "-\u201c dr\u00fccken \u00e4hnliche Konzepte aus";
            if (node.hasDependent("advmod|nmod|obl")) {
                return match.withCorrector(removeGrundOrKern).withMessage(message);
            }
            return match.withCorrector(NodeCorrector.replace(node, "")).withCorrector(removeGrundOrKern).withMessage(message);
        }));
    }

    private static NodePattern ehemaligerEx() {
        return NodePattern.N.formCaseSensitive("Ex").directlyAfter(NodePattern.N.lemma("ehemalig").correct(NodeCorrector.replace(""))).reportEverythingTouched().message(REDUNDANCY_MSG).andOptionally(NodePattern.N.withHeadRelation("compound").directlyBefore(NodePattern.PUNCT).correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1)))).andOptionally(NodePattern.N.withHeadRelation("compound|nmod").andNot(NodePattern.N.directlyBefore(NodePattern.PUNCT)).correct(NodeCorrector.replace(NodePointer.anchor(), "")));
    }

    private static NodePattern entstammenAus() {
        return NodePattern.N.lemma("entstammen").includeIntoReport().withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("aus|von").includeIntoReport().correct(NodeCorrector.replace("")))).andOr(NodePattern.N.withDependent("aux", NodePattern.N.lemma("sein").markAs("AuxSein")).correct(NodeCorrector.replace("gestammt").join(LemmaChanges.changeOwnVerbLemma("haben").corrector(NodePointer.marked("AuxSein")))).correct(NodeCorrector.replace("gekommen")), NodePattern.N.correct(NodeCorrector.regexReplace("ent(.*)", "$1")).correct(LemmaChanges.changeOwnVerbLemma("kommen"))).message(REDUNDANCY_MSG);
    }

    private static NodePattern redundantFirstPartCompoundPattern() {
        String gesichts = "Gesichts";
        String zukunfts = "Zukunfts";
        return NodePattern.or(Redundancy.twoWordCompound("Haupt", "Hauptprotagonist(in)?").andOr(NodePattern.N.lemma(".*in").correct(LemmaChanges.changeSameGenderNounLemma("Hauptfigur")), NodePattern.N.correct(LemmaChanges.changeSameGenderNounLemma("Hauptcharakter"))), Redundancy.twoWordCompound("Trommel", "Trommelrevolver"), Redundancy.twoWordCompound("Holz", "Holzxylo(f|ph)one?"), Redundancy.twoWordCompound("Zeit", "Zeitverz\u00f6gerung"), Redundancy.twoWordCompound("Billig", "Billigdiscounter"), Redundancy.twoWordCompound("Massen", "Massenepidemie"), NodePattern.N.lemma("Pappkarton").and(Redundancy.trimNounPrefix("Papp")).message("Der Begriff \u201ePappe\u201c bedeutet bereits Karton"), NodePattern.N.lemma("Zukunfts(optimismus|prognose)").and(Redundancy.trimNounPrefix(zukunfts)).and((node, match) -> match.withMessage("Der Begriff \u201e" + Redundancy.secondPart(zukunfts, node) + "\u201c bezieht sich bereits auf die Zukunft")), Redundancy.twoWordCompound("Gratis", "Gratisgeschenk"), Redundancy.twoWordCompound("Internet", "Internetblog"), Redundancy.twoWordCompound("Fu\u00df", "Fu\u00dfpedal"), Redundancy.twoWordCompound("Glas", "Glasvitrine"), Redundancy.twoWordCompound("Alt", "Altveteran"), Redundancy.twoWordCompound("Assekuranz", "Assekuranzversicherung").correct(LemmaChanges.changeSameGenderNounLemma("Assekuranz")), Redundancy.twoWordCompound("Haar", "Haarfrisur"), NodePattern.N.lemma("Gesichts(mimik|visier)").and(Redundancy.trimNounPrefix(gesichts)).and((node, match) -> match.withMessage("Der Begriff \u201e" + Redundancy.secondPart(gesichts, node) + "\u201c ist bereits auf das Gesicht bezogen")), Redundancy.twoWordCompound("Eier", "Eieromelett"), Redundancy.twoWordCompound("Baum", "Baumallee"), Redundancy.twoWordCompound("Au\u00dfen", "Au\u00dfenfassade"), NodePattern.N.lemma("Marionettenpuppe").correct(LemmaChanges.changeSameGenderNounLemma("Marionette")).message("Eine Marionette ist bereits eine Puppe"), NodePattern.N.form("Stielkasserollen?").and(Redundancy.trimNounPrefix("Stiel")).message("Eine Kasserolle hat immer einen Stiel"), NodePattern.N.form("Vogelvolieren?").and(Redundancy.trimNounPrefix("Vogel")).message("Eine Voliere ist speziell f\u00fcr V\u00f6gel konzipiert"), NodePattern.N.form("Eieromeletten?").and(Redundancy.trimNounPrefix("Eier")).message("Ein Omelette wird traditionell aus Eiern zubereitet"));
    }

    private static NodePattern twoWordCompound(String firstPart, String compound) {
        return NodePattern.N.lemma(compound).pos("SUB.*").and(Redundancy.trimNounPrefix(firstPart)).and((node, match) -> match.withMessage("\u201e" + StringTools.uppercaseFirstChar((String)node.form().substring(firstPart.length())) + "\u201c impliziert bereits \u201e" + firstPart + "\u201c"));
    }

    private static String secondPart(String prefixToRemove, Node node) {
        return StringTools.uppercaseFirstChar((String)node.form().substring(prefixToRemove.length()));
    }

    private static NodePattern trimNounPrefix(String prefixToRemove) {
        return NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.replace(node, Redundancy.secondPart(prefixToRemove, node))));
    }

    private static NodePattern undSowie() {
        return NodePattern.N.form("sowie").andNot(NodePattern.N.after(NodePattern.N.form("sowie"))).markAs("Sowie").andOr(NodePattern.N.directlyAfter(NodePattern.N.form("und").andNot(NodePattern.N.directlyAfter(CommonPatterns.comma)).markAs("Und").includeIntoReport()), NodePattern.N.directlyBefore(NodePattern.N.form("und").includeIntoReport().markAs("Und"))).message(UND_SOWIE_MSG).and((sowie, match) -> {
            Node und = match.getMarkedNode("Und");
            NodePattern beforeMehrere = NodePattern.N.directlyBefore(NodePattern.N.form("mehrere"));
            NodeCorrector removeUnd = NodeCorrector.replace(und, "");
            return und.isBefore(sowie) && beforeMehrere.matches(sowie) || und.isAfter(sowie) && beforeMehrere.matches(und) ? match.withCorrector(removeUnd).withCorrector(NodeCorrector.replace(sowie, "")) : match.withCorrector(removeUnd);
        });
    }

    private static NodePattern undEtc() {
        return NodePattern.N.form("und|&").includeIntoReport().andOr(NodePattern.N.directlyBefore(NodePattern.N.inFormSequence(0, "etc", "\\.").includeIntoReport()), NodePattern.N.directlyBefore(NodePattern.N.form("et").directlyBefore(NodePattern.N.form("cetera")).includeIntoReport())).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.withHead("conj", NodePattern.N.pos("ABK.*")).afterHead())).message(UND_ETC_MSG).correct(NodeCorrector.replace("")).and((und, match) -> {
            Node next = und.neighbor(1);
            NodePattern dotLastNode = CommonPatterns.dot.and(CommonPatterns.lastToken);
            NodeCorrector corrector = NodeCorrector.replaceNodes(next, next.hasForm("et|etc") && !dotLastNode.matches(next.neighbor(1)) ? next.neighbor(1) : next, "so weiter");
            return und.hasForm("&") ? match.withCorrector(NodeCorrector.replace(und, "und").join(corrector)) : match.withCorrector(corrector);
        });
    }

    private static NodePattern ebenfallsAuch() {
        NodeCorrector.Relative removeAuch = NodeCorrector.replace(NodePointer.marked("Auch"), "");
        NodeCorrector.Relative removeAdverb = NodeCorrector.replace(NodePointer.marked("Adverb"), "");
        NodeCorrector.Relative removeNoch = NodeCorrector.replace(NodePointer.neighbor(2), "");
        return NodePattern.N.form("auch").markAs("Auch").includeIntoReport().andOr(NodePattern.N.directlyAfter(NodePattern.N.form("ebenfalls|zugleich|zus\u00e4tzlich|zudem").includeIntoReport().markAs("Adverb").correct(removeAuch).correct(removeAdverb)), NodePattern.N.directlyAfter(NodePattern.N.form("erg\u00e4nzend").andOr(NodePattern.N.withNeighbor(2, NodePattern.N.form("noch")).correct(removeAuch.join(removeNoch)), NodePattern.N.correct(removeAuch))), NodePattern.N.directlyAfter(NodePattern.N.form("mitunter|darunter|teilweise").includeIntoReport().correct(removeAuch))).message(REDUNDANCY_MSG);
    }

    private static NodePattern adverbNoch() {
        NodeCorrector.Relative removeNoch = NodeCorrector.replace(NodePointer.marked("Noch"), "");
        NodeCorrector.Relative removeAdverb = NodeCorrector.replace("");
        return NodePattern.N.form("noch").markAs("Noch").includeIntoReport().andOr(NodePattern.N.directlyAfter(NodePattern.N.form("bisher|\u00fcberdies|erg\u00e4nzend|zus\u00e4tzlich|zudem").includeIntoReport().correct(removeNoch).correct(removeAdverb)), NodePattern.N.directlyAfter(NodePattern.N.form("zuk\u00fcnftig").includeIntoReport().correct(removeNoch))).message(REDUNDANCY_MSG);
    }

    private static NodePattern wiederErneuern() {
        NodePattern verb = NodePattern.N.pos(".*VER.*").lemma("erneuern|renovieren|wiederherstellen|wiederholen");
        return NodePattern.N.form("wieder|nochmals|neu").includeIntoReport().correct(NodeCorrector.replace("")).withHead("advmod|mark", NodePattern.or(verb.includeIntoReport(), reaktivieren.correct(NodeCorrector.regexReplace("re(.*)", "$1")).includeIntoReport())).andNot(NodePattern.N.form("wieder").withHead(verb).andOr(NodePattern.N.withDependent("advmod"), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("obj|obl")))).message("\u201e$_\u201c mit dem Verb zusammen ist redundant, da beide Wiederholung oder Erneuerung implizieren");
    }

    private static NodePattern zusammenMiteinader() {
        NodeCorrector.Relative removeZusammen = NodeCorrector.replace(NodePointer.marked("Zusammen"), "");
        return NodePattern.N.form("zusammen").markAs("Zusammen").andOr(NodePattern.N.withHead("advmod|mark", NodePattern.N).includeIntoReport().andOr(NodePattern.N.directlyAfter(NodePattern.N.form("miteinander|gemeinsam").correct(removeZusammen).correct(NodeCorrector.replace(""))), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("miteinander").includeIntoReport().andOr(NodePattern.N.withHead(NodePattern.ROOT.form("umgehen").correct(removeZusammen)), NodePattern.N.correct(removeZusammen).correct(NodeCorrector.replace(""))), NodePattern.N.lemma("gemeinsam").includeIntoReport().correct(removeZusammen).correct(NodeCorrector.replace(""))))), NodePattern.N.withHead("compound:prt", NodePattern.N).includeIntoReport().directlyAfter(NodePattern.N.form("miteinander|gemeinsam").includeIntoReport().correct(NodeCorrector.replace("")))).message(REDUNDANCY_MSG);
    }

    private static NodePattern zuletztAbschliessend() {
        NodePattern zuletzt = NodePattern.N.form("zuletzt").markAs("Zuletzt").includeIntoReport();
        NodePattern nichtBeforeZuletzt = zuletzt.withDependent("advmod", NodePattern.N.form("nicht").markAs("Nicht"));
        return NodePattern.N.lemma("abschlie\u00dfend").includeIntoReport().andOr(NodePattern.or(NodePattern.N.withDependent("advmod", nichtBeforeZuletzt), NodePattern.N.withHead("advmod", NodePattern.ROOT.withDependent("advmod", nichtBeforeZuletzt))).correct(NodeCorrector.replace("")).correct(NodeCorrector.replace("").join(NodeCorrector.replaceNodes(NodePointer.marked("Nicht"), NodePointer.marked("Zuletzt"), "abschlie\u00dfend"))), NodePattern.N.withHead("advmod", NodePattern.ROOT.withDependent("advmod", zuletzt)).noDependents("advmod", NodePattern.N.form("nicht")).correct(NodeCorrector.replace("")).correct(NodeCorrector.replace(NodePointer.marked("Zuletzt"), "abschlie\u00dfend").join(NodeCorrector.replace(""))), NodePattern.N.withHead("conj", zuletzt).withDependent("cc", NodePattern.N.form("und").markAs("Und")).andOr(NodePattern.N.withHead(NodePattern.N.withDependent("case", NodePattern.N.markAs("Case"))).correct(NodeCorrector.replace("").join(NodeCorrector.replace(NodePointer.marked("Und"), ""))).correct(NodeCorrector.replaceNodes(NodePointer.marked("Zuletzt"), NodePointer.marked("Und"), "").join(NodeCorrector.replace(NodePointer.marked("Case"), ""))), NodePattern.N.correct(NodeCorrector.replaceNodes(NodePointer.marked("Und"), NodePointer.anchor(), "")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Zuletzt"), NodePointer.marked("Und"), ""))), NodePattern.N.withHeadRelation("amod").directlyAfter(zuletzt).correct(NodeCorrector.replace("")).correct(NodeCorrector.replace(NodePointer.marked("Zuletzt"), ""))).message("\u201eZuletzt\u201c und \u201eabschlie\u00dfend\u201c dr\u00fccken \u00e4hnliche Konzepte aus");
    }

    private static NodePattern explizitBetonen() {
        NodePattern redundantExplizit = NodePattern.N.form("explizit").withHead("advmod", NodePattern.N.lemma("betonen|hervorheben|unterstreichen|herausstreichen").markAs("Verb")).withOptionalDependent("advmod", NodePattern.N).markAs("Advmod").reportEverythingTouched().message(EXPLIZIT_BETONEN_MSG);
        return NodePattern.or(NodePattern.or(redundantExplizit.withDependent("advmod"), CommonPatterns.firstToken.and(redundantExplizit)).correct(NodeCorrector.replace("ausdr\u00fccklich", "besonders")), redundantExplizit.correct(NodeCorrector.replace("")));
    }

    private static NodePattern zurueckAntworten() {
        return zurueck.withHead("compound:prt|advmod|iobj", antworten.markAs("Verb")).correct(NodeCorrector.replace("")).message("\u201eZur\u00fcck\u201c ist redundant, da \u201e$Verb\u201c bereits die Bedeutung des Zur\u00fcckgebens beinhaltet");
    }

    private static NodePattern zunehmendComparativeAdj() {
        NodePattern nodeComparativeAdj = NodePattern.N.form("h\u00e4ufiger|st\u00e4rker|mehr|\u00f6fter").markAs("ComparativeAdj").includeIntoReport();
        return NodePattern.N.form("zunehmend").markAs("Zunehmend").includeIntoReport().andOr(NodePattern.N.directlyBeforeHead().withHead("advmod", nodeComparativeAdj.withHead("advmod", NodePattern.N.lemma("werdend").markAs("Werdend"))), NodePattern.N.directlyBefore(nodeComparativeAdj.andOptionally(NodePattern.N.withHead("advmod", NodePattern.N.lemma("werdend").markAs("Werdend"))).andOptionally(NodePattern.N.withHeadRelation("xcomp").markAs("Xcomp")))).message(ZUNEHMEND_COMPARATIVE_ADJ_MSG).and((node, match) -> {
            Node werdend = match.findMarkedNode("Werdend");
            Node comparativeAdj = match.getMarkedNode("ComparativeAdj");
            NodeCorrector zunehmendZuImmer = NodeCorrector.replace(node, "immer");
            if (werdend != null) {
                String zunehmendToAdj = node.lowForm() + werdend.lowForm().substring(7);
                return match.withCorrector(zunehmendZuImmer).withCorrector(NodeCorrector.replace(node, zunehmendToAdj).join(NodeCorrector.replaceNodes(comparativeAdj, werdend, "")));
            }
            if (comparativeAdj.hasHeadRelation("xcomp") || NodePattern.N.withHead(NodePattern.N.withHeadRelation("obl")).matches(comparativeAdj)) {
                return match.withCorrector(zunehmendZuImmer);
            }
            return match.withCorrector(zunehmendZuImmer).withCorrector(NodeCorrector.removeNode(comparativeAdj));
        });
    }

    private static NodePattern mitEinbeziehen() {
        return NodePattern.N.form("mit").includeIntoReport().directlyBefore(NodePattern.N.lemma("einbeziehen|einschlie\u00dfen").markAs("Verb")).reportEverythingTouched().message("\u201eMit\u201c ist \u00fcberfl\u00fc\u00dfig, da \u201e$Verb\u201c bereits Teilnahme oder Inklusion bedeutet").correct(NodeCorrector.replace(""));
    }

    private static NodePattern weiterFortschreiten() {
        return NodePattern.N.lemma("fort(.*)").pos("VER.*").includeIntoReport().withDependent("advmod", NodePattern.N.form("weiter").includeIntoReport().andOr(NodePattern.N.directlyAfter(NodePattern.N.form("immer").includeIntoReport().correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), ""))), NodePattern.N.correct(NodeCorrector.replace("")))).message("\u201eWeiter\u201c ist redundant, da \u201e$_\u201c bereits die Fortdauer eines Prozesses impliziert");
    }

    private static NodePattern einzelnSeparatGetrennt() {
        NodeCorrector.Relative removeEinzeln = NodeCorrector.replace(NodePointer.marked("Einzeln"), "");
        NodeCorrector.Relative einzelnToAdv = NodeCorrector.replace(NodePointer.marked("Einzeln"), "einzeln");
        NodeCorrector.Relative removeSeparatGetrennt = NodeCorrector.replace("");
        return NodePattern.N.lemma("separat|getrennt").directlyAfter(NodePattern.N.lemma("einzeln").markAs("Einzeln")).reportEverythingTouched().andOr(NodePattern.N.lemma("separat").message("Die W\u00f6rter \u201eeinzeln\u201c und \u201eseparat\u201c dr\u00fccken \u00e4hnliche Konzepte aus"), NodePattern.N.message("Die W\u00f6rter \u201eeinzeln\u201c und \u201egetrennt\u201c dr\u00fccken \u00e4hnliche Konzepte aus")).andOr(NodePattern.N.withHeadRelation("advmod").directlyAfter(NodePattern.N.withHeadRelation("amod|nsubj:pass")).correct(einzelnToAdv.join(removeSeparatGetrennt)), NodePattern.N.withHeadRelation("advmod").directlyBefore(NodePattern.N.form("voneinander")).directlyAfter(NodePattern.N.withHeadRelation("advmod")).correct(einzelnToAdv.join(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), ""))), NodePattern.N.withHeadRelation("amod").directlyAfter(NodePattern.N.withHeadRelation("advmod")).and(NodePattern.custom((node, match) -> {
            Node einzeln = match.getMarkedNode("Einzeln");
            String lemma = node.hasLemma("getrennt") ? "getrennt" : "separat";
            String einzelnToAdj = einzeln.lowForm() + node.lowForm().substring(lemma.length());
            return match.withCorrector(NodeCorrector.replace(einzeln, einzelnToAdj).join(NodeCorrector.replace(node, "")));
        })), NodePattern.N.correct(removeSeparatGetrennt)).correct(removeEinzeln);
    }

    private static NodePattern moeglichesPotenzial() {
        return NodePattern.N.lemma("Poten[zt]ial|M\u00f6glichkeit").includeIntoReport().markAs("Nomen").directlyAfter(NodePattern.or(NodePattern.N.lemma("poten[zt]iell|m\u00f6glich"), NodePattern.N.form("poten[zt]ial(e[rnsm]?)?")).includeIntoReport().andOr(NodePattern.N.withDependent("advmod").message("\u201e$Nomen\u201c und \u201e$_\u201c k\u00f6nnten redundant sein, da sie \u00e4hnliche Konzepte ausdr\u00fccken"), NodePattern.N.correct(NodeCorrector.replace("")).message("\u201e$Nomen\u201c und \u201e$_\u201c dr\u00fccken \u00e4hnliche Konzepte aus")));
    }

    private static NodePattern ergaenzenderZusatz() {
        NodePattern nodeErgaenzend = NodePattern.N.lemma("erg\u00e4nzend|zus\u00e4tzlich").markAs("Ergaenzend").includeIntoReport();
        NodeCorrector.Relative removeErgaenzend = NodeCorrector.replace(NodePointer.marked("Ergaenzend"), "");
        return NodePattern.N.lemma("Zusatz|Erg\u00e4nzung").includeIntoReport().andOr(NodePattern.N.withDependent("amod", NodePattern.N.directlyAfter(nodeErgaenzend.withHeadRelation("amod").markAs("ZweitesAmod").includeIntoReport())).correct(NodeCorrector.regexReplace(NodePointer.marked("Ergaenzend"), ".*(end|lich)(.*)", "weiter$2")), NodePattern.N.withDependent("amod", nodeErgaenzend.andNot(NodePattern.N.directlyBefore("amod"))).correct(removeErgaenzend), NodePattern.N.directlyAfter(NodePattern.N.form("als|in").markAs("Case").directlyAfter(nodeErgaenzend)).correct(removeErgaenzend).correct(NodeCorrector.replace("").join(NodeCorrector.replace(NodePointer.marked("Case"), ""))), NodePattern.N.withHead("obl|obj|nsubj|nsubj:pass", NodePattern.N.withDependent("advmod", NodePattern.or(CommonPatterns.firstToken.and(nodeErgaenzend).correct(NodeCorrector.replace(NodePointer.marked("Ergaenzend"), "dar\u00fcber hinaus")).correct(NodeCorrector.replace(NodePointer.marked("Ergaenzend"), "au\u00dferdem")), nodeErgaenzend.directlyBefore(NodePattern.N.pos("ADJ.*")).correct(NodeCorrector.replace(NodePointer.marked("Ergaenzend"), "")).correct(NodeCorrector.replace(NodePointer.marked("Ergaenzend"), "ebenfalls")), nodeErgaenzend.correct(removeErgaenzend)))), NodePattern.N.withHead("nmod", nodeErgaenzend).correct(removeErgaenzend)).message("Entfernen oder ersetzen Sie das \u00fcberfl\u00fcssige \u201e$Ergaenzend\u201c");
    }

    private static NodePattern kommunikativeMitteilung() {
        return NodePattern.N.lemma("Mitteilung").directlyAfter(NodePattern.N.lemma("kommunikativ")).reportEverythingTouched().message("\u201eMitteilung\u201c und \u201ekommunikativ\u201c sind redundant, da beide Kommunikation bedeuten").correct(NodeCorrector.replace(NodePointer.neighbor(-1), ""));
    }

    private static NodePattern exemplarischesBeispiel() {
        NodePattern exemplarisch = NodePattern.N.lemma("exemplarisch").markAs("Exemplarisch").includeIntoReport();
        return NodePattern.N.lemma("Beispiel").includeIntoReport().andOr(NodePattern.N.withDependent("amod", exemplarisch), NodePattern.N.withDependent("nmod|amod", NodePattern.N.withDependent("amod|advmod", exemplarisch)), NodePattern.N.withHead("obj|obl|nsubj|nsubj:pass", NodePattern.N.withDependent("advmod", exemplarisch))).message("Entfernen oder ersetzen Sie das \u00fcberfl\u00fcssige \u201eexemplarisch\u201c").correct(NodeCorrector.replace(NodePointer.marked("Exemplarisch"), ""));
    }

    private static NodePattern darueberHinausEbenfalls() {
        NodePattern nodeHinaus = NodePattern.N.form("hinaus").markAs("Hinaus").includeIntoReport();
        NodePattern withEbenfalls = NodePattern.N.withDependent("advmod", NodePattern.N.form("ebenfalls").markAs("Ebenfalls").includeIntoReport().andOr(NodePattern.N.directlyAfter(NodePattern.N.form("nat\u00fcrlich|jedoch|allerdings").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Darueber"), NodePointer.marked("Hinaus"), ""))), NodePattern.N.correct(NodeCorrector.replace("")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Darueber"), NodePointer.marked("Hinaus"), "ebenfalls").join(NodeCorrector.replace("")))));
        return NodePattern.N.form("dar\u00fcber").markAs("Darueber").includeIntoReport().andNot(NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("nsubj"))).andOr(NodePattern.N.directlyBefore(nodeHinaus).withHead("case|advmod", NodePattern.or(withEbenfalls, NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", withEbenfalls))), NodePattern.N.directlyBefore(nodeHinaus.withHead("advmod", withEbenfalls))).message("\u201eDar\u00fcber hinaus\u201c und \u201eebenfalls\u201c zusammen sind \u00fcberfl\u00fcssig");
    }

    private static NodePattern nurBeschraenkenAuf() {
        return NodePattern.N.lemma("beschr\u00e4nken").includeIntoReport().andOr(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("advmod", NodePattern.N.form("nur").includeIntoReport().correct(NodeCorrector.replace("")))).message("\u201eNur\u201c und \u201ebeschr\u00e4nken\u201c implizieren eine Begrenzung"), NodePattern.N.withDependent("advmod", NodePattern.N.form("ausschlie\u00dflich").includeIntoReport().correct(NodeCorrector.replace(""))).message("\u201eAusschlie\u00dflich\u201c und \u201ebeschr\u00e4nken\u201c implizieren eine Begrenzung"));
    }

    private static NodePattern restriktiveBeschraenkung() {
        NodePattern nodeRestriktiv = NodePattern.N.lemma("restriktiv").markAs("Restriktiv");
        NodePattern inflectAdjective = NodePattern.custom((restriktiv, match) -> {
            String suffix = restriktiv.lowForm().substring("restriktiv".length());
            String replacementStreng = "streng" + suffix;
            String replacementStark = "stark" + suffix;
            NodeCorrector restriktiveToStark = NodeCorrector.replace(restriktiv, replacementStark);
            return match.getMarkedNode("Noun").hasLemma("Beschr\u00e4nkung") ? match.withCorrector(NodeCorrector.replace(restriktiv, replacementStreng)).withCorrector(restriktiveToStark) : match.withCorrector(restriktiveToStark);
        });
        return NodePattern.N.lemma("Beschr\u00e4nkung|Einschr\u00e4nkung").markAs("Noun").andOr(NodePattern.N.withDependent("amod", nodeRestriktiv.andOr(NodePattern.N.withDependent("advmod").and(inflectAdjective), NodePattern.N.correct(NodeCorrector.replace("")))), NodePattern.N.withHead(CommonPatterns.possiblySkipDown("xcomp", nodeRestriktiv)).andOptionally(NodePattern.N.lemma("Beschr\u00e4nkung").correct(NodeCorrector.replace(NodePointer.marked("Restriktiv"), "streng"))).correct(NodeCorrector.replace(NodePointer.marked("Restriktiv"), "stark"))).message("\u201e$_\u201c und \u201erestriktiv\u201c sind redundant, da beide Begrenzung bedeuten");
    }

    private static NodePattern zunehmendSteigern() {
        return NodePattern.N.lemma("steigern").includeIntoReport().withDependent("advmod", NodePattern.N.form("zunehmend").includeIntoReport().markAs("Zunehmend")).andOr(NodePattern.N.withDependent("expl:pv|obj", NodePattern.N.lemma("sich").markAs("Sich")).message("\u201eZunehmend\u201c und \u201esich steigern\u201c sind redundant, da beide Zunahme bedeuten"), NodePattern.N.message("\u201eZunehmend\u201c und \u201esteigern\u201c sind redundant, da beide Zunahme bedeuten")).andOr(NodePattern.markedNodeMatches("Zunehmend", obligatoryFirstPlace.correct(NodeCorrector.replace("nach und nach"))), NodePattern.N.markAs("Steigern").correct(NodeCorrector.replace(NodePointer.marked("Zunehmend"), "")).andOptionally(NodePattern.markedNodeMatches("Sich", NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Sich"), "").join(NodeCorrector.replace(NodePointer.marked("Zunehmend"), "")).join(LemmaChanges.changeOwnVerbLemma("zunehmen").corrector(NodePointer.marked("Steigern")))))).correct(NodeCorrector.replace(NodePointer.marked("Zunehmend"), "nach und nach")));
    }

    private static NodePattern strukturellerAufbau() {
        NodePattern nodeStrukturell = NodePattern.N.lemma("strukturell").markAs("Strukturell").includeIntoReport();
        String potentialRedundancy = "\u201eStrukturell\u201c und \u201eAufbau\u201c k\u00f6nnten redundant sein, da beide Struktur oder Organisation bedeuten";
        String removeStrukturell = "\u201eStrukturell\u201c und \u201eAufbau\u201c sind redundant, da beide Struktur oder Organisation bedeuten";
        return NodePattern.N.lemma("Aufbau").includeIntoReport().withDependent("amod", NodePattern.or(nodeStrukturell.andOr(NodePattern.N.withHeadRelation("amod").andOr(NodePattern.N.form("strukturellem").directlyAfter(NodePattern.N.withHeadRelation("case").form("von").beforeHead().withHead(NodePattern.N.withDependent("case", NodePattern.N.form("her"))).correct(NodeCorrector.replace("vom").join(NodeCorrector.replace(NodePointer.marked("Strukturell"), "")))).message(removeStrukturell), NodePattern.N.correct(NodeCorrector.replace("")).message(removeStrukturell)), NodePattern.N.withHeadRelation("advmod|conj").message(potentialRedundancy)), NodePattern.N.withDependent("advmod|conj", nodeStrukturell).message(potentialRedundancy)));
    }

    private static NodePattern wennDann() {
        return NodePattern.N.form("dann").markAs("Dann").includeIntoReport().directlyAfter(CommonPatterns.comma).withHead("advmod", GermanTreePatterns.clause.withDependent("advcl|ccomp", NodePattern.N.withDependent("mark", NodePattern.N.form("wenn|falls").includeIntoReport(ReportingKind.Hover)).noDependents("ccomp|xcomp|conj", NodePattern.N.afterHead()).before("Dann"))).message(WENN_DANN_MSG).correct(NodeCorrector.replace(""));
    }

    private static NodePattern taeglicherAlltag() {
        NodePattern nodeAlltag = NodePattern.N.lemma("Alltag").noHeadRelation("obj").noDependents("conj").includeIntoReport();
        NodePattern objWithDependentAlltag = NodePattern.N.withHeadRelation("obj").withDependent("nmod", nodeAlltag);
        return NodePattern.N.lemma("t\u00e4glich").includeIntoReport().andOr(NodePattern.N.withHead("amod", NodePattern.N.lemma("Alltags(.*)").markAs("FirstRootWord")).and((node, match) -> {
            Node firstRootWord = match.getMarkedNode("FirstRootWord");
            return match.withCorrector(NodeCorrector.replace(firstRootWord, StringTools.uppercaseFirstChar((String)firstRootWord.form().substring(7))));
        }), NodePattern.N.withHead("amod", NodePattern.N.lemma("(.*)alltag")), NodePattern.N.withHead("advmod", NodePattern.N).withNextSibling(NodePattern.or(nodeAlltag, NodePattern.N.withHeadRelation("advmod|obj").andOr(NodePattern.N.withDependent("nmod", nodeAlltag), NodePattern.N.pos("ADV.*|ADJ.*").withNextSibling(nodeAlltag)), objWithDependentAlltag))).message(TAEGLICHER_ALLTAG_MSG).correct(NodeCorrector.replace(""));
    }

    private static NodePattern zeitlichSynchron() {
        NodePattern zeitlich = NodePattern.N.lemma("zeitlich").markAs("Zeitlich").noDependents("conj").andNot(NodePattern.N.inSentenceWith(NodePattern.N.lemma("r\u00e4umlich"))).includeIntoReport();
        return NodePattern.N.form("synchron.*|asynchron.*").includeIntoReport().andOr(NodePattern.N.withDependent("advmod|amod", zeitlich), NodePattern.N.withHead("advmod", CommonPatterns.possiblySkipDown("advcl", NodePattern.N.withDependent("advmod", zeitlich)))).message("\u201e$_\u201c beinhaltet bereits eine zeitliche Komponente").correct(NodeCorrector.replace(NodePointer.marked("Zeitlich"), ""));
    }

    private static NodePattern scheintAnscheinend() {
        String rephrasingSuggestion = "Versuchen Sie, \u201eanscheinend\u201c zu ersetzen, da der Satz bereits \u201escheinen\u201c enth\u00e4lt";
        String redundancyMessage = "\u201eAnscheinend\u201c ist redundant, da \u201escheinen\u201c bereits eine Vermutung impliziert";
        NodePattern anscheinendDependent = NodePattern.N.withDependent("advmod", NodePattern.N.form("anscheinend").includeIntoReport().markAs("Anscheinend"));
        NodePattern auxDependent = NodePattern.N.withDependent("aux.*|cop", NodePattern.N.andNot(NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("conj"))).markAs("Aux"));
        NodePattern afterZu = NodePattern.N.directlyAfter(NodePattern.N.form("zu"));
        return NodePattern.N.lemma("scheinen").includeIntoReport().andOr(anscheinendDependent.andOptionally(NodePattern.N.withDependent("xcomp", NodePattern.N.markAs("Xcomp").andOptionally(auxDependent))), NodePattern.N.withDependent("conj", anscheinendDependent), NodePattern.N.withDependent("xcomp", anscheinendDependent.markAs("Xcomp").andOptionally(auxDependent)), NodePattern.N.withHead("acl", GermanTreePatterns.clause.and(anscheinendDependent))).and((node, match) -> {
            Node xcomp = match.findMarkedNode("Xcomp");
            Node anscheinend = match.getMarkedNode("Anscheinend");
            Node aux = match.findMarkedNode("Aux");
            NodeCorrector removeAnscheinend = NodeCorrector.replace(anscheinend, "");
            boolean auxWithZu = afterZu.matches(aux);
            boolean xcompWithZu = afterZu.matches(xcomp);
            if (xcomp != null && xcomp.hasForm(prefixedVerbWithZu) && !xcomp.hasDependent("conj")) {
                String prefix = xcomp.lowForm().replaceFirst(prefixedVerbWithZu, "$1");
                String xcompStemWithZuPrefix = xcomp.lowForm().substring(prefix.length());
                String replacement = xcompStemWithZuPrefix.substring("zu".length());
                return match.withMessage(redundancyMessage).withCorrector(NodeCorrector.replace(anscheinend, "")).withCorrector(LemmaChanges.changeOwnVerbLemma(replacement).corrector(node).join(NodeCorrector.insertAfter(xcomp, " " + prefix)).join(NodeCorrector.replace(xcomp, "")));
            }
            if (auxWithZu || xcompWithZu) {
                Node replacementForScheinen = auxWithZu ? aux : xcomp;
                String verbForm = replacementForScheinen.lowForm();
                if (replacementForScheinen.prevNode() != null) {
                    NodeCorrector scheinenToAnotherVerb = LemmaChanges.changeOwnVerbLemma(verbForm).corrector(node).join(NodeCorrector.replaceNodes(replacementForScheinen.prevNode(), replacementForScheinen, ""));
                    if (obligatoryFirstPlace.matches(anscheinend)) {
                        return match.withMessage(redundancyMessage).withCorrector(scheinenToAnotherVerb);
                    }
                    return match.withMessage(redundancyMessage).withCorrector(removeAnscheinend).withCorrector(scheinenToAnotherVerb);
                }
            }
            if (node.hasDependent("conj") || obligatoryFirstPlace.matches(anscheinend)) {
                return match.withMessage(rephrasingSuggestion);
            }
            return match.withCorrector(removeAnscheinend).withMessage(redundancyMessage);
        });
    }

    private static NodePattern innenHohl() {
        return NodePattern.N.form("innen").includeIntoReport().withHead("advmod", CommonPatterns.possiblySkipUp("acl", NodePattern.N.lemma("hohl").includeIntoReport())).andOr(obligatoryFirstPlace, NodePattern.N.correct(NodeCorrector.replace(""))).message("\u201eInnen\u201c ist redundant, da \u201ehohl\u201c bereits Leere im Inneren impliziert");
    }

    private static NodePattern ploetzlichAufEinmal() {
        NodePattern ploetzlich = NodePattern.N.lemma("pl\u00f6tzlich").markAs("Pl\u00f6tzlich").includeIntoReport();
        NodeCorrector.Relative removeAufEinmal = NodeCorrector.replaceNodes(NodePointer.neighbor("AufEinmal", -1), NodePointer.marked("AufEinmal"), "");
        NodeCorrector.Relative removePloetzlich = NodeCorrector.replace(NodePointer.marked("Pl\u00f6tzlich"), "");
        return NodePattern.N.inFormSequence(1, "auf", "einmal").markAs("AufEinmal").reportEverythingTouched().withHead("obl", NodePattern.or(ploetzlich, GermanTreePatterns.clause.and(CommonPatterns.possiblySkipDown("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("advmod|amod", ploetzlich))), NodePattern.N.withHead("a(dv)?cl|ccomp|xcomp", NodePattern.N.withHeadRelation("nsubj(:pass)?|i?obj|obl|nmod|compound").withDependent("amod", ploetzlich)))).message("\u201ePl\u00f6tzlich\u201c und \u201eauf einmal\u201c sind redundant, da beide Unerwartetes bedeuten").andOr(NodePattern.markedNodeMatches("Pl\u00f6tzlich", NodePattern.or(obligatoryFirstPlace.correct(removeAufEinmal).correct(NodeCorrector.replace("auf einmal").join(removeAufEinmal)), NodePattern.N.withHeadRelation("amod").correct(removeAufEinmal))), obligatoryFirstPlace.correct(removePloetzlich).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "pl\u00f6tzlich").join(removePloetzlich)), NodePattern.N.correct(removeAufEinmal).correct(removePloetzlich));
    }

    private static NodePattern exaktGenau() {
        NodeCorrector.Relative removeExakt = NodeCorrector.replace(NodePointer.marked("Exakt"), "");
        return NodePattern.N.lemma("genau|genauso").includeIntoReport().directlyAfter(NodePattern.N.form("exakt").markAs("Exakt").includeIntoReport()).andOr(NodePattern.N.form("genauso").correct(removeExakt).correct(NodeCorrector.replace("so")), NodePattern.N.lemma("genau").andOr(NodePattern.N.withHeadRelation("amod").correct(removeExakt).and((node, match) -> {
            Node exakt = match.getMarkedNode("Exakt");
            String exaktToAdj = "exakt" + node.form().substring(5);
            return match.withCorrector(NodeCorrector.replace(node, exaktToAdj).join(NodeCorrector.replace(exakt, "")));
        }), NodePattern.N.correct(removeExakt).correct(NodeCorrector.replace("")))).message("\u201eExakt\u201c und \u201egenau\u201c sind redundant, da beide Genauigkeit bedeuten");
    }

    private static NodePattern alsoFolglich() {
        NodeCorrector.Relative removeFolglich = NodeCorrector.replace(NodePointer.marked("Folglich"), "");
        NodeCorrector.Relative removeAlso = NodeCorrector.replace(NodePointer.marked("Also"), "");
        return NodePattern.N.form("also").markAs("Also").includeIntoReport().withHead("advmod", GermanTreePatterns.clause.withDependent("advmod|amod", NodePattern.N.form("folglich").markAs("Folglich").includeIntoReport())).message("\u201eAlso\u201c und \u201efolglich\u201c sind redundant, da beide eine Schlussfolgerung markieren").andOr(obligatoryFirstPlace.correct(removeFolglich).correct(NodeCorrector.replace("folglich").join(removeFolglich)), NodePattern.markedNodeMatches("Folglich", obligatoryFirstPlace.correct(removeAlso).correct(NodeCorrector.replace("also").join(removeAlso))), NodePattern.N.correct(removeFolglich).correct(NodeCorrector.replace("")));
    }

    private static NodePattern zusaetzlchHinzu() {
        NodePattern hinzu = NodePattern.N.lemma("hinzu.*").markAs("Hinzu").includeIntoReport();
        String removeAdverbMsg = "Entfernen Sie \u201e$_\u201c, da \u201ehinzu-\u201c bereits eine Erg\u00e4nzung bedeutet";
        NodePattern headIsKommen = NodePattern.N.withHead("advmod|obl", NodePattern.N.lemma("kommen"));
        NodeCorrector.Relative removeHinzu = NodeCorrector.replace(NodePointer.marked("Hinzu"), "");
        NodePattern adv = NodePattern.N.lemma("zus\u00e4tzlich|erg\u00e4nzend");
        return adv.includeIntoReport().withHead("advmod|amod", CommonPatterns.possiblySkipUp("nsubj(:pass)?|i?obj|obl|nmod|compound|advmod", GermanTreePatterns.clause.andOr(hinzu, NodePattern.N.withDependent("compound:prt", hinzu)))).andOr(NodePattern.N.before(adv).message("Beide W\u00f6rter zusammen sind redundant, da \u201ehinzu-\u201c bereits eine Erg\u00e4nzung impliziert"), NodePattern.N.withHeadRelation("amod").message("Ersetzen Sie \u201e$_\u201c oder das Verb mit \u201ehinzu-\u201c, da beide eine Erg\u00e4nzung bedeuten"), obligatoryFirstPlace.andOr(headIsKommen.message(removeAdverbMsg).correct(NodeCorrector.replace("hinzu").join(removeHinzu)), NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("advmod")).message("Das Verb mit \u201ehinzu-\u201c und \u201e$_\u201c k\u00f6nnten redundant sein"), NodePattern.N.message(removeAdverbMsg).correct(NodeCorrector.replace("au\u00dferdem", "dar\u00fcber hinaus"))), NodePattern.or(NodePattern.N.form("zus\u00e4tzlich").correct(removeHinzu).message("Verwenden Sie \u201e$_\u201c oder \u201ehinzu\u201c, da beide eine Erg\u00e4nzung bedeuten"), NodePattern.N.message(removeAdverbMsg)).correct(NodeCorrector.replace("")));
    }

    private static NodePattern ungefaehrFast() {
        NodePattern approxAdv = NodePattern.N.form("fast|ungef\u00e4hr|beinah(e)|nahezu|ann\u00e4hernd").andNot(NodePattern.N.inFormSequence(2, "nicht", "von", "ungef\u00e4hr"));
        NodePattern adv1 = approxAdv.includeIntoReport();
        NodePattern adv2 = approxAdv.markAs("Adv2").includeIntoReport();
        NodePattern approxNummod = NodePattern.N.withDependent("nummod|det", NodePattern.N.withDependent("advmod", adv2));
        return adv1.andOr(NodePattern.N.directlyBefore(adv2), NodePattern.N.withNextSibling(adv2), NodePattern.N.withHead("advmod", CommonPatterns.possiblySkipDown("obl", approxNummod)), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("advmod").withDependent("obl", CommonPatterns.possiblySkipDown("nummod", approxNummod))), NodePattern.N.withNextSibling(NodePattern.N.withDependent("advmod", adv2.beforeHead()))).message("\u201e$_\u201c und \u201e$Adv2\u201c sind redundant, da beide Ungenauigkeit oder N\u00e4herung implizieren").correct(NodeCorrector.replace("")).correct(NodeCorrector.replace(NodePointer.marked("Adv2"), ""));
    }

    private static NodePattern baeuerlichRustikal() {
        NodePattern mod = NodePattern.N.lemma("b\u00e4uerlich|rustikal|d\u00f6rflich|l\u00e4ndlich").includeIntoReport();
        NodePattern mod2 = mod.markAs("Mod2").andNot(NodePattern.N.alreadyMarkedAs("Mod1"));
        String message = "Verwenden Sie entweder \u201e$_\u201c oder \u201e$Mod2\u201c, da beide dasselbe Konzept ausdr\u00fccken";
        NodeCorrector.Relative removeMod1 = NodeCorrector.replace(NodePointer.marked("Mod1"), "");
        return mod.markAs("Mod1").andOr(NodePattern.N.withHead("advmod", mod2).and((node, match) -> {
            Node adverb = match.getMarkedNode("Mod2");
            int stemEnd = adverb.lemmaReadings().get(0).length();
            String newAdverb = node.lowForm() + adverb.lowForm().substring(stemEnd);
            return match.withCorrector(NodeCorrector.replace(node, newAdverb).join(NodeCorrector.replace(adverb, ""))).withCorrector(NodeCorrector.replace(node, ""));
        }), NodePattern.N.withNextSibling(mod2.correct(NodeCorrector.replace(""))).correct(removeMod1), CommonPatterns.possiblySkipUp("amod", CommonPatterns.possiblySkipUp("nsubj(:pass)?|i?obj|obl|nmod|compound", CommonPatterns.possiblyConj(NodePattern.N.withDependent("conj", mod2)))), NodePattern.N.withHead("acl|amod|advcl", NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", mod2)), NodePattern.N.withHead("amod", CommonPatterns.possiblySkipDown("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.withDependent("acl", NodePattern.N.withDependent("advmod", mod2))))).message(message);
    }

    private static NodePattern freiwilligGewollt() {
        NodePattern gewollt = NodePattern.N.form("gewollt").markAs("Gewollt").includeIntoReport();
        NodeCorrector.Relative removeGewollt = NodeCorrector.replace(NodePointer.marked("Gewollt"), "");
        return NodePattern.N.form("freiwillig").includeIntoReport().andOr(NodePattern.N.withHead("advmod", NodePattern.N.withHeadRelation("csubj").withDependent("advmod", gewollt.correct(removeGewollt))).correct(NodeCorrector.replace("")), NodePattern.N.withHead("advmod", gewollt.andOr(NodePattern.N.withDependent("cop", NodePattern.N).correct(removeGewollt), NodePattern.N.withDependent("aux", NodePattern.N.lemma("haben")))).correct(NodeCorrector.replace("selbst")), NodePattern.N.withDependent("conj", gewollt)).message("\u201eFreiwillig\u201c und \u201egewollt\u201c sind redundant, da beide Eigenentscheidung implizieren");
    }

    private static NodePattern weltweitDerWelt() {
        NodePattern welt = NodePattern.N.lemma("Welt").markAs("Welt").includeIntoReport().withDependent("det.*", NodePattern.N.pos(".*GEN.*"));
        NodePattern nmodWelt = NodePattern.N.withDependent("nmod", welt);
        NodeCorrector.Relative removeWeltweit = NodeCorrector.replace(NodePointer.marked("Weltweit"), "");
        String rephraseMessage = "Versuchen Sie, \u201eWelt\u201c zu ersetzen, da der Satz bereits \u201eweltweit\u201c enth\u00e4lt";
        String removeMessage = "\u201eWeltweit\u201c und \u201eWelt\u201c dr\u00fccken dasselbe Konzept aus";
        NodePattern maybeRemoveWelt = NodePattern.markedNodeMatches("Welt", NodePattern.N.withOnlyDependents(NodePattern.N.form("der|unserer")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "")));
        return NodePattern.N.form("weltweit").markAs("Weltweit").includeIntoReport().withHead("amod|advmod", NodePattern.or(nmodWelt, NodePattern.N.withHead("amod|advmod", CommonPatterns.possiblySkipUp("amod", nmodWelt)), NodePattern.N.withDependent("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.or(CommonPatterns.possiblySkipDown("nmod", nmodWelt), NodePattern.N.withDependent("nsubj", NodePattern.N.withDependent("nmod", welt.withDependent("nmod"))))))).andOr(obligatoryFirstPlace.andOr(maybeRemoveWelt.message(removeMessage), NodePattern.N.message(rephraseMessage)), NodePattern.N.correct(removeWeltweit).andOptionally(maybeRemoveWelt).message(removeMessage));
    }

    private static NodePattern einanderGegenseitig() {
        return NodePattern.N.form("einander").markAs("Einander").includeIntoReport().withHead("obj|iobj", NodePattern.N.withDependent("advmod", NodePattern.N.form("gegenseitig").includeIntoReport().correct(NodeCorrector.replace(""))).withDependent("nsubj", NodePattern.or(NodePattern.N.form("ihr").correct(NodeCorrector.replace(NodePointer.marked("Einander"), "euch")), NodePattern.N.form("wir").correct(NodeCorrector.replace(NodePointer.marked("Einander"), "uns")), NodePattern.N.correct(NodeCorrector.replace(NodePointer.marked("Einander"), "sich"))))).message("\u201eEinander\u201c und \u201egegenseitig\u201c sind redundant, da beide Wechselseitigkeit ausdr\u00fccken");
    }

    private static NodePattern twoAdverbs() {
        return NodePattern.or(Redundancy.twoAdverbPattern("eventuell|vielleicht|m\u00f6glicherweise", "Verwenden Sie entweder \u201e$Advmod1\u201c oder \u201e$Advmod2\u201c, da beide Unsicherheit ausdr\u00fccken"), Redundancy.twoAdverbPattern("ausschlie\u00dflich|blo\u00df|nur", "Verwenden Sie entweder \u201e$Advmod1\u201c oder \u201e$Advmod2\u201c, da beide Ausschluss anderer M\u00f6glichkeiten ausdr\u00fccken"), Redundancy.twoAdverbPattern("bald|demn\u00e4chst", "Verwenden Sie \u201e$Advmod1\u201c oder \u201e$Advmod2\u201c f\u00fcr bevorstehende Ereignisse"), Redundancy.twoAdverbPattern("meist(ens)?|jederzeit|immer", "Verwenden Sie entweder \u201e$Advmod1\u201c oder \u201e$Advmod2\u201c, da beide H\u00e4ufigkeit ausdr\u00fccken"), Redundancy.twoAdverbPattern("schon|bereits", "\u201e$Advmod1\u201c oder \u201e$Advmod2\u201c sind redundant, da beide ein eingetretenes Ereignis signalisieren"));
    }

    private static NodePattern twoAdverbPattern(String adverbs, String message) {
        NodePattern advmod2 = NodePattern.N.form(adverbs).markAs("Advmod2").includeIntoReport().andNot(NodePattern.N.alreadyMarkedAs("Advmod1")).andNot(NodePattern.N.sameWordAs("Advmod1"));
        NodeCorrector.Relative removeAdv2 = NodeCorrector.replace(NodePointer.marked("Advmod2"), "");
        NodeCorrector.Relative removeAdv1 = NodeCorrector.replace(NodePointer.marked("Advmod1"), "");
        NodeCorrector.Relative removeSlash = NodeCorrector.replace(NodePointer.marked("Slash"), "");
        NodePattern immerWithAdvmod = NodePattern.N.form("immer").withDependent("advmod");
        return NodePattern.N.form(adverbs).markAs("Advmod1").includeIntoReport().andOr(NodePattern.N.withHead("advmod", advmod2.correct(removeAdv2).correct(removeAdv1)), NodePattern.N.withHead("advmod", NodePattern.N.withHead("advmod", NodePattern.N.withDependent("advmod", advmod2))).correct(removeAdv2), NodePattern.N.withHead("advmod", NodePattern.N.withDependent("advmod", advmod2)).and(obligatoryFirstPlace.correct(removeAdv2).and((node, match) -> {
            Node adv2 = match.getMarkedNode("Advmod2");
            return match.withCorrector(NodeCorrector.replace(node, adv2.lowForm()).join(NodeCorrector.replace(adv2, "")));
        })), NodePattern.N.withHead("advmod", NodePattern.N.withDependent("advmod", advmod2.andOr(immerWithAdvmod.correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "")).correct(removeAdv1), NodePattern.N.correct(removeAdv2).correct(removeAdv1)))), NodePattern.N.directlyBefore(NodePattern.PUNCT.form("/").markAs("Slash").includeIntoReport().directlyBefore(advmod2).correct(removeAdv2.join(removeSlash)).correct(removeAdv1.join(removeSlash)))).message(message);
    }

    private static NodePattern moeglicherweiseKann() {
        NodePattern zu = NodePattern.N.form("zu").markAs("Zu");
        NodePattern koennen = NodePattern.N.lemma("k\u00f6nnen").markAs("Koennen").includeIntoReport();
        NodePattern withoutConditionalConjs = NodePattern.N.noDependents("mark", NodePattern.N.form("wenn|sofern|soweit|falls"));
        NodePattern withoutRelativePronoun = NodePattern.N.noDependents("nsubj", NodePattern.N.directlyAfter(NodePattern.PUNCT).after("Adv"));
        NodePattern moeglicherweise = NodePattern.N.form("m\u00f6glicherweise");
        return NodePattern.N.form("m\u00f6glicherweise|poten[zt]iell|eventuell|m\u00f6glich|f\u00e4hig").markAs("Adv").includeIntoReport().andOr(NodePattern.N.withHead("advmod", withoutConditionalConjs.and(withoutRelativePronoun).withDependent("aux", koennen)).andOr(obligatoryFirstPlace.andOr(moeglicherweise.withHead(NodePattern.N.lemma("sein").correct(NodeCorrector.replace("").join(NodeCorrector.replace(NodePointer.marked("Adv"), "m\u00f6glich")).join(LemmaChanges.changeOwnVerbLemma("sein").corrector(NodePointer.marked("Koennen"))))), NodePattern.N.withHead(NodePattern.N.markAs("Verb").and((node, match) -> {
            Node aux = match.getMarkedNode("Koennen");
            if (node.hasForm(prefixedVerb)) {
                String prefix = node.lowForm().replaceFirst(prefixedVerb, "$1");
                String verbStem = node.lowForm().substring(prefix.length());
                return match.withCorrector(LemmaChanges.changeOwnVerbLemma(verbStem).corrector(aux).join(NodeCorrector.replace(node, prefix)));
            }
            return match.withCorrector(LemmaChanges.changeOwnVerbLemma(node.lowForm()).corrector(aux).join(NodeCorrector.replace(node, "")));
        }))), NodePattern.or(moeglicherweise.withHead("advmod", NodePattern.N.lemma("sein").markAs("Sein")).and((node, match) -> {
            Node aux = match.getMarkedNode("Koennen");
            Node sein = match.getMarkedNode("Sein");
            return match.withCorrector(NodeCorrector.replace(node, "")).withCorrector(NodeCorrector.replace(node, "m\u00f6glich").join(LemmaChanges.changeOwnVerbLemma("sein").corrector(aux)).join(NodeCorrector.replace(sein, "")));
        }), NodePattern.not(moeglicherweise.withHead("advmod", NodePattern.N.withDependent("nsubj", NodePattern.N.pos("PRO.*").noPos("ART.*")).noDependents(NodePattern.N.pos(".*KJ2")))).correct(NodeCorrector.replace("")))), CommonPatterns.possiblySkipUp("amod", NodePattern.N.withDependent("csubj|ccomp|xcomp|acl", NodePattern.N.markAs("Verb").and(withoutConditionalConjs).and(withoutRelativePronoun).andOr(NodePattern.N.noHeadRelation("acl"), NodePattern.N.withDependent("mark", NodePattern.N.form("zu"))).withDependent("aux", koennen.andOr(NodePattern.N.directlyAfter(zu).and((node, match) -> {
            Node verb = match.getMarkedNode("Verb");
            NodeCorrector insertZu = NodeCorrector.insertBefore(verb, "zu ");
            NodeCorrector removeZuKoennen = NodeCorrector.replaceNodes(node.neighbor(-1), node, "");
            List<Node> conjs = verb.findDependents("conj");
            NodeCorrector corrector = insertZu.join(removeZuKoennen);
            for (Node conj : conjs) {
                corrector = corrector.join(NodeCorrector.insertBefore(conj, "zu "));
            }
            return match.withCorrector(corrector);
        }), NodePattern.custom((node, match) -> {
            Node verb = match.getMarkedNode("Verb");
            return match.withCorrector(LemmaChanges.changeOwnVerbLemma(verb.lowForm()).corrector(node).join(NodeCorrector.replace(verb, "")));
        }))))), NodePattern.N.withDependent("cop", NodePattern.N.markAs("Verb")).withDependent("aux", koennen.noPos(".*KJ2")).and(NodePattern.custom((node, match) -> {
            Node verb = match.getMarkedNode("Verb");
            Node aux = match.getMarkedNode("Koennen");
            return match.withCorrector(NodeCorrector.replace(node, "m\u00f6glich").join(LemmaChanges.changeOwnVerbLemma("sein").corrector(aux)).join(NodeCorrector.replace(verb, "")));
        }))).andOr(NodePattern.N.form("f\u00e4hig").message("\u201eF\u00e4hig\u201c und \u201ek\u00f6nnen\u201c zusammen sind redundant, da beide Unsicherheit oder M\u00f6glichkeit ausdr\u00fccken"), NodePattern.N.message("\u201e$Adv\u201c und \u201ek\u00f6nnen\u201c zusammen sind redundant, da beide Kapazit\u00e4t oder F\u00e4higkeit ausdr\u00fccken"));
    }

    private static String prefixAndAttachZu(Node node) {
        String prefix = node.lowForm().replaceFirst(prefixedVerb, "$1");
        String verbStem = node.lowForm().substring(prefix.length());
        if (node.tree().treeSupport().tagToken(verbStem).hasPos("VER.*") && !node.hasForm("(durch|\u00fcber|um|unter|voll|wider|hinter|ent).+")) {
            return prefix + "zu" + verbStem;
        }
        return "zu " + node.form();
    }

    private static NodePattern faehigkeitZuKoennen() {
        NodePattern markedVerbWithZuKoennen = NodePattern.N.pos("VER.*").markAs("Verb").withDependent("aux", NodePattern.N.lemma("k\u00f6nnen|d\u00fcrfen").markAs("Aux").includeIntoReport().directlyAfter(SpellingRules.zu));
        return NodePattern.N.lemma("F\u00e4higkeit|Genehmigung|Gelegenheit|Erlaubnis|Lizenz").includeIntoReport().andOr(NodePattern.N.directlyBefore(CommonPatterns.comma).withDependent("xcomp|acl", markedVerbWithZuKoennen), NodePattern.N.withHead("obj", NodePattern.N.directlyBefore(CommonPatterns.comma).withDependent("xcomp|acl", markedVerbWithZuKoennen))).and((node, match) -> {
            Node verb = match.getMarkedNode("Verb");
            Node aux = match.getMarkedNode("Aux");
            NodeCorrector insertZu = NodeCorrector.insertBefore(verb, "zu ");
            NodeCorrector removeZuKoennen = NodeCorrector.replaceNodes(aux.neighbor(-1), aux, "");
            List<Node> conjs = verb.findDependents("conj");
            if (verb.hasForm(prefixedVerb)) {
                String newVerb = Redundancy.prefixAndAttachZu(verb);
                NodeCorrector corrector = NodeCorrector.replace(verb, newVerb).join(removeZuKoennen);
                for (Node conj : conjs) {
                    boolean conjHasPrefix = conj.hasForm(prefixedVerb);
                    if (conjHasPrefix) {
                        String newConj = Redundancy.prefixAndAttachZu(conj);
                        corrector = corrector.join(NodeCorrector.replace(conj, newConj));
                        continue;
                    }
                    corrector = corrector.join(NodeCorrector.insertBefore(conj, "zu "));
                }
                return match.withCorrector(corrector);
            }
            NodeCorrector corrector = insertZu.join(removeZuKoennen);
            for (Node conj : conjs) {
                corrector = corrector.join(NodeCorrector.insertBefore(conj, "zu "));
            }
            return match.withCorrector(corrector);
        }).andOr(NodePattern.markedNodeMatches("k\u00f6nnen", NodePattern.N.message("\u201e$_\u201c und \u201e$Aux\u201c sind redundant, da beide die F\u00e4higkeit oder die Erlaubnis, etwas zu tun, implizieren")), NodePattern.N.message("\u201e$_\u201c und \u201e$Aux\u201c sind redundant, da beide die Genehmigung oder die Berechtigung, etwas zu tun, implizieren"));
    }

    private static NodePattern sameMeaningAdjNoun() {
        return NodePattern.or(Redundancy.amodNounPattern("semantisch", "bedeut(ung|en)"), Redundancy.amodNounPattern("klein", ".*(chen|lein)").noLemma("(.*)m\u00e4dchen|(Veil|Br\u00f6t|Kanin|Radies|M\u00fcn|(.*)zei|(.*)(eich|grau)h\u00f6rn|Gummib\u00e4r|Flitt|Verbre|Dra|Berei)chen").noLemma("(k|al|Hal)lein"), Redundancy.amodNounPattern("kausal|urs\u00e4chlich", "(ver)ursach(ung|en?)"), Redundancy.amodNounPattern("zeitlich", "verz\u00f6ger(ung|n)|dauern?"), Redundancy.amodNounPattern("(kreis)?rund", "Kugel|Kreis"), Redundancy.amodNounPattern("finanziell", "Geldproblem", NodePattern.custom((node, match) -> {
            Node geldProblem = match.getMarkedNode("Main");
            return match.withCorrector(NodeCorrector.replace(geldProblem, StringTools.uppercaseFirstChar((String)geldProblem.form().substring(4))));
        })), Redundancy.amodNounPattern("erh\u00f6ht", ".*hochdruck").and((node, match) -> {
            Node nounEndsWithHochDruck = match.getMarkedNode("Main");
            String firstPart = nounEndsWithHochDruck.lowForm().replaceFirst("hochdruck", "");
            return match.withCorrector(NodeCorrector.replace(nounEndsWithHochDruck, StringTools.uppercaseFirstChar((String)(firstPart + "druck"))));
        }), Redundancy.amodNounPattern("gemeinsam", "Schnittmenge"), Redundancy.amodNounPattern("katholisch", "Papst"), Redundancy.amodNounPattern("einvernehmlich", "Konsens"), Redundancy.amodNounPattern("akustisch", "Klang"), Redundancy.amodNounPattern("optisch|visuell", "Bild"), Redundancy.amodNounPattern("brutal", "(.*)gewalt", NodePattern.N.correct(NodeCorrector.regexReplace("brutal(.*)", "roh$1"))), Redundancy.amodNounPattern("problematisch", "Problem", NodePattern.N.correct(NodeCorrector.regexReplace("problematisch(.*)", "schwierig$1"))), Redundancy.amodNounPattern("schriftlich", "Klausur(arbeit)?"), Redundancy.amodNounPattern("\u00fcblich", "Gepflogenheit|Gewohnheit", NodePattern.N.correct(NodeCorrector.regexReplace("\u00fcblich(.*)", "hiesig$1"))), Redundancy.amodNounPattern("schwarz", "Rappe"), Redundancy.amodNounPattern("tot", "Leiche"), Redundancy.amodNounPattern("wahr", "Fakt|Tatsache"), Redundancy.amodNounPattern("k\u00fcnstlich|geschaffen", "Artefakt"), Redundancy.amodNounPattern("islamisch", "Moschee"), Redundancy.amodNounPattern("j\u00fcdisch", "Synagoge"), Redundancy.amodNounPattern("(recht|vier)eckig", "Quadrat|(Recht|Vier)eck"), Redundancy.amodNounPattern("selten", "Rarit\u00e4t", NodePattern.N.correct(NodeCorrector.regexReplace("selten(.*)", "gefragt$1")).correct(NodeCorrector.regexReplace("selten(.*)", "begehrt$1"))), Redundancy.amodNounPattern("andere", "Alternative").correct(LemmaChanges.changeSameGenderNounLemma("M\u00f6glichkeit")).andOptionally(NodePattern.N.noPos(".*PLU.*").correct(LemmaChanges.changeSameGenderNounLemma("Wahl"))));
    }

    private static NodePattern amodNounPattern(String mod, String main) {
        return Redundancy.amodNounPattern(mod, main, NodePattern.N);
    }

    private static NodePattern amodNounPattern(String mod, String main, NodePattern modifierCorrections) {
        NodePattern markedMod = NodePattern.N.lemma(mod).andNot(NodePattern.N.inFormSequence(1, "sehr|ganz|\u00e4u(\u00df|ss)erst|total|nur", "klein.+")).markAs("Mod").includeIntoReport();
        return NodePattern.N.lemma(main).pos("VER.*|SUB.*").markAs("Main").includeIntoReport().andOr(NodePattern.N.withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", CommonPatterns.possiblySkipDown("xcomp|acl|ccomp", markedMod)), NodePattern.N.withDependent("amod|advmod", markedMod.correct(NodeCorrector.replace("")).and(modifierCorrections))).message("\u201e$_\u201c beinhaltet bereits das durch \u201e$Mod\u201c ausgedr\u00fcckte Merkmal");
    }

    private static NodePattern rechtlichLegal() {
        NodePattern legal = NodePattern.N.lemma("(il)?legal").markAs("Legal").includeIntoReport();
        return NodePattern.or(NodePattern.N.lemma("rechtlich|juristisch").includeIntoReport(), NodePattern.N.inFormSequence(2, "aus|im", "(rechtlich|juristisch)e[rn]", "Sicht|Perspektive|Sinne|Hinsicht").markAs("Sicht").withNeighbor(-1, NodePattern.N.markAs("Rechtlich")).reportEverythingTouched()).andOr(NodePattern.N.withHead("advmod|nmod", legal).andOr(obligatoryFirstPlace, NodePattern.markedNodeMatches("Sicht", NodePattern.N.correct(NodeCorrector.removeNodes(NodePointer.neighbor(-2), NodePointer.anchor()))), NodePattern.N.correct(NodeCorrector.replace(""))), NodePattern.N.withHead("amod", NodePattern.N.withDependent("amod", legal.correct(NodeCorrector.replace("")))).correct(NodeCorrector.replace("")), NodePattern.N.withHead("advmod", NodePattern.N.form("betrachtet|gesehen").markAs("Gesehen").andOr(NodePattern.N.withHead(legal), CommonPatterns.possiblySkipUp("advmod", NodePattern.N.withDependent("advmod|xcomp", legal)))).andOptionally(NodePattern.N.directlyBefore("Gesehen").correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1))).andNot(NodePattern.or(NodePattern.N.withDependent("advmod"), NodePattern.N.directlyAfter(GermanTreePatterns.openingQuotation), obligatoryFirstPlace)))).andOr(NodePattern.markedNodeMatches("Sicht", NodePattern.N.message("\u201e$Rechtlich\u201c und \u201e$Legal\u201c sind redundant, da beide eine rechtliche Dimension implizieren")), NodePattern.N.message("\u201e$_\u201c und \u201e$Legal\u201c sind redundant, da beide eine rechtliche Dimension implizieren"));
    }

    private static NodePattern waehrendDesVerlaufs() {
        NodeCorrector.Relative imVerlauf = NodeCorrector.replaceNodes(NodePointer.marked("W\u00e4hrend"), NodePointer.marked("Des"), "im").join(NodeCorrector.replace("Verlauf"));
        return NodePattern.N.lemma("Verlauf").markAs("Verlauf").includeIntoReport().withDependent("det", NodePattern.N.inFormSequence(1, "w\u00e4hrend", "de[sm]").withNeighbor(-1, NodePattern.N.markAs("W\u00e4hrend")).markAs("Des")).includeIntoReport().withDependent("nmod", NodePattern.N.afterHead()).andOr(NodePattern.N.withDependent(".*", NodePattern.N.after("Des").before("Verlauf")), NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("det.*")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "")), NodePattern.N.directlyBefore(NodePattern.N.lemma("von"))).correct(imVerlauf).message("\u201eW\u00e4hrend\u201c und \u201eVerlauf\u201c zusammen sind redundant, da beide eine zeitliche Dauer signalisieren");
    }

    private static NodePattern morgenAmMorgen() {
        NodePattern amMorgen = NodePattern.N.inFormSequence(1, "am", "Morgen").withNeighbor(-1, NodePattern.N.markAs("Am").includeIntoReport()).markAs("Morgen").includeIntoReport();
        NodePattern withDependentAmMorgen = NodePattern.N.withDependent("obl|conj|nmod", amMorgen);
        NodePattern frueh = NodePattern.N.form("fr\u00fch");
        NodeCorrector.Relative removeAmMorgen = NodeCorrector.replaceNodes(NodePointer.marked("Am"), NodePointer.marked("Morgen"), "");
        NodeCorrector.Relative amMorgenToVormittagFrueh = NodeCorrector.replaceNodes(NodePointer.marked("Am"), NodePointer.marked("Morgen"), "Vormittag", "fr\u00fch");
        NodeCorrector.Relative morgenToVormittag = NodeCorrector.replace(NodePointer.marked("Morgen"), "Vormittag");
        return NodePattern.N.lemmaCaseSensitive("morgen").includeIntoReport().andOr(NodePattern.N.withNextSibling(amMorgen.andOr(NodePattern.N.withDependent("conj").correct(morgenToVormittag), NodePattern.N.correct(amMorgenToVormittagFrueh))), NodePattern.N.withHead("advmod|obl", NodePattern.or(withDependentAmMorgen.andOr(NodePattern.N.withDependent("advmod").correct(morgenToVormittag), NodePattern.N.correct(morgenToVormittag)), frueh.withHead("advmod", withDependentAmMorgen).correct(amMorgenToVormittagFrueh.join(NodeCorrector.replace(""))).correct(removeAmMorgen.join(NodeCorrector.replace("in aller Fr\u00fche"))), NodePattern.N.withHead("advmod|advcl", withDependentAmMorgen).correct(NodeCorrector.replaceNodes(NodePointer.marked("Am"), NodePointer.marked("Morgen"), "am Vormittag", "fr\u00fch")), NodePattern.N.withDependent("advmod", withDependentAmMorgen.correct(removeAmMorgen).correct(morgenToVormittag)), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("conj", withDependentAmMorgen).correct(amMorgenToVormittagFrueh)), NodePattern.N.withDependent("conj", CommonPatterns.possiblySkipDown("xcomp", withDependentAmMorgen).correct(morgenToVormittag))))).message(WORDS_REPEATED_DIFFERENT_MEANING);
    }

    private static NodePattern sameMeaningHyphenatedNounPattern() {
        NodeCorrector.Relative removeFirstNeighborTillEnd = NodeCorrector.removeNodes(NodePointer.neighbor(1), NodePointer.marked("End"));
        NodePattern beforeHeadOrHyphen = NodePattern.or(NodePattern.N.directlyAfterHead(), NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen)).markAs("End");
        return NodePattern.or(Redundancy.sameMeaningNoun("SMS", "Service"), Redundancy.sameMeaningNoun("SEK", "Kommando"), Redundancy.sameMeaningNoun("IT", "Technik"), Redundancy.sameMeaningNoun("ISBN|IBAN|TAN|PIN", "Nummer"), Redundancy.sameMeaningNoun("DTV", "Verlag"), Redundancy.sameMeaningNoun("ABM", "Ma(\u00df|ss)nahme").correct(LemmaChanges.changeSameGenderNounLemma("Arbeitsbeschaffungsma\u00dfnahme").join(removeFirstNeighborTillEnd)), Redundancy.sameMeaningNoun("LCD", "Display"), Redundancy.sameMeaningNoun("HIV", "Virus").correct(NodeCorrector.replace("HI")), NodePattern.N.form("[PO]DF").markAs("Start").withDependent("flat|appos", NodePattern.N.lemma("Format").and(beforeHeadOrHyphen)).reportEverythingTouched().andOr(NodePattern.N.withDependent("case", NodePattern.N.form("im").directlyBeforeHead()).correct(NodeCorrector.replace(NodePointer.neighbor(-1), "als").join(removeFirstNeighborTillEnd)), NodePattern.N.correct(removeFirstNeighborTillEnd)).message("Das \u201eF\u201c im \u201e$_\u201c steht bereits f\u00fcr \u201eFormat\u201c"), NodePattern.N.inFormSequence(0, "La", "-", "Ola", "-", "Welle").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(4), "La Ola")).message("\u201eLa Ola\u201c bedeutet \u201edie Welle\u201c auf Spanisch"), Redundancy.sameMeaningNoun("EVN", "Nachweis"), NodePattern.N.form("SSD").markAs("Start").withDependent("flat|appos", NodePattern.N.lemma("Laufwerk").and(beforeHeadOrHyphen)).reportEverythingTouched().message("Das \u201eD\u201c im \u201e$_\u201c steht f\u00fcr \u201eDrive\u201c und bedeutet bereits \u201eLaufwerk\u201c").correct(removeFirstNeighborTillEnd));
    }

    private static NodePattern sameMeaningNoun(String abbr, String noun) {
        return NodePattern.N.form(abbr).and(CommonPatterns.beforeSkipping(CommonPatterns.noSpaceHyphen, NodePattern.N.lemma(noun).markAs("End"))).reportRangeTo("End").correct(NodeCorrector.removeNodes(NodePointer.neighbor(1), NodePointer.marked("End"))).message("Die Abk\u00fcrzung \u201e$_\u201c enth\u00e4lt bereits das Wort \u201e$End\u201c");
    }
}

