/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.de;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.de.AgreementSet;
import ai.grazie.rules.de.Articles;
import ai.grazie.rules.de.Case;
import ai.grazie.rules.de.GermanTreePatterns;
import ai.grazie.rules.de.SemanticRules;
import ai.grazie.rules.de.StyleRules;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.Iterator;
import java.util.List;
import org.languagetool.tools.StringTools;

class WrongApostrophe {
    private static final String NO_APOSTROPHE_IN_IMPERATIVE = "Bei Imperativbildung entf\u00e4llt der Apostroph";
    private static final String NO_APOSTROPHE_WITH_PROPER_NAMES = "Verwenden Sie keinen Apostroph bei Eigennamen im Genitiv";
    private static final String NO_APOSTROPHE_IN_PLURAL_NOUNS = "Setzen Sie bei Pluralformen von Substantiven keinen Apostroph";
    private static final String NO_APOSTROPHE_IN_PREPOSITIONS = "Bei der Verschmelzung von Pr\u00e4positionen wird kein Apostroph verwendet";

    WrongApostrophe() {
    }

    static Rule.PatternRule rule() {
        return new Rule.PatternRule("Grammar.WRONG_APOSTROPHE", "Unn\u00f6tiger Apostroph", "Im Genitiv von Eigennamen, im Plural von Substantiven, im Imperativ und Konjunktiv I sowie bei Verschmelzung von W\u00f6rtern entf\u00e4llt der Apostroph.", "https://www.scribbr.de/rechtschreibung/deppenapostroph/", NodePattern.or(WrongApostrophe.imperative(), WrongApostrophe.withProperNames(), WrongApostrophe.inPluralNoun(), WrongApostrophe.withPrepositions(), WrongApostrophe.konjunktiv1(), WrongApostrophe.wordEnding(), WrongApostrophe.genitive(), WrongApostrophe.paraphraseGenitive()), new Example("<b>Sag'</b> uns deine Meinung.", NO_APOSTROPHE_IN_IMPERATIVE, "<b>Sag</b> uns deine Meinung.", "<b>Sage</b> uns deine Meinung."), new Example("<b>Annette's</b> Schwester ist wieder da.", NO_APOSTROPHE_WITH_PROPER_NAMES, "<b>Annettes</b> Schwester ist wieder da."), new Example("Fortan ziehen sie und ihre M\u00e4nner als Piraten <b>\u00fcber's</b> Meer", NO_APOSTROPHE_IN_PREPOSITIONS, "Fortan ziehen sie und ihre M\u00e4nner als Piraten <b>\u00fcbers</b> Meer"), new Example("Wir freuen uns auf die <b>Foto's</b>.", NO_APOSTROPHE_IN_PLURAL_NOUNS, "Wir freuen uns auf die <b>Fotos</b>."));
    }

    private static NodePattern imperative() {
        return GermanTreePatterns.apos.noSpaceBefore().directlyAfter(NodePattern.N.withHeadRelation("root|ccomp|aux:pass|cop|conj").pos("VER:IMP:SIN.*").markAs("Verb").andNot(CommonPatterns.skipUp("aux:pass", NodePattern.N.withDependent("nsubj.*", NodePattern.N.pos(".*")))).andNot(NodePattern.N.withHead("cop|aux", NodePattern.N.withHeadRelation("[cx]comp").withDependent("nsubj")))).andNot(GermanTreePatterns.afterOpeningApos).message(NO_APOSTROPHE_IN_IMPERATIVE).and(NodePattern.custom((apos, match) -> {
            Node verb = apos.neighbor(-1);
            if (verb.hasForm("sei")) {
                return match.withCorrector(NodeCorrector.replaceNodes(verb, apos, verb.lowForm()));
            }
            return match.withCorrector(NodeCorrector.replaceNodes(verb, apos, verb.lowForm(), verb.lowForm() + "e"));
        }));
    }

    private static NodePattern konjunktiv1() {
        return GermanTreePatterns.apos.noSpaceBefore().directlyAfter(NodePattern.N.form("sei").withHead("cop|aux.*", CommonPatterns.possiblySkipUp("advmod", NodePattern.N.withDependent("nsubj.*")))).andNot(GermanTreePatterns.afterOpeningApos).message("Verwenden Sie keinen Apostroph im Konjunktiv").correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "sei"));
    }

    private static NodePattern withProperNames() {
        return NodePattern.N.form("['`\u00b4\u2019]s").noLabel("ORGANIZATION|LOCATION|GEO_POLITICAL_ENTITY").directlyAfter(NodePattern.or(SemanticRules.familyMembers.message("Verwenden Sie keinen Apostroph bei Verwandtschaftsnamen im Genitiv"), NodePattern.or(NodePattern.N.label("PERSON"), NodePattern.N.label("ORGANIZATION|GEO_POLITICAL_ENTITY|EVENT|LOCATION").noForm("McDonald|Moody|Levi|Domino")).message(NO_APOSTROPHE_WITH_PROPER_NAMES)).markAs("Noun").andNot(NodePattern.N.withDependent("det", NodePattern.N.pos("ART.*GEN.*")).withDependent("amod").noLabel("ORGANIZATION")).and(CommonPatterns.possiblyConj(NodePattern.N.withHead("nmod(:poss)?|flat", NodePattern.or(NodePattern.N.pos("SUB.*"), NodePattern.N.label("PERSON")).markAs("Head").noDependents("case", NodePattern.N.beforeHead().pos("PRP:LOK:DAT")).noLabel("LOCATION|MISC").andNot(NodePattern.N.lemma("(.*)(laden|gesch\u00e4ft|restaurant|caf\u00e9|ware|shop)")).andNot(NodePattern.N.withHead("nmod(:poss)?", GermanTreePatterns.englishWord.andOr(NodePattern.N.label("ORGANIZATION"), NodePattern.N.withDependent(".*", GermanTreePatterns.englishWord.label("MISC"))))))))).and((node, match) -> {
            Node noun = match.getMarkedNode("Noun");
            NodeCorrector removeApostrophe = NodeCorrector.replace(node, node.form().substring(0, node.lowForm().length() - 1));
            NodeCorrector joinNameEs = NodeCorrector.replaceNodes(noun, node, noun.form() + "s");
            return noun.hasForm(".*(x|s|z|ce)") ? match.withCorrector(removeApostrophe) : match.withCorrector(joinNameEs);
        });
    }

    private static NodePattern inPluralNoun() {
        return NodePattern.N.pos("SUB.*").noPos("VER.*").directlyBefore(NodePattern.N.form("['`\u00b4\u2019]s").markAs("Apos")).noHeadRelation("nmod.*").message(NO_APOSTROPHE_IN_PLURAL_NOUNS).andOr(NodePattern.N.form("AGB").correct(NodeCorrector.replace(NodePointer.neighbor(1), "s")), NodePattern.N.noLabel("ORGANIZATION|MISC").and((node, match) -> {
            Node apos = match.getMarkedNode("Apos");
            String word = node.form() + "s";
            if (!node.tree().treeSupport().tagToken(word).hasPos(".*PLU.*")) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(node, apos, word));
        }));
    }

    private static NodePattern withPrepositions() {
        return NodePattern.N.withHeadRelation("case").andOr(NodePattern.N.form("(\u00fcber|hinter|unter|vor)['`\u00b4\u2019][snm]").andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("det"))).and((node, match) -> {
            String preposition = node.lowForm();
            int length = preposition.length();
            String replacement = preposition.substring(length - 1);
            String newNode = preposition.substring(0, length - 2);
            return match.withCorrector(NodeCorrector.replace(node, newNode + replacement));
        }), NodePattern.or(NodePattern.N.form("hinter|\u00fcber|unter|vor").directlyBefore(NodePattern.N.form("['`\u00b4\u2019][snm]")), NodePattern.N.form("auf|durch|in|um|f\u00fcr").directlyBefore(NodePattern.N.form("['`\u00b4\u2019]s")), NodePattern.N.form("an").directlyBefore(NodePattern.N.form("['`\u00b4\u2019][sm]")), NodePattern.N.form("bei").directlyBefore(NodePattern.N.form("['`\u00b4\u2019]m"))).and((node, match) -> {
            String mergedPreposition = node.neighbor(1).lowForm().substring(1);
            return match.withCorrector(NodeCorrector.replace(node.neighbor(1), mergedPreposition));
        })).message(NO_APOSTROPHE_IN_PREPOSITIONS);
    }

    private static NodePattern wordEnding() {
        return NodePattern.N.withHeadRelation("advmod|nsubj(:pass)?|i?obj|obl|nmod|compound|conj|case|amod|dep").directlyBefore(NodePattern.N.form("['`\u00b4\u2019]s").markAs("Apos")).noDependents("det").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("case"))).message("Trennen Sie eine normale Wortendung nicht mit Apostroph ab").andOr(NodePattern.N.form("wochentag|andernort|.*w\u00e4rt|hinterr\u00fcck|unversehen").correct(NodeCorrector.replace(NodePointer.neighbor(1), "s")), NodePattern.custom((node, match) -> {
            Node apos = match.getMarkedNode("Apos");
            String word = node.lowForm() + "s";
            if (!node.tree().treeSupport().tagToken(word).hasPos("ADV.*|PRP.*|PRO:IND.*")) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(node, apos, word));
        }));
    }

    private static NodePattern genitive() {
        return NodePattern.N.pos("SUB.*").noLabel("ORGANIZATION").withDependent("det.*", NodePattern.N.pos(".*GEN.*")).afterHead().withHead("nmod", NodePattern.not(GermanTreePatterns.englishWord)).andOr(NodePattern.N.withDependent("appos").directlyBefore(NodePattern.N.form("['`\u00b4\u2019]").noSpaceBefore().spaceAfter().markAs("Apos")).and((node, match) -> {
            Node apos = match.getMarkedNode("Apos");
            String newNoun = node.tree().treeSupport().synthesize(node.lowForm(), node.lowForm(), "SUB.*", "SUB:GEN:SIN.*").get(0);
            return match.withCorrector(NodeCorrector.replace(node, StringTools.uppercaseFirstChar((String)newNoun)).join(NodeCorrector.replace(apos, "")));
        }), NodePattern.N.directlyBefore(NodePattern.N.form("['`\u00b4\u2019]s").markAs("Apos")).and((node, match) -> {
            Node apos = match.getMarkedNode("Apos");
            String word = node.form() + "s";
            if (!node.tree().treeSupport().tagToken(word).hasPos("SUB:GEN.*")) {
                return null;
            }
            return match.withCorrector(NodeCorrector.replaceNodes(node, apos, word));
        })).message("Verwenden Sie keinen Apostroph bei Substantiven im Genitiv");
    }

    private static NodePattern paraphraseGenitive() {
        NodePattern organizationOrEventLabel = NodePattern.N.label("ORGANIZATION|EVENT");
        return NodePattern.N.form("['`\u00b4\u2019]s").noLabel("LOCATION").markAs("Appos").directlyAfter(NodePattern.or(NodePattern.N.andOptionally(NodePattern.N.label("PERSON").markAs("Person")).withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.N.markAs("PostApostropheNoun")).markAs("NominalDependent").withDependent("amod", NodePattern.N.markAs("Amod").directlyBeforeHead().directlyAfter(NodePattern.N.withHeadRelation("det").pos("ART.*GEN.*").and((articleGen, match) -> {
            Node postApostropheNoun = match.getMarkedNode("PostApostropheNoun");
            Node appos = match.getMarkedNode("Appos");
            boolean person = match.findMarkedNode("Person") != null;
            AgreementSet headSet = AgreementSet.create(postApostropheNoun);
            if (headSet == null) {
                return null;
            }
            AgreementSet.Number number = headSet.numberRestriction != null ? headSet.numberRestriction : (postApostropheNoun.hasPos(".*PLU.*") ? AgreementSet.Number.PLU : AgreementSet.Number.SIN);
            Iterator<Case> iterator = headSet.possibleCases.allowed().iterator();
            if (iterator.hasNext()) {
                Case caze = iterator.next();
                String article = Articles.getDefArticleForm(postApostropheNoun, caze, number, StyleRules.pickGender(postApostropheNoun));
                if (article == null) {
                    return match;
                }
                NodeCorrector removeGenitive = appos.neighbor(-1).hasPos("EIG.*") || person ? NodeCorrector.removeNode(appos) : NodeCorrector.replace(appos, appos.form().substring(appos.textRange().length() - 1));
                return match.withCorrector(NodeCorrector.insertBefore(articleGen, article + " " + postApostropheNoun.form() + " ").join(NodeCorrector.replace(postApostropheNoun, "").join(removeGenitive)));
            }
            return null;
        }))).message("Bilden Sie den Genitiv durch Versetzen von \u201e$NominalDependent\u201c oder formulieren Sie den Satz um"), NodePattern.or(organizationOrEventLabel, NodePattern.N.noLabel("PRODUCT|LOCATION")).beforeHead().markAs("NounInGenitive").andNot(GermanTreePatterns.englishWord.and(organizationOrEventLabel)).withHead("nsubj(:pass)?|i?obj|obl|nmod|compound", NodePattern.or(NodePattern.N.withDependent("appos|flat", NodePattern.N.directlyAfterHead().markAs("PostApostropheNoun")), NodePattern.N.noLabel("PRODUCT|LOCATION").markAs("PostApostropheNoun")).andOr(NodePattern.N.pos("SUB.*"), organizationOrEventLabel).withDependent("case", NodePattern.N.before("NounInGenitive"))).directlyAfter(NodePattern.N.pos("(PRP|PRO).*DAT.*").beforeHead()).markAs("NominalDependent").and((node, match) -> {
            Node postApostropheNoun = match.getMarkedNode("PostApostropheNoun");
            Node appos = match.getMarkedNode("Appos");
            SentenceWithNERAnnotations.Annotation.Label label = postApostropheNoun.nerLabels().findFirst().orElse(null);
            boolean miscOrOrganization = label == SentenceWithNERAnnotations.Annotation.Label.MISC || label == SentenceWithNERAnnotations.Annotation.Label.ORGANIZATION;
            String message = "Bilden Sie den Genitiv durch Versetzen von \u201e" + node.form() + "\u201c oder formulieren Sie den Satz um";
            String prepositionWithArticle = postApostropheNoun.hasPos("SUB.*PLU.*") ? "in den" : (postApostropheNoun.hasPos(".*FEM") ? "in der" : "im");
            Node prev = node.neighbor(-1);
            if (SemanticRules.dayOfWeek.matches(node) && node.prevNode() != null && node.prevNode().hasForm("im")) {
                NodeCorrector insertPrepositionWithArticle = NodeCorrector.replace(prev, prepositionWithArticle);
                if (!postApostropheNoun.hasHeadRelation("appos|flat")) {
                    String compound = node.form() + "s" + postApostropheNoun.lowForm();
                    if (node.tree().treeSupport().tagToken(compound).hasPos("SUB.*") && !miscOrOrganization) {
                        return match.withCorrector(NodeCorrector.replaceNodes(node, postApostropheNoun, compound).join(insertPrepositionWithArticle)).withMessage(message);
                    }
                }
                return match.withCorrector(NodeCorrector.replaceNodes(node, appos, "").join(NodeCorrector.insertAfter(postApostropheNoun, " vom " + node.form())).join(insertPrepositionWithArticle)).withMessage(message);
            }
            if (node.hasForm("Morgen|Abend|(Nach)?mittag") && node.prevNode() != null && node.prevNode().hasForm("in")) {
                return match.withCorrector(NodeCorrector.replaceNodes(node.prevNode(), appos, "heute " + node.form()).join(NodeCorrector.insertAfter(appos, " " + prepositionWithArticle + " "))).withMessage(message);
            }
            if (prev.hasLemma("dies") && node.neighbor(-2).hasLemma("von")) {
                AgreementSet headSet = AgreementSet.create(postApostropheNoun);
                if (headSet == null) {
                    return null;
                }
                AgreementSet.Gender gender = StyleRules.pickGender(postApostropheNoun);
                AgreementSet.Number number = StyleRules.pickNumber(postApostropheNoun, headSet);
                String article = Articles.getDefArticleForm(postApostropheNoun, Case.GEN, number, gender);
                if (article == null) {
                    return match.withMessage(message);
                }
                List<String> postApostropheNounInGenitive = postApostropheNoun.tree().treeSupport().inflectNode(postApostropheNoun, "SUB.*", "SUB:GEN:" + number + ".*");
                List<String> diesInGen = prev.tree().treeSupport().inflectNode(prev, "PRO.*", "PRO:DEM:GEN:SIN:" + StyleRules.pickGender(node) + ".*");
                if (!postApostropheNounInGenitive.isEmpty() && !diesInGen.isEmpty()) {
                    return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-2), appos, "").join(NodeCorrector.insertBefore(postApostropheNoun, article + " ")).join(NodeCorrector.replace(postApostropheNoun, StringTools.uppercaseFirstChar((String)postApostropheNounInGenitive.get(0)))).join(NodeCorrector.insertAfter(postApostropheNoun, " " + diesInGen.get(0) + " " + node.form() + "s"))).withMessage(message);
                }
            }
            return match.withMessage(message);
        }).noLabel("PERSON")));
    }
}

