/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.GenderBias;
import ai.grazie.rules.en.PassiveToActive;
import ai.grazie.rules.en.PrepositionIssues;
import ai.grazie.rules.en.PronounForm;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.TagQuestions;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.en.WordOrder;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;

class EnglishCrazyParseDetector {
    private static final NodePattern aBut = NodePattern.N.inFormSequence(1, "a", "but");
    private static final NodePattern postIt = NodePattern.N.inFormSequence(1, "post", "its?");
    static final NodePattern possibleDoubleXComp = NodePattern.N.form("possible").markAs("First").withHeadRelation("xcomp").directlyBefore(NodePattern.N.pos("JJ.*").withHeadRelation("xcomp").withPrevSibling(NodePattern.N.alreadyMarkedAs("First"))).trace("possibleDoubleXComp");
    private static final NodePattern beingModifierClause = NodePattern.N.withDependent("cop|aux:pass", NodePattern.N.form("being"));
    private static final NodePattern havingModifierClause = NodePattern.N.withDependent("aux", NodePattern.N.form("having"));
    static final NodePattern oblWithoutCase = NodePattern.N.withHeadRelation("obl").noDependents("case");
    private static final NodePattern expletiveObj = NodePattern.N.directlyAfterHead().withHead("expl", CommonPatterns.possiblySkipDown("xcomp", NodePattern.N.withDependent("ccomp")));
    private static final NodePattern[] crazyParse = new NodePattern[]{NodePattern.N.withHead("cop|aux:pass", NodePattern.N.withDependent("advcl|parataxis", NodePattern.N.beforeHead().andNot(CommonPatterns.phraseEndsWithComma)).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl").withOptionalDependent("advcl", NodePattern.N.beforeHead()).withOptionalDependent("parataxis", NodePattern.N.beforeHead())).message("misparsed cop|aux:pass subj"), NodePattern.ROOT.withDependent("nsubj.*", NodePattern.N.afterHead()).withDependent("advcl", NodePattern.N.beforeHead()).noDependents("expl").message("advcl predicate subject"), NodePattern.N.withHead("obj", NodePattern.N.withHeadRelation("nsubj.*")).message("obj on nsubj"), NodePattern.N.withHead("case", NodePattern.N.withHead("nummod", NodePattern.N).noLemma("dozen|hundred|thousand|million|billion|(ga)?zillion").andNot(StyleRules.numOutOfNum).andNot(NodePattern.N.inFormSequence(2, "\\d+", "in", "\\d+").directlyBeforeHead())).message("case on nummod"), NodePattern.N.withHead("case", NodePattern.N.withHeadRelation("amod")).message("case on amod"), NodePattern.N.withHeadRelation("nummod").beforeHead().directlyBefore(CommonPatterns.comma).noDependents().message("nummod comma"), NodePattern.N.withHead("cop", NodePattern.N.withHead("advmod", NodePattern.N).withPrevSibling(NodePattern.N)).message("cop on advmod"), NodePattern.N.withHead("aux.*", NodePattern.N.withHead("cop", NodePattern.N).withPrevSibling(NodePattern.N)).message("aux on cop"), NodePattern.N.pos("IN").noPos("NN.*|JJ.*").noDependents().andOr(NodePattern.N.withHead("obl", NodePattern.N.withHead("parataxis", NodePattern.N)), CommonPatterns.lastChildPhrase.withHead("nmod", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"))).message("preposition in nominal position"), NodePattern.N.potentialPos("NNS").withHead("parataxis", NodePattern.N.pos("VB").noDependents(NodePattern.N.beforeHead()).noDependents("advmod")).noDependents("punct", CommonPatterns.DASH_NODE).withOptionalDependent("nsubj", NodePattern.N).message("imperative obj misparsed as parataxis"), NodePattern.N.afterHead().potentialPos("NNS?").withHead("nsubj", NodePattern.N.pos("VB").withDependent("obl", NodePattern.N.beforeHead()).noDependents("expl")).message("imperative obj misparsed as nsubj"), NodePattern.N.afterHead().potentialPos("NNS?").withHead("obj", NodePattern.N.potentialPos("NNS?").withHead("ccomp", NodePattern.N).withPrevSibling(NodePattern.N.noPos().withHeadRelation("obj"))).message("compound misparsed as ccomp obj"), EnglishTreePatterns.localUnk.withHead(NodePattern.not(GenderBias.femaleHonorific)).noPos("CD").noForm("au|lait|-").andNot(NodePattern.N.inFormSequence(1, "o", "['\u2019`\u2018]", "clock")).andNot(NodePattern.N.withPrevSiblingIncludingOtherSide(GenderBias.femaleHonorific)).andNot(CommonPatterns.capitalized.withHead("<unk>", NodePattern.N.label("LOCATION"))).and(CommonPatterns.touchHierarchy).message("<unk>"), NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.N).withDependent(".*", NodePattern.not(EnglishTreePatterns.negation).andNot(CommonPatterns.comma)).andNot(StyleRules.wanna).andNot(TagQuestions.possiblyTagQuestion).and((node, match) -> match.withTouchedNodes(node.allDependents())).message("aux with dependent"), NodePattern.N.pos("VB.*").noPos("MD").noLemma("do|have|be|let|hand").withHeadRelation("aux").message("plain verb as aux"), NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("nmod")).message("nsubj as child of nmod"), NodePattern.N.beforeHead().withHead("xcomp", NodePattern.N).withDependent(".*").message("xcomp before head"), NodePattern.N.form("gentle|low").pos("V.*").noHeadRelation("advmod").message("Adjective incorrectly tagged as verb"), NodePattern.N.withHeadRelation("advcl").pos("JJ.*|VBG").directlyBefore(NodePattern.N.withHeadRelation("advcl").pos("NN.*")).message("torn NP"), NodePattern.N.afterHead().withHead("expl", NodePattern.N.pos("VB")).andNot(expletiveObj).message("obj misparsed as expl"), NodePattern.N.markAs("Expl").withHead("expl", NodePattern.N.withDependent("cop", NodePattern.N.before("Expl")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?")).message("nsubj misparsed as expl"), NodePattern.N.withHead("advcl", NodePattern.N).withDependent("cop|aux|aux:pass", CommonPatterns.firstChildPhrase).andNot(beingModifierClause).andNot(havingModifierClause).message("advcl started with aux"), NodePattern.N.pos("W.*").form("wh.*").afterHead().withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N).withNextSibling(EnglishTreePatterns.clause.andNot(NodePattern.N.withDependent("nsubj", WordConfusion.itDirectlyBeforeHead)).andNot(NodePattern.N.withDependent("punct", CommonPatterns.semicolon))).message("incorrect wh attachment"), NodePattern.N.withHeadRelation("advmod|obl").withNextSibling(NodePattern.N.withHeadRelation("cc")).message("advmod|obl before cc"), NodePattern.N.withHeadRelation("advmod").withNextSibling(NodePattern.N.pos("RBS")).message("advmod before RBS"), NodePattern.N.withHeadRelation("nsubj(:pass)?").withPrevSibling(NodePattern.N.form("to").withHeadRelation("mark")).andNot(PronounForm.whomever).message("to nsubj"), NodePattern.N.withHeadRelation("acl").onlyPos("VBP?").withDependent("obj").noDependents(NodePattern.N.beforeHead()).message("base acl"), NodePattern.N.withHead("acl:relcl", NodePattern.N).andNot(EnglishTreePatterns.verbalClause).noDependents("cop|aux|aux:pass").andNot(NodePattern.N.withNeighbor(-2, PrepositionIssues.inNotAdj)).andNot(NodePattern.N.withDependent("nsubj", WordConfusion.itDirectlyBeforeHead)).andNot(NodePattern.N.pos("VBG").withDependent("nsubj", NodePattern.N.noPos("DT"))).andNot(NodePattern.N.potentialPos("VBD").withDependent("nsubj")).andNot(CommonPatterns.inParentheses).message("non-clause relcl"), NodePattern.N.withHead("acl:relcl", EnglishTreePatterns.clause.andNot(EnglishTreePatterns.unlikelyToBeVerb).withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N)).message("relcl on a misparsed clause"), NodePattern.N.withHead("acl:relcl", NodePattern.N.withHead("nsubj", NodePattern.N)).pos("VBZ").noDependents(NodePattern.N.beforeHead()).message("csubj misparsed as relcl"), NodePattern.N.withHeadRelation("acl:relcl").beforeHead().message("pre-head acl:relcl"), NodePattern.N.withHeadRelation("acl:relcl").withDependent("aux:pass").withDependent("nsubj:pass").and(TreeMigration.revise("specific to tree-en?", NodePattern.N.withDependent("aux"))).noDependents(NodePattern.or(NodePattern.N.form("that"), Questions.whPhrase)).message("misparsed passive relcl"), NodePattern.N.withHead("nsubj|det", NodePattern.N).withDependent("case|fixed", NodePattern.not(StyleRules.incompleteEgIe).noForm("out")).noDependents("nummod", StyleRules.numOutOfNum).message("nsubj|det with case"), NodePattern.N.pos("W.*").withHead("case", NodePattern.N).message("wh case"), EnglishTreePatterns.caseAfterUnknown.directlyAfter(NodePattern.N.withHead("case", NodePattern.N)).message("case after unknown case"), EnglishTreePatterns.demonstratives.withHead("det", NodePattern.ROOT.onlyPos("VB.*").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?")).message("subj demonstrative misparsed as det"), EnglishTreePatterns.apostropheS.beforeHead().withHead("case", NodePattern.N).message("possessive case before head"), NodePattern.N.withHead("case", NodePattern.N).afterHead().pos("IN").noForm("through|to").andOptionally(NodePattern.N.withDependent("fixed")).message("preposition after head"), NodePattern.N.withHeadRelation("obj").withDependent("case", NodePattern.N.directlyBeforeHead()).message("obj with case").andNot(PronounForm.caseWho), NodePattern.N.form("how").withHead(NodePattern.N.withHeadRelation("advcl")).withPrevSibling(NodePattern.not(NodePattern.N.withHeadRelation("mark"))).message("advcl with how without another mark before it"), NodePattern.N.form("an?|the").withDependent("amod").message("amod on an article"), EnglishTreePatterns.nmodWithoutCase.noForm("[\\d/]+|la|(st|nd|rd|th)").afterHead().andNot(CommonPatterns.severalDependents("det")).andOptionally(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("nmod"))).andNot(Articles.prepositionsInNounCoordination).andNot(NodePattern.N.form("[\u00b4\u2032`;<>4\"!@#$%^&*()+]s").directlyAfterHead()).andNot(NodePattern.N.withDependent("nmod|nummod", NodePattern.N.beforeHead().withDependent("case|mark"))).message("nmod without case|mark"), NodePattern.N.withHeadRelation("nmod").beforeHead().directlyBefore(NodePattern.N.withHeadRelation("nummod")).noPos("JJS").message("nmod before nummod"), oblWithoutCase.noDependents(NodePattern.N.beforeHead()).directlyAfter(NodePattern.N.withHeadRelation("case")).message("misattached obl case"), NodePattern.N.withHead("acl:relcl", NodePattern.not(Questions.whWord.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|advcl|acl(:relcl)?|[xc]comp|csubj(:pass)?|parataxis")).andNot(StyleRules.whatcha)).withOnlyDependents(NodePattern.N.withHeadRelation("cop|aux|aux:pass")).message("relcl without args"), NodePattern.N.withHeadRelation("csubj").andOr(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.not(NodePattern.or(PronounForm.whomever, NodePattern.N.form("What").withHead("nsubj", NodePattern.N.form("makes"))))).potentialPos("NN.*").noDependents("advmod|mark").message("compound misparsed as subj inside csubj"), NodePattern.N.pos("VBN").withDependent("det").message("DP misparsed as csubj"), NodePattern.N.withPrevSibling(Questions.whPhrase).message("misparsed wh-phrase")), NodePattern.N.withHeadRelation("csubj:pass").andOr(NodePattern.N.pos("VB[ZD]").noDependents("mark").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", Questions.whPhrase).message("finite clause misparsed as csubj:pass"), NodePattern.N.form("providing").withDependent("obj").message("providing [X is Y] parsed as providing [X] is Y")), NodePattern.N.pos("VB.*|MD").withHeadRelation("parataxis").noDependents().markAs("Aux").withHead(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.before("Aux")).withDependent("cop|aux|aux:pass", NodePattern.N.after("Aux"))).message("aux misparsed as parataxis"), NodePattern.N.withHead("cop|aux|aux:pass|nsubj", NodePattern.N.withHead("aux|cop|amod|nsubj.*|obj|obl.*", NodePattern.N.andOptionally(NodePattern.N.withHead("advmod", NodePattern.N))).andNot(StyleRules.wanna).andNot(WordOrder.headlessWhCopulaClause).andNot(TagQuestions.possiblyTagQuestion)).andNot(CommonPatterns.firstWord.lemma("be").withHead("cop", NodePattern.N.withHeadRelation("nsubj"))).andNot(WordConfusion.itDirectlyBeforeHead).message("aux.*|cop|nsubj on a non-clause"), NodePattern.N.withHead("nsubj", NodePattern.N.withHead("compound", NodePattern.N).noDependents("cop|aux|aux:pass")).message("nsubj on compound"), NodePattern.N.withHead("det", NodePattern.N.withDependent("aux").noDependents("cop")).noDependents("punct", CommonPatterns.comma.afterHead()).message("det+aux"), NodePattern.N.form("that").withHead("mark", NodePattern.N.withHeadRelation("nsubj").potentialPos("VB").withDependent("compound", NodePattern.N.pos("NNS"))).message("that-csubj misparsed as nsubj"), NodePattern.N.form("that").withHeadRelation("mark").withNextSibling(NodePattern.N.withHeadRelation("cop").withNextSibling(NodePattern.N.withHeadRelation("nsubj"))).message("that cop nsubj"), NodePattern.N.form("that").withHeadRelation("mark").withPrevSibling(NodePattern.N.withHeadRelation("advcl")).message("that after advcl"), NodePattern.N.form("that").and(CommonPatterns.firstChildPhrase).withHead("det", NodePattern.N.withHeadRelation("appos|acl:relcl").withOptionalDependent("compound", NodePattern.N)).message("misparsed relcl with that"), NodePattern.N.form("an?").withHead("nsubj", NodePattern.ROOT.pos("NN.*")).message("an nsubj"), NodePattern.N.form("in").withHead("mark", NodePattern.N.withHeadRelation("acl").pos("VB").withOptionalDependent("obj", NodePattern.N)).noDependents().message("in <mark VB"), NodePattern.N.lemma("be").withDependent("ccomp", NodePattern.N.afterHead().noDependents("mark").noDependents(Questions.whPhrase).andNot(Questions.whPhrase).noPos("VBG?")).message("be + ccomp"), NodePattern.N.withHead("ccomp", NodePattern.N).andOr(NodePattern.N.pos("VBZ"), NodePattern.N.pos("VBP").withDependent("mark", NodePattern.N.form("that")), NodePattern.N.withDependent("cop|aux|aux:pass", CommonPatterns.firstChildPhrase.pos("VBP"))).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).message("finite ccomp without subj"), NodePattern.N.withHead("ccomp", NodePattern.N.pos("RB.*").form(".*ly").andNot(EnglishTreePatterns.clause)).message("RB ccomp"), NodePattern.N.withHead("ccomp", NodePattern.N.lemma("save|use").withOptionalDependent("obj", NodePattern.N)).potentialPos("NN.*").withDependent(".*", NodePattern.N.beforeHead()).message("unexpected ccomp"), NodePattern.N.withHead("obj", EnglishValences.definitelyIntransitive).message("obj on an intransitive verb"), NodePattern.N.withHead("expl", NodePattern.N.withDependent("nsubj").noLemma("be").noDependents("cop")).message("nsubj + expl"), NodePattern.N.markAs("First").andNot(Questions.whPhrase).andNot(StyleRules.whatcha).noForm("that|whether").withHead("obj|nummod", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.after("First")).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.before("First")).andNot(NodePattern.N.withHead("ccomp", Semantics.directSpeech).and(CommonPatterns.insideQuotes))).message("obj|nummod before subj"), NodePattern.N.markAs("Subj").withHead("nsubj(:pass)?", NodePattern.N.after("Subj").and((predicate, match) -> {
        Node subject = match.getMarkedNode("Subj");
        return subject.nextUntil(predicate).anyMatch(n -> n.hasForm("[:\\]]") && !EnglishTreePatterns.noSpaceColon.matches((Node)n)) ? match : null;
    })).message("subj: predicate"), EnglishTreePatterns.severalSubjects.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(WordConfusion.lowercaseI, WordConfusion.aPart, PronounForm.whom, EnglishTreePatterns.duplicateVerbParsedAsSubj, PassiveToActive.expletiveIt, TagQuestions.pronounBeforeQuestion.afterHead(), NodePattern.N.withDependent("case", StyleRules.incompleteEgIe), NodePattern.N.withDependent("nsubj", PronounForm.whomever), NodePattern.N.label("PRODUCT").withDependent("punct", CommonPatterns.dot.noSpaceAround()))).andNot(NodePattern.N.withDependent("nsubj:outer").withDependent("nsubj")).andNot(NodePattern.N.withHead("ccomp", Semantics.directSpeech).and(CommonPatterns.insideQuotes)).noDependents("punct", CommonPatterns.HYPHEN_NODE.and(CommonPatterns.firstPhrase)).message("Several dependents of the same type"), CommonPatterns.severalDependents("xcomp").noDependents("xcomp", possibleDoubleXComp).message("Several of xcomp"), CommonPatterns.severalDependents("ccomp").noDependents("ccomp", ToggleContraction.thatIs).andNot(Semantics.directSpeech.withDependent("ccomp", NodePattern.N.withDependent("punct", EnglishTreePatterns.quotations))).message("Several of ccomp"), CommonPatterns.severalDependents("obj").noLemma("give").andNot(EnglishTreePatterns.letS).noDependents("obj", NodePattern.or(EnglishTreePatterns.aBit, aBut, postIt, NodePattern.N.pos("NN[PS]").directlyBefore(NodePattern.N.withHeadRelation("obj")), Questions.whWord, NodePattern.N.withDependent("amod", WordConfusion.loseLoose), NodePattern.N.pos("CD"), CommonPatterns.parenthesizedPhrase.pos("NNP"))).andOptionally(NodePattern.N.withHead(NodePattern.N)).message("Several of obj"), CommonPatterns.severalDependents("cc").message("Several of cc"), CommonPatterns.severalDependents("acl:relcl").message("Several of acl:relcl"), NodePattern.ROOT.and(EnglishValences::needsObject).noDependents("obj").withDependent("nsubj", NodePattern.N.markAs("Subj").directlyAfter(NodePattern.N.pos("NN"))).withDependent("advcl", NodePattern.N.before("Subj")).message("relcl misparsed as a root"), NodePattern.N.noLabel(".*").noDependents("flat").withHead("conj", NodePattern.or(NodePattern.N.pos("NNS?|PRP"), NodePattern.N.pos("NNP").withDependent("case")).andNot(EnglishTreePatterns.clause)).and(EnglishTreePatterns.clause).andNot(EnglishTreePatterns.verbalClause.withDependent("compound|det")).andOr(NodePattern.N.withPhraseStart(NodePattern.not(CommonPatterns.comma)), NodePattern.N.withHead(CommonPatterns.skipUp("conj|appos", NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound")))).message("NP conj VP"), CommonPatterns.conjBeforeHead.and(CommonPatterns.touchHierarchy).message("conj before head"), CommonPatterns.comma.afterHead().withHead("punct", NodePattern.N).withNextSibling(NodePattern.N.withHeadRelation("obj")).message("comma obj"), NodePattern.N.form("of").withHead("mark", NodePattern.not(NodePattern.N.withHeadRelation("acl"))).message("of <mark"), NodePattern.N.form("for").beforeHead().markAs("Mark").withHead("mark", NodePattern.N.pos("VBP?").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("Mark"))).message("subj for VB"), NodePattern.N.form("then").beforeHead().markAs("Then").withHead("advmod", NodePattern.N.pos("VB").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.before("Then"))).message("Tom answers then says"), NodePattern.N.withHeadRelation("parataxis").form("[^\\p{L}\\d]+").noForm("%").withOptionalDependent("obj", NodePattern.N).message("punctuation parataxis"), NodePattern.N.pos("VBG").markAs("VBG").noDependents("amod").withHead("amod|compound", NodePattern.N.pos("NNS").noForm("data|fees").noDependents("nummod|det|amod", NodePattern.N.before("VBG"))).message("VBing NN"), NodePattern.N.pos("NN.*").noPos("IN").withHeadRelation("obl").noDependents().andNot(CommonPatterns.firstWord.formCaseSensitive("How")).message("lone noun obl"), NodePattern.N.withHead("obl:tmod", EnglishTreePatterns.clause).and(Semantics.timeUnits).noDependents().message("lone tmod"), NodePattern.N.withHead("obl", NodePattern.N).withDependent("mark|case", NodePattern.N.form("if")).message("if <mark obl"), NodePattern.N.withHead("advcl|nmod|expl", NodePattern.N.withHeadRelation("amod")).andOptionally(NodePattern.N.withPrevSibling(NodePattern.N.afterHead())).andOptionally(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?")).message("advcl|nmod|expl on amod"), NodePattern.N.withHead("advmod", NodePattern.N).beforeHead().noPos("RB.*").markAs("NotAdverb").directlyBefore(NodePattern.N.withHead("case", NodePattern.N.withHead("obl", NodePattern.N.alreadyMarkedAs("NotAdverb")))).message("Advcl/advmod confusion"), NodePattern.N.withHead("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("NN.*").noDependents("cop")).and(EnglishTreePatterns.possiblyImperativeVB).noDependents().message("Imperative+Subject misparsed as Subject+NounPredicate"), NodePattern.N.pos("NNP").withHead("flat", NodePattern.N.noPos("NNP").potentialPos("VB").withHeadRelation("nsubj")).message("Watch Powell discuss..."), NodePattern.or(NodePattern.N.form("the"), NodePattern.N.pos("MD")).withHead("mark", NodePattern.N.pos("VB.*")).message("the|MD <mark VB"), NodePattern.N.form("the").andOr(NodePattern.N.withHead("advmod|case", NodePattern.N).message("the <advmod|case"), NodePattern.N.withHead("nsubj", NodePattern.N.pos("VBN").withDependent("obj")).message("the VBN obj misparsed as nsubj"), NodePattern.N.withHeadRelation("nmod").withDependent("acl", NodePattern.N.pos("VBN").directlyAfterHead()).message("misparsed the+VBN")), NodePattern.N.withHeadRelation("flat").withDependent("nmod").message("nmod on flat"), NodePattern.N.inFormSequence(1, "does|do|did", EnglishTreePatterns.contractedNot.getFormRegex()).and(CommonPatterns.firstChildPhrase).noSpaceBefore().withHead("advmod", NodePattern.N.withHeadRelation("obj")).message("torn doesn't"), NodePattern.N.inFormSequence(0, "double", "the", "number").directlyAfterHead().withHead("ccomp", NodePattern.N.lemma("have")).message("double the number NP"), NodePattern.N.form("s\\d*").withHeadRelation("nummod").message("<s>"), NodePattern.N.form("some").withHead("advmod", NodePattern.N.noForm("hand")).message("some <advmod"), CommonPatterns.firstWord.form("have").withHead("aux", NodePattern.N.pos("VB")).withNextSibling(NodePattern.N.pos("NN.*").withHeadRelation("nsubj")).message("misparsed imperative: have X get Y"), NodePattern.N.lemma("think").withDependent("obj", NodePattern.N.afterHead().pos("NN.*")).message("think NN"), NodePattern.N.inFormSequence(0, "gon", "na").noSpaceAfter().withHead("obl", NodePattern.N).and(CommonPatterns.touchHierarchy).message("misparsed gonna"), NodePattern.N.form("Juve").message("Juve"), NodePattern.N.form("read|write|execute").directlyBefore(NodePattern.N.lemma("access|permission|action|buffer").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("NN.*")))).message("noun chaining parsed as verb+obj"), NodePattern.N.form("saw").withDependent("aux", NodePattern.N.lemma("have")).directlyBefore(NodePattern.N.pos("NN.*")).message("had saw marks"), NodePattern.ROOT.and(EnglishTreePatterns.clause).withDependent("mark", NodePattern.N.form("because")).withDependent("conj", NodePattern.N).message("because X and Y doesn't mean ..."), NodePattern.N.form("is").withDependent("nsubj", NodePattern.N.markAs("Subj")).withDependent("aux", NodePattern.N.lemma("do").after("Subj")).withDependent("mark", NodePattern.N.form("that").before("Subj")).message("... and that they do not is because nobody cares"), NodePattern.N.form("what").withHead("nsubj", NodePattern.N.pos("VB").markAs("Infinitive")).directlyBefore(NodePattern.N.form("to").directlyBefore("Infinitive")).message("what to do"), NodePattern.N.form("as").withHead("advmod", NodePattern.N.withHead("advmod", NodePattern.N).noDependents("advcl")).message("as <advmod <advmod"), NodePattern.N.withHead("cc", NodePattern.not(NodePattern.N.withHeadRelation("conj"))).withPrevSibling(NodePattern.N.withHeadRelation("advcl")).withNextSibling(NodePattern.N.withHeadRelation("advcl|mark|expl|nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound")).message("if X and Y"), NodePattern.N.form("if").withHead("mark", NodePattern.N.pos("VBG").withHead("acl", NodePattern.N.withHead("nsubj.*", NodePattern.N)).noDependents("cop|aux|aux:pass")).message("Checks if the PSI tree corresponding to the specified document has been modified"), NodePattern.N.form("will").withHead("cop", NodePattern.N.withDependent("nsubj.*", NodePattern.N.withDependent("det"))).message("when will those ship"), NodePattern.N.noPos().withHeadRelation("cop").message("unknown cop"), NodePattern.N.form("few").andNot(NodePattern.N.directlyBeforeHead()).directlyBefore(NodePattern.N.pos("CD")).withHead(NodePattern.N).message("few CD"), NodePattern.N.form("evident").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").message("nominal evident"), NodePattern.N.form("[a-z0-9].*").directlyAfter(NodePattern.N.pos("NN.*").withHead(NodePattern.N.markAs("Head"))).directlyBefore(NodePattern.N.withHead(NodePattern.N.alreadyMarkedAs("Head")).and(n -> n.form().equals(n.neighbor(-2).form()))).message("misparsed X by X"), NodePattern.N.form("\\+").directlyAfter(NodePattern.N.withHead("nsubj.*", NodePattern.N.markAs("Pred"))).directlyBefore(NodePattern.N.alreadyMarkedAs("Pred")).message("Ctrl + Shift"), NodePattern.ROOT.pos("NN.*").withDependent("acl", NodePattern.N.withDependent("obl", NodePattern.N.withDependent("compound").potentialPos("VB.*"))).message("compound/clause ambiguity inside acl"), NodePattern.N.inFormSequence(1, "the", "fact", "that").markAs("Fact").directlyBefore(NodePattern.not(NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Fact")))).message("misattached 'the fact that'"), NodePattern.N.pos("VBG").withHeadRelation("csubj").directlyBefore(NodePattern.N.withHeadRelation("nsubj")).message("VBing clausal subject before nominal subject"), NodePattern.N.form(".*\\..*").andNot(StyleRules.incompleteEgIe).withHead("case", NodePattern.N).directlyAfter(NodePattern.N).message("not a preposition"), NodePattern.N.form("much|many").withHeadRelation("amod").directlyBefore(NodePattern.N.form("most").withHeadRelation("amod")).message("'much' placed in the wrong clause"), NodePattern.N.withHead("ccomp", NodePattern.N.lemma("place")).message("ccomp on place"), NodePattern.N.inFormSequence(0, "singular", "they").andNot(NodePattern.N.directlyBeforeHead()).message("singular they"), NodePattern.N.inFormSequence(1, ".+\\{.+", "}").and(CommonPatterns.touchHierarchy).message("mislexed braces"), NodePattern.N.withHead("nummod", NodePattern.N).andOr(NodePattern.N.form("\\p{L}+\\d+\\p{L}+"), CommonPatterns.punctForm).message("non-number nummod"), NodePattern.N.form("\"").noSpaceBefore().spaceAfter().andOr(NodePattern.not(CommonPatterns.firstToken).withHead(NodePattern.N).andNot(NodePattern.N.withPrevSiblingIncludingOtherSide(NodePattern.N)).message("Quotation phrase-start"), NodePattern.N.inPhrase(EnglishTreePatterns.clause.markAs("Clause1")).and(NodePattern.markedNodeMatches("Clause1", NodePattern.N.withHeadRelation("parataxis"))).directlyBefore(NodePattern.N.inPhrase(EnglishTreePatterns.clause.withHeadRelation("parataxis").withPrevSibling(NodePattern.N.alreadyMarkedAs("Clause1")))).message("quote-separated parataxis clauses")), CommonPatterns.noSpaceHyphen.directlyAfter(NodePattern.N.withHeadRelation("obj")).directlyBefore(NodePattern.N.withHeadRelation("nsubj")).message("obj hyphen subj"), NodePattern.N.form("aged").pos("VBD").directlyBefore(NodePattern.N.pos("CD")).message("Past tense verb instead of participle"), NodePattern.N.form("\\$").noSpaceAfter().directlyBefore(CommonPatterns.letterWord).message("Word after $ is a placeholder"), NodePattern.N.inFormSequence(0, "commit", "messages?|texts?").pos("V.*").message("wrong POS and likely Head relation for 'commit'"), NodePattern.N.form("much|many").withHead("amod", NodePattern.N.pos("NNP")).message("'many'/'much' cannot modify a singular proper noun"), NodePattern.N.form("to").withHead("mark", NodePattern.ROOT).directlyAfter(NodePattern.N.withHeadRelation("acl:relcl")).directlyBefore(NodePattern.N.pos("V.*")).message("incorrect syntactic tagging of a dangling preposition inside a relative clause"), NodePattern.N.inFormSequence(0, "cross", "-", ".*").withHeadRelation("compound").noSpaceAfter().message("a prefix parsed as compound"), NodePattern.N.inFormSequence(2, "verb|noun|adjective|pronoun", "number", "form").pos("V.*").message("noun 'form' parsed as verb in a set expression"), NodePattern.N.inFormSequence(0, "advocate", "leads?").noHeadRelation("compound|nsubj").message("advocate leads"), NodePattern.N.inFormSequence(2, "ctrl|control|shift|alt|option|meta|command", "-", "a").withHeadRelation("det").noSpaceBefore().message("misparsed shortcut")};
    static final CrazyParseDetector INSTANCE = new CrazyParseDetector(Language.ENGLISH, crazyParse);

    EnglishCrazyParseDetector() {
    }
}

