/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.phonetics.metaphone.DoubleMetaphone;
import ai.grazie.rules.HunspellFacade;
import ai.grazie.spell.lists.hunspell.HunspellWordList;
import ai.grazie.spell.suggestion.ranker.JaroWinklerSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.LinearAggregatingSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.PhoneticSuggestionRanker;
import ai.grazie.spell.suggestion.ranker.SuggestionRanker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EnglishHunspell {
    private static final HunspellWordList HUNSPELL = HunspellFacade.loadHunspellWordList(Language.ENGLISH);
    private static final SuggestionRanker RANKER = new LinearAggregatingSuggestionRanker(Map.of(new JaroWinklerSuggestionRanker(), 0.43, new PhoneticSuggestionRanker(new DoubleMetaphone()), 0.11));

    public static boolean isEnglishWord(String word, boolean caseSensitive) {
        return HUNSPELL.contains(word, caseSensitive);
    }

    static List<String> getSpellerSuggestions(String word) {
        return new ArrayList<String>(RANKER.rank(word, HUNSPELL.suggest(word)));
    }
}

