/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.Quotes;
import ai.grazie.rules.en.EnglishCrazyParseDetector;
import ai.grazie.rules.en.EnglishHunspell;
import ai.grazie.rules.en.EnglishTreeDisambiguator;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.VariantDifferences;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.LTTagger;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tagger;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.util.List;
import java.util.Locale;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNullByDefault;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.language.English;
import org.languagetool.tagging.disambiguation.rules.XmlRuleDisambiguator;

@NotNullByDefault
public class EnglishTreeSupport
extends TreeSupport {
    protected static final String JVM_EN_CLOUD_MODEL_NAME = "gml-supar-ewt-bert-aug-v3";
    private static final NodePattern opParenthQuote = NodePattern.N.form(".*\\([\"\u201c\u201d].*");
    private static final NodePattern quoteClParenth = NodePattern.N.form(".*[\"\u201c\u201d]\\).*");

    public EnglishTreeSupport(English english) {
        super((Language)english);
    }

    @Override
    public String getCloudTreeModelName() {
        return JVM_EN_CLOUD_MODEL_NAME;
    }

    @Override
    public List<String> getCloudParserOptions() {
        return JVM_CLOUD_PARSER_OPTIONS;
    }

    @Override
    public boolean needsNer() {
        return true;
    }

    @Override
    protected Tagger createTagger() {
        return EnglishTreeSupport.createTagger(this.language());
    }

    static LTTagger createTagger(Language language) {
        return new LTTagger(language, () -> new XmlRuleDisambiguator(language, true)){

            @Override
            public List<Tree.Reading> toReadings(AnalyzedTokenReadings token) {
                return super.toReadings(token).stream().map(t -> new Tree.Reading(EnglishTreeSupport.fixPOS(t.pos()), t.lemma())).filter(r -> !EnglishTreeSupport.shouldRemoveReading(r, token.getToken())).distinct().toList();
            }
        };
    }

    @Override
    public Tree buildTree(String text2, List<SentenceWithTreeDependencies.Node> conllu) {
        return new EnglishTreeDisambiguator(super.buildTree(text2, conllu)).disambiguateByTree();
    }

    @Override
    public CrazyParseDetector crazyParseDetector() {
        return EnglishCrazyParseDetector.INSTANCE;
    }

    @Override
    public String quote(String text2) {
        return "'" + text2 + "'";
    }

    @Override
    protected boolean shouldPreserveCase(TextChange.Replacement change, Tree tree, String prevText) {
        String firstWord = EnglishTreeSupport.getFirstWord(prevText);
        return super.shouldPreserveCase(change, tree, prevText) && this.isAcceptedBySpellchecker(firstWord.toLowerCase(Locale.ROOT));
    }

    static String getFirstWord(String text2) {
        int dash;
        String firstWord = text2;
        int space = firstWord.indexOf(32);
        if (space > 0) {
            firstWord = firstWord.substring(0, space);
        }
        if ((dash = firstWord.indexOf(45)) > 0) {
            firstWord = firstWord.substring(0, dash);
        }
        return firstWord;
    }

    @Override
    public boolean isTrulyLowerCase(Node node) {
        return !Semantics.needsCapitalization.matches(node);
    }

    @Override
    public List<String> inflectNode(Node node, String posRegex, String posReplacement) {
        List<String> result2 = super.inflectNode(node, posRegex, posReplacement);
        Tree tree = node.tree();
        if (!result2.isEmpty()) {
            return VariantDifferences.removeVariantIncompatibleSuggestions(result2, tree);
        }
        return result2;
    }

    @Override
    public List<String> synthesize(String form, String lemma, String srcPos, String targetPos) {
        if (srcPos.equals("NNS") && targetPos.equals("NN") && this.tagToken(lemma).hasPos("NN")) {
            return List.of(lemma);
        }
        if (lemma.equals("instal") && form.toLowerCase(Locale.ROOT).contains("install")) {
            return List.of();
        }
        List<String> list = super.synthesize(form, lemma, srcPos, targetPos);
        if (lemma.equals("leave")) {
            list.remove("leaved");
        }
        if (lemma.equals("bus")) {
            list.remove("busses");
        }
        if (lemma.equals("diploma")) {
            list.remove("diplomata");
        }
        if (lemma.equals("pay")) {
            list.remove("payed");
        }
        if (lemma.equals("money")) {
            list.removeAll(List.of("monies", "moneys"));
        }
        if (lemma.equals("focus") && !form.startsWith("focuss")) {
            list.removeIf(s -> s.startsWith("focuss"));
        }
        list.remove("youngers");
        return list.stream().filter(this::isAcceptedBySpellchecker).toList();
    }

    private static boolean shouldRemoveReading(Tree.Reading reading, String form) {
        if ("prex".equals(reading.lemma())) {
            return !form.equalsIgnoreCase("prex");
        }
        if ("test".equalsIgnoreCase(form) && reading.hasPos("JJ")) {
            return true;
        }
        return "optimise".equalsIgnoreCase(form) && reading.hasPos("NN");
    }

    @Nullable
    private static String fixPOS(@Nullable String pos) {
        return pos != null && pos.startsWith("NN:") ? "NN" : pos;
    }

    @Override
    public Quotes getAllQuotes() {
        return EnglishTreePatterns.quotes;
    }

    @Override
    public boolean isInsideQuotes(Node node) {
        boolean hasOpeningApos = false;
        for (Node each : (StreamEx)node.back().skip(1L)) {
            if (EnglishTreePatterns.onlyQuotes.matches(each)) {
                if (!EnglishTreePatterns.quotes.canBeOpeningQuote(each.form()) || !Quotes.openingPosition.matches(each)) break;
                return true;
            }
            if (EnglishTreePatterns.onlyApos.matches(each)) {
                if (!each.form().equals("'") && !each.form().equals("\u2018") && !each.form().equals("`") || !Quotes.openingPosition.matches(each)) break;
                hasOpeningApos = true;
                break;
            }
            if (EnglishTreePatterns.withOnlyQuote.matches(each) && !quoteClParenth.matches(each)) {
                return true;
            }
            if (!quoteClParenth.matches(each)) continue;
            break;
        }
        for (Node each : (StreamEx)node.forward().skip(1L)) {
            if (EnglishTreePatterns.onlyQuotes.matches(each)) {
                if (!EnglishTreePatterns.quotes.canBeClosingQuote(each.form()) || !Quotes.closingPosition.matches(each)) break;
                return true;
            }
            if (hasOpeningApos && (each.form().equals("'") || each.form().equals("\u2019") || each.form().equals("`")) && Quotes.closingPosition.matches(each)) {
                return true;
            }
            if (EnglishTreePatterns.withOnlyQuote.matches(each) && !opParenthQuote.matches(each)) {
                return true;
            }
            if (!opParenthQuote.matches(each)) continue;
            break;
        }
        return false;
    }

    @Override
    public boolean isAcceptedBySpellchecker(String word) {
        return EnglishHunspell.isEnglishWord(word, true);
    }

    @Override
    public List<String> similarWords(String form) {
        return EnglishHunspell.getSpellerSuggestions(form);
    }
}

