/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SemiModal;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

enum Number {
    singular,
    plural,
    ambiguous;

    private static final NodePattern potentiallyPluralAdj;
    static final NodePattern theAdjCoordination;
    private static final NodePattern mightBeCopulaEllipsis;
    static final NodePattern one1;
    static final NodePattern withOneOfNummod;
    static final NodePattern pluralDeterminers;
    static final NodePattern moreLess;
    static final NodePattern withOfNmod;
    static final NodePattern perCent;
    static final NodePattern anyPercent;
    static final NodePattern numberDelegatingHead;
    private static final NodePattern xTimeWorthOf;
    private static final NodePattern meanS;
    static final NodePattern mistypedClauseNegation;
    private static final NodePattern toClause;
    private static final NodePattern infinitiveExpected;
    private static final NodePattern singularVerb;
    private static final NodePattern ambiguousVerb;
    private static final NodePattern nonVerb;
    private static final NodePattern ambiguousSubjectWithNumerals;
    private static final NodePattern capitalizedWord;
    static final NodePattern withEtAl;
    static final NodePattern misparsedVsCompound;
    private static final NodePattern ambiguousNoun;
    private static final NodePattern singularNoun;
    private static final NodePattern pluralNoun;
    private static final NodePattern hasPluralPos;
    private static final NodePattern hasSingularPos;

    boolean conflictsWith(@Nullable Number that) {
        return this == singular && that == plural || this == plural && that == singular;
    }

    @NotNull
    static Number verbNumber(Node verb) {
        if (nonVerb.matches(verb)) {
            return ambiguous;
        }
        if (singularVerb.matches(verb)) {
            return singular;
        }
        if (ambiguousVerb.matches(verb)) {
            return ambiguous;
        }
        return plural;
    }

    @Nullable
    static Number specifierNumber(Node spec) {
        if (pluralDeterminers.matches(spec)) {
            return plural;
        }
        if (spec.hasLemma("this|that")) {
            return singular;
        }
        return null;
    }

    @NotNull
    static Number npNumberGroupAware(Node noun) {
        boolean delegating = numberDelegatingHead.matches(noun);
        boolean possibly = Semantics.possiblyNumberDelegatingGroup.matches(noun);
        if (delegating || possibly) {
            Node nmod = Number.findOfNmod(noun);
            if (nmod == null || delegating && noun.hasDependent("amod")) {
                return ambiguous;
            }
            if (nmod.hasForm("us|them|you")) {
                return delegating ? plural : ambiguous;
            }
            if (potentiallyPluralAdj.matches(nmod)) {
                return ambiguous;
            }
            Number fromDelegate = Number.nounNumber(nmod);
            if (fromDelegate == singular && possibly) {
                return singular;
            }
            return delegating ? fromDelegate : ambiguous;
        }
        return Number.npNumberWithNumerals(noun);
    }

    @Nullable
    static Node findOfNmod(Node noun) {
        NodeMatch match = withOfNmod.match(noun);
        return match == null ? null : match.getMarkedNode("Nmod");
    }

    static Number npNumberWithNumerals(Node noun) {
        if (withOneOfNummod.matches(noun)) {
            return singular;
        }
        for (Node dependent : noun.findDependents("nummod|amod")) {
            if (!dependent.hasLemma("dozen|hundred|thousand|million|billion|(ga)?zillion")) continue;
            return Number.nounNumber(dependent);
        }
        if (ambiguousSubjectWithNumerals.matches(noun) || xTimeWorthOf.matches(noun)) {
            return ambiguous;
        }
        Number bare = Number.nounNumber(noun);
        if (noun.hasDependent("nummod") && bare != plural) {
            return ambiguous;
        }
        return bare;
    }

    @NotNull
    static Number nounNumber(Node noun) {
        boolean hasSingular;
        Number asSpecifier = Number.specifierNumber(noun);
        if (asSpecifier != null && !noun.hasForm("fewer")) {
            return asSpecifier;
        }
        if (Semantics.people.matches(noun)) {
            return Semantics.ambiguousPeople.matches(noun) ? ambiguous : plural;
        }
        if (singularNoun.matches(noun)) {
            return singular;
        }
        if (ambiguousNoun.matches(noun)) {
            return ambiguous;
        }
        if (pluralNoun.matches(noun)) {
            return plural;
        }
        boolean hasPlural = hasPluralPos.matches(noun);
        return hasPlural == (hasSingular = hasSingularPos.matches(noun)) ? ambiguous : (hasPlural ? plural : singular);
    }

    static {
        potentiallyPluralAdj = NodePattern.or(NodePattern.N.pos("JJ.*|VBN"), NodePattern.N.withDependent("advmod", NodePattern.N.pos("JJS")).potentialPos("JJ.*")).and(CommonPatterns.possiblySkipDown("advmod", NodePattern.N.withDependent("det", NodePattern.N.form("the")))).noDependents("amod", NodePattern.N.noPos("ORD"));
        theAdjCoordination = potentiallyPluralAdj.noPos("NN.*").withDependent("conj", NodePattern.N.pos("JJ.*"));
        mightBeCopulaEllipsis = NodePattern.N.potentialPos("JJ.*").withHeadRelation("acl|advcl").noDependents("i?obj").noDependents("cop|aux|aux:pass");
        one1 = NodePattern.N.form("one|1");
        withOneOfNummod = NodePattern.N.withDependent("nummod", one1.directlyBefore(NodePattern.or(NodePattern.N.form("of|in"), NodePattern.N.inFormSequence(0, "out", "of"))));
        pluralDeterminers = NodePattern.N.form("both|these|those|many|few(er)?|several").andNot(NodePattern.N.withDependent("mark", NodePattern.N.pos("WRB")).withDependent("acl:relcl"));
        moreLess = NodePattern.N.lemma("more|less");
        withOfNmod = NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("of")).markAs("Nmod"));
        perCent = NodePattern.N.inFormSequence(1, "per", "cents?");
        anyPercent = NodePattern.or(NodePattern.N.form("%|percents?"), perCent);
        numberDelegatingHead = NodePattern.or(Semantics.numberDelegatingGroup.and(withOfNmod), anyPercent.and(CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("nummod"))).and(withOfNmod).andNot(NodePattern.markedNodeMatches("Nmod", Semantics.possiblyUncountableForm)));
        xTimeWorthOf = NodePattern.N.form("hours|days|weeks|months|years").markAs("TimeNoun").withDependent("amod", NodePattern.N.form("worth")).withDependent("amod|nummod", NodePattern.N.before("TimeNoun"));
        meanS = NodePattern.N.inFormSequence(0, "mean", EnglishTreePatterns.apostropheS.getFormRegex());
        mistypedClauseNegation = NodePattern.N.form("not").directlyAfter(NodePattern.N.noPos());
        toClause = NodePattern.N.withDependent("mark", NodePattern.N.form("to").markAs("Mark")).noDependents("cop", NodePattern.N.before("Mark"));
        infinitiveExpected = NodePattern.or(CommonPatterns.skipUp("aux:pass", NodePattern.N.markAs("Comp").withHead("[cx]comp|parataxis", NodePattern.or(NodePattern.N.pos("JJ").withDependent("cop").withDependent("nsubj|expl", NodePattern.N.form("it")), CommonPatterns.possiblySkipDown("conj", NodePattern.or(NodePattern.N.lemmaCaseSensitive("watch|see|hear|feel|make|help|[lL]et|notice"), NodePattern.N.lemma("have").noDependents("obj")).before("Comp")))).noDependents("mark", NodePattern.N.lemma("whether"))).potentialPos("VB"), NodePattern.N.withHeadRelation("csubj(:pass)?"), CommonPatterns.possiblySkipUp("cop|aux|aux:pass", toClause), NodePattern.N.withDependent("advmod", mistypedClauseNegation), NodePattern.N.inFormSequence(0, "need", "not"));
        singularVerb = NodePattern.or(NodePattern.N.pos("VBZ").noPos("VB[PD]?"), EnglishTreePatterns.duplicateVerbParsedAsSubj.potentialPos("VBZ").noPotentialPos("VB[PD]?"), NodePattern.N.form("[a'\u2019`\u2018]m|was"), meanS).andNot(toClause);
        ambiguousVerb = NodePattern.or(EnglishTreePatterns.imperativePossible, mightBeCopulaEllipsis, infinitiveExpected, EnglishTreePatterns.subjunctivePossible, SemiModal.possiblyModalNeed, NodePattern.N.withHead("xcomp|ccomp", Questions.semiModalRootQuestion), NodePattern.N.pos("VBP?").directlyBefore(NodePattern.N.inFormSequence(0, "\\(", "s").noSpaceAround()), NodePattern.N.form("be|will|can"), NodePattern.N.pos("VBD").noForm("were"), NodePattern.N.pos("VBZ").pos("VB[PD]?"), NodePattern.N.noPos("VB[ZPD]?"));
        nonVerb = NodePattern.N.form("true");
        ambiguousSubjectWithNumerals = NodePattern.or(NodePattern.N.withDependent("nummod"), NodePattern.N.withDependent("amod", NodePattern.N.lemma("many|much|little|few"))).withHead("nsubj(:pass)?", NodePattern.or(NodePattern.or(NodePattern.N.lemma("mean|seem|imply|appear|define|regard|consider|look|sound"), NodePattern.N.lemma("feel").noDependents("ccomp")).andOr(NodePattern.N.pos("VB[ZD]").noDependents("cop|aux|aux:pass"), NodePattern.N.withDependent("aux", NodePattern.N.lemma("do").pos("VB[ZD]"))), NodePattern.N.withDependent("cop", NodePattern.N.form(".+s")).noDependents("expl|case").andNot(EnglishTreePatterns.tHere)));
        capitalizedWord = NodePattern.N.formCaseSensitive("\\p{Lu}(\\p{Ll}|[^\\p{L}])*");
        withEtAl = NodePattern.or(NodePattern.N.withDependent("flat", EnglishTreePatterns.etAl), NodePattern.N.withDependent("conj", NodePattern.N.directlyAfter(EnglishTreePatterns.etAl)));
        misparsedVsCompound = NodePattern.N.withHeadRelation("nmod").withDependent("case", NodePattern.N.form("vs")).withDependent("compound");
        ambiguousNoun = NodePattern.or(NodePattern.N.withDependent(".*", misparsedVsCompound), Semantics.adjectivesPossiblyDenotingGroups, EnglishTreePatterns.wordSlashWord, anyPercent, withEtAl, NodePattern.N.form("islands|emirates").and(Articles.geoRequiringThe), potentiallyPluralAdj, NodePattern.N.form("tons|no|all|half|any|some"), NodePattern.N.formCaseSensitive("hooks").directlyAfter(NodePattern.N.formCaseSensitive("bell")), Semantics.loneALot, NodePattern.N.formCaseSensitive("Coroutines"), NodePattern.N.pos("NNS").andOr(Semantics.possiblySingularNNS, capitalizedWord.directlyAfter(NodePattern.N.markAs("Prev")).andOr(NodePattern.markedNodeMatches("Prev", NodePattern.N.directlyBeforeHead().and(capitalizedWord)), NodePattern.N.form(".*s").andNot(CommonPatterns.firstWord)), NodePattern.N.label("ORGANIZATION|PRODUCT")), NodePattern.N.pos("CD|PRP\\$"), EnglishTreePatterns.abbreviation, NodePattern.N.pos("NN").and(Semantics.possiblePluralNN), NodePattern.N.pos("NNP").andNot(Semantics.reallySingularProperName), NodePattern.N.withDependent("acl:relcl", NodePattern.N.withDependent("advcl", EnglishTreePatterns.misparsedPassiveAcl)));
        singularNoun = NodePattern.or(NodePattern.N.form("less|Yukos|one|(him|her|it|my|your)self"), NodePattern.or(NodePattern.N.inFormSequence(1, "United", "States"), NodePattern.N.formCaseSensitive("U\\.?S"), NodePattern.N.form("Netherlands|Philippines")).andNot(NodePattern.N.withHead(NodePattern.N.pos("NNS"))));
        pluralNoun = NodePattern.or(NodePattern.N.formCaseSensitive("\\p{Lu}+(Ses|s)|[a-z]+ists").andNot(NodePattern.N.inFormSequence(0, "ms", "\\.")), NodePattern.N.form("(y?our|them)selves"));
        hasPluralPos = NodePattern.N.pos("NNP?S");
        hasSingularPos = NodePattern.N.pos("NNP?|DT");
    }
}

