/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.DateChecker;
import ai.grazie.rules.en.EnglishDateChecker;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpellingOutNumbers {
    private static final String SPELL_OUT_NUMBER_MSG = "Consider spelling out the number";
    private static final String SPELL_OUT_START_SMALL_NUMBER = "Consider spelling out the number at the beginning of the sentence";
    private static final String SPELL_OUT_START_LARGE_NUMBER = "Consider rewording the sentence or spelling out the number";
    private static final String SPELL_OUT_LARGE_ROUND_NUMBER_MSG = "Consider using words for large round numbers for better readability";
    private static final String SPELL_OUT_RUN_ON_NUMBERS_MSG = "Writing one of the two numbers in words can enhance readability";
    private static final String[] singleWordSmallNumbers = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
    private static final String[] tens = new String[]{"twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    private static final String[] singleWordSmallOrdinalNumbers = new String[]{"zeroth", "first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth"};
    private static final String[] tensOrdinal = new String[]{"twentieth", "thirtieth", "fortieth", "fiftieth", "sixtieth", "seventieth", "eightieth", "ninetieth"};
    private static final Map<Long, String> largeRoundNumbers = Map.of(1000L, " thousand", 1000000L, " million", 1000000000L, " billion");
    static final String ordinalEnding = "(st|nd|rd|th)";
    private static final NodePattern uomOrAbbr = NodePattern.N.form("(foot|inch|mile|ounce|pound|degree|gallon)|(kilo|deci|centi|milli|nano)?(meter|metre|liter|litre|gram(me)?|hertz|watt)|(mega|giga)?(tonne|pixel|hertz|watt)|((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])");
    private static final NodePattern month = EnglishDateChecker.INSTANCE.month;
    private static final NodePattern decimalNumber = NodePattern.N.form("\\d*[.,]\\d+");
    private static final NodePattern twoDigitNumber = NodePattern.N.form("\\d{2}");
    private static final NodePattern threePlusDigitNumber = NodePattern.N.form("\\d{3,}").andNot(DateChecker.year);
    private static final NodePattern numberTooBigToSpellOut = NodePattern.or(EnglishParameters.SPELL_OUT_NUMERALS.withValue("single\\+double\\+large").andOr(decimalNumber, threePlusDigitNumber), EnglishParameters.SPELL_OUT_NUMERALS.withValue("|single(\\+large)?").andOr(decimalNumber, twoDigitNumber, threePlusDigitNumber));
    private static final NodePattern followedByNumberInParentheses = NodePattern.N.withHeadRelation("nummod").andNot(CommonPatterns.inParentheses).andOr(NodePattern.N.withNextSibling(CommonPatterns.inParentheses.withHeadRelation("nummod")), NodePattern.N.withDependent("appos", CommonPatterns.inParentheses));
    private static final NodePattern prohibitedInSentence = CommonPatterns.withNumberLikeForm.andOr(NodePattern.N.directlyBefore(NodePattern.or(uomOrAbbr, NodePattern.N.form("="))), NodePattern.N.directlyAfter(NodePattern.N.form("[=+^]")));
    private static final NodePattern measurements = NodePattern.or(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.lemma("baht|dollar|euro|pound|ruble|ether|bitcoin|(foot|inch|mile|ounce|pound|degree|gallon)|(kilo|deci|centi|milli|nano)?(meter|metre|liter|litre|gram(me)?|hertz|watt)|(mega|giga)?(tonne|pixel|hertz|watt)")), Semantics.timeUnits, Semantics.progressUnit, NodePattern.N.form("[$\u00a3\u20ac\u00a5\u20bd]|RUB|EUR|USD|GBP|BTC|ETH"), NodePattern.N.lemma("age|percentage|per|point"), Number.anyPercent, NodePattern.N.formCaseSensitive("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])").directlyAfter("Number"), NodePattern.N.form("pm|am|a\\.m\\.?|p\\.m\\.?|o['\u2019`\u2018]clock"));

    SpellingOutNumbers() {
    }

    static List<Rule.PatternRule> rules() {
        return List.of(new Rule.PatternRule("Style.SPELLING_OUT_NUMBERS_SENT_START", "Spell out numbers that start a sentence", "Using words instead of numbers to start a sentence improves readability and clarity.", "https://topcontent.com/for-writers/blog/can-you-start-a-sentence-with-a-number/", SpellingOutNumbers.spellingOutNumbersSentStart(), new Example("<b>7 </b>puppies played with three tennis balls at the dog park.", SPELL_OUT_START_SMALL_NUMBER, "<b>Seven</b> puppies played with three tennis balls at the dog park."), new Example("<b>90</b> people waited at the airport.", SPELL_OUT_START_SMALL_NUMBER, "<b>Ninety</b> people waited at the airport."), new Example("<b>250</b> babies are born every minute.", SPELL_OUT_START_LARGE_NUMBER, "<b>Two hundred fifty</b> babies are born every minute.")).honorCrazyParses(), new Rule.PatternRule("Style.SPELLING_OUT_NUMBERS", EnglishParameters.SPELL_OUT_NUMERALS.displayName(), "In formal and professional writing, numbers from zero to nine are usually spelled out in words.\nNumbers 10 and above are generally written in numerals.\n", "https://www.niu.edu/writingtutorial/grammar/use-of-numbers.shtml", NodePattern.or(SpellingOutNumbers.spellingOutNumbers(), SpellingOutNumbers.spellingOutOrdinalNumbers(), SpellingOutNumbers.spellingOutRunOnNumbers()), new Example("In <b>4 </b>languages; <b>4th</b> floor; with 4 hundred books (0\u20139 excluding large numerals)", List.of(SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG), List.of("In <b>four</b> languages; <b>fourth</b> floor; with 4 hundred books (0\u20139 excluding large numerals)"), Map.of(EnglishParameters.SPELL_OUT_NUMERALS, "single")), new Example("In <b>4 </b>languages; <b>4th</b> floor; with <b>4 </b>hundred books (0\u20139 including large numerals)", List.of(SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG), List.of("In <b>four</b> languages; <b>fourth</b> floor; with <b>four</b> hundred books (0\u20139 including large numerals)"), Map.of(EnglishParameters.SPELL_OUT_NUMERALS, "single+large")), new Example("In <b>4 </b>languages; with <b>4 </b>hundred books; <b>4th</b> floor; in <b>14</b> countries; <b>14th</b> century; for <b>40</b> thousand people (0\u201399 including large numerals)", List.of(SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG, SPELL_OUT_NUMBER_MSG), List.of("In <b>four</b> languages; with <b>four</b> hundred books; <b>fourth</b> floor; in <b>fourteen</b> countries; <b>fourteenth</b> century; for <b>forty</b> thousand people (0\u201399 including large numerals)"), Map.of(EnglishParameters.SPELL_OUT_NUMERALS, "single+double+large"))).honorCrazyParses(), new Rule.PatternRule("Style.SPELLING_OUT_LARGE_NUMBERS", "Spell out large round numbers", "With large round numerals, use words instead of numbers to enhance readability. For large mixed numerals (such as '5,500,000'), use a number-plus-word combination.", "https://engrcomm.che.utexas.edu/faq/what-are-the-rules-for-writing-numbers/", SpellingOutNumbers.spellingOutRoundNumbers(), new Example("It was based on a survey of <b>250,000</b> adults.", SPELL_OUT_LARGE_ROUND_NUMBER_MSG, "It was based on a survey of <b>250 thousand</b> adults."), new Example("He inherited <b>2,000,000</b> dollars.", SPELL_OUT_LARGE_ROUND_NUMBER_MSG, "He inherited <b>two million</b> dollars."), new Example("We now have more than <b>5,500,000</b> users worldwide.", SPELL_OUT_LARGE_ROUND_NUMBER_MSG, "We now have more than <b>5.5 million</b> users worldwide.")));
    }

    @Nullable
    private static String spellOutOrdinalBelowHundred(int number) {
        if (number < 0) {
            return null;
        }
        if (number < 20) {
            return singleWordSmallOrdinalNumbers[number];
        }
        if (number < 100) {
            int last = number % 10;
            String first = tens[number / 10 - 2];
            return last == 0 ? tensOrdinal[number / 10 - 2] : first + "-" + singleWordSmallOrdinalNumbers[last];
        }
        return null;
    }

    @Nullable
    private static String spellOutBelowHundred(int number) {
        if (number < 0) {
            return null;
        }
        if (number < 20) {
            return singleWordSmallNumbers[number];
        }
        if (number < 100) {
            String first = tens[number / 10 - 2];
            int last = number % 10;
            return last == 0 ? first : first + "-" + singleWordSmallNumbers[last];
        }
        return null;
    }

    @Nullable
    private static String spellOutBelowThousand(int number) {
        int last = number % 100;
        int hundreds = number / 100;
        if (number >= 1000) {
            hundreds %= 10;
        }
        if (hundreds == 0 && last == 0) {
            return "";
        }
        String hundredsSpelledOut = singleWordSmallNumbers[hundreds] + " hundred";
        return hundreds == 0 ? SpellingOutNumbers.spellOutBelowHundred(last) : (last == 0 ? hundredsSpelledOut : hundredsSpelledOut + " " + SpellingOutNumbers.spellOutBelowHundred(last));
    }

    @Nullable
    private static String spellOut(int number) {
        if (number < 100) {
            return SpellingOutNumbers.spellOutBelowHundred(number);
        }
        if (number < 1000) {
            return SpellingOutNumbers.spellOutBelowThousand(number);
        }
        if (number < 100000) {
            int thousands = number / 1000;
            return SpellingOutNumbers.spellOutBelowHundred(thousands) + " thousand " + SpellingOutNumbers.spellOutBelowThousand(number);
        }
        return null;
    }

    private static String mixedNumeral(long number, long base, String baseWord) {
        if (number % (base / 10L) == 0L) {
            double decimal = (double)number / (double)base;
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            return new DecimalFormat("#.#", symbols).format(decimal) + baseWord;
        }
        return null;
    }

    private static String largeRoundNumberToWord(long number, long base, String spellOutParameter) {
        boolean spellOutDouble = spellOutParameter.matches("single\\+double\\+large");
        boolean spellOutSingle = spellOutParameter.matches("|single\\+large");
        String baseWord = largeRoundNumbers.get(base);
        long units = number / base;
        if (number % base == 0L) {
            if (number < base * 10L && (spellOutDouble || spellOutSingle)) {
                return singleWordSmallNumbers[(int)units] + baseWord;
            }
            if (number < base * 100L && spellOutDouble) {
                return SpellingOutNumbers.spellOutBelowHundred((int)units) + baseWord;
            }
            return units + baseWord;
        }
        return SpellingOutNumbers.mixedNumeral(number, base, baseWord);
    }

    @Nullable
    private static String largeRoundNumbers(long number, String spellOutParameter) {
        if (number < 1000000L) {
            return SpellingOutNumbers.largeRoundNumberToWord(number, 1000L, spellOutParameter);
        }
        if (number < 1000000000L) {
            return SpellingOutNumbers.largeRoundNumberToWord(number, 1000000L, spellOutParameter);
        }
        if (number < 1000000000000L) {
            return SpellingOutNumbers.largeRoundNumberToWord(number, 1000000000L, spellOutParameter);
        }
        return null;
    }

    private static NodePattern spellOutOrdinalNumber() {
        return NodePattern.custom((node, match) -> {
            String number = node.form().replaceAll(ordinalEnding, "");
            try {
                String spelled = SpellingOutNumbers.spellOutOrdinalBelowHundred(Integer.parseInt(number));
                return spelled == null ? null : match.withCorrector(NodeCorrector.replace(node, spelled).batchCapable("SpellOutOrdinalNumber"));
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    private static NodePattern spellOutNumber(@Nullable String batchId) {
        return NodePattern.custom((node, match) -> {
            try {
                String spelled = SpellingOutNumbers.spellOut(Integer.parseInt(node.form()));
                return spelled == null ? null : match.withCorrector(batchId == null ? NodeCorrector.replace(node, spelled) : NodeCorrector.replace(node, spelled).batchCapable(batchId));
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    private static NodePattern spellOutRoundNumber(@NotNull String batchId) {
        return NodePattern.custom((node, match) -> {
            String spellOutParameter = EnglishParameters.SPELL_OUT_NUMERALS.getValue(node.tree());
            String numberForm = node.form().replaceAll(",", "");
            try {
                long number = Long.parseLong(numberForm);
                if (100000L <= number && number < 1000000000000L && number % 100L == 0L) {
                    String spelled = SpellingOutNumbers.largeRoundNumbers(number, spellOutParameter);
                    if (spelled == null) {
                        return null;
                    }
                    if (spelled.startsWith("one ")) {
                        return match.withCorrector(NodeCorrector.replace(node, List.of(spelled, "a " + spelled.substring(4))));
                    }
                    return match.withCorrector(NodeCorrector.replace(node, spelled).batchCapable(batchId));
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        });
    }

    private static NodePattern spellingOutNumbersSentStart() {
        String batchId = "SpellOutSentenceStartNumber";
        return NodePattern.or(NodePattern.N.form("[1-9]").and(SpellingOutNumbers.spellOutNumber(batchId)).and(CommonPatterns.highlightPlusOneChar).message(SPELL_OUT_START_SMALL_NUMBER), NodePattern.N.form("[1-9]\\d").and(SpellingOutNumbers.spellOutNumber(batchId)).message(SPELL_OUT_START_SMALL_NUMBER), NodePattern.N.form("[1-9]\\d+").and(SpellingOutNumbers.spellOutNumber(batchId)).message(SPELL_OUT_START_LARGE_NUMBER)).and(CommonPatterns.firstToken).spaceAfter().andNot(NodePattern.or(NodePattern.N.withHead(Semantics.actionWithNumbers), NodePattern.N.withDependent("acl.*", Semantics.actionWithNumbers))).noDependents("nmod", CommonPatterns.possiblySkipDown("nummod", CommonPatterns.withNumberLikeForm)).andNot(NodePattern.N.withHead(month)).andNot(NodePattern.N.directlyBefore(NodePattern.or(EnglishTreePatterns.anyPunct, CommonPatterns.capitalizedMiddle, NodePattern.N.form("((da|[QRYZEPTGMkhdcm\u03bcnf])?(s|m|g|A|K|mol|cd|rad|sr|Hz|N|Pa|J|W|V|F|\u03a9|S|Wb|T|lm|lx|Bq|Sv|kat|L|l|M)|MMBtu|lux|rad|grad|pt|mp[gh]|[ndkmgt](b|hz)|ms|px|[kdcm]m|[kmhc]g|[md]l|b?hp|cc|lb|ft|hr|min|sec|[symw]|[rf]p[smhdy])|pm|am|a\\.m\\.?|p\\.m\\.?|o['\u2019`\u2018]clock")))).andNot(DateChecker.year.andOr(NodePattern.N.withHead(NodePattern.N.noPos("NNS")), NodePattern.N.withDependent(".*"))).andNot(CommonPatterns.inAllCapitalizedSentence).andNot(prohibitedInSentence).andNot(NodePattern.N.inSentenceWith(prohibitedInSentence));
    }

    private static NodePattern spellingOutNumbers() {
        NodePattern withNumberTooBigToSpellOut = NodePattern.N.withDependent("nummod|compound|nmod|obl|conj|xcomp", numberTooBigToSpellOut);
        NodePattern enumeratedNoun = NodePattern.or(NodePattern.N.withHeadRelation("goeswith"), NodePattern.N.withDependent("goeswith", CommonPatterns.capitalized), NodePattern.N.lemma("act|action|activity|operation|plan|reaction|response|deed|move|article|version|instance|number"), NodePattern.N.inFormSequence(1, "no", "\\."), NodePattern.N.withDependent("nummod", NodePattern.N.directlyAfterHead()), NodePattern.N.onlyPos("NNP?").noPotentialPos("IN"), NodePattern.N.label(".*"), EnglishTreePatterns.typeSynonyms, CommonPatterns.capitalizedMiddle, EnglishTreePatterns.verbAsCompoundToleratingHead);
        NodePattern biggerNumbersNearby = NodePattern.or(NodePattern.N.inPhrase(NodePattern.or(withNumberTooBigToSpellOut.markAs("NumberHead"), NodePattern.N.withHeadRelation("parataxis").withDependent("conj|obl", withNumberTooBigToSpellOut.markAs("NumberHead")), NodePattern.N.withDependent("conj", CommonPatterns.possiblySkipDown("nummod|compound|obl", withNumberTooBigToSpellOut.markAs("NumberHead").noDependents("nummod", NodePattern.N.afterHead()))).noDependents("[xc]comp"), NodePattern.N.withHead("conj", CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|nummod", CommonPatterns.possiblySkipDown(".*", numberTooBigToSpellOut).markAs("NumberHead"))), NodePattern.N.withDependent("obl", NodePattern.N.withDependent("nummod", withNumberTooBigToSpellOut.markAs("NumberHead")).withDependent("case")), NodePattern.N.withDependent("obj|nmod", withNumberTooBigToSpellOut.markAs("NumberHead")), NodePattern.N.withDependent("obl|nmod|nummod", CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|nummod", CommonPatterns.possiblySkipDown(".*", numberTooBigToSpellOut)).withDependent("case").markAs("NumberHead")))).andNot(NodePattern.markedNodeMatches("NumberHead", measurements)), NodePattern.N.withHead(NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion").andNot(measurements).inPhrase(NodePattern.or(NodePattern.ROOT.and(CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|parataxis", withNumberTooBigToSpellOut.andOr(NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion"), NodePattern.not(measurements)))), NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("nummod", NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion").and(withNumberTooBigToSpellOut)))))));
        NodePattern age = NodePattern.or(NodePattern.N.withDependent("cop", NodePattern.N.lemma("be")).noDependents(NodePattern.N.afterHead().noHeadRelation("conj")), NodePattern.N.withDependent("case", NodePattern.N.form("at|between|from|to|over")).inPhrase(NodePattern.N.withHead("nmod", NodePattern.or(NodePattern.N.form("people|generation|child"), NodePattern.N.lemma("woman|girl(friend)?|dudette|lady|princess|man|boy(friend)?|dude|guy|(lord|prince)(ling)?")))), NodePattern.N.withHeadRelation("obl").directlyAfter(NodePattern.N.form("at")), NodePattern.N.withHead("obl", CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.lemma("age"))));
        NodePattern range = NodePattern.N.inFormSequence(0, 2, "\\d+", CommonPatterns.HYPHEN_LIKE_NODE.getFormRegex(), "\\d+");
        String timePattern = "[12]?\\d";
        NodePattern xToY = NodePattern.N.inFormSequence(0, 2, timePattern, "to", timePattern).and(CommonPatterns.skipUp("nmod", NodePattern.or(NodePattern.N.withHead("compound", NodePattern.N.pos("NN").noPos("CD")), NodePattern.N.withHead("nummod", NodePattern.N.pos("NN").noPos("CD")), NodePattern.N.withHeadRelation("conj").withDependent("orphan", CommonPatterns.withNumberLikeForm.afterHead().withDependent("case")), CommonPatterns.skipConjUp(CommonPatterns.withNumberLikeForm.withDependent("case").withDependent("nmod", NodePattern.N.afterHead())))));
        NodePattern prepWithNumericDependent = NodePattern.N.withDependent("case").withDependent("compound|nummod", NodePattern.N.pos("CD"));
        return NodePattern.or(NodePattern.N.form("[0-9]{2}").and(EnglishParameters.SPELL_OUT_NUMERALS.withValue("single\\+double\\+large")), NodePattern.N.form("[0-9]").and(CommonPatterns.highlightPlusOneChar)).markAs("Number").andOr(NodePattern.N.beforeHead(), NodePattern.N.withHead("conj", NodePattern.N.pos("CD")), NodePattern.N.withDependent(".*", NodePattern.N.afterHead()), NodePattern.N.withHead("nmod", CommonPatterns.possiblySkipDown("nummod", NodePattern.N.pos("CD"))), NodePattern.N.withDependent("case").andOr(NodePattern.N.withNextSibling(prepWithNumericDependent), NodePattern.N.withPrevSibling(prepWithNumericDependent))).andOr(NodePattern.ROOT.noDependents("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.or(measurements, month)).andNot(CommonPatterns.lastWord).noDependents(NodePattern.or(Semantics.ageRelatedWords, Semantics.timeRelatedWords)), NodePattern.N.withHeadRelation("nsubj|obj").andOr(NodePattern.N.withDependent("nmod", CommonPatterns.possiblySkipDown("nummod", NodePattern.N.withDependent("case"))), NodePattern.N.noDependents("conj").withHead(EnglishTreePatterns.clause.withHead("conj", NodePattern.N.withDependent("nsubj", NodePattern.N.withDependent("nummod"))).noPos("CD"))), NodePattern.N.withHeadRelation("obl.*|nmod").andOr(NodePattern.N.directlyBefore(NodePattern.N.withHead("case", NodePattern.N.withDependent("compound|nummod", CommonPatterns.withNumberLikeForm.andNot(NodePattern.N.alreadyMarkedAs("Number"))).anyPos().andNot(measurements))), NodePattern.N.withPrevSibling(NodePattern.N.withHeadRelation("obl").withDependent("compound|nummod", CommonPatterns.withNumberLikeForm).andNot(month)), NodePattern.N.withDependent("advmod", NodePattern.N.form("above|below").afterHead())), NodePattern.N.withHead("nummod|nmod|compound|conj", NodePattern.or(CommonPatterns.letterWord.anyPos().andNot(measurements).andNot(CommonPatterns.upperCase).andNot(month).andNot(CommonPatterns.capitalized.pos("NNP?").and(NodePattern.markedNodeMatches("Number", NodePattern.N.noForm("1")))).andNot(Semantics.addressWord.inPhrase(NodePattern.N.label("LOCATION"))).andNot(CommonPatterns.skipUp("conj|nmod", NodePattern.N.withHead("nummod", NodePattern.or(measurements, enumeratedNoun.before("Number"))))).andNot(CommonPatterns.skipUp("nmod", CommonPatterns.skipUp("obl|obj|nmod", Semantics.actionWithNumbers).withDependent(".*", NodePattern.N.afterHead()))), CommonPatterns.withNumberLikeForm.andOr(NodePattern.N.withHead("nummod", NodePattern.N.pos("NN.*")).beforeHead(), NodePattern.not(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("case"))).withDependent("nmod")).andNot(NodePattern.N.withHead(NodePattern.or(Semantics.ageRelatedWords, measurements))).andNot(NodePattern.N.withPrevSibling(Semantics.timeUnits)).andNot(CommonPatterns.skipUp("obl", CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", Semantics.ageRelatedWords)))))).andOr(NodePattern.N.spaceAfter(), NodePattern.N.withNeighbor(1, NodePattern.PUNCT.noForm("\\+").spaceAfter()).withNeighbor(-1, NodePattern.not(NodePattern.PUNCT)), CommonPatterns.lastToken).andNot(EnglishParameters.SPELL_OUT_NUMERALS.withValue("single").directlyBefore(NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion"))).noDependents("goeswith|appos").andNot(CommonPatterns.skipConjUp(age)).andNot(NodePattern.N.withHead("nmod", CommonPatterns.skipBack(CommonPatterns.withNumberLikeForm, NodePattern.or(enumeratedNoun, month))).noDependents("acl", NodePattern.N.directlyAfterHead())).andNot(range).andNot(NodePattern.N.directlyAfter(NodePattern.or(measurements, enumeratedNoun, EnglishTreePatterns.anyPunct.andNot(CommonPatterns.parenthesis).noSpaceAfter(), CommonPatterns.slash, NodePattern.N.form("top"), CommonPatterns.withNumberLikeForm))).andNot(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.pos("CD").pos("JJ").withHeadRelation("nummod|compound"), NodePattern.N.pos("ORD")))).andNot(NodePattern.N.withHeadRelation("obl|nmod").withDependent("conj|nmod", CommonPatterns.withNumberLikeForm.and(CommonPatterns.lastWord))).noDependents(NodePattern.PUNCT.andNot(CommonPatterns.lastToken)).noDependents("case", NodePattern.N.noLemma(".*")).andNot(NodePattern.N.withDependent("case", NodePattern.N.form("than")).withHead("obl", NodePattern.N.pos("JJR"))).andNot(CommonPatterns.skipConjUp(enumeratedNoun)).andNot(NodePattern.N.directlyBefore(NodePattern.or(measurements, CommonPatterns.withNumberLikeForm))).andNot(prohibitedInSentence).andNot(NodePattern.N.inSentenceWith(prohibitedInSentence)).andNot(biggerNumbersNearby.trace("biggerNumbersNearby")).andNot(xToY.trace("xToY")).andNot(followedByNumberInParentheses).andNot(CommonPatterns.inAllCapitalizedSentence).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("x"))).and(SpellingOutNumbers.spellOutNumber("SpellOutNumber")).andOptionally(CommonPatterns.firstToken.form("[0-9]").spaceAfter().directlyBefore(CommonPatterns.capitalized.noPos("CD")).correct(NodeCorrector.insertAfter("."))).message(SPELL_OUT_NUMBER_MSG);
    }

    private static NodePattern spellingOutOrdinalNumbers() {
        NodePattern spellOutDouble = EnglishParameters.SPELL_OUT_NUMERALS.withValue("single\\+double\\+large");
        NodePattern biggerOrdinal = NodePattern.or(NodePattern.N.form("\\d{3,}(st|nd|rd|th)").and(spellOutDouble), NodePattern.N.form("\\d{2,}(st|nd|rd|th)").andNot(spellOutDouble));
        NodePattern biggerNumbersNearby = NodePattern.or(NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", biggerOrdinal), CommonPatterns.skipConjUp(NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.withDependent("advmod", biggerOrdinal))), CommonPatterns.possiblySkipDown("conj", NodePattern.N.withDependent("conj", biggerOrdinal)), NodePattern.N.inPhrase(NodePattern.N.withDependent("conj", CommonPatterns.possiblySkipDown("amod|advmod|orphan", biggerOrdinal))));
        NodePattern dayNames = EnglishDateChecker.INSTANCE.dayOfWeek;
        NodePattern date = NodePattern.or(NodePattern.N.withHead(NodePattern.or(month, dayNames)), NodePattern.N.withDependent("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound|nmod:tmod", NodePattern.or(month, dayNames, NodePattern.N.noLemma(".*"))), NodePattern.N.directlyAfter(NodePattern.or(month, dayNames)), CommonPatterns.skipUp("nmod", NodePattern.N.withPrevSibling(month)), NodePattern.N.withHead("nmod", NodePattern.N.pos("NNS?")).withDependent("case", NodePattern.N.form("of")), NodePattern.N.withDependent("case", NodePattern.N.form("on")));
        return NodePattern.or(spellOutDouble.form("\\d\\d?(st|nd|rd|th)"), NodePattern.not(spellOutDouble).form("\\d(st|nd|rd|th)")).andNot(NodePattern.N.withHeadRelation("appos|advmod").withDependent("det")).andNot(date).andNot(NodePattern.N.withHead(NodePattern.N.noPos().noForm("\\d+(st|nd|rd|th)"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("CD"))).andNot(NodePattern.N.withHead(Semantics.addressWord.inPhrase(NodePattern.N.label("LOCATION")))).andNot(biggerNumbersNearby).and(SpellingOutNumbers.spellOutOrdinalNumber()).message(SPELL_OUT_NUMBER_MSG);
    }

    private static NodePattern spellingOutRunOnNumbers() {
        NodePattern numberBelowHundred = NodePattern.N.form("[0-9]{1,2}");
        NodePattern spellOutNumberBelowThreshold = NodePattern.not(numberTooBigToSpellOut).andNot(EnglishParameters.SPELL_OUT_NUMERALS.withValue("single").and(CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_LIKE_NODE, NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion")))).and(SpellingOutNumbers.spellOutNumber(null));
        NodePattern probablyRelatedNumbers = NodePattern.or(NodePattern.N.withPrevSibling(CommonPatterns.possiblySkipDown("nmod", NodePattern.N.alreadyMarkedAs("AnotherNumber").noHeadRelation("compound"))), NodePattern.N.withNextSibling(NodePattern.N.alreadyMarkedAs("AnotherNumber").noHeadRelation("compound")), NodePattern.N.directlyBeforeHead().withHead(NodePattern.N.alreadyMarkedAs("AnotherNumber")), NodePattern.N.withDependent(".*", NodePattern.N.alreadyMarkedAs("AnotherNumber").directlyBeforeHead()), NodePattern.N.withHead("compound|goeswith|nummod", NodePattern.N.alreadyMarkedAs("AnotherNumber")), NodePattern.N.withDependent("compound|goeswith|nummod", NodePattern.N.alreadyMarkedAs("AnotherNumber")));
        NodePattern anotherNumber = NodePattern.N.form("\\d+").andNot(DateChecker.year).markAs("AnotherNumber").andNot(NodePattern.N.directlyBefore(measurements)).andOptionally(spellOutNumberBelowThreshold);
        return numberBelowHundred.noForm("0+").andOr(NodePattern.N.directlyBefore(anotherNumber), NodePattern.N.directlyAfter(anotherNumber)).noDependents("case").andNot(probablyRelatedNumbers.trace("probablyRelatedNumbers")).andNot(NodePattern.or(NodePattern.N.withNeighbor(2, NodePattern.N.form("\\d+")), NodePattern.N.withNeighbor(-2, NodePattern.N.form("\\d+")))).and(spellOutNumberBelowThreshold).reportRangeTo("AnotherNumber").message(SPELL_OUT_RUN_ON_NUMBERS_MSG);
    }

    private static NodePattern spellingOutRoundNumbers() {
        String batchId = "SpellOutRoundNumber";
        return NodePattern.N.form("(\\d+|\\d{0,3},(\\d{3},)*\\d)00").markAs("Number").spaceBefore().withHead(NodePattern.N.pos(".*")).andNot(NodePattern.N.withHead(NodePattern.or(CommonPatterns.possiblySkipDown("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.or(uomOrAbbr, NodePattern.N.lemma("dozen|hundred|thousand|million|billion|(ga)?zillion"), CommonPatterns.withNumberLikeForm)), NodePattern.N.withDependent("conj", CommonPatterns.possiblySkipDown("conj", CommonPatterns.withNumberLikeForm))))).andNot(DateChecker.year.andNot(NodePattern.N.withHeadRelation("nummod").directlyBeforeHead())).andNot(followedByNumberInParentheses).and(SpellingOutNumbers.spellOutRoundNumber(batchId)).message(SPELL_OUT_LARGE_ROUND_NUMBER_MSG);
    }
}

