/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.Example;
import ai.grazie.rules.MatchingResult;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.document.ConsistencyChecker;
import ai.grazie.rules.document.DocumentRule;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.en.EnglishMetadata;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.NegativePhrases;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ToggleContraction {
    static final String simpleNegationContractions = "is|are|were|was|had|has|have|did|does|do|could|must|should|would|need";
    static final String decontractOnly = "may|might|dare|ought";
    private static final String EXPAND_CONTRACTED_FORM = "Expand the contracted form into full one";
    private static final String EXPAND_AMBIGUOUS_CONTRACTED_FORM = "Expand the ambiguous contracted form";
    private static final String USE_CONTRACTED_FORM = "Use the contracted form";
    private static final NodePattern ifYouWill = NodePattern.N.pos("MD").withHeadRelation("advcl");
    private static final String BATCH_CONTRACT = "BatchContract";
    private static final String BATCH_DECONTRACT = "BatchDecontract";
    static final NodePattern subPhraseNot = CommonPatterns.firstChildPhrase.and(EnglishTreePatterns.notOnly).withHead("advmod", NodePattern.N.withHead("cc(:.*)?|advmod", CommonPatterns.possiblySkipDown("i?obj|obl", NodePattern.N.withDependent("conj|parataxis", NodePattern.N.withDependent("cc", NodePattern.N.form("but"))))));
    private static final NodePattern contractNot = NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.form("not").andNot(subPhraseNot)).noDependents("aux.*").and((node, match) -> {
        String contracted = ToggleContraction.contractNegation(node.lowForm());
        return contracted == null ? null : match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), contracted).batchCapable(BATCH_CONTRACT));
    }), NegativePhrases.singleTokenCannot.correct(NodeCorrector.replace("can\u2019t").batchCapable("BatchContract")));
    static final Set<String> CONTRACTION_SUFFIXES = Set.of("t", "s", "re", "d", "ve", "m", "ll");
    private static final NodePattern contractLets = NodePattern.N.directlyAfter(EnglishTreePatterns.letUs.reportEverythingTouched().noDependents("nsubj.*|mark", NodePattern.N.beforeHead())).directlyBefore(NodePattern.N.noForm("know")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "let\u2019s").batchCapable("BatchContract"));
    private static final NodePattern noDepsAfterLone = NodePattern.N.noDependents(NodePattern.N.after("Lone").noHeadRelation("punct|conj|appos"));
    static final NodePattern thatIs = NodePattern.N.lemma("be").directlyAfter(NodePattern.N.form("that|this")).noDependents(NodePattern.N.afterHead());
    private static final NodePattern loneVerb = NodePattern.N.markAs("Lone").andOr(NodePattern.N.afterHead().withHead("cop|aux|aux:pass", noDepsAfterLone), NodePattern.N.withHead("cop", NodePattern.or(NodePattern.N.withHeadRelation("acl:relcl").withDependent("case"), NodePattern.N.pos("W.*").withHeadRelation("advmod"))).andNot(thatIs), EnglishTreePatterns.clause.lemma("be").andOr(noDepsAfterLone, NodePattern.N.withHeadRelation("acl:relcl").withDependent("obl", NodePattern.N.afterHead().andNot(NodePattern.N.withPrevSibling(NodePattern.N)))).andNot(thatIs));
    private static final NodePattern expletive = NodePattern.or(EnglishTreePatterns.tHere, NodePattern.N.lemma("it|what")).andOr(NodePattern.N.withHeadRelation("expl|advmod|nsubj"), NodePattern.N.withDependent("cop"));
    private static final NodePattern pronounSubject = NodePattern.N.pos("PRP|WP").andOr(NodePattern.N.withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.markAs("MisparsedSubj").withDependent("acl:relcl", NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.directlyAfter("MisparsedSubj")))).noForm("which|one");
    static final NodePattern afterSubjectOrExpletive = NodePattern.N.directlyAfter(NodePattern.or(expletive, pronounSubject));
    private static final NodePattern contractVerb = afterSubjectOrExpletive.lemma("be|have|will|shall").and((node, match) -> {
        String contracted;
        Node predicate = ToggleContraction.getPredicate(node);
        String string = node.hasForm("is|has") && ToggleContraction.disambiguateS(node, predicate) != null ? "\u2019s" : (node.hasForm("had|would") && ToggleContraction.disambiguateD(node, predicate) != null ? "\u2019d" : (node.hasForm("are") ? "\u2019re" : (node.hasForm("am") ? "\u2019m" : (node.hasForm("have") ? "\u2019ve" : (contracted = node.hasForm("will|shall") ? "\u2019ll" : null)))));
        if (contracted != null) {
            return match.withCorrector(NodeCorrector.replaceNodes(node.neighbor(-1), node, node.neighbor(-1).form() + contracted).batchCapable(BATCH_CONTRACT));
        }
        return null;
    }).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.startsWithApostrophe)).andNot(NodePattern.N.directlyAfter(EnglishTreePatterns.tHere).noForm("has|is|will")).andNot(NodePattern.N.inFormSequence(1, "that|what", "are|have")).andNot(NodePattern.N.inFormSequence(1, "what", "had").trace("'what'd' usually is 'what did'")).andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.comma, EnglishTreePatterns.contractedNot))).noHeadRelation("dep").andNot(loneVerb).andNot(ifYouWill).andNot(NodePattern.N.withHead("cop", NodePattern.N.withDependent("advmod|mark", NodePattern.N.form("where")))).andNot(NodePattern.N.lemma("have").andOr(NodePattern.not(NodePattern.N.withHeadRelation("aux")), NodePattern.N.withHead(NodePattern.N.noPos("VB.*").noDependents("cop"))));
    private static final NodePattern contractAlways = NodePattern.or(contractNot, contractLets, contractVerb);
    private static final NodePattern cant = NodePattern.N.inFormSequence(0, "ca", EnglishTreePatterns.contractedNot.getFormRegex());
    private static final NodePattern wont = NodePattern.N.inFormSequence(0, "wo", EnglishTreePatterns.contractedNot.getFormRegex());
    private static final NodePattern shant = NodePattern.N.inFormSequence(0, "sha", EnglishTreePatterns.contractedNot.getFormRegex());
    private static final NodePattern auxBeforeSubject = NodePattern.N.markAs("Aux").withHead("cop|aux|aux:pass", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.markAs("Subj"))).and(NodePattern.markedNodeMatches("Subj", NodePattern.N.after("Aux")));
    private static final NodePattern decontractFusedNegation = NodePattern.or(cant.correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "cannot").batchCapable("BatchDecontract")), NodePattern.or(wont, shant).reportEverythingTouched().andOr(auxBeforeSubject, NodePattern.custom((aux, m) -> m.withCorrector(NodeCorrector.replaceNodes(aux, aux.neighbor(1), ToggleContraction.decontractVerb(aux).get(0) + " not").batchCapable(BATCH_DECONTRACT)))));
    private static final NodePattern nonContractedAux = NodePattern.N.directlyAfter(EnglishTreePatterns.negation);
    private static final NodePattern decontractAlways = NodePattern.or(decontractFusedNegation, NodePattern.N.directlyAfter(EnglishTreePatterns.letS).reportEverythingTouched().correct(NodeCorrector.replace(" us").batchCapable("BatchDecontract")), EnglishTreePatterns.contractedNot.includeIntoReport().directlyAfter(NodePattern.or(NodePattern.or(NodePattern.N.form("is|are|were|was|had|has|have|did|does|do|could|must|should|would|need"), NodePattern.N.form("may|might|dare|ought")).andNot(EnglishTreePatterns.vbAposS).andOr(NodePattern.N.lemma("have").andOr(NodePattern.N.withDependent("obj"), NodePattern.N.withHead("aux", NodePattern.N.pos("NN.*")).withDependent("nsubj")), auxBeforeSubject, NodePattern.custom((node, m) -> m.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), node.form() + " not").batchCapable(BATCH_DECONTRACT)))), NodePattern.N.form("ai")).includeIntoReport()), NodePattern.N.inFormSequence(0, "['\u2019`\u2018]d", "['\u2019`\u2018]ve").correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), " would have")), NodePattern.N.lemma("be|have|will|would").and((node, match) -> {
        List<String> full = ToggleContraction.decontractVerb(node);
        if (full.get(0).equals(node.lowForm())) {
            return null;
        }
        return match.withCorrector(NodeCorrector.replace(node, full.stream().map(v -> " " + v).toList()).batchCapable(BATCH_DECONTRACT));
    }).andNot(nonContractedAux), NodePattern.N.withHeadRelation("cop|aux|aux:pass").andOr(EnglishTreePatterns.apostropheS.andNot(EnglishTreePatterns.itsConfusion).andOr(NodePattern.N.directlyAfter(NodePattern.N.withHead("obj", NodePattern.N.noPos("VBP?").andNot(CommonPatterns.possiblySkipDown("aux", NodePattern.N.pos("VBN"))))).correct(NodeCorrector.replace(" is")), NodePattern.N.directlyAfter(NodePattern.or(NodePattern.ROOT, NodePattern.N.withHeadRelation("obj"))), NodePattern.N.correct(NodeCorrector.replace(" is", " has")).andNot(NodePattern.N.inFormSequence(1, "do", ".s"))), NodePattern.N.form("['\u2019`\u2018]d").andOr(NodePattern.not(afterSubjectOrExpletive), NodePattern.N.correct(NodeCorrector.replace(" had", " would")))).andNot(nonContractedAux));
    private static final NodePattern contractAmbiguous = contractAlways.noForm("us|is|has|had|would|will|shall");
    private static final NodePattern subjunctive = NodePattern.N.withDependent("advcl", NodePattern.N.withDependent("aux|aux:pass", NodePattern.N.form("had")));
    private static final NodePattern disambiguateS = NodePattern.or(CommonPatterns.possiblySkipDown("cop|aux|aux:pass", NodePattern.N.form("been")).markAs("Has"), NodePattern.or(NodePattern.N.pos("VBG"), NodePattern.N.noPos("VBN"), NodePattern.N.withDependent("obl.*", EnglishTreePatterns.byPP)).markAs("Is"), NodePattern.N.form("got").markAs("Has"), NodePattern.N.withDependent("obj").markAs("Has"));
    private static final ConsistencyChecker<ContractionStyle> consistency = new ConsistencyChecker<ContractionStyle>(ContractionStyle.class, EnglishMetadata.contractionConsistency){

        @Override
        @Nullable
        protected ConsistencyChecker.SingleFix correctStyle(ContractionStyle style, Node node) {
            return ConsistencyChecker.SingleFix.from((style == ContractionStyle.contracted ? contractAmbiguous : decontractAlways).match(node));
        }

        @Override
        protected String quickFixMessage(ContractionStyle style) {
            return style == ContractionStyle.contracted ? "Use unambiguous contracted forms everywhere" : "Use full forms everywhere";
        }
    };

    ToggleContraction() {
    }

    @Nullable
    static String contractNegation(String verbLowForm) {
        return switch (verbLowForm) {
            case "can" -> "can\u2019t";
            case "will" -> "won\u2019t";
            case "shall" -> "shan\u2019t";
            default -> verbLowForm.matches(simpleNegationContractions) ? verbLowForm + "n\u2019t" : null;
        };
    }

    static List<String> decontractVerb(@NotNull Node node) {
        if (cant.matches(node)) {
            return List.of("can");
        }
        if (wont.matches(node)) {
            return List.of("will");
        }
        if (shant.matches(node)) {
            return List.of("shall");
        }
        String form = node.lowForm();
        if (!EnglishTreePatterns.startsWithApostrophe.matches(node) || !afterSubjectOrExpletive.matches(node)) {
            return List.of(form);
        }
        if (EnglishTreePatterns.itsConfusion.matches(node)) {
            return List.of(form);
        }
        return switch (form.substring(1)) {
            case "s" -> {
                String single = ToggleContraction.disambiguateS(node, ToggleContraction.getPredicate(node));
                if (single != null) {
                    yield List.of(single);
                }
                yield List.of("is", "has");
            }
            case "d" -> {
                String single = ToggleContraction.disambiguateD(node, ToggleContraction.getPredicate(node));
                if (single != null) {
                    yield List.of(single);
                }
                yield List.of("would", "had");
            }
            case "re" -> List.of("are");
            case "m" -> List.of("am");
            case "ve" -> List.of("have");
            case "ll" -> List.of("will");
            default -> List.of(form);
        };
    }

    @NotNull
    private static Node getPredicate(Node contractable) {
        Node head = contractable.head();
        return head == null || !contractable.hasHeadRelation("cop|aux|aux:pass|nsubj") ? contractable : head;
    }

    @Nullable
    private static String disambiguateD(Node aux, Node predicate) {
        Node nextVerb;
        if (subjunctive.matches(predicate)) {
            return "would";
        }
        List<Node> auxVerbs = predicate.findDependents("cop|aux|aux:pass");
        int nextIndex = auxVerbs.indexOf(aux) + 1;
        Node node = nextVerb = nextIndex < auxVerbs.size() ? auxVerbs.get(nextIndex) : predicate;
        if (nextVerb.hasPos("VBN")) {
            if (nextVerb.tagIndependently().hasPos("VB")) {
                return null;
            }
            return "had";
        }
        return "would";
    }

    @Nullable
    private static String disambiguateS(Node aux, Node predicate) {
        if (predicate == aux) {
            return "is";
        }
        NodeMatch match = disambiguateS.match(predicate);
        if (match != null) {
            if (match.findMarkedNode("Is") != null) {
                return "is";
            }
            if (match.findMarkedNode("Has") != null) {
                return "has";
            }
        }
        return null;
    }

    static Rule rule() {
        NodePattern possiblyOpeningQuotation = EnglishTreePatterns.quotations.noSpaceAfter();
        NodePattern possiblyClosingQuotation = EnglishTreePatterns.quotations.noSpaceBefore();
        final String consistentlyMsg = "Use contracted forms consistently";
        NodePattern consistently = EnglishParameters.CONTRACTION_USE.withValue(EnglishParameters.ContractionUse.consistently.id()).andNot(NodePattern.N.after(possiblyOpeningQuotation)).andNot(NodePattern.N.before(possiblyClosingQuotation));
        String desc = ToggleContraction.generateDescription(RuleClient.FullyCapable);
        final Example consistencyExample = new Example("<b>I am</b> glad <b>I\u2019ve</b> come here. (contract consistently)", List.of(consistentlyMsg, consistentlyMsg), List.of("<b>I\u2019m</b> glad <b>I\u2019ve</b> come here. (contract consistently)", "<b>I am</b> glad <b>I have</b> come here. (contract consistently)"), Map.of(EnglishParameters.CONTRACTION_USE, EnglishParameters.ContractionUse.consistently.id()));
        return new DocumentRule.PatternRule("Style.ENFORCE_CONTRACTION_USE", "Check full and contracted word forms", desc, "https://dictionary.cambridge.org/grammar/british-grammar/contractions", NodePattern.or(contractAlways.and(EnglishParameters.CONTRACTION_USE.withValue(EnglishParameters.ContractionUse.always.id())).message(USE_CONTRACTED_FORM), decontractAlways.andOr(EnglishParameters.CONTRACTION_USE.withValue(EnglishParameters.ContractionUse.never.id()).message(EXPAND_CONTRACTED_FORM), EnglishParameters.CONTRACTION_USE.withValue(EnglishParameters.ContractionUse.unambiguous.id()).form("['\u2019`\u2018](s|d|ll)").message(EXPAND_AMBIGUOUS_CONTRACTED_FORM), consistently.and(consistency.record(ContractionStyle.contracted))), contractAmbiguous.andOr(EnglishParameters.CONTRACTION_USE.withValue(EnglishParameters.ContractionUse.unambiguous.id()).message(USE_CONTRACTED_FORM), consistently.and(consistency.record(ContractionStyle.full)))), new Example[]{new Example("<b>Let us</b> go shopping like we <b>have not</b> done in years! (always contract)", List.of(USE_CONTRACTED_FORM, USE_CONTRACTED_FORM), List.of("<b>Let\u2019s</b> go shopping like we <b>haven\u2019t</b> done in years! (always contract)"), Map.of(EnglishParameters.CONTRACTION_USE, EnglishParameters.ContractionUse.always.id())), new Example("<b>Let\u2019s</b> go shopping like we <b>haven\u2019t</b> done in years! (never contract)", List.of(EXPAND_CONTRACTED_FORM, EXPAND_CONTRACTED_FORM), List.of("<b>Let us</b> go shopping like we <b>have not</b> done in years! (never contract)"), Map.of(EnglishParameters.CONTRACTION_USE, EnglishParameters.ContractionUse.never.id())), new Example("<b>I am</b> glad <b>she\u2019s</b> finally presented her results. (contract only unambiguous forms)", List.of(USE_CONTRACTED_FORM, EXPAND_AMBIGUOUS_CONTRACTED_FORM), List.of("<b>I\u2019m</b> glad she <b>has</b> finally presented her results. (contract only unambiguous forms)"), Map.of(EnglishParameters.CONTRACTION_USE, EnglishParameters.ContractionUse.unambiguous.id()))}){

            @Override
            public MatchingResult checkDocument(List<DocumentSentence.Analyzed> sentences2) {
                return MatchingResult.from(consistency.checkConsistency(sentences2, this, consistentlyMsg));
            }

            @Override
            public boolean shouldSuppressInCodeLikeFragments() {
                return false;
            }

            @Override
            public boolean isEnabledByDefault(RuleClient client) {
                return false;
            }

            @Override
            public String getDescription(RuleClient client) {
                return ToggleContraction.generateDescription(client);
            }

            @Override
            public List<Example> getExamples(RuleClient client) {
                return StreamEx.of(super.getExamples(client)).append(client.supportsMetadataBasedDocumentAnalysis() ? List.of(consistencyExample) : List.of()).toList();
            }
        }.styleFlavor(StyleFlavor.Formality);
    }

    private static String generateDescription(RuleClient client) {
        return "Check the style configured via '" + EnglishParameters.CONTRACTION_USE.displayName() + "' setting: Contractions help make your writing sound more informal and conversational.\n<ul>\n<li>When unambiguous: words whose contracted forms end in <i>\u2018d</i>, <i>\u2018s</i>, and <i>\u2018ll</i> are ignored\nbecause these can be unclear to people with lower levels of English proficiency.\n<li>Always: contractions are suggested whenever possible.\n<li>Never: expanded forms are suggested as replacements for contracted forms.\n" + (client.supportsMetadataBasedDocumentAnalysis() ? "\n<li>Consistently: contracted and expanded forms are both accepted as long as they are consistent within the same text." : "") + "\n</ul>";
    }

    private static enum ContractionStyle {
        contracted,
        full;

    }
}

