/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.settings;

import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleClient;
import ai.grazie.rules.settings.ExpandableDescription;
import ai.grazie.rules.settings.RuleSetting;
import ai.grazie.rules.settings.Setting;
import ai.grazie.rules.settings.SettingGroup;
import ai.grazie.rules.settings.TextStyle;
import ai.grazie.rules.toolkit.LanguageToolkit;
import ai.grazie.rules.tree.Parameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingComponent
extends JPanel {
    private final LanguageToolkit toolkit;
    private final RuleClient client;
    private final UI ui;
    private final FontMetrics metrics;
    private final JScrollPane scrollPane;
    @Nullable
    private TextStyle style;
    private final Map<RuleSetting, JCheckBox> ruleToSetting = new LinkedHashMap<RuleSetting, JCheckBox>();
    private final Map<Parameter, JComboBox<Setting.Value>> paramToSetting = new LinkedHashMap<Parameter, JComboBox<Setting.Value>>();
    private final Map<SettingGroup, GroupComponent> groupComponents = new LinkedHashMap<SettingGroup, GroupComponent>();
    private final Map<Setting, JComponent> settingToReset = new LinkedHashMap<Setting, JComponent>();
    public static final UI INTERNAL_UI = new UI(){
        private static final BufferedImage EMPTY_IMAGE = new BufferedImage(1, 1, 2);

        @Override
        public JComponent createResetToDefaultComponent(Runnable action) {
            return 2.createLinkLabel("Reset to default", action);
        }

        @Override
        public JComponent createExpandComponent(boolean examplesOnly, Runnable doExpand) {
            return 2.createLinkLabel(examplesOnly ? "Show examples" : "Expand", doExpand);
        }

        @Override
        public JComponent createCollapseComponent(boolean examplesOnly, Runnable doCollapse) {
            return 2.createLinkLabel(examplesOnly ? "Hide examples" : "Collapse", doCollapse);
        }

        @NotNull
        private static JComponent createLinkLabel(String text2, final Runnable onClick) {
            JLabel link = new JLabel(text2);
            link.setCursor(Cursor.getPredefinedCursor(12));
            SettingComponent.useFontStyle(link, 0);
            SettingComponent.useSmallFont(link);
            link.setForeground(Color.BLUE);
            link.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    onClick.run();
                }
            });
            return link;
        }

        @Override
        public JComponent createGroupHeader(String name) {
            JLabel header = new JLabel(name);
            Font defaultFont = header.getFont();
            header.setFont(defaultFont.deriveFont(defaultFont.getSize2D() * 1.3f));
            SettingComponent.useFontStyle(header, 1);
            int vInset = header.getFontMetrics(defaultFont).getHeight() * 3 / 4;
            header.setBorder(new EmptyBorder(vInset, 0, vInset, 0));
            return header;
        }

        @Override
        public void customizeSettingSection(Setting setting, JComponent section) {
            section.setBorder(new EmptyBorder(0, 0, section.getFontMetrics(section.getFont()).getHeight() / 2, 0));
        }

        @Override
        public void customizeRuleDescription(JEditorPane pane) {
            SettingComponent.useSmallFont(pane);
            pane.setForeground(Color.gray);
        }

        @Override
        public boolean shouldShowNavBar(List<SettingGroup> groups) {
            return groups.size() > 1;
        }

        @Override
        public JComponent createFilterComponent(final Consumer<String> doFilter) {
            final JTextField filterField = new JTextField();
            JPanel filterComponent = new JPanel(new BorderLayout(20, 0));
            filterComponent.add(filterField);
            filterComponent.add((Component)new JLabel("Filter:"), "West");
            filterComponent.setBorder(SettingComponent.emptyBorder(10));
            filterField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.changedUpdate(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    doFilter.accept(filterField.getText());
                }
            });
            return filterComponent;
        }

        @Override
        public String getExamplePrefix() {
            return "Example:";
        }

        @Override
        public String getCorrectionPrefix() {
            return "Corrected:";
        }

        @Override
        public void navigateHyperlink(URL url) {
            try {
                Desktop.getDesktop().browse(url.toURI());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public Image externalLinkArrow() {
            return EMPTY_IMAGE;
        }
    };

    public SettingComponent(LanguageToolkit toolkit, RuleClient client, UI ui2) {
        super(new BorderLayout());
        this.toolkit = toolkit;
        this.client = client;
        this.ui = ui2;
        this.metrics = this.getFontMetrics(this.getFont());
        int lineHeight = this.metrics.getHeight();
        List<SettingGroup> settings2 = toolkit.getSettings(client);
        this.scrollPane = new JScrollPane(this.createContentPanel(settings2));
        this.scrollPane.setBorder(SettingComponent.emptyBorder(0));
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(lineHeight);
        JPanel root = new JPanel(new BorderLayout(this.metrics.stringWidth("WW"), 0));
        root.setBackground(this.getGeneralBackground());
        root.add((Component)this.scrollPane, "Center");
        if (ui2.shouldShowNavBar(settings2)) {
            root.add((Component)this.createNavigationPanel(), "West");
        }
        root.add((Component)ui2.createFilterComponent(this::filter), "North");
        this.add(root);
    }

    protected void filter(String searchText) {
        this.groupComponents.values().forEach(c -> c.filter(searchText));
    }

    private JPanel createContentPanel(List<SettingGroup> settings2) {
        JPanel main = new JPanel(new GridBagLayout());
        main.setBackground(this.getGeneralBackground());
        GridBagConstraints c = SettingComponent.createMainPanelConstraints();
        for (SettingGroup group : settings2) {
            GroupComponent comp = new GroupComponent(group);
            this.groupComponents.put(group, comp);
            main.add((Component)comp, c);
        }
        c.fill = 3;
        c.weighty = 1.0;
        main.add((Component)new JLabel(), c);
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.gridheight = 0;
        c.weightx = 1.0;
        main.add((Component)new JLabel(), c);
        return main;
    }

    private static GridBagConstraints createMainPanelConstraints() {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridx = 0;
        return c;
    }

    private JPanel createNavigationPanel() {
        JPanel navPanel = new JPanel(new GridBagLayout());
        navPanel.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.ipadx = c.ipady = this.metrics.stringWidth("w");
        c.gridx = 0;
        c.weightx = 1.0;
        for (Map.Entry<SettingGroup, GroupComponent> entry2 : this.groupComponents.entrySet()) {
            final JLabel navLink = new JLabel(entry2.getKey().displayName());
            navLink.setBackground(this.getGeneralBackground());
            navLink.setOpaque(true);
            final GroupComponent mainComponent = entry2.getValue();
            navPanel.add((Component)navLink, c);
            navLink.setCursor(Cursor.getPredefinedCursor(12));
            navLink.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    SettingComponent.this.scrollComponentToVisible(mainComponent);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    navLink.setBackground(SettingComponent.this.getGeneralBackground().darker());
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    navLink.setBackground(SettingComponent.this.getGeneralBackground());
                }
            });
        }
        c.fill = 3;
        c.weighty = 1.0;
        navPanel.add((Component)new JLabel(), c);
        navPanel.setBorder(SettingComponent.emptyBorder(this.metrics.stringWidth("w")));
        return navPanel;
    }

    public void scrollComponentToVisible(JComponent component2) {
        component2.scrollRectToVisible(new Rectangle(component2.getWidth(), this.scrollPane.getHeight()));
    }

    static EmptyBorder emptyBorder(int inset) {
        return new EmptyBorder(inset, inset, inset, inset);
    }

    private static EmptyBorder leftIndentBorder(int indent) {
        return new EmptyBorder(0, indent, 0, 0);
    }

    protected Color getGeneralBackground() {
        return new JPanel().getBackground();
    }

    private JPanel withResetLabel(Setting setting, JComponent comp) {
        List<Object> list;
        StreamEx streamEx = StreamEx.of((Object)setting);
        if (setting instanceof RuleSetting) {
            RuleSetting rs = (RuleSetting)setting;
            list = rs.getSubSettings();
        } else {
            list = List.of();
        }
        List relatedSettings = streamEx.append(list).toList();
        JComponent reset = this.ui.createResetToDefaultComponent(() -> {
            for (Setting relatedSetting1 : relatedSettings) {
                this.resetToDefault(relatedSetting1);
            }
        });
        reset.setVisible(false);
        for (Setting relatedSetting : relatedSettings) {
            this.settingToReset.put(relatedSetting, reset);
        }
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)comp, "West");
        panel.add((Component)reset, "East");
        return panel;
    }

    private void resetToDefault(Setting setting) {
        if (setting instanceof RuleSetting) {
            RuleSetting rs = (RuleSetting)setting;
            this.findRuleComponent(rs).setSelected(this.isEnabledByDefault(rs.rule));
        } else if (setting instanceof Parameter) {
            Parameter p = (Parameter)setting;
            this.findParamComponent(p).setSelectedItem(this.defaultParamValue(p));
        }
    }

    public JComponent findParentSettingComponent(Setting setting) {
        JCheckBox jCheckBox;
        if (setting instanceof Parameter) {
            Parameter p = (Parameter)setting;
            for (RuleSetting rs : this.ruleToSetting.keySet()) {
                if (!rs.getSubSettings().contains(p)) continue;
                return this.findRuleComponent(rs);
            }
            return this.findParamComponent(p);
        }
        if (setting instanceof RuleSetting) {
            RuleSetting rs = (RuleSetting)setting;
            jCheckBox = this.findRuleComponent(rs);
        } else {
            jCheckBox = null;
        }
        return jCheckBox;
    }

    public JComponent findOwnSettingComponent(Setting setting) {
        JComponent jComponent;
        if (setting instanceof RuleSetting) {
            RuleSetting rs = (RuleSetting)setting;
            jComponent = this.findRuleComponent(rs);
        } else {
            jComponent = this.findParamComponent((Parameter)setting);
        }
        return jComponent;
    }

    private JCheckBox findRuleComponent(RuleSetting rs) {
        return this.ruleToSetting.get(rs);
    }

    private JComboBox<Setting.Value> findParamComponent(Parameter p) {
        return this.paramToSetting.get(p);
    }

    private static void useSmallFont(JComponent component2) {
        component2.setFont(component2.getFont().deriveFont((float)component2.getFont().getSize() * 0.95f));
    }

    protected void somethingModified() {
        HashSet<JComponent> resetsToEnable = new HashSet<JComponent>();
        for (Map.Entry<RuleSetting, JCheckBox> entry2 : this.ruleToSetting.entrySet()) {
            if (entry2.getValue().isSelected() == this.isEnabledByDefault(entry2.getKey().rule)) continue;
            resetsToEnable.add(this.settingToReset.get(entry2.getKey()));
        }
        for (Map.Entry<Setting, JComponent> entry3 : this.paramToSetting.entrySet()) {
            if (((JComboBox)entry3.getValue()).getSelectedItem() == this.defaultParamValue((Parameter)entry3.getKey())) continue;
            resetsToEnable.add(this.settingToReset.get(entry3.getKey()));
        }
        for (JComponent jComponent : this.settingToReset.values()) {
            jComponent.setVisible(resetsToEnable.contains(jComponent));
        }
    }

    static void useFontStyle(JComponent component2, int style) {
        component2.setFont(component2.getFont().deriveFont(style));
    }

    public void loadState(SettingState state, @Nullable TextStyle style) {
        this.style = style;
        for (Map.Entry<RuleSetting, JCheckBox> entry2 : this.ruleToSetting.entrySet()) {
            Rule rule = entry2.getKey().rule;
            entry2.getValue().setSelected(state.isRuleEnabled(rule, this.isEnabledByDefault(rule)));
        }
        for (Map.Entry<Setting, JComponent> entry3 : this.paramToSetting.entrySet()) {
            Parameter param = (Parameter)entry3.getKey();
            Setting.Value defaultState = this.defaultParamValue(param);
            String value = state.paramValues.getOrDefault(param.id(), defaultState.id());
            Setting.Value toSelect = StreamEx.of(param.possibleValues(this.client)).findFirst(v -> v.id().equals(value)).orElse(defaultState);
            ((JComboBox)entry3.getValue()).setSelectedItem(toSelect);
        }
    }

    public SettingState getState() {
        SettingState state = new SettingState(new LinkedHashMap<String, String>(), new LinkedHashSet<String>(), new LinkedHashSet<String>());
        for (Map.Entry<RuleSetting, JCheckBox> entry2 : this.ruleToSetting.entrySet()) {
            Rule rule = entry2.getKey().rule;
            boolean defaultState = this.isEnabledByDefault(rule);
            if (entry2.getValue().isSelected() == defaultState) continue;
            (defaultState ? state.disabledRules : state.enabledRules).add(rule.id);
        }
        for (Map.Entry<Setting, JComponent> entry3 : this.paramToSetting.entrySet()) {
            Parameter param = (Parameter)entry3.getKey();
            Setting.Value defaultValue = this.defaultParamValue(param);
            Setting.Value actual = (Setting.Value)((JComboBox)entry3.getValue()).getSelectedItem();
            if (actual == null || defaultValue.equals(actual)) continue;
            state.paramValues.put(param.id(), actual.id());
        }
        return state;
    }

    @NotNull
    private Setting.Value defaultParamValue(Parameter param) {
        return param.defaultValue(this.style != null ? this.style : TextStyle.Unspecified, this.client);
    }

    private boolean isEnabledByDefault(Rule rule) {
        return this.style != null ? rule.isRuleEnabledByDefault(this.style, this.client) : rule.isRuleEnabledByDefaultAnywhere();
    }

    private static boolean stringMatches(String searchText, String uiText) {
        return uiText.toLowerCase(Locale.ROOT).contains(searchText.toLowerCase(Locale.ROOT));
    }

    public static interface UI {
        public JComponent createResetToDefaultComponent(Runnable var1);

        public JComponent createExpandComponent(boolean var1, Runnable var2);

        public JComponent createCollapseComponent(boolean var1, Runnable var2);

        public JComponent createGroupHeader(String var1);

        public JComponent createFilterComponent(Consumer<String> var1);

        public void customizeSettingSection(Setting var1, JComponent var2);

        public void customizeRuleDescription(JEditorPane var1);

        public boolean shouldShowNavBar(List<SettingGroup> var1);

        public String getExamplePrefix();

        public String getCorrectionPrefix();

        public void navigateHyperlink(URL var1);

        public Image externalLinkArrow();
    }

    private class GroupComponent
    extends JPanel {
        final SettingGroup group;
        final JComponent header;

        GroupComponent(SettingGroup group) {
            super(new GridBagLayout());
            this.group = group;
            GridBagConstraints c = SettingComponent.createMainPanelConstraints();
            c.weightx = 1.0;
            this.header = SettingComponent.this.ui.createGroupHeader(group.displayName());
            this.add((Component)this.header, c);
            for (Setting setting : group.settings()) {
                SettingSection section = new SettingSection(setting);
                SettingComponent.this.ui.customizeSettingSection(setting, section);
                this.add((Component)section, c);
            }
        }

        void filter(String searchText) {
            if (SettingComponent.stringMatches(searchText, this.group.displayName())) {
                this.setVisible(true);
                for (Component child : this.getComponents()) {
                    child.setVisible(true);
                }
            } else {
                this.setVisible(false);
                for (Component component2 : this.getComponents()) {
                    if (!(component2 instanceof SettingSection)) continue;
                    SettingSection s = (SettingSection)component2;
                    s.filter(searchText);
                    if (!s.isVisible()) continue;
                    this.setVisible(true);
                }
            }
        }
    }

    public record SettingState(Map<String, String> paramValues, Set<String> enabledRules, Set<String> disabledRules) {
        public static final SettingState UNCHANGED = new SettingState(Map.of(), Set.of(), Set.of());

        public boolean isRuleEnabled(Rule rule, boolean defaultState) {
            return this.enabledRules.contains(rule.id) || defaultState && !this.disabledRules.contains(rule.id);
        }
    }

    private class SettingSection
    extends JPanel {
        final Setting setting;
        final ExpandableDescription description;

        SettingSection(Setting setting) {
            super(new BorderLayout());
            this.setting = setting;
            if (setting instanceof RuleSetting) {
                RuleSetting rs = (RuleSetting)setting;
                this.description = new ExpandableDescription(rs.rule, SettingComponent.this.ui, SettingComponent.this.toolkit, SettingComponent.this.client);
                this.add(this.createRuleComponent(rs, this.description));
            } else {
                this.description = null;
                this.add(SettingComponent.this.withResetLabel(setting, this.createParamRow((Parameter)setting)));
            }
        }

        private JPanel createRuleComponent(RuleSetting rs, ExpandableDescription description) {
            JComponent header;
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.weightx = 1.0;
            c.anchor = 18;
            c.fill = 2;
            Parameter headerParameter = rs.headerParameter();
            String name = headerParameter != null ? SettingSection.paramText(headerParameter) : rs.displayName();
            JCheckBox cb = new JCheckBox(name);
            SettingComponent.useFontStyle(cb, 0);
            SettingComponent.this.ruleToSetting.put(rs, cb);
            if (headerParameter == null) {
                header = cb;
            } else {
                header = new JPanel(new BorderLayout());
                header.add((Component)cb, "West");
                header.add(this.paramComboBox(headerParameter));
            }
            panel.add((Component)SettingComponent.this.withResetLabel(rs, header), c);
            int indent = SettingComponent.this.metrics.stringWidth("WW");
            description.setBorder(SettingComponent.leftIndentBorder(indent));
            panel.add((Component)description, c);
            List<Parameter> parameters = rs.getSubSettings();
            for (Parameter param : parameters) {
                if (param == headerParameter) continue;
                JPanel paramComponent = this.createParamRow(param);
                paramComponent.setBorder(SettingComponent.leftIndentBorder(indent));
                panel.add((Component)paramComponent, c);
            }
            cb.addChangeListener(e -> {
                this.updateParameterAvailability(cb, parameters);
                SettingComponent.this.somethingModified();
            });
            this.updateParameterAvailability(cb, parameters);
            return panel;
        }

        private static String paramText(Parameter param) {
            return param.displayName() + ": ";
        }

        private void updateParameterAvailability(JCheckBox cb, List<Parameter> parameters) {
            for (Parameter parameter : parameters) {
                SettingComponent.this.findParamComponent(parameter).setEnabled(cb.isSelected());
            }
        }

        private JPanel createParamRow(Parameter param) {
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            JLabel label = new JLabel(SettingSection.paramText(param));
            SettingComponent.useFontStyle(label, 0);
            panel.add(label);
            panel.add(this.paramComboBox(param));
            panel.add(new JPanel());
            return panel;
        }

        private JComboBox<Setting.Value> paramComboBox(Parameter param) {
            JComboBox<Setting.Value> cb = new JComboBox<Setting.Value>(new Vector<Setting.Value>(param.possibleValues(SettingComponent.this.client)));
            SettingComponent.useFontStyle(cb, 0);
            SettingComponent.this.paramToSetting.put(param, cb);
            cb.addActionListener(e -> SettingComponent.this.somethingModified());
            return cb;
        }

        void filter(String searchText) {
            Setting setting = this.setting;
            if (setting instanceof RuleSetting) {
                RuleSetting rs = (RuleSetting)setting;
                if (SettingComponent.stringMatches(searchText, rs.rule.displayName) || rs.getSubSettings().stream().anyMatch(p -> SettingSection.paramMatches(searchText, p))) {
                    this.setVisible(true);
                    if (this.description.preview != null) {
                        this.description.collapse();
                    }
                    return;
                }
                if (SettingComponent.stringMatches(searchText, rs.rule.getDescription(SettingComponent.this.client))) {
                    if (this.description.preview != null && !SettingComponent.stringMatches(searchText, this.description.preview)) {
                        this.description.expand();
                    }
                    this.setVisible(true);
                    return;
                }
            } else {
                Parameter parameter;
                setting = this.setting;
                if (setting instanceof Parameter && SettingSection.paramMatches(searchText, parameter = (Parameter)setting)) {
                    this.setVisible(true);
                    return;
                }
            }
            this.setVisible(false);
        }

        private static boolean paramMatches(String searchText, Parameter parameter) {
            return SettingComponent.stringMatches(searchText, parameter.displayName());
        }
    }
}

