/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.toolkit;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class Selectioner {
    public List<TextRange> calcExtendSelectionRanges(Tree tree, int startOffset, int endOffset) {
        Node node = tree.findNodeAt(startOffset);
        if (node == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<TextRange> allRanges = new LinkedHashSet<TextRange>();
        allRanges.add(node.textRange());
        while (node != null) {
            List<TextRange> forHead = this.calcRangesForHead(node);
            forHead.sort(Comparator.comparing(r -> r.end() - r.start()));
            allRanges.addAll(forHead);
            node = node.head();
        }
        TextRange last = new TextRange(startOffset, endOffset);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        for (TextRange range : allRanges) {
            if (!range.encloses(last) || range.equals(last)) continue;
            result2.add(range);
            last = range;
        }
        return result2;
    }

    @NotNull
    protected List<TextRange> calcRangesForHead(Node head) {
        Node last;
        Node afterLast;
        Node phraseStart = head.phraseStart();
        Node phraseEnd = head.phraseEnd();
        if ((phraseStart = phraseStart.skipForward(n -> "punct".equals(n.headRelation()))) == null || phraseStart.isAfter(phraseEnd)) {
            return Collections.emptyList();
        }
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        result2.add(new TextRange(phraseStart.startOffset(), phraseEnd.endOffset()));
        phraseEnd = phraseEnd.skipBack(n -> "punct".equals(n.headRelation()));
        if (phraseEnd == null || phraseStart.isAfter(phraseEnd)) {
            return result2;
        }
        for (Node dependent : head.findDependents("case|cc|cop")) {
            if (!dependent.isBefore(head)) continue;
            phraseStart = Objects.requireNonNull(dependent.nextNode());
            result2.add(new TextRange(phraseStart.startOffset(), phraseEnd.endOffset()));
        }
        for (Node dependent : head.findDependents("flat|appos")) {
            if (!dependent.isAfter(head)) continue;
            result2.add(new TextRange(phraseStart.startOffset(), dependent.phraseEnd().endOffset()));
        }
        head.nerAnnotations().findFirst().ifPresent(a -> result2.add(new TextRange(a.component1().getStart(), a.component1().getEndExclusive())));
        for (Node relClause : head.findDependents("acl:relcl|advcl|conj")) {
            Node prev = relClause.phraseStart().prevNode();
            if (prev == null || !prev.isAfter(phraseStart)) continue;
            phraseEnd = prev;
            result2.add(new TextRange(phraseStart.startOffset(), phraseEnd.endOffset()));
        }
        List adverbs = head.findDependents("advmod").stream().filter(n -> n.isBefore(head)).collect(Collectors.toList());
        if (!adverbs.isEmpty() && (afterLast = (last = (Node)Iterables.getLast(adverbs)).phraseEnd().nextNode()) != null && afterLast.isBefore(phraseEnd)) {
            result2.add(new TextRange(afterLast.startOffset(), phraseEnd.endOffset()));
        }
        return result2;
    }
}

