/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.tree.DocumentParserHelper;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.util.BatchParser;
import ai.grazie.rules.util.BatchSentenceTokenizer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public interface BatchTreeParser
extends BatchParser<Tree> {
    public TreeSupport support();

    public TreeSource getSource();

    @Nullable
    default public BatchTreeParser getSecondaryParser() {
        return null;
    }

    default public BatchTreeParser withSecondary(final @Nullable BatchTreeParser secondary) {
        if (!(secondary == null || 2.$assertionsDisabled || this.getSource() == TreeSource.Cloud && secondary.getSource() == TreeSource.Local)) {
            throw new AssertionError();
        }
        return new BatchTreeParser(){

            @Override
            public TreeSupport support() {
                return BatchTreeParser.this.support();
            }

            @Override
            public TreeSource getSource() {
                return BatchTreeParser.this.getSource();
            }

            @Override
            public LinkedHashMap<String, Tree> parse(List<String> sentences2) {
                return BatchTreeParser.this.parse(sentences2);
            }

            @Override
            @Nullable
            public BatchTreeParser getSecondaryParser() {
                return secondary;
            }
        };
    }

    default public List<Tree> parseTokenized(String text2) {
        return this.parseTokenized(List.of(text2)).get(text2);
    }

    default public LinkedHashMap<String, List<Tree>> parseTokenized(List<String> texts) {
        return this.parseTokenized(texts, StandardSentenceTokenizer.defaultFor(this.support().getGrazieLanguage()));
    }

    default public LinkedHashMap<String, List<Tree>> parseTokenized(List<String> texts, StandardSentenceTokenizer tokenizer) {
        BatchSentenceTokenizer batcher = new BatchSentenceTokenizer(texts, tokenizer);
        return batcher.textTrees(this.parse(batcher.sentencesToParse()));
    }

    default public List<DocumentSentence.Parsed> parseDocument(List<DocumentSentence> rawDoc) {
        Language language = this.support().getGrazieLanguage();
        DocumentParserHelper helper = new DocumentParserHelper(rawDoc);
        Map<Language, List<String>> toParse = helper.sentencesToParse();
        LinkedHashMap parsed = this.parse(toParse.getOrDefault(language, List.of()));
        return helper.withTrees(Map.of(language, parsed));
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum TreeSource {
        Cloud,
        Local,
        ForcedFlat;

    }
}

