/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.ner.model.SentenceWithNERAnnotations;
import ai.grazie.nlp.tokenizer.NonDestructiveTokenizer;
import ai.grazie.nlp.tokenizer.Tokenizer;
import ai.grazie.nlp.tokenizer.retokenizer.pattern.PatternRetokenizers;
import ai.grazie.rules.tree.AccessedParameters;
import ai.grazie.rules.tree.CrazyParseDetector;
import ai.grazie.rules.tree.HeadRelations;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Parameter;
import ai.grazie.rules.tree.PosEnumerator;
import ai.grazie.rules.tree.StubbedSentence;
import ai.grazie.rules.tree.TreeCache;
import ai.grazie.rules.tree.TreePainter;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.util.CharUtil;
import ai.grazie.text.TextRange;
import ai.grazie.tree.model.SentenceWithTreeDependencies;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import kotlin.ranges.IntRange;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class Tree {
    static final int MAX_KNOWN_HEAD_REL_V1 = HeadRelations.maxKnownId();
    private final TreeSupport treeSupport;
    private final String sentenceText;
    private final List<TokenWithDependency> tokens;
    private final List<Node> nodes;
    private final int startOffset;
    @VisibleForTesting
    public final ParameterValues parameterValues;
    final boolean local;
    @NotNull
    final List<SentenceWithNERAnnotations.Annotation> namedEntities;
    @ApiStatus.Internal
    @Nullable
    public final StubbedSentence stubbed;
    private final Map<TreeCache, TreeCache.CachedData> cache = new HashMap<TreeCache, TreeCache.CachedData>();
    private CrazyParseDetector.CrazyParses[] crazyParses = new CrazyParseDetector.CrazyParses[]{null};
    private static final TreeCache<Tree> flatTree = new TreeCache<Tree>("flatTree", t -> Tree.createFlatTree(t.treeSupport, t.sentenceText).withNamedEntities(t.namedEntities).withStartOffset(t.startOffset).withParameters(t.parameterValues).markLocal());

    @ApiStatus.Internal
    public static Tree build(TreeSupport treeSupport, String text2, List<SentenceWithTreeDependencies.Node> tree) {
        int i;
        List<Token> tagged = treeSupport.tagTokens(tree.stream().map(node -> treeSupport.tagger.normalizeToken(text2.substring(node.getRange().getStart(), node.getRange().getEndExclusive()))).toList());
        ArrayList<TokenWithDependency> tokens = new ArrayList<TokenWithDependency>();
        HashMap<String, Integer> id2Index = new HashMap<String, Integer>(tree.size());
        for (i = 0; i < tree.size(); ++i) {
            id2Index.put(tree.get(i).getId(), i);
        }
        for (i = 0; i < tree.size(); ++i) {
            Integer headIndex;
            SentenceWithTreeDependencies.Node arc = tree.get(i);
            String head = arc.getHeadId();
            if (arc.getId().equals(head)) {
                throw new AssertionError((Object)"Cyclic tree!");
            }
            Integer n2 = headIndex = "0".equals(arc.getHeadId()) ? Integer.valueOf(-1) : (Integer)id2Index.get(arc.getHeadId());
            if (headIndex == null) {
                throw new AssertionError((Object)("Unknown head id " + arc.getHeadId() + " among " + StreamEx.of(tree).map(n -> n.getId()).toList()));
            }
            TextRange range = arc.getRange();
            int start = range.getStart();
            String raw = text2.substring(start, range.getEndExclusive());
            Token token = new Token(start, treeSupport.tagger.normalizeToken(raw), raw, tagged.get((int)i).readings);
            tokens.add(new TokenWithDependency(token, HeadRelations.internDynamic(arc.getDependency()), headIndex));
        }
        return new Tree(treeSupport, text2, tokens, 0, new ParameterValues(Map.of()), false, List.of(), null);
    }

    public Tree getFlatTree() {
        return this.getCached(flatTree);
    }

    private static Tree createFlatTree(TreeSupport treeSupport, String text2) {
        List<String> tokenized = Tree.createTokenizer(treeSupport).tokenize(text2).stream().map(t -> t.getToken()).toList();
        List<Token> tagged = treeSupport.tagger.tagTokens(tokenized);
        ArrayList<Token> normalized = new ArrayList<Token>(tagged.size());
        int offset = 0;
        for (Token token : tagged) {
            String raw = token.rawForm;
            if (!Tree.isWhitespace(token.form)) {
                normalized.add(new Token(offset, treeSupport.tagger.normalizeToken(raw), raw, token.readings));
            }
            offset += raw.length();
        }
        ArrayList<TokenWithDependency> tokens = new ArrayList<TokenWithDependency>();
        if (!normalized.isEmpty()) {
            tokens.add(new TokenWithDependency((Token)normalized.get(0), HeadRelations.internKnown("root"), -1));
            for (int i = 1; i < normalized.size(); ++i) {
                tokens.add(new TokenWithDependency((Token)normalized.get(i), HeadRelations.internKnown("flat_dep"), 0));
            }
        }
        return new Tree(treeSupport, text2, tokens, 0, new ParameterValues(Map.of()), false, List.of(), null);
    }

    private static Tokenizer createTokenizer(final TreeSupport treeSupport) {
        return new PatternRetokenizers.URL(new NonDestructiveTokenizer(){

            @Override
            @NotNull
            public List<Tokenizer.Token> tokenize(@NotNull String text2) {
                int start = 0;
                ArrayList<Tokenizer.Token> result2 = new ArrayList<Tokenizer.Token>();
                for (String token : treeSupport.language().getWordTokenizer().tokenize(text2)) {
                    result2.add(new Tokenizer.Token(token, new IntRange(start, start + token.length() - 1)));
                    start += token.length();
                }
                return result2;
            }
        });
    }

    private static boolean isWhitespace(String s) {
        return s.chars().allMatch(c -> CharUtil.isAnySpace((char)c));
    }

    private Tree(TreeSupport treeSupport, String sentenceText, List<TokenWithDependency> dependencies, int startOffset, ParameterValues values, boolean local, @NotNull List<SentenceWithNERAnnotations.Annotation> namedEntities, @Nullable StubbedSentence stubbed) {
        int i;
        this.treeSupport = treeSupport;
        this.sentenceText = sentenceText;
        this.startOffset = startOffset;
        this.parameterValues = values;
        this.local = local;
        this.tokens = dependencies;
        this.namedEntities = namedEntities;
        ArrayList<Node> nodes = new ArrayList<Node>(dependencies.size());
        ArrayList dependents = new ArrayList(dependencies.size());
        for (i = 0; i < dependencies.size(); ++i) {
            dependents.add(new ArrayList());
        }
        for (i = 0; i < dependencies.size(); ++i) {
            TokenWithDependency twd = dependencies.get(i);
            int headIndex = twd.headIndex;
            Node node = new Node(this, twd.token, twd.headRel, i, headIndex, (List)dependents.get(i));
            if (headIndex >= 0) {
                ((List)dependents.get(headIndex)).add(node);
            }
            nodes.add(node);
        }
        this.nodes = nodes;
        this.stubbed = stubbed;
    }

    private Tree replaceToken(Node node, List<Reading> newReadings) {
        Token token = new Token(node.startOffset(), node.form(), node.rawForm(), newReadings, node.initialReadings == null ? node.tokenReadings() : node.initialReadings);
        ArrayList<TokenWithDependency> tokens = new ArrayList<TokenWithDependency>(this.tokens);
        tokens.set(node.index, new TokenWithDependency(token, node.headRel, node.headIndex));
        return new Tree(this.treeSupport, this.sentenceText, tokens, this.startOffset, this.parameterValues, this.local, this.namedEntities, this.stubbed);
    }

    public Tree withStartOffset(int startOffset) {
        assert (startOffset >= 0);
        return new Tree(this.treeSupport, this.sentenceText, this.tokens, startOffset, this.parameterValues, this.local, this.namedEntities, this.stubbed);
    }

    public Tree withStubbed(@NotNull StubbedSentence stubbed) {
        return new Tree(this.treeSupport, this.sentenceText, this.tokens, this.startOffset, this.parameterValues, this.local, this.namedEntities, stubbed);
    }

    public Tree withReadings(Node node, List<Reading> readings) {
        if (readings.isEmpty()) {
            return this;
        }
        return this.replaceToken(node, Stream.concat(node.tokenReadings().stream(), readings.stream()).toList());
    }

    public Tree withoutReadings(Node node, List<Reading> readings) {
        if (readings.isEmpty()) {
            return this;
        }
        LinkedHashSet<Reading> copy = new LinkedHashSet<Reading>(node.tokenReadings());
        readings.forEach(copy::remove);
        return this.replaceToken(node, new ArrayList<Reading>(copy));
    }

    public String text() {
        return this.sentenceText;
    }

    public org.languagetool.Language language() {
        return this.treeSupport().language();
    }

    public TreeSupport treeSupport() {
        return this.treeSupport;
    }

    @Nullable
    public Node findBestNodeAt(int offset) {
        List<Node> all = this.findNodesAt(offset);
        if (all.isEmpty()) {
            return null;
        }
        Node first = all.get(0);
        return all.size() == 1 ? first : all.stream().filter(n -> !NodePattern.PUNCT.matches((Node)n)).findFirst().orElse(first);
    }

    @NotNull
    public List<Node> findNodesAt(int offset) {
        return this.nodes().stream().filter(n -> n.startOffset() <= offset && offset <= n.endOffset()).toList();
    }

    @Nullable
    public Node findNodeAt(int offset) {
        List<Node> list = this.findNodesAt(offset);
        return list.isEmpty() ? null : list.get(0);
    }

    @NotNull
    public List<Node> nodes() {
        return this.nodes;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int startOffset() {
        return this.startOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getCached(TreeCache<T> cache) {
        Map<TreeCache, TreeCache.CachedData> map2 = this.cache;
        synchronized (map2) {
            TreeCache.CachedData<T> data2 = this.cache.get(cache);
            if (data2 == null) {
                data2 = cache.compute(this);
                this.cache.put(cache, data2);
            }
            return data2.value();
        }
    }

    public CrazyParseDetector.CrazyParses crazyParseNodes() {
        CrazyParseDetector.CrazyParses result2 = this.crazyParses[0];
        if (result2 == null) {
            AccessedParameters token = AccessedParameters.start();
            token.prohibitAccess = true;
            try {
                this.crazyParses[0] = result2 = this.treeSupport.crazyParseDetector().findCrazyParses(this);
            }
            finally {
                token.finish();
            }
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree t = (Tree)o;
        return this.sentenceText.equals(t.sentenceText) && this.parameterValues.equals(t.parameterValues) && this.namedEntities.equals(t.namedEntities) && t.nodes.size() == this.nodes.size() && IntStream.range(0, this.nodes.size()).allMatch(i -> this.nodes.get(i).structureEquals(t.nodes.get(i)));
    }

    public int hashCode() {
        return Objects.hash(this.sentenceText, this.parameterValues, this.nodes.stream().map(Node::headRelation).toList());
    }

    public String toString() {
        Node node;
        int i;
        int leftColumn = 0;
        Object[] lines = (StringBuilder[])StreamEx.of(this.nodes).map(n -> new StringBuilder(n.form())).toArray(StringBuilder[]::new);
        for (i = 0; i < this.nodes.size(); ++i) {
            node = this.nodes.get(i);
            leftColumn = Math.max(leftColumn, Tree.visibleLength(lines[i]) + 1 + node.headRelation().length());
        }
        for (i = 0; i < this.nodes.size(); ++i) {
            node = this.nodes.get(i);
            lines[i].append(" ".repeat(leftColumn - Tree.visibleLength((CharSequence)lines[i]) - node.headRelation().length())).append(node.headRelation());
        }
        char[][] tree = TreePainter.drawTree(this.nodes);
        for (int i2 = 0; i2 < this.nodes.size(); ++i2) {
            String suffix = this.nodes.get(i2).toString();
            int afterForm = suffix.indexOf(91);
            ((StringBuilder)lines[i2]).append(tree[i2]).append("  ").append(suffix.substring(afterForm));
        }
        String result2 = "\n" + StreamEx.of((Object[])lines).joining((CharSequence)"\n");
        if (!this.parameterValues.isEmpty()) {
            result2 = result2 + "\n// parameters: " + this.parameterValues.map;
        }
        return result2;
    }

    private static int visibleLength(CharSequence lines) {
        return (int)lines.chars().filter(c -> Character.getType(c) != 6).count();
    }

    public Tree withNamedEntities(@NotNull List<SentenceWithNERAnnotations.Annotation> namedEntities) {
        if (namedEntities.isEmpty()) {
            return this;
        }
        return new Tree(this.treeSupport, this.sentenceText, this.tokens, this.startOffset, this.parameterValues, this.local, namedEntities, this.stubbed);
    }

    public Tree markLocal() {
        return new Tree(this.treeSupport, this.sentenceText, this.tokens, this.startOffset, this.parameterValues, true, this.namedEntities, this.stubbed);
    }

    public Tree withParameters(Map<Parameter, String> values) {
        return this.withParameters(ParameterValues.fromMap(values));
    }

    public Tree withParameters(ParameterValues parameters) {
        if (parameters.equals(this.parameterValues)) {
            return this;
        }
        Tree result2 = new Tree(this.treeSupport, this.sentenceText, this.tokens, this.startOffset, parameters, this.local, this.namedEntities, this.stubbed);
        for (Map.Entry<TreeCache, TreeCache.CachedData> entry2 : this.cache.entrySet()) {
            if (!entry2.getKey().dependsOnlyOnStructure()) continue;
            result2.cache.put(entry2.getKey(), entry2.getValue());
        }
        result2.crazyParses = this.crazyParses;
        result2 = this.treeSupport.disambiguateWithParameters(result2);
        if (this.stubbed != null) {
            result2 = result2.withStubbed(new StubbedSentence(this.stubbed.sentence(), this.stubbed.tree().withParameters(parameters)));
        }
        return result2;
    }

    public void serialize(DataOutput out) throws IOException {
        PosEnumerator posEnumerator = PosEnumerator.forLanguage(this.treeSupport.getGrazieLanguage());
        this.serialize(out, MAX_KNOWN_HEAD_REL_V1, posEnumerator, posEnumerator.maxStaticId());
    }

    private void serialize(DataOutput out, int maxHeadRel, PosEnumerator posEnumerator, int maxPosId) throws IOException {
        out.writeVInt(this.tokens.size());
        for (TokenWithDependency twd : this.tokens) {
            if (twd.headRel <= maxHeadRel) {
                out.writeVInt((int)twd.headRel);
            } else {
                out.writeVInt(0);
                out.writeString(HeadRelations.byId(twd.headRel));
            }
            out.writeVInt(twd.headIndex);
            Token token = twd.token;
            out.writeVInt(token.startOffset());
            out.writeVInt(token.endOffset());
            out.writeVInt(token.readings.size());
            String prev = token.form;
            for (Reading reading : token.readings) {
                short posId;
                String pos = reading.pos;
                short s = posId = pos == null ? (short)0 : posEnumerator.enumerate(pos);
                if (posId > 0 && posId <= maxPosId) {
                    out.writeVInt((int)posId);
                } else {
                    out.writeVInt(0);
                    out.writeString(Objects.requireNonNullElse(pos, ""));
                }
                String lemma = reading.lemma;
                if (lemma == null) {
                    out.writeVInt(0);
                } else if (lemma.equals(prev)) {
                    out.writeVInt(1);
                } else {
                    byte[] bytes = lemma.getBytes(StandardCharsets.UTF_8);
                    out.writeVInt(bytes.length + 1);
                    out.writeBytes(bytes, bytes.length);
                }
                prev = lemma;
            }
        }
        out.writeVInt(this.namedEntities.size());
        for (SentenceWithNERAnnotations.Annotation annotation : this.namedEntities) {
            out.writeVInt(annotation.getRange().getStart());
            out.writeVInt(annotation.getRange().getEndExclusive());
            out.writeVInt(annotation.getLabel().ordinal());
        }
    }

    public static Tree deserialize(DataInput in, TreeSupport treeSupport, String text2) throws IOException {
        int tokenCount = in.readVInt();
        ArrayList<TokenWithDependency> tokens = new ArrayList<TokenWithDependency>(tokenCount);
        PosEnumerator posEnumerator = PosEnumerator.forLanguage(treeSupport.getGrazieLanguage());
        for (int i = 0; i < tokenCount; ++i) {
            short headRel = (short)in.readVInt();
            if (headRel == 0) {
                headRel = HeadRelations.internDynamic(in.readString());
            }
            int headIndex = in.readVInt();
            int tokenStart = in.readVInt();
            int tokenEnd = in.readVInt();
            int readingCount = in.readVInt();
            String rawForm = text2.substring(tokenStart, tokenEnd);
            String form = treeSupport.tagger.normalizeToken(rawForm);
            ArrayList<Reading> readings = new ArrayList<Reading>(readingCount);
            String prev = form;
            for (int j = 0; j < readingCount; ++j) {
                String lemma;
                int posId = in.readVInt();
                String pos = posId != 0 ? posEnumerator.byId((short)posId) : in.readString();
                int encodedLemma = in.readVInt();
                if (encodedLemma == 0) {
                    lemma = null;
                } else if (encodedLemma == 1) {
                    lemma = prev;
                } else {
                    byte[] bytes = new byte[encodedLemma - 1];
                    in.readBytes(bytes, 0, bytes.length);
                    lemma = new String(bytes, StandardCharsets.UTF_8);
                }
                readings.add(new Reading(pos.isEmpty() ? null : pos, lemma));
                prev = lemma;
            }
            tokens.add(new TokenWithDependency(new Token(tokenStart, form, rawForm, readings), headRel, headIndex));
        }
        int neCount = in.readVInt();
        ArrayList<SentenceWithNERAnnotations.Annotation> namedEntities = new ArrayList<SentenceWithNERAnnotations.Annotation>(neCount);
        for (int i = 0; i < neCount; ++i) {
            TextRange range = new TextRange(in.readVInt(), in.readVInt());
            namedEntities.add(new SentenceWithNERAnnotations.Annotation(range, SentenceWithNERAnnotations.Annotation.Label.values()[in.readVInt()]));
        }
        return new Tree(treeSupport, text2, tokens, 0, new ParameterValues(Map.of()), false, namedEntities, null);
    }

    public static class Token {
        private final int offset;
        private final String form;
        private final String rawForm;
        private String lowForm;
        private final List<Reading> readings;
        @Nullable
        protected final List<Reading> initialReadings;
        private volatile List<String> posReadings;
        private volatile List<String> lemmaReadings;
        private volatile short[] sortedPosIds;

        protected Token(Token token) {
            this(token.offset, token.form, token.rawForm, token.readings, token.initialReadings);
            this.lowForm = token.lowForm;
            this.lemmaReadings = token.lemmaReadings;
            this.posReadings = token.posReadings;
            this.sortedPosIds = token.sortedPosIds;
        }

        public Token(int offset, String form, String rawForm, List<Reading> readings) {
            this(offset, form, rawForm, readings, null);
        }

        private Token(int offset, String form, String rawForm, List<Reading> readings, @Nullable List<Reading> initialReadings) {
            this.offset = offset;
            this.form = form;
            this.rawForm = rawForm;
            this.readings = readings;
            this.initialReadings = initialReadings;
        }

        public String rawForm() {
            return this.rawForm;
        }

        public String form() {
            return this.form;
        }

        public List<Reading> tokenReadings() {
            return this.readings;
        }

        public int startOffset() {
            return this.offset;
        }

        public int endOffset() {
            return this.startOffset() + this.rawForm.length();
        }

        public String toString() {
            return this.form + this.readings + (String)(this.initialReadings == null ? "" : " (originally " + this.initialReadings + ")");
        }

        public boolean hasPos(String regex) {
            Pattern pattern = Pattern.compile(regex);
            return this.posReadings().stream().anyMatch(p -> pattern.matcher((CharSequence)p).matches());
        }

        public List<String> posReadings() {
            List<String> result2 = this.posReadings;
            if (result2 == null) {
                this.posReadings = result2 = this.extractFromReadings(r -> r.pos);
            }
            return result2;
        }

        public List<String> lemmaReadings() {
            List<String> result2 = this.lemmaReadings;
            if (result2 == null) {
                this.lemmaReadings = result2 = this.extractFromReadings(r -> r.lemma);
            }
            return result2;
        }

        short[] sortedPosIds(TreeSupport support) {
            short[] result2 = this.sortedPosIds;
            if (result2 == null) {
                short[] ids = PosEnumerator.forLanguage(support.getGrazieLanguage()).enumerate(this.posReadings());
                Arrays.sort(ids);
                result2 = ids;
                this.sortedPosIds = ids;
            }
            return result2;
        }

        private List<String> extractFromReadings(Function<Reading, String> extractor) {
            int size = this.readings.size();
            if (size == 0) {
                return List.of();
            }
            String single = extractor.apply(this.readings.get(0));
            if (size == 1) {
                return single == null ? List.of() : List.of(single);
            }
            LinkedHashSet<String> set = null;
            for (int i = 1; i < size; ++i) {
                String value = extractor.apply(this.readings.get(i));
                if (value == null) continue;
                if (single == null || value.equals(single)) {
                    single = value;
                    continue;
                }
                if (set == null) {
                    set = new LinkedHashSet<String>(2);
                    set.add(single);
                }
                set.add(value);
            }
            return set != null ? new ArrayList(set) : (single != null ? List.of(single) : List.of());
        }

        public String lowForm() {
            String result2 = this.lowForm;
            if (result2 == null) {
                this.lowForm = result2 = this.form.toLowerCase(Locale.ROOT);
            }
            return result2;
        }

        @VisibleForTesting
        public boolean hasInitialReadings() {
            return this.initialReadings != null;
        }
    }

    private record TokenWithDependency(Token token, short headRel, int headIndex) {
    }

    public static final class ParameterValues {
        private final Map<String, String> map;

        public ParameterValues(Map<String, String> map2) {
            this.map = map2;
        }

        public static ParameterValues fromMap(Map<Parameter, String> parameters) {
            return new ParameterValues(EntryStream.of(parameters).mapKeys(Parameter::id).toMap());
        }

        @Nullable
        public String getValueId(Parameter parameter) {
            AccessedParameters current = AccessedParameters.current();
            if (current != null) {
                current.accessed(parameter);
            }
            return this.map.get(parameter.id());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof ParameterValues)) return false;
            ParameterValues pv = (ParameterValues)obj;
            if (!Objects.equals(this.map, pv.map)) return false;
            return true;
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public String toString() {
            return this.map.toString();
        }
    }

    public record Reading(@Nullable String pos, @Nullable String lemma) {
        public Reading(@Nullable String pos, @Nullable String lemma) {
            assert (pos != null || lemma != null);
            assert (pos == null || !pos.isEmpty());
            assert (lemma == null || !lemma.isEmpty());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Reading)) {
                return false;
            }
            Reading reading = (Reading)o;
            return Objects.equals(this.pos, reading.pos) && Objects.equals(this.lemma, reading.lemma);
        }

        @Override
        @NotNull
        public String toString() {
            return this.lemma + "/" + this.pos;
        }

        public boolean hasPos(@Language(value="RegExp") String pattern) {
            return this.pos != null && this.pos.matches(pattern);
        }
    }
}

