/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.uk;

import ai.grazie.rules.Example;
import ai.grazie.rules.Rule;
import ai.grazie.rules.StyleFlavor;
import ai.grazie.rules.common.ChangeLemma;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.SentenceCapitalizationRule;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.uk.Euphony;
import ai.grazie.rules.uk.Pleonasm;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;

class StyleRules {
    private static final String LISTUVATYSYA_MSG = StyleRules.ukKrasce("\u043b\u0438\u0441\u0442\u0443\u0432\u0430\u0442\u0438\u0441\u044f");
    private static final String VSERIVNO_MSG = StyleRules.ukKrasce("\u043e\u0434\u043d\u0430\u043a\u043e\u0432\u043e");
    private static final String PREDSTAVLYATY_MSG = StyleRules.ukKrasce("\u044f\u0432\u043b\u044f\u0442\u0438 \u0441\u043e\u0431\u043e\u044e");
    private static final String ZUPYNKA_MSG = "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u043e\u044e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0438\u0441\u0430\u0442\u0438 \u00ab\u0437\u0443\u043f\u0438\u043d\u043a\u0430\u00bb";
    private static final String PONAD_MSG = "\u0417\u0430\u043c\u0456\u0441\u0442\u044c \u00ab\u0431\u0456\u043b\u044c\u0448\u0435\u00bb \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u043f\u043e\u043d\u0430\u0434\u00bb";
    private static final String VYGLYADATY_MSG = StyleRules.ukKrasce("\u043c\u0430\u0442\u0438 \u0432\u0438\u0433\u043b\u044f\u0434");
    private static final String VYBACHAYUS_MSG = StyleRules.ukKrasce("\u043f\u0435\u0440\u0435\u043f\u0440\u043e\u0448\u0443\u044e", "\u0432\u0438\u0431\u0430\u0447\u0442\u0435", "\u043f\u0440\u043e\u0431\u0430\u0447\u0442\u0435");
    private static final String MULTI_PUNCTUATION = "\u0423\u043d\u0438\u043a\u0430\u0439\u0442\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u043a\u0456\u043b\u044c\u043a\u043e\u0445 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0445 \u0437\u043d\u0430\u043a\u0456\u0432";
    private static final String MULTI_EXCLAMATION = "\u0423\u043d\u0438\u043a\u0430\u0439\u0442\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u043a\u0456\u043b\u044c\u043a\u043e\u0445 \u0437\u043d\u0430\u043a\u0456\u0432 \u043e\u043a\u043b\u0438\u043a\u0443";
    private static final String EXCLAMATION_MARK = "\u041d\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 \u0437\u043d\u0430\u043a\u0438 \u043e\u043a\u043b\u0438\u043a\u0443";
    private static final String SMILEY_USE_MSG = "\u0420\u043e\u0437\u0433\u043b\u044f\u043d\u044c\u0442\u0435 \u043c\u043e\u0436\u043b\u0438\u0432\u0456\u0441\u0442\u044c \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f \u0441\u043c\u0430\u0439\u043b\u0438\u043a\u0430, \u0449\u043e\u0431 \u0437\u0440\u043e\u0431\u0438\u0442\u0438 \u0432\u0430\u0448 \u0442\u043e\u043d \u0431\u0456\u043b\u044c\u0448 \u043e\u0444\u0456\u0446\u0456\u0439\u043d\u0438\u043c";
    private static final String EMOJI_USE_MSG = "\u0420\u043e\u0437\u0433\u043b\u044f\u043d\u044c\u0442\u0435 \u043c\u043e\u0436\u043b\u0438\u0432\u0456\u0441\u0442\u044c \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f \u0435\u043c\u043e\u0434\u0437\u0456, \u0449\u043e\u0431 \u0437\u0440\u043e\u0431\u0438\u0442\u0438 \u0432\u0430\u0448 \u0442\u043e\u043d \u0431\u0456\u043b\u044c\u0448 \u043e\u0444\u0456\u0446\u0456\u0439\u043d\u0438\u043c";
    private static final String POLOVYNA_MSG = "\u041f\u043e\u043b\u043e\u0432\u0438\u043d\u0430 \u043d\u0435 \u043c\u043e\u0436\u0435 \u0431\u0443\u0442\u0438 \u0431\u0456\u043b\u044c\u0448\u043e\u044e \u0447\u0438 \u043c\u0435\u043d\u0448\u043e\u044e";
    private static final NodePattern doSerca = NodePattern.N.withDependent("obl", NodePattern.N.form("\u0432\u0456\u0434\u043e\u043c\u0430|\u0441\u0435\u0440\u0446\u044f|\u0443\u0432\u0430\u0433\u0438").markAs("Obl").withDependent("case", NodePattern.N.form("\u0434\u043e")));
    private static final NodePattern uchast = NodePattern.N.form("\u0443\u0447\u0430\u0441\u0442[\u044c\u0456]|\u0437\u043e\u0431\u043e\u0432'\u044f\u0437\u0430\u043d\u043d\u044f").markAs("Obj");
    private static final NodePattern miry = NodePattern.N.form("\u043c\u0456\u0440\u0438").noDependents("amod", NodePattern.N.pos("adj.*|noun.*").noLemma("\u043f\u0440\u0438\u0439\u043d\u044f\u0442\u0438\u0439"));
    static final NodePattern naManir = NodePattern.N.form("\u043c\u0430\u043d\u0435\u0440").withDependent("case", NodePattern.N.form("\u043d\u0430"));

    StyleRules() {
    }

    private static String ukKrasce(String ... words) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            result2.append("\u00ab").append(words[i]).append("\u00bb");
            if (i < words.length - 2) {
                result2.append(", ");
            }
            if (i != words.length - 2) continue;
            result2.append(" \u0447\u0438 ");
        }
        return "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u043e\u044e \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 " + result2;
    }

    static List<Rule> rules() {
        return List.of(new Rule.PatternRule("Style.RUSSIAN_CALQUE", "\u041a\u0430\u043b\u044c\u043a\u0430 \u0437 \u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u043e\u0457 \u043c\u043e\u0432\u0438", "\u0421\u043b\u043e\u0432\u043e \u0430\u0431\u043e \u043c\u043e\u0432\u043d\u0438\u0439 \u0437\u0432\u043e\u0440\u043e\u0442, \u0437\u0430\u043f\u043e\u0437\u0438\u0447\u0435\u043d\u0438\u0439 \u0437 \u0440\u043e\u0441\u0456\u0439\u0441\u044c\u043a\u043e\u0457 \u043c\u043e\u0432\u0438.", null, StyleRules.russianCalque().andNot(CommonPatterns.insideQuotes), new Example("\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456 <b>\u0432\u0435\u0434\u0443\u0442\u044c \u0437 \u043d\u0438\u043c\u0438 \u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0443</b>.", LISTUVATYSYA_MSG, "\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456 <b>\u043b\u0438\u0441\u0442\u0443\u044e\u0442\u044c\u0441\u044f</b> \u0437 \u043d\u0438\u043c\u0438."), new Example("\u042f <b>\u0432\u0441\u0435 \u0440\u0456\u0432\u043d\u043e</b> \u0432\u0438\u0440\u0456\u0448\u0438\u0432 \u043f\u043e\u043a\u0456\u043d\u0447\u0438\u0442\u0438 \u0436\u0438\u0442\u0442\u044f \u0441\u0430\u043c\u043e\u0433\u0443\u0431\u0441\u0442\u0432\u043e\u043c.", VSERIVNO_MSG, "\u042f <b>\u043e\u0434\u043d\u0430\u043a\u043e\u0432\u043e</b> \u0432\u0438\u0440\u0456\u0448\u0438\u0432 \u043f\u043e\u043a\u0456\u043d\u0447\u0438\u0442\u0438 \u0436\u0438\u0442\u0442\u044f \u0441\u0430\u043c\u043e\u0433\u0443\u0431\u0441\u0442\u0432\u043e\u043c."), new Example("\u0417\u0432\u2019\u044f\u0437\u043e\u043a \u043f\u043e\u043d\u044f\u0442\u0442\u044f \u0437 \u0446\u0456\u0454\u044e \u043d\u0430\u0437\u0432\u043e\u044e <b>\u043d\u043e\u0441\u0438\u0442\u044c</b> \u043d\u0435 \u0441\u0443\u0431\u2019\u0454\u043a\u0442\u0438\u0432\u043d\u0438\u0438\u0306 \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440", StyleRules.ukKrasce("\u043c\u0430\u0442\u0438 \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440"), "\u0417\u0432\u2019\u044f\u0437\u043e\u043a \u043f\u043e\u043d\u044f\u0442\u0442\u044f \u0437 \u0446\u0456\u0454\u044e \u043d\u0430\u0437\u0432\u043e\u044e <b>\u043c\u0430\u0454</b> \u043d\u0435 \u0441\u0443\u0431\u2019\u0454\u043a\u0442\u0438\u0432\u043d\u0438\u0438\u0306 \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440"), new Example("\u0429\u043e <b>\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f\u0454 \u0441\u043e\u0431\u043e\u044e</b> \u043d\u0430 \u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456 \u0441\u043b\u0443\u0436\u0431\u0430 \u043f\u043e\u0440\u044f\u0442\u0443\u043d\u043a\u0443 \u0423\u043a\u0440\u0430\u0457\u043d\u0438?", PREDSTAVLYATY_MSG, "\u0429\u043e <b>\u044f\u0432\u043b\u044f\u0454 \u0441\u043e\u0431\u043e\u044e</b> \u043d\u0430 \u0441\u044c\u043e\u0433\u043e\u0434\u043d\u0456 \u0441\u043b\u0443\u0436\u0431\u0430 \u043f\u043e\u0440\u044f\u0442\u0443\u043d\u043a\u0443 \u0423\u043a\u0440\u0430\u0457\u043d\u0438?"), new Example("\u0414\u043e \u043d\u0430\u0441\u0442\u0443\u043f\u043d\u043e\u0457 <b>\u043e\u0441\u0442\u0430\u043d\u0456\u0432\u043a\u0438</b> \u0432\u043e\u043d\u0438 \u0457\u0445\u0430\u043b\u0438 \u043c\u043e\u0432\u0447\u043a\u0438.", ZUPYNKA_MSG, "\u0414\u043e \u043d\u0430\u0441\u0442\u0443\u043f\u043d\u043e\u0457 <b>\u0437\u0443\u043f\u0438\u043d\u043a\u0438</b> \u0432\u043e\u043d\u0438 \u0457\u0445\u0430\u043b\u0438 \u043c\u043e\u0432\u0447\u043a\u0438."), new Example("\u0427\u043e\u0433\u043e \u0442\u0438 \u0432\u0441\u0435 \u0442\u0430\u043a \u0431\u043b\u0438\u0437\u044c\u043a\u043e \u0434\u043e \u0441\u0435\u0440\u0446\u044f <b>\u043f\u0440\u0438\u0439\u043c\u0430\u0454\u0448</b>?", StyleRules.ukKrasce("\u0431\u0440\u0430\u0442\u0438 \u0434\u043e \u0441\u0435\u0440\u0446\u044f"), "\u0427\u043e\u0433\u043e \u0442\u0438 \u0432\u0441\u0435 \u0442\u0430\u043a \u0431\u043b\u0438\u0437\u044c\u043a\u043e \u0434\u043e \u0441\u0435\u0440\u0446\u044f <b>\u0431\u0435\u0440\u0435\u0448</b>?"), new Example("\u0426\u044c\u043e\u043c\u0443 \u0434\u0435\u0440\u0435\u0432\u0443 <b>\u0431\u0456\u043b\u044c\u0448\u0435 \u0441\u0442\u0430</b> \u0440\u043e\u043a\u0456\u0432.", PONAD_MSG, "\u0426\u044c\u043e\u043c\u0443 \u0434\u0435\u0440\u0435\u0432\u0443 <b>\u043f\u043e\u043d\u0430\u0434 \u0441\u0442\u043e</b> \u0440\u043e\u043a\u0456\u0432.", "\u0426\u044c\u043e\u043c\u0443 \u0434\u0435\u0440\u0435\u0432\u0443 <b>\u0431\u0456\u043b\u044c\u0448 \u044f\u043a \u0441\u0442\u043e</b> \u0440\u043e\u043a\u0456\u0432.", "\u0426\u044c\u043e\u043c\u0443 \u0434\u0435\u0440\u0435\u0432\u0443 <b>\u0431\u0456\u043b\u044c\u0448\u0435 \u043d\u0456\u0436 \u0441\u0442\u043e</b> \u0440\u043e\u043a\u0456\u0432."), new Example("\u0412\u0456\u043d <b>\u0432\u0438\u0433\u043b\u044f\u0434\u0430\u0432 \u0434\u0443\u0436\u0435 \u043d\u0430\u043b\u044f\u043a\u0430\u043d\u0438\u043c</b>.", VYGLYADATY_MSG, "\u0412\u0456\u043d <b>\u043c\u0430\u0432 \u0434\u0443\u0436\u0435 \u043d\u0430\u043b\u044f\u043a\u0430\u043d\u0438\u0439 \u0432\u0438\u0433\u043b\u044f\u0434</b>.", "\u0412\u0456\u043d <b>\u0432\u0438\u0434\u0430\u0432\u0430\u0432\u0441\u044c \u0434\u0443\u0436\u0435 \u043d\u0430\u043b\u044f\u043a\u0430\u043d\u0438\u043c</b>.", "\u0412\u0456\u043d <b>\u0432\u0438\u0434\u0430\u0432\u0430\u0432\u0441\u044f \u0434\u0443\u0436\u0435 \u043d\u0430\u043b\u044f\u043a\u0430\u043d\u0438\u043c</b>."), new Example("<b>\u041f\u0440\u0438\u0439\u043c\u0456\u0442\u044c</b> \u0443\u0447\u0430\u0441\u0442\u044c \u0443 \u0440\u043e\u0437\u0456\u0433\u0440\u0430\u0448\u0456.", StyleRules.ukKrasce("\u0432\u0437\u044f\u0442\u0438 \u0443\u0447\u0430\u0441\u0442\u044c"), "<b>\u0411\u0435\u0440\u0456\u0442\u044c</b> \u0443\u0447\u0430\u0441\u0442\u044c \u0443 \u0440\u043e\u0437\u0456\u0433\u0440\u0430\u0448\u0456.", "<b>\u0412\u0456\u0437\u044c\u043c\u0456\u0442\u044c</b> \u0443\u0447\u0430\u0441\u0442\u044c \u0443 \u0440\u043e\u0437\u0456\u0433\u0440\u0430\u0448\u0456."), new Example("\u041f\u0456\u0441\u043b\u044f \u043e\u0431\u0433\u043e\u0432\u043e\u0440\u0435\u043d\u043d\u044f \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0443 \u0431\u0443\u043b\u043e <b>\u043f\u0440\u0438\u0439\u043d\u044f\u0442\u043e</b>.", StyleRules.ukKrasce("\u0443\u0445\u0432\u0430\u043b\u0438\u0442\u0438 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0443"), "\u041f\u0456\u0441\u043b\u044f \u043e\u0431\u0433\u043e\u0432\u043e\u0440\u0435\u043d\u043d\u044f \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0443 \u0431\u0443\u043b\u043e <b>\u0443\u0445\u0432\u0430\u043b\u0435\u043d\u043e</b>."), new Example("\u0412 \u043d\u0430\u0441 \u0441\u0443\u0442\u043e \u0434\u0456\u043b\u043e\u0432\u0456 <b>\u0432\u0437\u0430\u0454\u043c\u043e\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d\u0438</b>.", "\u00ab\u0432\u0437\u0430\u0454\u043c\u043e\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d\u0438\u00bb \u2013 \u0440\u043e\u0441\u0456\u044f\u043d\u0456\u0437\u043c, \u044f\u043a\u0438\u0439 \u0432 \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0456\u0439 \u043c\u043e\u0432\u0456 \u043a\u0440\u0430\u0449\u0435 \u043d\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438", "\u0412 \u043d\u0430\u0441 \u0441\u0443\u0442\u043e \u0434\u0456\u043b\u043e\u0432\u0456 <b>\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d\u0438</b>.")), new Rule.PatternRule("Style.VYBACHAYUS", "\u00ab\u0412\u0438\u0431\u0430\u0447\u0442\u0435\u00bb \u0437\u0430\u043c\u0456\u0441\u0442\u044c \u00ab\u0432\u0438\u0431\u0430\u0447\u0430\u044e\u0441\u044c\u00bb", "\u0414\u043b\u044f \u043f\u0440\u043e\u0445\u0430\u043d\u043d\u044f \u0449\u043e\u0441\u044c \u0437\u0440\u043e\u0431\u0438\u0442\u0438 \u043a\u0440\u0430\u0449\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0432\u0430\u0442\u0438 \u00ab\u043f\u0435\u0440\u0435\u043f\u0440\u043e\u0448\u0443\u044e\u00bb, \u00ab\u0432\u0438\u0431\u0430\u0447\u0442\u0435\u00bb, \u00ab\u043f\u0440\u043e\u0431\u0430\u0447\u0442\u0435\u00bb, \u00ab\u0434\u0430\u0440\u0443\u0439\u0442\u0435\u00bb. \u00ab\u0412\u0438\u0431\u0430\u0447\u0430\u044e\u0441\u044c\u00bb \u0434\u043e\u0440\u0435\u0447\u043d\u043e \u0432\u0436\u0438\u0432\u0430\u0442\u0438, \u043d\u0430\u0437\u0438\u0432\u0430\u044e\u0447\u0438 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u043d\u0438\u0439 \u043f\u0440\u043e\u0446\u0435\u0441.", null, StyleRules.vybachayus().andNot(CommonPatterns.insideQuotes), new Example("<b>\u0412\u0438\u0431\u0430\u0447\u0430\u044e\u0441\u044c</b>, \u0447\u0438 \u043c\u043e\u0433\u043b\u0438 \u0431 \u0432\u0438 \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0438 \u0442\u0438\u0445\u0456\u0448\u0435?", VYBACHAYUS_MSG, "<b>\u041f\u0435\u0440\u0435\u043f\u0440\u043e\u0448\u0443\u044e</b>, \u0447\u0438 \u043c\u043e\u0433\u043b\u0438 \u0431 \u0432\u0438 \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0438 \u0442\u0438\u0445\u0456\u0448\u0435?", "<b>\u0412\u0438\u0431\u0430\u0447\u0442\u0435</b> \u043c\u0435\u043d\u0456, \u0447\u0438 \u043c\u043e\u0433\u043b\u0438 \u0431 \u0432\u0438 \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0438 \u0442\u0438\u0445\u0456\u0448\u0435?", "<b>\u041f\u0440\u043e\u0431\u0430\u0447\u0442\u0435</b>, \u0447\u0438 \u043c\u043e\u0433\u043b\u0438 \u0431 \u0432\u0438 \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0438 \u0442\u0438\u0445\u0456\u0448\u0435?", "<b>\u0414\u0430\u0440\u0443\u0439\u0442\u0435</b>, \u0447\u0438 \u043c\u043e\u0433\u043b\u0438 \u0431 \u0432\u0438 \u0433\u043e\u0432\u043e\u0440\u0438\u0442\u0438 \u0442\u0438\u0445\u0456\u0448\u0435?")), new Rule.PatternRule("Style.LOGIC", "\u041b\u043e\u0433\u0456\u0447\u043d\u0456 \u043f\u043e\u043c\u0438\u043b\u043a\u0438", "\u041f\u043e\u0440\u0443\u0448\u0435\u043d\u043d\u044f \u043b\u043e\u0433\u0456\u043a\u0438 \u0432 \u0442\u0435\u043a\u0441\u0442\u0456.", "https://goroh.pp.ua/%D0%A1%D0%BB%D0%BE%D0%B2%D0%BE%D0%B2%D0%B6%D0%B8%D0%B2%D0%B0%D0%BD%D0%BD%D1%8F/%D0%BF%D0%BE%D0%BB%D0%BE%D0%B2%D0%B8%D0%BD%D0%B0", StyleRules.bilshayaPolovina(), new Example("\u0423\u0436\u0435 \u0432 2016 \u0440\u043e\u0446\u0456 \u043d\u0430 <b>\u0431\u0456\u043b\u044c\u0448\u0456\u0439 \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0456</b> \u043e\u0431\u2019\u0454\u043a\u0442\u0456\u0432 \u0440\u043e\u0431\u043e\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0456.", POLOVYNA_MSG, "\u0423\u0436\u0435 \u0432 2016 \u0440\u043e\u0446\u0456 \u043d\u0430 <b>\u0431\u0456\u043b\u044c\u0448\u0456\u0439 \u0447\u0430\u0441\u0442\u0438\u043d\u0456</b> \u043e\u0431\u2019\u0454\u043a\u0442\u0456\u0432 \u0440\u043e\u0431\u043e\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0456.", "\u0423\u0436\u0435 \u0432 2016 \u0440\u043e\u0446\u0456 \u043d\u0430 <b>\u0431\u0456\u043b\u044c\u0448 \u043d\u0456\u0436 \u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0456</b> \u043e\u0431\u2019\u0454\u043a\u0442\u0456\u0432 \u0440\u043e\u0431\u043e\u0442\u0438 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0456.")), Euphony.rule(), Pleonasm.rule(), new SentenceCapitalizationRule("\u041e\u0434\u043d\u043e\u043c\u0430\u043d\u0456\u0442\u043d\u0456\u0441\u0442\u044c \u0443 \u043f\u043e\u0447\u0430\u0442\u043a\u0430\u0445 \u0440\u0435\u0447\u0435\u043d\u044c", "\u0423\u0441\u0456 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u043f\u043e\u0432\u0438\u043d\u043d\u0456 \u043f\u043e\u0447\u0438\u043d\u0430\u0442\u0438\u0441\u044c \u0430\u0431\u043e \u0437 \u0432\u0435\u043b\u0438\u043a\u043e\u0457 \u043b\u0456\u0442\u0435\u0440\u0438, \u0430\u0431\u043e \u0437 \u043c\u0430\u043b\u043e\u0457 (\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e \u0432 \u0456\u043d\u0442\u0435\u0440\u043d\u0435\u0442-\u0441\u043f\u0456\u043b\u043a\u0443\u0432\u0430\u043d\u043d\u0456).", null, "\u043f\u0435\u0440\u0448\u0435 \u0440\u0435\u0447\u0435\u043d\u043d\u044f. <i>\u0414\u0440</i>\u0443\u0433\u0435 \u0440\u0435\u0447\u0435\u043d\u043d\u044f.", "\u041d\u0435\u043f\u043e\u0441\u043b\u0456\u0434\u043e\u0432\u043d\u0438\u0439 \u0440\u0435\u0433\u0456\u0441\u0442\u0440 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u0440\u0435\u0447\u0435\u043d\u043d\u044f", "\u041f\u043e\u0447\u0438\u043d\u0430\u0442\u0438 \u0432\u0441\u0456 \u0440\u0435\u0447\u0435\u043d\u043d\u044f \u0437 \u0432\u0435\u043b\u0438\u043a\u043e\u0457 \u043b\u0456\u0442\u0435\u0440\u0438"), new Rule.PatternRule("Style.EXCLAMATION_MARK", "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u0437\u043d\u0430\u043a\u0430 \u043e\u043a\u043b\u0438\u043a\u0443", "\u041d\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 \u0437\u043d\u0430\u043a\u0438 \u043e\u043a\u043b\u0438\u043a\u0443.", null, CommonPatterns.exclamationMark(EXCLAMATION_MARK, NodePattern.or(new NodePattern[0])), new Example("\u0411\u0443\u0434\u0435\u043c\u043e \u0440\u0430\u0434\u0456 \u0432\u0430\u0441 <b>\u0431\u0430\u0447\u0438\u0442\u0438!</b>", EXCLAMATION_MARK, "\u0411\u0443\u0434\u0435\u043c\u043e \u0440\u0430\u0434\u0456 \u0432\u0430\u0441 \u0431\u0430\u0447\u0438\u0442\u0438<b>.</b>")).styleFlavor(StyleFlavor.Formality).disableByDefault(), new Rule.PatternRule("Style.EXPRESSIVE_PUNCTUATION", "\u041d\u0430\u0434\u043c\u0456\u0440\u043d\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u0435\u043a\u0441\u043f\u0440\u0435\u0441\u0438\u0432\u043d\u0438\u0445 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0445 \u0437\u043d\u0430\u043a\u0456\u0432", "\u0423\u043d\u0438\u043a\u0430\u0439\u0442\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u043a\u0456\u043b\u044c\u043a\u043e\u0445 \u0440\u043e\u0437\u0434\u0456\u043b\u043e\u0432\u0438\u0445 \u0437\u043d\u0430\u043a\u0456\u0432.", "https://ekadrovik.mcfr.ua/919754", CommonPatterns.expressivePunctuation(MULTI_EXCLAMATION, "\u0423\u043d\u0438\u043a\u0430\u0439\u0442\u0435 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u043a\u0456\u043b\u044c\u043a\u043e\u0445 \u0437\u043d\u0430\u043a\u0456\u0432 \u043f\u0438\u0442\u0430\u043d\u043d\u044f", MULTI_PUNCTUATION), new Example("<b>\u0414\u044f\u043a\u0443\u044e!!!</b>", MULTI_EXCLAMATION, "\u0414\u044f\u043a\u0443\u044e<b>!</b>"), new Example("\u0429\u043e \u0446\u0435 <b>\u043e\u0437\u043d\u0430\u0447\u0430\u0454?!</b>", MULTI_PUNCTUATION, "\u0429\u043e \u0446\u0435 \u043e\u0437\u043d\u0430\u0447\u0430\u0454<b>?</b>")).styleFlavor(StyleFlavor.Formality).disableByDefault(), new Rule.PatternRule("Style.SMILEY_OR_EMOJI_USE", "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u0441\u043c\u0430\u0439\u043b\u0438\u043a\u0456\u0432 \u0430\u0431\u043e \u0435\u043c\u043e\u0434\u0437\u0456", "\u0421\u043c\u0430\u0439\u043b\u0438\u043a\u0438 \u0442\u0430 \u0435\u043c\u043e\u0434\u0437\u0456 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u044e\u0442\u044c\u0441\u044f \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0456 \u0435\u043c\u043e\u0446\u0456\u0439 \u0430\u0431\u043e \u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044f. \u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0454\u0442\u044c\u0441\u044f \u0443\u043d\u0438\u043a\u0430\u0442\u0438 \u0457\u0445 \u0432\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u0430\u043d\u043d\u044f \u0432 \u043e\u0444\u0456\u0446\u0456\u0439\u043d\u043e\u043c\u0443 \u043f\u0438\u0441\u044c\u043c\u0456.", "http://www.nrcu.gov.ua/news.html?newsID=90970", NodePattern.or(CommonPatterns.smileyUse(SMILEY_USE_MSG), CommonPatterns.emojiUse(EMOJI_USE_MSG)), new Example("\u0412\u0438 \u0432\u0441\u0456 \u2014 \u0444\u0430\u043d\u0442\u0430\u0441\u0442\u0438\u0447\u043d\u0456<b> \ud83d\udca5</b>", EMOJI_USE_MSG, "\u0412\u0438 \u0432\u0441\u0456 \u2014 <b>\u0444\u0430\u043d\u0442\u0430\u0441\u0442\u0438\u0447\u043d\u0456</b>"), new Example("\u0426\u0435 \u0432\u0430\u0433\u043e\u043c\u0438\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0449\u043e\u0431 \u043f\u043e\u0447\u0430\u0442\u0438<b>:)</b>", SMILEY_USE_MSG, "\u0426\u0435 \u0432\u0430\u0433\u043e\u043c\u0438\u0439 \u0430\u0440\u0433\u0443\u043c\u0435\u043d\u0442 \u0449\u043e\u0431 <b>\u043f\u043e\u0447\u0430\u0442\u0438</b>")).styleFlavor(StyleFlavor.Formality).disableByDefault());
    }

    private static NodePattern russianCalque() {
        return NodePattern.or(StyleRules.simpleCalques(), StyleRules.bilshe(), StyleRules.prijmatyBraty(), StyleRules.vygladati(), StyleRules.naProtyazi(), StyleRules.vidnoshennya(), StyleRules.vChisli());
    }

    private static NodePattern naProtyazi() {
        return NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u043f\u0440\u043e\u0442\u044f\u0437\u0456").withDependent("nmod", NodePattern.N.lemma("\u0441\u0435\u043a\u0443\u043d\u0434\u0430|\u0445\u0432\u0438\u043b\u0438\u043d\u0430|\u0433\u043e\u0434\u0438\u043d\u0430|\u0434\u0435\u043d\u044c|\u0434\u043e\u0431\u0430|\u0442\u0438\u0436\u0434\u0435\u043d\u044c|\u043c\u0456\u0441\u044f\u0446\u044c|\u0440\u0456\u043a|\u0441\u0442\u043e\u0440\u0456\u0447\u0447\u044f")).directlyAfter(NodePattern.N.markAs("Na")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Na"), NodePointer.anchor(), "\u043f\u0440\u043e\u0442\u044f\u0433\u043e\u043c")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Na"), NodePointer.anchor(), "\u0432\u043f\u0440\u043e\u0434\u043e\u0432\u0436")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Na"), NodePointer.anchor(), "\u0443\u043f\u0440\u043e\u0434\u043e\u0432\u0436")).message("\u041f\u0440\u043e \u0442\u0440\u0438\u0432\u0430\u043b\u0456\u0441\u0442\u044c \u0434\u0456\u0457 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0438\u0441\u0430\u0442\u0438 \u00ab\u043f\u0440\u043e\u0442\u044f\u0433\u043e\u043c\u00bb");
    }

    private static NodePattern simpleCalques() {
        return NodePattern.or(NodePattern.N.form("\u043e\u0441\u0442\u0430\u043d\u0456\u0432[\u043a\u0446]([\u0430\u0438\u0443\u0456]|\u043e\u044e|\u0430\u0445|\u0430\u043c)").message(ZUPYNKA_MSG).correct(NodeCorrector.regexReplace("\u043e\u0441\u0442\u0430\u043d\u0456\u0432(.*)", "\u0437\u0443\u043f\u0438\u043d$1")), NodePattern.N.form("\u043f\u043e\u0448\u043b\u0456\u043d([\u0430\u0438\u0443\u043e]|\u043e\u044e|\u0456)").message("\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u043e\u044e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0438\u0441\u0430\u0442\u0438 \u00ab\u043c\u0438\u0442\u043e\u00bb").and((node, match) -> {
            String femEnding = node.lowForm().substring(6);
            if (femEnding.equals("\u0456")) {
                return match.withCorrector(NodeCorrector.replace(node, List.of("\u043c\u0438\u0442\u0456", "\u043c\u0438\u0442\u0443")));
            }
            String mascEnding = femEnding.equals("\u0430") ? "\u043e" : (femEnding.equals("\u0438") ? "\u0430" : (femEnding.equals("\u0443") ? "\u043e" : (femEnding.equals("\u043e\u044e") ? "\u043e\u043c" : (femEnding.equals("\u043e") ? "\u043e" : ""))));
            return match.withCorrector(NodeCorrector.replace(node, "\u043c\u0438\u0442" + mascEnding));
        }), NodePattern.N.form("\u043f\u0456\u0434").includeIntoReport().directlyBefore(NodePattern.N.form("\u0440\u0435\u0434\u0430\u043a\u0446\u0456\u0454\u044e").withDependent("nmod").includeIntoReport()).message("\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u043e\u044e \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0438\u0441\u0430\u0442\u0438 \u00ab\u0437\u0430 \u0440\u0435\u0434\u0430\u043a\u0446\u0456\u0454\u044e\u00bb").correct(NodeCorrector.replace("\u0437\u0430")), NodePattern.or(NodePattern.N.inFormSequence(0, "[\u0432\u0443]", "\u043a\u0456\u043d\u0446\u0456", "\u043a\u0456\u043d\u0446\u0456\u0432").withNeighbor(2, NodePattern.N.markAs("End")), NodePattern.N.inFormSequence(0, "\u043a\u0456\u043d\u0435\u0446\u044c", "\u043a\u0456\u043d\u0446\u0456\u0432").withNeighbor(1, NodePattern.N.markAs("End")), NodePattern.N.inFormSequence(0, "\u043a\u0456\u043d\u0435\u0446\u044c", "-", "\u043a\u0456\u043d\u0446\u0456\u0432").withNeighbor(2, NodePattern.N.markAs("End")), NodePattern.N.inFormSequence(0, "[\u0432\u0443]", "\u043a\u0456\u043d\u0446\u0456", "-", "\u043a\u0456\u043d\u0446\u0456\u0432").withNeighbor(3, NodePattern.N.markAs("End"))).message(StyleRules.ukKrasce("\u0437\u0440\u0435\u0448\u0442\u043e\u044e")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "\u0437\u0440\u0435\u0448\u0442\u043e\u044e", "\u0443\u0440\u0435\u0448\u0442\u0456", "\u043a\u0456\u043d\u0435\u0446\u044c \u043a\u0456\u043d\u0446\u0435\u043c", "\u0443\u0440\u0435\u0448\u0442\u0456-\u0440\u0435\u0448\u0442")), NodePattern.N.form("\u0437\u0430\u043c\u0456\u0441\u0442\u044c").directlyBefore(NodePattern.N.form("\u0446\u044c\u043e\u0433\u043e").markAs("End")).message(StyleRules.ukKrasce("\u043d\u0430\u0442\u043e\u043c\u0456\u0441\u0442\u044c")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.marked("End"), "\u043d\u0430\u0442\u043e\u043c\u0456\u0441\u0442\u044c")), NodePattern.N.lemma("\u0437\u0443\u0441\u0442\u0440\u0456\u0447\u0430\u0442\u0438\u0441\u044f").withDependent("nsubj", NodePattern.N.form("\u0432\u0438\u043f\u0430\u0434\u043a\u0438")).message("\u0417 \u00ab\u0432\u0438\u043f\u0430\u0434\u043a\u0438\u00bb \u043a\u0440\u0430\u0449\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u00ab\u0442\u0440\u0430\u043f\u043b\u044f\u0442\u0438\u0441\u044f\u00bb").correct(StyleRules.changeVerbLemma("\u0442\u0440\u0430\u043f\u043b\u044f\u0442\u0438\u0441\u044f")), NodePattern.N.lemma("\u0432\u0456\u0434\u0432\u043e\u043b\u0456\u043a\u0430\u0442\u0438").withDependent("obj", NodePattern.N.form("\u0443\u0432\u0430\u0433\u0443")).message(StyleRules.ukKrasce("\u0432\u0456\u0434\u0432\u0435\u0440\u0442\u0430\u0442\u0438 \u0443\u0432\u0430\u0433\u0443")).correct(StyleRules.changeVerbLemma("\u0432\u0456\u0434\u0432\u0435\u0440\u0442\u0430\u0442\u0438")), NodePattern.N.lemma("\u043f\u0435\u0440\u0435\u043f\u0438\u0441\u0443\u0432\u0430\u0442\u0438\u0441\u044f").message(LISTUVATYSYA_MSG).correct(NodeCorrector.regexReplace("\u043f\u0435\u0440\u0435\u043f\u0438\u0441(.*)", "\u043b\u0438\u0441\u0442$1")), NodePattern.N.lemma("\u043d\u043e\u0441\u0438\u0442\u0438").withDependent("obj", NodePattern.N.lemma("\u043d\u0430\u0437\u0432\u0430|\u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440|\u0456\u043c'\u044f").markAs("Obj")).message(StyleRules.ukKrasce("\u043c\u0430\u0442\u0438 $Obj")).correct(StyleRules.changeVerbLemma("\u043c\u0430\u0442\u0438")), NodePattern.N.form("\u0432\u0441[\u0435\u0451]").withDependent("fixed", NodePattern.N.form("\u0440\u0456\u0432\u043d\u043e")).message(VSERIVNO_MSG).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "\u043e\u0434\u043d\u0430\u043a\u043e\u0432\u043e")), NodePattern.N.lemma("\u0432\u0435\u0441\u0442\u0438").withDependent("obj", NodePattern.N.form("\u043f\u0435\u0440\u0435\u043f\u0438\u0441\u043a\u0443").noDependents("amod|det").markAs("Perepis")).message(LISTUVATYSYA_MSG).and((node, match) -> {
            Node perepis = match.getMarkedNode("Perepis");
            return match.withCorrector(StyleRules.changeVerbLemma("\u043b\u0438\u0441\u0442\u0443\u0432\u0430\u0442\u0438\u0441\u044f").from("\u0432\u0435\u0441\u0442\u0438").corrector(node).join(NodeCorrector.removeNode(perepis)));
        }), NodePattern.N.lemma("\u0443\u044f\u0432\u043b\u044f.*|\u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u044f.*").andOr(NodePattern.N.withDependent("obl", NodePattern.N.form("\u0441\u0435\u0431\u0435").withDependent("case", NodePattern.N.form("\u0437\u0456|\u0437|\u0456\u0437").markAs("Z")).markAs("Sebe")).and((node, match) -> {
            NodeCorrector firstCorrector = node.hasPos("advp:.*") ? NodeCorrector.regexReplace(node, "(.*)\u0432\u043b\u044f(.*)", "\u044f\u0432\u043b\u044f$2") : StyleRules.changeVerbLemma("\u044f\u0432\u043b\u044f\u0442\u0438").corrector(node);
            return match.withCorrector(firstCorrector.join(NodeCorrector.replace(node.neighbor(2), "\u0441\u043e\u0431\u043e\u044e")).join(NodeCorrector.removeNode(node.neighbor(1))));
        }), NodePattern.N.withDependent("obl|parataxis:discourse", NodePattern.N.form("\u0441\u043e\u0431\u043e\u044e")).andOr(NodePattern.N.pos("advp:.*").correct(NodeCorrector.regexReplace("(.*)\u0432\u043b\u044f(.*)", "\u044f\u0432\u043b\u044f$2")), NodePattern.N.correct(StyleRules.changeVerbLemma("\u044f\u0432\u043b\u044f\u0442\u0438")))).reportEverythingTouched().message(PREDSTAVLYATY_MSG), NodePattern.N.lemma("\u0432\u0437\u0430\u0454\u043c\u043e(\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d\u0438|\u0441\u0442\u043e\u0441\u0443\u043d\u043e\u043a)").message("\u00ab$_\u00bb \u2013 \u0440\u043e\u0441\u0456\u044f\u043d\u0456\u0437\u043c, \u044f\u043a\u0438\u0439 \u0432 \u0443\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0456\u0439 \u043c\u043e\u0432\u0456 \u043a\u0440\u0430\u0449\u0435 \u043d\u0435 \u0432\u0436\u0438\u0432\u0430\u0442\u0438").correct(NodeCorrector.regexReplace("\u0432\u0437\u0430\u0454\u043c\u043e(.*)", "$1")), NodePattern.N.inFormSequence(0, "\u043e\u0434\u0438\u043d", "\u043d\u0430", "\u043e\u0434\u0438\u043d").andNot(NodePattern.N.withHead("obl|nmod", NodePattern.N.lemma(".*\u043a\u043b\u0430[\u0441\u0434].*|.*\u0441\u0442\u0430\u0432.*|\u043d\u0430\u043f\u043e\u0432\u0437.*|\u043d\u0430\u043d\u0438\u0437.*"))).message(StyleRules.ukKrasce("\u0441\u0430\u043c \u043d\u0430 \u0441\u0430\u043c")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "\u0441\u0430\u043c \u043d\u0430 \u0441\u0430\u043c")), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u0434\u0443\u0448\u0430\u043c").withHead("obl", NodePattern.N.lemma(".*(\u0433\u043e\u0432\u043e\u0440|\u043c\u043e\u0432|\u0431\u0430\u043b\u0430\u043a|\u0431\u0435\u0441\u0456\u0434).*")).message(StyleRules.ukKrasce("\u0449\u0438\u0440\u043e", "\u0432\u0456\u0434\u0432\u0435\u0440\u0442\u043e", "\u043f\u043e \u0449\u0438\u0440\u043e\u0441\u0442\u0456")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "\u0449\u0438\u0440\u043e")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "\u0432\u0456\u0434\u0432\u0435\u0440\u0442\u043e")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "\u043f\u043e \u0449\u0438\u0440\u043e\u0441\u0442\u0456")), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u0441\u0438\u043b\u0430\u0445").message(StyleRules.ukKrasce("\u043f\u0456\u0434 \u0441\u0438\u043b\u0443", "\u0434\u043e \u0441\u043d\u0430\u0433\u0438")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "\u043f\u0456\u0434 \u0441\u0438\u043b\u0443")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "\u0434\u043e \u0441\u043d\u0430\u0433\u0438")), naManir.message("\u041f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u043f\u0438\u0441\u0430\u0442\u0438 \u00ab\u043d\u0430 \u043c\u0430\u043d\u0456\u0440\u00bb").correct(NodeCorrector.replace("\u043c\u0430\u043d\u0456\u0440")));
    }

    private static NodePattern vygladati() {
        NodePattern adjv = NodePattern.N.pos("adj:.:v_oru.*|adv:compb.*");
        return NodePattern.N.lemma("\u0432\u0438\u0433\u043b\u044f\u0434\u0430\u0442\u0438").andOr(NodePattern.N.withDependent("xcomp:pred|appos", adjv.markAs("Marked")), NodePattern.N.withDependent("advmod", adjv.markAs("Marked").andNot(NodePattern.N.withNextSiblingIncludingOtherSide(NodePattern.N.withHeadRelation("advmod")))).noDependents("i?obj|obl")).message(VYGLYADATY_MSG).and((node, match) -> {
            Node adjvNode = match.getMarkedNode("Marked");
            boolean isAdj = adjvNode.hasPos("adj.*") && !adjvNode.hasPos("adv.*");
            List conjs = ((StreamEx)StreamEx.of(adjvNode.findDependents("conj")).takeWhile(adjv::matches)).toList();
            NodeCorrector adjvCorrector = isAdj ? NodeCorrector.inflect(adjvNode, "adj:.:v_oru(.*)", "adj:m:v_zna:rinanim$1") : NodeCorrector.regexReplace(adjvNode, "(.*)[\u0435\u043e]", "$1\u0438\u0439");
            for (Node conj : conjs) {
                adjvCorrector = isAdj ? adjvCorrector.join(NodeCorrector.inflect(conj, "adj:.:v_oru(.*)", "adj:m:v_zna:rinanim$1")) : adjvCorrector.join(NodeCorrector.regexReplace(conj, "(.*)[\u0435\u043e]", "$1\u0438\u0439"));
            }
            Node lastAdjv = conjs.isEmpty() ? adjvNode : (Node)conjs.get(conjs.size() - 1);
            List<String> maty = StyleRules.changeVerbLemma("\u043c\u0430\u0442\u0438").suggestions(node);
            NodeCorrector insVyglyad = NodeCorrector.insertAfter(lastAdjv, " \u0432\u0438\u0433\u043b\u044f\u0434");
            if (!isAdj && node.isAfter(adjvNode) && !maty.isEmpty()) {
                return match.withCorrector(adjvCorrector.join(NodeCorrector.insertBefore(adjvNode.phraseStart(), maty.get(0) + " ")).join(insVyglyad).join(NodeCorrector.removeNode(node)));
            }
            match = match.withCorrector(NodeCorrector.replace(node, maty).join(adjvCorrector).join(insVyglyad));
            return isAdj ? match.withCorrector(StyleRules.changeVerbLemma("\u0432\u0438\u0434\u0430\u0432\u0430\u0442\u0438\u0441\u044f").corrector(node)) : match;
        });
    }

    private static NodePattern prijmatyBraty() {
        return NodePattern.N.lemma("\u043f\u0440\u0438\u0439\u043c\u0430.*|\u043f\u0440\u0438\u0439\u043d\u044f.*").andOr(NodePattern.or(NodePattern.or(NodePattern.N.withDependent("obj", uchast), NodePattern.N.withHead("amod", uchast)).message(StyleRules.ukKrasce("\u0432\u0437\u044f\u0442\u0438 $Obj")), CommonPatterns.possiblySkipDown("advmod", doSerca).message(StyleRules.ukKrasce("\u0431\u0440\u0430\u0442\u0438 \u0434\u043e $Obl"))).andOr(NodePattern.N.pos("verb:rev:.*").correct(StyleRules.changeVerbLemma("\u0431\u0440\u0430\u0442\u0438\u0441\u044f")), NodePattern.N.pos("advp:.*").correct(NodeCorrector.regexReplace("\u043f\u0440\u0438\u0439\u043c\u0430\u044e(.*)", "\u0431\u0435\u0440\u0443$1")), NodePattern.N.correct(StyleRules.changeVerbLemma("\u0431\u0440\u0430\u0442\u0438"))).andOr(NodePattern.N.pos("verb:rev:.*").correct(StyleRules.changeVerbLemma("\u0432\u0437\u044f\u0442\u0438\u0441\u044f")), NodePattern.N.pos("adj:.*").correct(NodeCorrector.regexReplace("\u043f\u0440\u0438\u0439\u043d\u044f(.*)", "\u0432\u0437\u044f$1")), NodePattern.N.correct(StyleRules.changeVerbLemma("\u0432\u0437\u044f\u0442\u0438"))), NodePattern.or(NodePattern.N.withDependent("obj", miry).and((node, match) -> {
            NodeCorrector corrector = node.hasPos("advp:.*") ? NodeCorrector.regexReplace(node, "\u043f\u0440\u0438\u0439\u043c\u0430\u044e(.*)", "\u0432\u0436\u0438\u0432\u0430\u044e$1") : (node.hasPos("adj:.*") ? NodeCorrector.regexReplace(node, "\u043f\u0440\u0438\u0439\u043c\u0430\u044e(.*)", "\u0432\u0436\u0438\u0432\u0430\u044e$1") : StyleRules.changeVerbLemma("\u0432\u0436\u0438\u0432\u0430\u0442\u0438").corrector(node));
            return match.withCorrector(corrector.join(NodeCorrector.replace(node.findDependents("obj").get(0), "\u0437\u0430\u0445\u043e\u0434\u0456\u0432")));
        }), NodePattern.N.withHead("amod", miry.markAs("Miry")).correct(NodeCorrector.replace("\u0432\u0436\u0438\u0442\u0456").join(NodeCorrector.replace(NodePointer.marked("Miry"), "\u0437\u0430\u0445\u043e\u0434\u0438")))).message(StyleRules.ukKrasce("\u0432\u0436\u0438\u0432\u0430\u0442\u0438 \u0437\u0430\u0445\u043e\u0434\u0456\u0432")), NodePattern.N.withDependent("obj", NodePattern.N.lemma("\u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u0430|\u0437\u0430\u043a\u043e\u043d|\u043a\u043e\u043d\u0441\u0442\u0438\u0442\u0443\u0446\u0456\u044e|\u0434\u0435\u043a\u043b\u0430\u0440\u0430\u0446\u0456\u044e|\u0432\u0435\u0440\u0434\u0438\u043a\u0442|\u043d\u0430\u043c\u0456\u0440").markAs("Obj")).message(StyleRules.ukKrasce("\u0443\u0445\u0432\u0430\u043b\u0438\u0442\u0438 $Obj")).correct(StyleRules.changeVerbLemma("\u0443\u0445\u0432\u0430\u043b\u0438\u0442\u0438")));
    }

    private static NodePattern vidnoshennya() {
        return NodePattern.N.lemma("\u0432\u0456\u0434\u043d\u043e\u0448\u0435\u043d\u043d\u044f").noDependents("amod", NodePattern.N.lemma("\u0441\u0438\u043d\u0442\u0430\u043a\u0441\u0438\u0447\u043d\u0438\u0439|\u0430\u0440\u0438\u0444\u043c\u0435\u0442\u0438\u0447\u043d\u0438\u0439|\u0437\u043e\u043b\u043e\u0442\u0438\u0439")).andNot(NodePattern.N.withHead("obj", NodePattern.N.lemma("\u043c\u0430\u0442\u0438")).inFormSequence(0, "\u0432\u0456\u0434\u043d\u043e\u0448\u0435\u043d\u043d\u044f", "\u0434\u043e")).andOr(NodePattern.N.withDependent("amod", NodePattern.N.lemma("\u0434\u0456\u043b\u043e\u0432\u0438\u0439|\u043e\u0441\u043e\u0431\u0438\u0441\u0442\u0438\u0439")).message(StyleRules.ukKrasce("\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d\u0438", "\u0441\u0442\u043e\u0441\u0443\u043d\u043a\u0438", "\u0432\u0437\u0430\u0454\u043c\u0438\u043d\u0438")).and(StyleRules.changeNnyaToNyEnding("\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d")).and(StyleRules.changeNnyaToOkEnding("\u0441\u0442\u043e\u0441\u0443\u043d")).and(StyleRules.changeNnyaToNyEnding("\u0432\u0437\u0430\u0454\u043c\u0438\u043d")), NodePattern.N.withDependent("amod", NodePattern.N.lemma("\u0440\u043e\u0434\u0438\u043d\u043d\u0438\u0439")).message(StyleRules.ukKrasce("\u0432\u0437\u0430\u0454\u043c\u0438\u043d\u0438")).and(StyleRules.changeNnyaToNyEnding("\u0432\u0437\u0430\u0454\u043c\u0438\u043d")), NodePattern.or(NodePattern.N.withDependent("amod", NodePattern.N.lemma("\u043f\u043e\u0437\u0430\u0448\u043b\u044e\u0431\u043d\u0438\u0439|\u043c\u0456\u0436\u0434\u0435\u0440\u0436\u0430\u0432\u043d\u0438\u0439|\u0440\u043e\u043c\u0430\u043d\u0442\u0438\u0447\u043d\u0438\u0439|\u0441\u0456\u043c\u0435\u0439\u043d\u0438\u0439")), NodePattern.N.withHead(NodePattern.N.lemma("\u0437'\u044f\u0441\u043e\u0432\u0443\u0432\u0430\u0442\u0438"))).message(StyleRules.ukKrasce("\u0441\u0442\u043e\u0441\u0443\u043d\u043a\u0438")).and(StyleRules.changeNnyaToOkEnding("\u0441\u0442\u043e\u0441\u0443\u043d")), NodePattern.N.pos(".*:p:.*").directlyBefore(NodePattern.N.form("\u0434\u043e")).message(StyleRules.ukKrasce("\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u043d\u044f")).correct(NodeCorrector.regexReplace("\u0432\u0456\u0434\u043d\u043e\u0448\u0435\u043d(.*)", "\u0441\u0442\u0430\u0432\u043b\u0435\u043d$1")), NodePattern.N.inFormSequence(2, "[\u0432\u0443]", "\u0431\u0430\u0433\u0430\u0442\u044c\u043e\u0445|[\u0432\u0443]\u0441\u0456\u0445", "\u0432\u0456\u0434\u043d\u043e\u0448\u0435\u043d\u043d\u044f\u0445").message(StyleRules.ukKrasce("\u0437 \u0443\u0441\u0456\u0445 \u0431\u043e\u043a\u0456\u0432", "\u0437 \u0443\u0441\u044f\u043a\u043e\u0433\u043e \u043f\u043e\u0433\u043b\u044f\u0434\u0443", "\u0443 \u0432\u0441\u044c\u043e\u043c\u0443")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "\u0437 \u0443\u0441\u0456\u0445 \u0431\u043e\u043a\u0456\u0432")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "\u0437 \u0443\u0441\u044f\u043a\u043e\u0433\u043e \u043f\u043e\u0433\u043b\u044f\u0434\u0443")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "\u0443 \u0432\u0441\u044c\u043e\u043c\u0443")), NodePattern.N.inFormSequence(2, "[\u0432\u0443]", "\u0434\u0435\u044f\u043a\u0438\u0445|\u043f\u0435\u0432\u043d\u0438\u0445|\u0440\u0456\u0437\u043d\u0438\u0445", "\u0432\u0456\u0434\u043d\u043e\u0448\u0435\u043d\u043d\u044f\u0445").message(StyleRules.ukKrasce("\u0437 \u0434\u0435\u044f\u043a\u0438\u0445 \u0431\u043e\u043a\u0456\u0432", "\u0437 \u0434\u0435\u044f\u043a\u043e\u0433\u043e \u043f\u043e\u0433\u043b\u044f\u0434\u0443")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "\u0437 \u0434\u0435\u044f\u043a\u0438\u0445 \u0431\u043e\u043a\u0456\u0432")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "\u0437 \u0434\u0435\u044f\u043a\u043e\u0433\u043e \u043f\u043e\u0433\u043b\u044f\u0434\u0443")), NodePattern.N.form("\u0432\u0456\u0434\u043d\u043e\u0448\u0435\u043d\u043d\u0456").withNeighbor(-2, NodePattern.N.form("[\u0432\u0443]")).andOr(NodePattern.N.directlyAfter(NodePattern.N.form("(\u0435\u043a\u043e\u043b\u043e\u0433\u0456\u0447\u043d\u043e|\u043f\u0440\u0430\u043a\u0442\u0438\u0447\u043d\u043e|\u0442\u0435\u0445\u043d\u0456\u0447\u043d\u043e|\u0445\u0443\u0434\u043e\u0436\u043d\u044c\u043e|\u0456\u043d\u0436\u0435\u043d\u0435\u0440\u043d\u043e)\u043c\u0443")).message(StyleRules.ukKrasce("\u0437 \u043f\u043e\u0433\u043b\u044f\u0434\u0443")).correct(NodeCorrector.replace(NodePointer.neighbor(-2), "\u0437").join(NodeCorrector.regexReplace(NodePointer.neighbor(-1), "(.*)\u043c\u0443", "$1\u0433\u043e")).join(NodeCorrector.replace("\u043f\u043e\u0433\u043b\u044f\u0434\u0443"))), NodePattern.N.directlyAfter(NodePattern.N.form("(\u0430\u0434\u043c\u0456\u043d\u0456\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e|\u0435\u043a\u043e\u043d\u043e\u043c\u0456\u0447\u043d\u043e|\u043a\u0443\u043b\u044c\u0442\u0443\u0440\u043d\u043e|\u043f\u043e\u043b\u0456\u0442\u0438\u0447\u043d\u043e|\u0441\u043e\u0446\u0456\u0430\u043b\u044c\u043d\u043e)\u043c\u0443").markAs("Adj")).message(StyleRules.ukKrasce("\u0432 $Adj \u043f\u043b\u0430\u043d\u0456")).correct(NodeCorrector.replace("\u043f\u043b\u0430\u043d\u0456")), NodePattern.N.directlyAfter(NodePattern.N.form("\u043a\u0456\u043b\u044c\u043a\u0456\u0441\u043d\u043e\u043c\u0443")).message(StyleRules.ukKrasce("\u043a\u0456\u043b\u044c\u043a\u0456\u0441\u043d\u043e")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-2), NodePointer.anchor(), "\u043a\u0456\u043b\u044c\u043a\u0456\u0441\u043d\u043e"))), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u0432\u0456\u0434\u043d\u043e\u0448\u0435\u043d\u043d\u044e", "\u0434\u043e").withHeadRelation("obl|root").message(StyleRules.ukKrasce("\u0441\u0442\u043e\u0441\u043e\u0432\u043d\u043e", "\u0449\u043e\u0434\u043e")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "\u0441\u0442\u043e\u0441\u043e\u0432\u043d\u043e")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.neighbor(1), "\u0449\u043e\u0434\u043e")), NodePattern.N.pos(".*:p:.*").message(StyleRules.ukKrasce("\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d\u0438")).and(StyleRules.changeNnyaToNyEnding("\u0432\u0456\u0434\u043d\u043e\u0441\u0438\u043d")));
    }

    private static NodePattern changeNnyaToNyEnding(String newStem) {
        return NodePattern.custom((node, match) -> {
            String nyaEnding = node.lowForm().substring(8);
            String nyEnding = nyaEnding.equals("\u043d\u044f") ? "\u0438" : (nyaEnding.equals("\u044c") ? "" : (nyaEnding.equals("\u043d\u044f\u043c") ? "\u0430\u043c" : (nyaEnding.equals("\u043d\u044f\u043c\u0438") ? "\u0430\u043c\u0438" : (nyaEnding.equals("\u043d\u044f\u0445") ? "\u0430\u0445" : ""))));
            return match.withCorrector(NodeCorrector.replace(node, newStem + nyEnding));
        });
    }

    private static NodePattern changeNnyaToOkEnding(String newStem) {
        return NodePattern.custom((node, match) -> {
            String nyaEnding = node.lowForm().substring(8);
            String okEnding = nyaEnding.equals("\u043d\u044f") ? "\u043a\u0438" : (nyaEnding.equals("\u044c") ? "\u043a\u0456\u0432" : (nyaEnding.equals("\u043d\u044f\u043c") ? "\u043a\u0430\u043c" : (nyaEnding.equals("\u043d\u044f\u043c\u0438") ? "\u043a\u0430\u043c\u0438" : (nyaEnding.equals("\u043d\u044f\u0445") ? "\u043a\u0430\u0445" : ""))));
            return match.withCorrector(NodeCorrector.replace(node, newStem + okEnding));
        });
    }

    private static ChangeLemma changeVerbLemma(String toLemma) {
        return ChangeLemma.to(toLemma).transformPos(pos -> pos.startsWith("verb:perf") ? ".*" + pos.substring("verb:perf".length()) : (pos.startsWith("verb:imperf") ? ".*" + pos.substring("verb:imperf".length()) : pos));
    }

    private static NodePattern vybachayus() {
        return NodePattern.N.form("\u0432\u0438\u0431\u0430\u0447\u0430\u044e\u0441[\u044c\u044f]").message(VYBACHAYUS_MSG).noDependents("nsubj").correct(NodeCorrector.replace("\u043f\u0435\u0440\u0435\u043f\u0440\u043e\u0448\u0443\u044e", "\u0432\u0438\u0431\u0430\u0447\u0442\u0435 \u043c\u0435\u043d\u0456", "\u043f\u0440\u043e\u0431\u0430\u0447\u0442\u0435", "\u0434\u0430\u0440\u0443\u0439\u0442\u0435"));
    }

    private static NodePattern bilshayaPolovina() {
        return NodePattern.N.lemma("\u043f\u043e\u043b\u043e\u0432\u0438\u043d\u0430").andOr(NodePattern.N.withDependent("amod", NodePattern.N.lemma("\u0431\u0456\u043b\u044c\u0448\u0438\u0439").markAs("Bilshaya")).correct(NodeCorrector.regexReplace("\u043f\u043e\u043b\u043e\u0432\u0438\u043d(.*)", "\u0447\u0430\u0441\u0442\u0438\u043d$1")).correct(NodeCorrector.replace(NodePointer.marked("Bilshaya"), "\u0431\u0456\u043b\u044c\u0448 \u043d\u0456\u0436")), NodePattern.N.withDependent("amod", NodePattern.N.lemma("\u043c\u0435\u043d\u0448\u0438\u0439")).correct(NodeCorrector.regexReplace("\u043f\u043e\u043b\u043e\u0432\u0438\u043d(.*)", "\u0447\u0430\u0441\u0442\u0438\u043d$1"))).message(POLOVYNA_MSG).reportEverythingTouched();
    }

    private static NodePattern bilshe() {
        return NodePattern.N.form("\u0431\u0456\u043b\u044c\u0448\u0435").message(PONAD_MSG).directlyBefore(NodePattern.or(NodePattern.N.pos("numr:.*:v_rod.*|number").noLemma("\u043e\u0434\u0438\u043d"), NodePattern.N.lemma("\u0441\u0435\u043a\u0443\u043d\u0434\u0430|\u0445\u0432\u0438\u043b\u0438\u043d\u0430|\u0433\u043e\u0434\u0438\u043d\u0430|\u0434\u0435\u043d\u044c|\u0434\u043e\u0431\u0430|\u0442\u0438\u0436\u0434\u0435\u043d\u044c|\u043c\u0456\u0441\u044f\u0446\u044c|\u0440\u0456\u043a|\u0441\u0442\u043e\u0440\u0456\u0447\u0447\u044f").pos("noun:.*:v_rod.*").noDependents("nummod(:gov)?"), NodePattern.N.form("\\$").directlyBefore(NodePattern.N.pos("number")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("\u043d\u0435"))).and((node, match) -> {
            List correctors = List.of(NodeCorrector.replace(node, "\u043f\u043e\u043d\u0430\u0434"), NodeCorrector.replace(node, "\u0431\u0456\u043b\u044c\u0448 \u044f\u043a"), NodeCorrector.replace(node, "\u0431\u0456\u043b\u044c\u0448\u0435 \u043d\u0456\u0436"));
            Node next = Objects.requireNonNull(node.nextNode());
            if (next.hasPos("numr.*")) {
                correctors = StreamEx.of(correctors).map(c -> c.join(NodeCorrector.inflect(next, "(.*):v_rod(.*)", "$1:v_naz$2"))).toList();
            } else if (next.hasPos("noun.*")) {
                correctors = StreamEx.of(correctors).map(c -> c.join(NodeCorrector.inflect(next, "(.*):v_rod(.*)", "$1:v_zna$2"))).toList();
            }
            return match.withCorrectors(correctors);
        });
    }

    private static NodePattern vChisli() {
        return NodePattern.N.andNot(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("flat:title").directlyAfterHead())).andOr(NodePattern.N.inFormSequence(1, "[\u0432\u0443]", "\u0447\u0438\u0441\u043b\u0456").message(StyleRules.ukKrasce("\u0441\u0435\u0440\u0435\u0434")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "\u0441\u0435\u0440\u0435\u0434")), NodePattern.N.inFormSequence(1, "\u0456?\u0437|\u0437\u0456", "\u0447\u0438\u0441\u043b\u0430").message(StyleRules.ukKrasce("\u0437-\u043f\u043e\u043c\u0456\u0436")).correct(NodeCorrector.replaceNodes(NodePointer.neighbor(-1), NodePointer.anchor(), "\u0437-\u043f\u043e\u043c\u0456\u0436")), NodePattern.N.inFormSequence(0, "[\u0432\u0443]", "\u0442\u043e\u043c\u0443", "\u0447\u0438\u0441\u043b\u0456").message(StyleRules.ukKrasce("\u0437\u043e\u043a\u0440\u0435\u043c\u0430")).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(2), "\u0437\u043e\u043a\u0440\u0435\u043c\u0430")));
    }
}

