/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.vale;

import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.util.YamlParsingUtil;
import ai.grazie.rules.vale.CapitalizationRule;
import ai.grazie.rules.vale.YamlBasedRule;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.yaml.snakeyaml.composer.Composer;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public class YamlRuleParser {
    private static final Match MATCH = new Match(null, null, false, null, null, Match.CaseConversion.PRESERVE, false, false, Match.IncludeRange.NONE);
    private final String filePath;
    @Nullable
    private final JLanguageTool lt;

    public YamlRuleParser(@NotNull String filePath, @Nullable JLanguageTool lt) {
        this.filePath = filePath;
        this.lt = lt;
    }

    @NotNull
    public List<YamlBasedRule> parseBundled(String resourcePath) {
        List<YamlBasedRule> list;
        block9: {
            InputStream stream = Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(resourcePath));
            try {
                List<YamlBasedRule> rules = this.parseRules(stream, StandardCharsets.UTF_8, e -> {
                    throw new RuntimeException((Throwable)e);
                });
                if (rules.isEmpty()) {
                    throw new IllegalStateException("No rules in " + resourcePath);
                }
                list = rules;
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException(e2);
                }
            }
            stream.close();
        }
        return list;
    }

    @NotNull
    public List<YamlBasedRule> parseRules(@NotNull InputStream stream, Charset charset, Consumer<Throwable> exceptionHandler) {
        Composer composer = YamlParsingUtil.parseYaml(stream, charset);
        ArrayList<YamlBasedRule> rules = new ArrayList<YamlBasedRule>();
        while (composer.checkNode()) {
            Map<String, Node> map2;
            String message;
            Node node = composer.getNode();
            if (!(node instanceof MappingNode) || (message = YamlParsingUtil.asScalar((map2 = YamlParsingUtil.asMap((MappingNode)node)).get("message"))) == null) continue;
            String kind = YamlParsingUtil.asScalar(map2.get("extends"));
            try {
                rules.addAll("substitution".equals(kind) ? this.parseSubstitution(map2, message) : ("existence".equals(kind) ? this.parseExistence(map2, message) : ("sequence".equals(kind) ? this.parseSequence(node, map2, message) : ("conditional".equals(kind) ? this.parseConditional(node, map2, message) : ("occurrence".equals(kind) ? this.parseOccurrence(node, map2, message) : ("capitalization".equals(kind) ? this.parseCapitalization(node, map2, message) : Collections.emptyList()))))));
            }
            catch (EmptyRegexpException emptyRegexpException) {
            }
            catch (Throwable e) {
                exceptionHandler.accept(e);
            }
        }
        return rules;
    }

    private Collection<? extends YamlBasedRule> parseCapitalization(Node node, Map<String, Node> rule, String message) {
        if (this.lt == null) {
            throw new IllegalArgumentException("'capitalization' rules are not supported in language-independent code styles");
        }
        String match = YamlParsingUtil.asScalar(rule.get("match"));
        if (match == null) {
            return List.of();
        }
        String style = YamlParsingUtil.asScalar(rule.get("style"));
        Predicate<String> isException = YamlRuleParser.exceptionPredicate(rule);
        List<String> indicators = YamlParsingUtil.getStrings(rule.get("indicators"));
        return List.of(new CapitalizationRule(new YamlBasedRule.MetaData(this.filePath, rule), node, match, message, isException, style, indicators, this.lt));
    }

    private static Predicate<String> exceptionPredicate(Map<String, Node> rule) {
        Node exceptionNode = rule.get("exceptions");
        return exceptionNode instanceof SequenceNode ? YamlRuleParser.compilePattern(rule, String.join((CharSequence)"|", YamlParsingUtil.getStrings(exceptionNode))).asMatchPredicate() : __ -> false;
    }

    private Collection<? extends YamlBasedRule> parseConditional(Node node, Map<String, Node> rule, String message) {
        final Pattern definition = YamlRuleParser.compilePattern(rule, YamlParsingUtil.asScalar(rule.get("second")));
        YamlBasedRule.MetaData meta = new YamlBasedRule.MetaData(this.filePath, rule);
        final RegexMatcher usage = new RegexMatcher(YamlRuleParser.compilePattern(rule, YamlParsingUtil.asScalar(rule.get("first"))), String.format(message, "\\0"), true, List.of(), meta);
        final Predicate<String> isException = YamlRuleParser.exceptionPredicate(rule);
        return List.of(new YamlBasedRule.WholeFileRule(meta, node){

            @Override
            public Map<String, List<YamlBasedRule.RuleMatch>> checkFile(List<String> texts) {
                HashSet<String> defined = new HashSet<String>();
                for (String text2 : texts) {
                    Matcher matcher = definition.matcher(text2);
                    while (matcher.find()) {
                        defined.add(matcher.group(1));
                    }
                }
                HashMap<String, List<YamlBasedRule.RuleMatch>> result2 = new HashMap<String, List<YamlBasedRule.RuleMatch>>();
                for (String text3 : texts) {
                    if (result2.containsKey(text3)) continue;
                    for (YamlBasedRule.RuleMatch match : usage.check(text3)) {
                        String matched = text3.substring(match.start(), match.end());
                        if (defined.contains(matched) || isException.test(matched)) continue;
                        result2.computeIfAbsent(text3, __ -> new ArrayList()).add(match);
                    }
                }
                return result2;
            }
        });
    }

    private Collection<? extends YamlBasedRule> parseOccurrence(Node node, Map<String, Node> rule, String message) {
        Node minNode = rule.get("min");
        Node maxNode = rule.get("max");
        final int min = minNode != null ? Integer.parseInt(YamlParsingUtil.asScalar(minNode)) : 0;
        final int max = maxNode != null ? Integer.parseInt(YamlParsingUtil.asScalar(maxNode)) : 0;
        YamlBasedRule.MetaData meta = new YamlBasedRule.MetaData(this.filePath, rule);
        final RegexMatcher single = new RegexMatcher(YamlRuleParser.compilePattern(rule, YamlParsingUtil.asScalar(rule.get("token"))), message, true, List.of(), meta);
        return List.of(new YamlBasedRule(meta, node){

            @Override
            public List<YamlBasedRule.RuleMatch> check(String text2) {
                List<YamlBasedRule.RuleMatch> matches = single.check(text2);
                return !matches.isEmpty() && (matches.size() < min || matches.size() > max) ? List.of(matches.get(0)) : List.of();
            }
        });
    }

    private List<? extends YamlBasedRule> parseSubstitution(Map<String, Node> rule, String message) {
        Node swap = rule.get("swap");
        if (!(swap instanceof MappingNode)) {
            return Collections.emptyList();
        }
        return ((StreamEx)StreamEx.of((Collection)((MappingNode)swap).getValue()).map(e -> {
            try {
                String regexp = ((ScalarNode)e.getKeyNode()).getValue();
                if (regexp.isEmpty()) {
                    return null;
                }
                Pattern pattern = YamlRuleParser.compilePattern(rule, regexp);
                List replacements = ((StreamEx)StreamEx.of((Object[])((ScalarNode)e.getValueNode()).getValue().split("\\|")).filter(s -> !s.isEmpty())).toList();
                return new RegexMatcher(pattern, String.format(message, String.join((CharSequence)" or ", replacements), "\\0"), YamlRuleParser.asBoolean((Node)rule.get("nonword")), replacements, new YamlBasedRule.MetaData(this.filePath, rule)).toRule(e.getKeyNode());
            }
            catch (Throwable ex) {
                return null;
            }
        }).filter(Objects::nonNull)).toList();
    }

    private static Pattern compilePattern(Map<String, Node> rule, String regexp) {
        int flags = 8;
        if (YamlRuleParser.shouldIgnoreCase(rule)) {
            flags |= 0x42;
        }
        return Pattern.compile(regexp, flags);
    }

    private static boolean shouldIgnoreCase(Map<String, Node> rule) {
        return YamlRuleParser.asBoolean(rule.get("ignorecase"));
    }

    private static boolean asBoolean(Node node) {
        return "true".equals(YamlParsingUtil.asScalar(node));
    }

    private List<? extends YamlBasedRule> parseExistence(Map<String, Node> rule, String message) {
        Node raw = rule.get("raw");
        Node tokens = rule.get("tokens");
        List<String> rawStrings = YamlParsingUtil.getStrings(raw);
        String rawRegexp = rawStrings.isEmpty() ? "" : "(?:" + String.join((CharSequence)"", rawStrings) + ")";
        boolean nonWord = YamlRuleParser.asBoolean(rule.get("nonword"));
        boolean append = YamlRuleParser.asBoolean(rule.get("append"));
        YamlBasedRule.MetaData meta = new YamlBasedRule.MetaData(this.filePath, rule);
        String ltMessage = String.format(message, "\\0");
        if (tokens instanceof SequenceNode) {
            return ((StreamEx)StreamEx.of((Collection)((SequenceNode)tokens).getValue()).map(e -> {
                try {
                    String token = YamlParsingUtil.asScalar(e);
                    if (token.isEmpty()) {
                        return null;
                    }
                    Object regexp = token;
                    regexp = append ? (String)regexp + rawRegexp : rawRegexp + (String)regexp;
                    return new RegexMatcher(YamlRuleParser.compilePattern(rule, (String)regexp), ltMessage, nonWord, List.of(), meta).toRule((Node)e);
                }
                catch (Throwable ex) {
                    return null;
                }
            }).filter(Objects::nonNull)).toList();
        }
        if (!rawRegexp.isEmpty()) {
            return List.of(new RegexMatcher(YamlRuleParser.compilePattern(rule, rawRegexp), ltMessage, nonWord, List.of(), meta).toRule(raw));
        }
        return List.of();
    }

    private List<YamlBasedRule> parseSequence(Node ruleNode, Map<String, Node> rule, String message) {
        int index;
        if (this.lt == null) {
            throw new IllegalArgumentException("'sequence' rules are not supported in language-independent code styles");
        }
        message = ((String)message).replaceAll("%\\[(\\d)]s", "\\\\$1");
        int varIndex = 1;
        while ((index = ((String)message).indexOf("%s")) >= 0) {
            message = ((String)message).substring(0, index) + "\\" + varIndex + ((String)message).substring(index + 2);
            ++varIndex;
        }
        List tokens = StreamEx.of((Collection)((SequenceNode)rule.get("tokens")).getValue()).map(e -> {
            String skip;
            Map<String, Node> map2 = YamlParsingUtil.asMap((MappingNode)e);
            String plain = YamlParsingUtil.asScalar(map2.get("pattern"));
            String pos = YamlParsingUtil.asScalar(map2.get("tag"));
            PatternToken token = new PatternToken(plain != null ? plain : "", !YamlRuleParser.shouldIgnoreCase(rule), true, false);
            token.setNegation(YamlRuleParser.asBoolean(map2.get("negate")));
            if (pos != null) {
                token.setPosToken(new PatternToken.PosToken(pos, true, token.getNegation()));
            }
            if ((skip = YamlParsingUtil.asScalar(map2.get("skip"))) != null) {
                token.setSkipNext(Integer.parseInt(skip));
            }
            return token;
        }).toList();
        final PatternRule ltRule = new PatternRule("", this.lt.getLanguage(), tokens, "", (String)message, "");
        tokens.forEach(__ -> ltRule.addSuggestionMatch(MATCH));
        return List.of(new YamlBasedRule(new YamlBasedRule.MetaData(this.filePath, rule), ruleNode){

            @Override
            public List<YamlBasedRule.RuleMatch> check(String text2) {
                return 3.checkAnalyzedSentences(YamlRuleParser.this.lt, text2, sentence -> {
                    try {
                        return StreamEx.of((Object[])ltRule.match(sentence)).map(m -> YamlBasedRule.RuleMatch.fromLT(m, this.meta)).toList();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        });
    }

    private static class EmptyRegexpException
    extends RuntimeException {
        private EmptyRegexpException() {
        }
    }

    private record RegexMatcher(Pattern pattern, String message, boolean nonWord, List<String> replacements, YamlBasedRule.MetaData meta) {
        RegexMatcher {
            if (pattern.matcher("").matches()) {
                throw new EmptyRegexpException();
            }
        }

        List<YamlBasedRule.RuleMatch> check(String text2) {
            ArrayList<YamlBasedRule.RuleMatch> result2 = new ArrayList<YamlBasedRule.RuleMatch>();
            Matcher matcher = this.pattern.matcher(text2);
            while (matcher.find()) {
                int end;
                int start = matcher.start();
                String matched = text2.substring(start, end = matcher.end());
                if (this.replacements.contains(matched) || !this.nonWord && (RegexMatcher.isWordMiddle(text2, start) || RegexMatcher.isWordMiddle(text2, end))) continue;
                boolean caseInsensitive = (this.pattern.flags() & 2) != 0;
                List suggestions = StreamEx.of((Collection)this.meta.suggester.apply(matched)).append(this.replacements).map(s -> caseInsensitive ? TreeSupport.preserveCase(matched, s, null) : s).toList();
                result2.add(new YamlBasedRule.RuleMatch(start, end, this.message.replace("\\0", matched), suggestions));
            }
            return result2;
        }

        private static boolean isWordMiddle(String text2, int pos) {
            return pos > 0 && pos < text2.length() && RegexMatcher.isWordChar(text2.charAt(pos - 1)) && RegexMatcher.isWordChar(text2.charAt(pos));
        }

        private static boolean isWordChar(char c) {
            return c == '_' || Character.isLetterOrDigit(c);
        }

        YamlBasedRule toRule(Node anchorNode) {
            return new YamlBasedRule(this.meta, anchorNode){

                @Override
                public List<YamlBasedRule.RuleMatch> check(String text2) {
                    return this.check(text2);
                }
            };
        }
    }
}

