/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro;

import ai.grazie.nlp.langs.Language;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.detection.LangDetector;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.ide.msg.GrazieInitializerManager;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.ml.grazie.pro.GrazieProConfig;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.StringOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightingUtil {
    private static final Pattern COULD_BE_ENGLISH = Pattern.compile("([a-zA-Z]|[^\\p{L}])*+");
    public static final Comparator<TextContent> BY_TEXT_START = Comparator.comparing(tc -> tc.textOffsetToFile(0));
    private static final Pattern trackerIssuePrefix = Pattern.compile("\\s*([A-Z]\\w+-\\d+):?\\s+.*");

    public static boolean skipExpensivePrecommitAnalysis(PsiFile file) {
        for (PsiFile root : file.getViewProvider().getAllFiles()) {
            Function function = InspectionProfileWrapper.getCustomInspectionProfileWrapper((PsiFile)root);
            if (function == null || !function.getClass().getName().contains("com.intellij.codeInsight.daemon.impl.MainPassesRunner") || !Registry.is((String)"grazie.pro.in.ai.assistant.skip.precommit.checks")) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldEnableHighlighting(PsiFile file) {
        return HighlightingUtil.shouldEnableHighlighting(file.getProject(), file.getViewProvider().getVirtualFile());
    }

    public static boolean shouldEnableHighlighting(Project project, VirtualFile vFile) {
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
        return !fileIndex.isExcluded(vFile) && !fileIndex.isInLibrary(vFile);
    }

    public static Set<TextContent> findAllTextContents(FileViewProvider vp, Set<TextContent.TextDomain> domains) {
        HashSet<TextContent> allContents = new HashSet<TextContent>();
        for (PsiFile root : vp.getAllFiles()) {
            for (PsiElement element : SyntaxTraverser.psiTraverser((PsiElement)root)) {
                if (element.getFirstChild() != null) continue;
                allContents.addAll(TextExtractor.findTextsAt((PsiElement)element, domains));
            }
        }
        return allContents;
    }

    public static Set<TextContent.TextDomain> checkedDomains() {
        return GrazieInspection.Companion.checkedDomains();
    }

    public static List<TextRange> toFileRanges(TextContent text2, TextRange rangeInText) {
        return ContainerUtil.filter((Collection)text2.intersection(text2.textRangeToFile(rangeInText)), r -> !r.isEmpty());
    }

    public static List<TextRange> getFileHighlightRanges(TextProblem problem) {
        return ContainerUtil.flatMap((Iterable)problem.getHighlightRanges(), r -> HighlightingUtil.toFileRanges(problem.getText(), r));
    }

    static TextRange selectionRange(Editor editor) {
        return new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd());
    }

    public static <T> Map<PsiElement, List<Pair<TextRange, T>>> analyzeForAnnotator(TextContent text2, Key<Pair<Long, Map<PsiElement, List<Pair<TextRange, T>>>>> key, Supplier<List<Pair<TextRange, T>>> supplier) {
        long modCount = HighlightingUtil.grazieConfigTracker().getModificationCount();
        Pair cached = (Pair)text2.getUserData(key);
        if (cached == null || !((Long)cached.first).equals(modCount)) {
            cached = Pair.create((Object)modCount, HighlightingUtil.distributeByMinimalLeaves(text2, supplier.get()));
            text2.putUserData(key, (Object)cached);
        }
        return (Map)cached.second;
    }

    private static <T> Map<PsiElement, List<Pair<TextRange, T>>> distributeByMinimalLeaves(TextContent text2, List<Pair<TextRange, T>> data2) {
        HashMap<PsiElement, List<Pair<TextRange, T>>> result2 = new HashMap<PsiElement, List<Pair<TextRange, T>>>();
        for (Pair<TextRange, T> pair : data2) {
            TextRange range = (TextRange)pair.first;
            PsiElement minimal = (PsiElement)SyntaxTraverser.psiApi().parents((Object)text2.getContainingFile().findElementAt(range.getStartOffset())).find(e -> e.getTextRange().getEndOffset() >= range.getEndOffset());
            result2.computeIfAbsent(minimal, __ -> new ArrayList()).add(pair);
        }
        return result2;
    }

    public static ModificationTracker grazieConfigTracker() {
        GrazieConfig lite = (GrazieConfig)ApplicationManager.getApplication().getService(GrazieConfig.class);
        GrazieProConfig pro = GrazieProConfig.Companion.getInstance();
        return () -> lite.getModificationCount() + pro.getModificationCount();
    }

    public static boolean isTooLargeText(List<TextContent> texts) {
        return texts.stream().mapToInt(t -> t.length()).sum() > 50000;
    }

    public static void applyTextChanges(Document document, List<StringOperation> changes) {
        for (StringOperation r : (StreamEx)StreamEx.of(changes).sortedBy(c -> -c.getRange().getStartOffset())) {
            document.replaceString(r.getRange().getStartOffset(), r.getRange().getEndOffset(), r.getReplacement());
        }
    }

    @Nullable
    public static Lang activeEnglish() {
        return HighlightingUtil.findInstalledLang(Language.ENGLISH);
    }

    @Nullable
    public static Lang findInstalledLang(@NotNull Language language) {
        if (language == null) {
            HighlightingUtil.$$$reportNull$$$0(0);
        }
        return StreamEx.of((Collection)GrazieConfig.Companion.get().getAvailableLanguages()).findFirst(lang -> lang.getIso() == language.getIso()).orElse(null);
    }

    public static void addGrazieConfigListener(@NotNull Disposable parent, @NotNull GrazieStateLifecycle lifecycle) {
        if (parent == null) {
            HighlightingUtil.$$$reportNull$$$0(1);
        }
        if (lifecycle == null) {
            HighlightingUtil.$$$reportNull$$$0(2);
        }
        MessageBusConnection connection = ((GrazieInitializerManager)ApplicationManager.getApplication().getService(GrazieInitializerManager.class)).register(lifecycle);
        Disposer.register((Disposable)parent, (Disposable)connection);
    }

    @Nullable
    public static Language detectPreferringEnglish(String text2) {
        Language lang = LangDetector.INSTANCE.getLanguage(text2);
        if (lang != null && HighlightingUtil.findInstalledLang(lang) == null) {
            lang = null;
        }
        return lang == null && COULD_BE_ENGLISH.matcher(text2).matches() ? Language.ENGLISH : lang;
    }

    public static int stripPrefix(TextContent content) {
        int start = 0;
        String text2 = content.toString();
        if (CommitMessage.isCommitMessage((PsiElement)content.getContainingFile())) {
            if (text2.startsWith("[")) {
                int rBrace = text2.indexOf(93);
                if (rBrace >= 1 && rBrace <= 30) {
                    start = rBrace + 1;
                }
            } else {
                int colon = text2.indexOf(58);
                if (colon >= 1 && colon <= 30 && text2.substring(0, colon).chars().filter(Character::isWhitespace).count() <= 1L) {
                    start = colon + 1;
                }
            }
            Matcher issueMatch = trackerIssuePrefix.matcher(text2.substring(start));
            if (issueMatch.matches()) {
                start += issueMatch.group(1).length() + 1;
            }
        }
        while (start < content.length() && Character.isWhitespace(content.charAt(start))) {
            ++start;
        }
        return start;
    }

    public static List<TextContent> getCheckedFileTexts(FileViewProvider vp) {
        return (List)CachedValuesManager.getManager((Project)vp.getManager().getProject()).getCachedValue((UserDataHolder)vp, () -> {
            List contents = ContainerUtil.sorted(HighlightingUtil.findAllTextContents(vp, HighlightingUtil.checkedDomains()), BY_TEXT_START);
            return CachedValueProvider.Result.create((Object)contents, (Object[])new Object[]{vp.getAllFiles().get(0), HighlightingUtil.grazieConfigTracker()});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lifecycle";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ml/grazie/pro/HighlightingUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findInstalledLang";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addGrazieConfigListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

