/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.style;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.ml.grazie.pro.HighlightingUtil;
import com.intellij.ml.grazie.pro.style.StyleAnnotator;
import com.intellij.ml.grazie.pro.utils.GrazieUtilsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class StyleInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            StyleInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            StyleInspection.$$$reportNull$$$0(1);
        }
        if (GrazieUtilsKt.isFunctionallyDisabled()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                StyleInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        if (isOnTheFly) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                StyleInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        PsiFile file = holder.getFile();
        if (GrazieInspection.Companion.ignoreGrammarChecking(file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                StyleInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        final Set<TextContent.TextDomain> domains = HighlightingUtil.checkedDomains();
        final Function1 areChecksDisabled = GrazieInspection.getDisabledChecker((PsiFile)file);
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiWhiteSpace || ((Boolean)areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                List texts = TextExtractor.findUniqueTextsAt((PsiElement)element, (Set)domains);
                if (HighlightingUtil.isTooLargeText(texts)) {
                    return;
                }
                for (TextContent text2 : texts) {
                    PsiElement parent = text2.getCommonParent();
                    int parentStart = parent.getTextRange().getStartOffset();
                    for (Pair pair : ContainerUtil.flatten(StyleAnnotator.analyze(text2).values())) {
                        TextProblem problem = (TextProblem)pair.second;
                        LocalQuickFix[] fixes = StyleAnnotator.getReplacementFixes(problem).toArray(LocalQuickFix.EMPTY_ARRAY);
                        holder.registerProblem(parent, ((TextRange)pair.first).shiftLeft(parentStart), problem.getDescriptionTemplate(false), fixes);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ml/grazie/pro/style/StyleInspection$1", "visitElement"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ml/grazie/pro/style/StyleInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ml/grazie/pro/style/StyleInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

