/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.utils;

import com.intellij.openapi.util.TextRange;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000eH\u0007R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/grazie/pro/utils/TextUtils;", "", "<init>", "()V", "PUNCTUATIONS", "", "", "isNewline", "", "char", "", "isPunctuation", "isQuote", "alignToWordBounds", "Lcom/intellij/openapi/util/TextRange;", "textRange", "text", "", "expandToTouchWords", "range", "Latin", "intellij.ml.grazie.pro"})
public final class TextUtils {
    @NotNull
    public static final TextUtils INSTANCE = new TextUtils();
    @NotNull
    private static final Set<Byte> PUNCTUATIONS;

    private TextUtils() {
    }

    public final boolean isNewline(char c) {
        return c == '\n';
    }

    public final boolean isPunctuation(char c) {
        byte by = (byte)Character.getType(c);
        return PUNCTUATIONS.contains(by);
    }

    public final boolean isQuote(char c) {
        return c == '\'' || c == '\"';
    }

    @JvmStatic
    @NotNull
    public static final TextRange alignToWordBounds(@NotNull TextRange textRange, @NotNull CharSequence text2) {
        int end;
        int start;
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        for (start = textRange.getStartOffset(); start > 0 && TextUtils.alignToWordBounds$isWordChar(text2.charAt(start - 1)); --start) {
        }
        for (end = textRange.getEndOffset(); end < text2.length() && TextUtils.alignToWordBounds$isWordChar(text2.charAt(end)); ++end) {
        }
        return new TextRange(start, end);
    }

    @JvmStatic
    @NotNull
    public static final TextRange expandToTouchWords(@NotNull CharSequence text2, @NotNull TextRange range) {
        int start;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int end = range.getEndOffset();
        for (start = range.getStartOffset(); start > 0 && TextUtils.expandToTouchWords$shouldSkip(text2.charAt(start - 1)); --start) {
        }
        while (end < text2.length() && TextUtils.expandToTouchWords$shouldSkip(text2.charAt(end))) {
            ++end;
        }
        return new TextRange(start, end);
    }

    private static final boolean alignToWordBounds$isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '-';
    }

    private static final boolean expandToTouchWords$shouldSkip(char c) {
        return CharsKt.isWhitespace((char)c) || c == '\'' || c == '\"';
    }

    static {
        Object[] objectArray = new Byte[]{(byte)21, (byte)22, (byte)24, (byte)23, (byte)20, (byte)29, (byte)30};
        PUNCTUATIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ml/grazie/pro/utils/TextUtils$Latin;", "", "<init>", "()V", "endSentence", "", "", "partSentence", "isEndPunctuation", "", "symbol", "line", "", "isPartPunctuation", "intellij.ml.grazie.pro"})
    public static final class Latin {
        @NotNull
        public static final Latin INSTANCE = new Latin();
        @NotNull
        private static final Set<Character> endSentence;
        @NotNull
        private static final Set<Character> partSentence;

        private Latin() {
        }

        public final boolean isEndPunctuation(char symbol) {
            return endSentence.contains(Character.valueOf(symbol));
        }

        public final boolean isEndPunctuation(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return CollectionsKt.contains((Iterable)endSentence, (Object)StringsKt.lastOrNull((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()));
        }

        public final boolean isPartPunctuation(char symbol) {
            return partSentence.contains(Character.valueOf(symbol));
        }

        public final boolean isPartPunctuation(@NotNull String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return CollectionsKt.contains((Iterable)partSentence, (Object)StringsKt.lastOrNull((CharSequence)((Object)StringsKt.trim((CharSequence)line)).toString()));
        }

        static {
            Object[] objectArray = new Character[]{Character.valueOf('!'), Character.valueOf('?'), Character.valueOf('.')};
            endSentence = SetsKt.setOf((Object[])objectArray);
            objectArray = new Character[]{Character.valueOf(','), Character.valueOf(';')};
            partSentence = SetsKt.setOf((Object[])objectArray);
        }
    }
}

