/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.grazie.pro.yaml;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.en.EnglishToolkit;
import ai.grazie.rules.tree.TreeSupport;
import ai.grazie.rules.vale.YamlRuleSet;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.LangTool;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextProblem;
import com.intellij.ml.grazie.pro.DependencyParser;
import com.intellij.ml.grazie.pro.GrazieProConfig;
import com.intellij.ml.grazie.pro.HighlightingUtil;
import com.intellij.ml.grazie.pro.yaml.YamlRuleWrapper;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;

public class RuleEngineYamlChecker
extends TextChecker {
    public static final String ASSORTED_CATEGORY = "Assorted Style Guides";
    private static final Map<TreeSupport, List<YamlRuleWrapper>> rules = ContainerUtil.createConcurrentWeakMap();

    public static List<YamlRuleWrapper> enRules() {
        TreeSupport support = DependencyParser.obtainSupport(Language.ENGLISH);
        Lang lang = HighlightingUtil.activeEnglish();
        if (support == null || lang == null) {
            return List.of();
        }
        JLanguageTool tool = RuleEngineYamlChecker.getToolCancelable(lang);
        return rules.computeIfAbsent(support, __ -> ContainerUtil.map(EnglishToolkit.INSTANCE.publishedYamlRules(tool), RuleEngineYamlChecker::wrap));
    }

    public static JLanguageTool getToolCancelable(Lang lang) {
        try {
            return (JLanguageTool)ApplicationUtil.runWithCheckCanceled(() -> LangTool.INSTANCE.getTool(lang), (ProgressIndicator)EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Collection<? extends Rule> getRules(@NotNull Locale locale) {
        if (locale == null) {
            RuleEngineYamlChecker.$$$reportNull$$$0(0);
        }
        if (locale.getLanguage().equals("en")) {
            List<YamlRuleWrapper> list = RuleEngineYamlChecker.enRules();
            if (list == null) {
                RuleEngineYamlChecker.$$$reportNull$$$0(1);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            RuleEngineYamlChecker.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Collection<? extends TextProblem> check(@NotNull TextContent content) {
        if (content == null) {
            RuleEngineYamlChecker.$$$reportNull$$$0(3);
        }
        List list = Collections.emptyList();
        if (list == null) {
            RuleEngineYamlChecker.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static YamlRuleWrapper wrap(final YamlRuleSet set) {
        final List<String> categories = List.of("Style", ASSORTED_CATEGORY);
        return new YamlRuleWrapper(set.globalId(), set.displayName(), categories.get(0), set.rules(), set.messageSuffix()){

            public List<String> getCategories() {
                return categories;
            }

            @Override
            public boolean isBundled() {
                return true;
            }

            @NotNull
            public String getDescription() {
                String string = set.description();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean isEnabledByDefault() {
                return GrazieProConfig.get().getTextStyle().isRuleEnabled(this.getGlobalId(), () -> false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ml/grazie/pro/yaml/RuleEngineYamlChecker$1", "getDescription"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ml/grazie/pro/yaml/RuleEngineYamlChecker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ml/grazie/pro/yaml/RuleEngineYamlChecker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "check";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRules";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "check";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }
}

