/*
 * Decompiled with CFR 0.152.
 */
package net.fellbaum.jemoji;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.fellbaum.jemoji.Emoji;
import net.fellbaum.jemoji.EmojiGroup;
import net.fellbaum.jemoji.EmojiSubGroup;

public final class EmojiManager {
    private static final String PATH = "emoji_sources/emojis.json";
    private static final Map<String, Emoji> EMOJI_UNICODE_TO_EMOJI;
    private static final Map<Integer, List<Emoji>> EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING;
    private static final List<Emoji> EMOJIS_LENGTH_DESCENDING;
    private static final Pattern EMOJI_PATTERN;
    private static final Pattern NOT_WANTED_EMOJI_CHARACTERS;
    private static final Comparator<Emoji> EMOJI_CODEPOINT_COMPARATOR;

    private static Collector<Emoji, ?, LinkedHashMap<Integer, List<Emoji>>> getEmojiLinkedHashMapCollector() {
        return Collectors.groupingBy(emoji -> emoji.getEmoji().codePoints().toArray()[0], LinkedHashMap::new, Collectors.collectingAndThen(Collectors.toList(), list -> {
            list.sort(EMOJI_CODEPOINT_COMPARATOR);
            return list;
        }));
    }

    /*
     * Exception decompiling
     */
    private static String readFileAsString() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private EmojiManager() {
    }

    public static Optional<Emoji> getEmoji(String emoji) {
        if (EmojiManager.isStringNullOrEmpty(emoji)) {
            return Optional.empty();
        }
        return Optional.ofNullable(EMOJI_UNICODE_TO_EMOJI.get(emoji));
    }

    public static boolean isEmoji(String emoji) {
        if (EmojiManager.isStringNullOrEmpty(emoji)) {
            return false;
        }
        return EMOJI_UNICODE_TO_EMOJI.containsKey(emoji);
    }

    public static Set<Emoji> getAllEmojis() {
        return new HashSet<Emoji>(EMOJIS_LENGTH_DESCENDING);
    }

    public static Set<Emoji> getAllEmojisByGroup(EmojiGroup group) {
        return EMOJIS_LENGTH_DESCENDING.stream().filter(emoji -> emoji.getGroup() == group).collect(Collectors.toSet());
    }

    public static Set<Emoji> getAllEmojisBySubGroup(EmojiSubGroup subgroup) {
        return EMOJIS_LENGTH_DESCENDING.stream().filter(emoji -> emoji.getSubgroup() == subgroup).collect(Collectors.toSet());
    }

    public static List<Emoji> getAllEmojisLengthDescending() {
        return EMOJIS_LENGTH_DESCENDING;
    }

    public static Optional<Emoji> getByAlias(String alias) {
        if (EmojiManager.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        String aliasWithoutColon = EmojiManager.removeColonFromAlias(alias);
        String aliasWithColon = EmojiManager.addColonToAlias(alias);
        return EMOJI_UNICODE_TO_EMOJI.values().stream().filter(emoji -> emoji.getAllAliases().contains(aliasWithoutColon) || emoji.getAllAliases().contains(aliasWithColon)).findFirst();
    }

    public static Optional<Emoji> getByDiscordAlias(String alias) {
        if (EmojiManager.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        String aliasWithoutColon = EmojiManager.removeColonFromAlias(alias);
        String aliasWithColon = EmojiManager.addColonToAlias(alias);
        return EMOJI_UNICODE_TO_EMOJI.values().stream().filter(emoji -> emoji.getDiscordAliases().contains(aliasWithoutColon) || emoji.getDiscordAliases().contains(aliasWithColon)).findFirst();
    }

    public static Optional<Emoji> getByGithubAlias(String alias) {
        if (EmojiManager.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        String aliasWithoutColon = EmojiManager.removeColonFromAlias(alias);
        String aliasWithColon = EmojiManager.addColonToAlias(alias);
        return EMOJI_UNICODE_TO_EMOJI.values().stream().filter(emoji -> emoji.getGithubAliases().contains(aliasWithoutColon) || emoji.getGithubAliases().contains(aliasWithColon)).findFirst();
    }

    public static Optional<Emoji> getBySlackAlias(String alias) {
        if (EmojiManager.isStringNullOrEmpty(alias)) {
            return Optional.empty();
        }
        String aliasWithoutColon = EmojiManager.removeColonFromAlias(alias);
        String aliasWithColon = EmojiManager.addColonToAlias(alias);
        return EMOJI_UNICODE_TO_EMOJI.values().stream().filter(emoji -> emoji.getSlackAliases().contains(aliasWithoutColon) || emoji.getSlackAliases().contains(aliasWithColon)).findFirst();
    }

    private static String removeColonFromAlias(String alias) {
        return alias.startsWith(":") && alias.endsWith(":") ? alias.substring(1, alias.length() - 1) : alias;
    }

    private static String addColonToAlias(String alias) {
        return alias.startsWith(":") && alias.endsWith(":") ? alias : ":" + alias + ":";
    }

    public static Pattern getEmojiPattern() {
        return EMOJI_PATTERN;
    }

    public static boolean containsEmoji(String text2) {
        if (EmojiManager.isStringNullOrEmpty(text2)) {
            return false;
        }
        ArrayList emojis = new ArrayList();
        int[] textCodePointsArray = text2.codePoints().toArray();
        long textCodePointsLength = textCodePointsArray.length;
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            List<Emoji> emojisByCodePoint = EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.get(textCodePointsArray[textIndex]);
            if (emojisByCodePoint != null) {
                for (Emoji emoji : emojisByCodePoint) {
                    int[] emojiCodePointsArray = emoji.getEmoji().codePoints().toArray();
                    int emojiCodePointsLength = emojiCodePointsArray.length;
                    if ((long)(textIndex + emojiCodePointsLength) > textCodePointsLength) continue;
                    for (int i = 0; i < emojiCodePointsLength && textCodePointsArray[textIndex + i] == emojiCodePointsArray[i]; ++i) {
                        if (i != emojiCodePointsLength - 1) continue;
                        return true;
                    }
                }
            }
            ++textIndex;
        }
        return false;
    }

    public static List<Emoji> extractEmojisInOrder(String text2) {
        if (EmojiManager.isStringNullOrEmpty(text2)) {
            return Collections.emptyList();
        }
        ArrayList<Emoji> emojis = new ArrayList<Emoji>();
        int[] textCodePointsArray = text2.codePoints().toArray();
        long textCodePointsLength = textCodePointsArray.length;
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            int currentCodepoint = textCodePointsArray[textIndex];
            List<Emoji> emojisByCodePoint = EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.get(currentCodepoint);
            if (emojisByCodePoint != null) {
                block1: for (Emoji emoji : emojisByCodePoint) {
                    int[] emojiCodePointsArray = emoji.getEmoji().codePoints().toArray();
                    int emojiCodePointsLength = emojiCodePointsArray.length;
                    if ((long)(textIndex + emojiCodePointsLength) > textCodePointsLength) continue;
                    for (int emojiCodePointIndex = 0; emojiCodePointIndex < emojiCodePointsLength && textCodePointsArray[textIndex + emojiCodePointIndex] == emojiCodePointsArray[emojiCodePointIndex]; ++emojiCodePointIndex) {
                        if (emojiCodePointIndex != emojiCodePointsLength - 1) continue;
                        emojis.add(emoji);
                        textIndex += emojiCodePointsLength - 1;
                        break block1;
                    }
                }
            }
            ++textIndex;
        }
        return Collections.unmodifiableList(emojis);
    }

    public static Set<Emoji> extractEmojis(String text2) {
        return Collections.unmodifiableSet(new HashSet<Emoji>(EmojiManager.extractEmojisInOrder(text2)));
    }

    public static String removeAllEmojis(String text2) {
        return EmojiManager.removeAllEmojisExcept(text2, Collections.emptyList());
    }

    public static String removeEmojis(String text2, Emoji ... emojisToRemove) {
        return EmojiManager.removeEmojis(text2, Arrays.asList(emojisToRemove));
    }

    public static String removeEmojis(String text2, Collection<Emoji> emojisToRemove) {
        HashSet<Emoji> emojis = new HashSet<Emoji>(EMOJIS_LENGTH_DESCENDING);
        emojis.removeAll(emojisToRemove);
        return EmojiManager.removeAllEmojisExcept(text2, emojis);
    }

    public static String removeAllEmojisExcept(String text2, Emoji ... emojisToKeep) {
        return EmojiManager.removeAllEmojisExcept(text2, Arrays.asList(emojisToKeep));
    }

    public static String removeAllEmojisExcept(String text2, Collection<Emoji> emojisToKeep) {
        if (EmojiManager.isStringNullOrEmpty(text2)) {
            return "";
        }
        int[] textCodePointsArray = text2.codePoints().toArray();
        long textCodePointsLength = textCodePointsArray.length;
        StringBuilder sb = new StringBuilder();
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            int currentCodepoint = textCodePointsArray[textIndex];
            sb.appendCodePoint(currentCodepoint);
            List<Emoji> emojisByCodePoint = EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.get(currentCodepoint);
            if (emojisByCodePoint != null) {
                block1: for (Emoji emoji : emojisByCodePoint) {
                    int[] emojiCodePointsArray = emoji.getEmoji().codePoints().toArray();
                    int emojiCodePointsLength = emojiCodePointsArray.length;
                    if ((long)(textIndex + emojiCodePointsLength) > textCodePointsLength) continue;
                    for (int emojiCodePointIndex = 0; emojiCodePointIndex < emojiCodePointsLength && textCodePointsArray[textIndex + emojiCodePointIndex] == emojiCodePointsArray[emojiCodePointIndex]; ++emojiCodePointIndex) {
                        if (emojiCodePointIndex != emojiCodePointsLength - 1) continue;
                        textIndex += emojiCodePointsLength - 1;
                        sb.delete(sb.length() - Character.charCount(currentCodepoint), sb.length());
                        if (!emojisToKeep.contains(emoji)) break block1;
                        sb.append(emoji.getEmoji());
                        break block1;
                    }
                }
            }
            ++textIndex;
        }
        return sb.toString();
    }

    public static String replaceAllEmojis(String text2, String replacementString) {
        return EmojiManager.replaceEmojis(text2, replacementString, EMOJIS_LENGTH_DESCENDING);
    }

    public static String replaceAllEmojis(String text2, Function<Emoji, String> replacementFunction) {
        return EmojiManager.replaceEmojis(text2, replacementFunction, EMOJIS_LENGTH_DESCENDING);
    }

    public static String replaceEmojis(String text2, String replacementString, Collection<Emoji> emojisToReplace) {
        return EmojiManager.replaceEmojis(text2, (Emoji emoji) -> replacementString, emojisToReplace);
    }

    public static String replaceEmojis(String text2, String replacementString, Emoji ... emojisToReplace) {
        return EmojiManager.replaceEmojis(text2, (Emoji emoji) -> replacementString, Arrays.asList(emojisToReplace));
    }

    public static String replaceEmojis(String text2, Function<Emoji, String> replacementFunction, Collection<Emoji> emojisToReplace) {
        if (EmojiManager.isStringNullOrEmpty(text2)) {
            return "";
        }
        int[] textCodePointsArray = text2.codePoints().toArray();
        long textCodePointsLength = textCodePointsArray.length;
        StringBuilder sb = new StringBuilder();
        int textIndex = 0;
        while ((long)textIndex < textCodePointsLength) {
            int currentCodepoint = textCodePointsArray[textIndex];
            sb.appendCodePoint(currentCodepoint);
            List<Emoji> emojisByCodePoint = EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING.get(currentCodepoint);
            if (emojisByCodePoint != null) {
                block1: for (Emoji emoji : emojisByCodePoint) {
                    int[] emojiCodePointsArray = emoji.getEmoji().codePoints().toArray();
                    int emojiCodePointsLength = emojiCodePointsArray.length;
                    if ((long)(textIndex + emojiCodePointsLength) > textCodePointsLength) continue;
                    for (int emojiCodePointIndex = 0; emojiCodePointIndex < emojiCodePointsLength && textCodePointsArray[textIndex + emojiCodePointIndex] == emojiCodePointsArray[emojiCodePointIndex]; ++emojiCodePointIndex) {
                        if (emojiCodePointIndex != emojiCodePointsLength - 1) continue;
                        textIndex += emojiCodePointsLength - 1;
                        sb.delete(sb.length() - Character.charCount(currentCodepoint), sb.length());
                        if (emojisToReplace.contains(emoji)) {
                            sb.append(replacementFunction.apply(emoji));
                            break block1;
                        }
                        sb.append(emoji.getEmoji());
                        break block1;
                    }
                }
            }
            ++textIndex;
        }
        return sb.toString();
    }

    public static String replaceEmojis(String text2, Function<Emoji, String> replacementFunction, Emoji ... emojisToReplace) {
        return EmojiManager.replaceEmojis(text2, replacementFunction, Arrays.asList(emojisToReplace));
    }

    private static boolean isStringNullOrEmpty(String string) {
        return null == string || string.isEmpty();
    }

    static {
        NOT_WANTED_EMOJI_CHARACTERS = Pattern.compile("[\\p{Alpha}\\p{Z}]");
        EMOJI_CODEPOINT_COMPARATOR = (o1, o2) -> {
            if (o1.getEmoji().codePoints().toArray().length == o2.getEmoji().codePoints().toArray().length) {
                return 0;
            }
            return o1.getEmoji().codePoints().toArray().length > o2.getEmoji().codePoints().toArray().length ? -1 : 1;
        };
        String fileContent = EmojiManager.readFileAsString();
        try {
            List emojis = (List)new ObjectMapper().readValue(fileContent, (TypeReference)new TypeReference<List<Emoji>>(){});
            EMOJI_UNICODE_TO_EMOJI = Collections.unmodifiableMap(emojis.stream().collect(Collectors.toMap(Emoji::getEmoji, Function.identity())));
            EMOJIS_LENGTH_DESCENDING = Collections.unmodifiableList(emojis.stream().sorted(EMOJI_CODEPOINT_COMPARATOR).collect(Collectors.toList()));
            EMOJI_FIRST_CODEPOINT_TO_EMOJIS_ORDER_CODEPOINT_LENGTH_DESCENDING = emojis.stream().collect(EmojiManager.getEmojiLinkedHashMapCollector());
            EMOJI_PATTERN = Pattern.compile(EMOJIS_LENGTH_DESCENDING.stream().map(s -> "(" + Pattern.quote(s.getEmoji()) + ")").collect(Collectors.joining("|")), 256);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

