/*
 * Decompiled with CFR 0.152.
 */
package okio.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileHandle;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.ZipFileSystem;
import okio.internal.EocdRecord;
import okio.internal.ZipEntry;
import okio.internal.ZipFilesKt;
import okio.internal._ZlibJvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018H\u0002\u001a\u001f\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\u001c\u001a\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0000\u001a.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0014\b\u0002\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020&0%H\u0000\u001a\f\u0010'\u001a\u00020\u0016*\u00020(H\u0000\u001a\f\u0010)\u001a\u00020**\u00020(H\u0002\u001a.\u0010+\u001a\u00020,*\u00020(2\u0006\u0010-\u001a\u00020\u00012\u0018\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020,0/H\u0002\u001a\u0014\u00100\u001a\u00020\u0016*\u00020(2\u0006\u00101\u001a\u00020\u0016H\u0000\u001a\u0018\u00102\u001a\u0004\u0018\u00010\u0016*\u00020(2\b\u00101\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0014\u00103\u001a\u00020**\u00020(2\u0006\u00104\u001a\u00020*H\u0002\u001a\f\u00105\u001a\u00020,*\u00020(H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00066"}, d2={"BIT_FLAG_ENCRYPTED", "", "BIT_FLAG_UNSUPPORTED_MASK", "CENTRAL_FILE_HEADER_SIGNATURE", "COMPRESSION_METHOD_DEFLATED", "COMPRESSION_METHOD_STORED", "END_OF_CENTRAL_DIRECTORY_SIGNATURE", "HEADER_ID_EXTENDED_TIMESTAMP", "HEADER_ID_NTFS_EXTRA", "HEADER_ID_ZIP64_EXTENDED_INFO", "LOCAL_FILE_HEADER_SIGNATURE", "MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE", "", "ZIP64_EOCD_RECORD_SIGNATURE", "ZIP64_LOCATOR_SIGNATURE", "hex", "", "getHex", "(I)Ljava/lang/String;", "buildIndex", "", "Lokio/Path;", "Lokio/internal/ZipEntry;", "entries", "", "dosDateTimeToEpochMillis", "date", "time", "(II)Ljava/lang/Long;", "filetimeToEpochMillis", "filetime", "openZip", "Lokio/ZipFileSystem;", "zipPath", "fileSystem", "Lokio/FileSystem;", "predicate", "Lkotlin/Function1;", "", "readCentralDirectoryZipEntry", "Lokio/BufferedSource;", "readEocdRecord", "Lokio/internal/EocdRecord;", "readExtra", "", "extraSize", "block", "Lkotlin/Function2;", "readLocalHeader", "centralDirectoryZipEntry", "readOrSkipLocalHeader", "readZip64EocdRecord", "regularRecord", "skipLocalHeader", "okio"})
@SourceDebugExtension(value={"SMAP\nZipFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n52#2,4:504\n52#2,4:508\n52#2,22:512\n60#2,10:534\n56#2,3:544\n71#2,3:547\n52#2,22:550\n60#2,10:572\n56#2,3:582\n71#2,3:585\n1045#3:588\n*S KotlinDebug\n*F\n+ 1 ZipFiles.kt\nokio/internal/ZipFilesKt\n*L\n66#1:504,4\n101#1:508,4\n109#1:512,22\n101#1:534,10\n101#1:544,3\n101#1:547,3\n125#1:550,22\n66#1:572,10\n66#1:582,3\n66#1:585,3\n155#1:588\n*E\n"})
public final class ZipFilesKt {
    private static final int LOCAL_FILE_HEADER_SIGNATURE = 67324752;
    private static final int CENTRAL_FILE_HEADER_SIGNATURE = 33639248;
    private static final int END_OF_CENTRAL_DIRECTORY_SIGNATURE = 101010256;
    private static final int ZIP64_LOCATOR_SIGNATURE = 117853008;
    private static final int ZIP64_EOCD_RECORD_SIGNATURE = 101075792;
    public static final int COMPRESSION_METHOD_DEFLATED = 8;
    public static final int COMPRESSION_METHOD_STORED = 0;
    private static final int BIT_FLAG_ENCRYPTED = 1;
    private static final int BIT_FLAG_UNSUPPORTED_MASK = 1;
    private static final long MAX_ZIP_ENTRY_AND_ARCHIVE_SIZE = 0xFFFFFFFFL;
    private static final int HEADER_ID_ZIP64_EXTENDED_INFO = 1;
    private static final int HEADER_ID_NTFS_EXTRA = 10;
    private static final int HEADER_ID_EXTENDED_TIMESTAMP = 21589;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static final ZipFileSystem openZip(@NotNull Path zipPath, @NotNull FileSystem fileSystem, @NotNull Function1<? super ZipEntry, Boolean> predicate) throws IOException {
        Object var39_60;
        Throwable thrown$iv;
        block76: {
            ZipFileSystem zipFileSystem;
            Intrinsics.checkNotNullParameter((Object)zipPath, (String)"zipPath");
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Closeable $this$use$iv = fileSystem.openReadOnly(zipPath);
            boolean $i$f$use = false;
            Object thrown$iv22 = null;
            try {
                Unit unit;
                Throwable thrown$iv2;
                List entries2;
                Unit result$iv;
                String comment;
                block74: {
                    EocdRecord record;
                    long eocdOffset;
                    FileHandle fileHandle;
                    block69: {
                        fileHandle = (FileHandle)$this$use$iv;
                        boolean bl = false;
                        long scanOffset = fileHandle.size() - (long)22;
                        if (scanOffset < 0L) {
                            throw new IOException("not a zip: size=" + fileHandle.size());
                        }
                        long stopOffset = Math.max(scanOffset - 65536L, 0L);
                        eocdOffset = 0L;
                        record = null;
                        comment = null;
                        do {
                            try (BufferedSource source2 = Okio.buffer(fileHandle.source(scanOffset));){
                                if (source2.readIntLe() != 101010256) continue;
                                eocdOffset = scanOffset;
                                record = ZipFilesKt.readEocdRecord(source2);
                                comment = source2.readUtf8(record.getCommentByteCount());
                                break block69;
                            }
                        } while ((scanOffset += -1L) >= stopOffset);
                        throw new IOException("not a zip: end of central directory signature not found");
                    }
                    long zip64LocatorOffset = eocdOffset - (long)20;
                    if (zip64LocatorOffset > 0L) {
                        BufferedSource zip64LocatorSource;
                        Throwable thrown$iv3;
                        block72: {
                            Closeable $this$use$iv2 = Okio.buffer(fileHandle.source(zip64LocatorOffset));
                            boolean $i$f$use2 = false;
                            thrown$iv3 = null;
                            try {
                                zip64LocatorSource = (BufferedSource)$this$use$iv2;
                                boolean bl = false;
                                if (zip64LocatorSource.readIntLe() == 117853008) {
                                    Unit unit2;
                                    Throwable thrown$iv4;
                                    block70: {
                                        int diskWithCentralDir = zip64LocatorSource.readIntLe();
                                        long zip64EocdRecordOffset = zip64LocatorSource.readLongLe();
                                        int numDisks = zip64LocatorSource.readIntLe();
                                        if (numDisks != 1) throw new IOException("unsupported zip: spanned");
                                        if (diskWithCentralDir != 0) {
                                            throw new IOException("unsupported zip: spanned");
                                        }
                                        Closeable $this$use$iv3 = Okio.buffer(fileHandle.source(zip64EocdRecordOffset));
                                        boolean $i$f$use22 = false;
                                        thrown$iv4 = null;
                                        try {
                                            BufferedSource zip64EocdSource = (BufferedSource)$this$use$iv3;
                                            boolean bl2 = false;
                                            int zip64EocdSignature = zip64EocdSource.readIntLe();
                                            if (zip64EocdSignature != 101075792) {
                                                throw new IOException("bad zip: expected " + ZipFilesKt.getHex(101075792) + " but was " + ZipFilesKt.getHex(zip64EocdSignature));
                                            }
                                            record = ZipFilesKt.readZip64EocdRecord(zip64EocdSource, record);
                                            unit2 = Unit.INSTANCE;
                                        }
                                        catch (Throwable t$iv) {
                                            try {
                                                thrown$iv4 = t$iv;
                                                unit2 = null;
                                                break block70;
                                            }
                                            catch (Throwable throwable) {
                                                throw throwable;
                                            }
                                            finally {
                                                block71: {
                                                    try {
                                                        Closeable closeable = $this$use$iv3;
                                                        if (closeable != null) {
                                                            closeable.close();
                                                        }
                                                    }
                                                    catch (Throwable t$iv2) {
                                                        if (thrown$iv4 == null) {
                                                            thrown$iv4 = t$iv2;
                                                            break block71;
                                                        }
                                                        ExceptionsKt.addSuppressed((Throwable)thrown$iv4, (Throwable)t$iv2);
                                                    }
                                                }
                                            }
                                        }
                                        try {
                                            Closeable closeable = $this$use$iv3;
                                            if (closeable != null) {
                                                closeable.close();
                                            }
                                        }
                                        catch (Throwable t$iv) {
                                            thrown$iv4 = t$iv;
                                        }
                                    }
                                    result$iv = unit2;
                                    Throwable throwable = thrown$iv4;
                                    if (throwable != null) {
                                        throw throwable;
                                    }
                                }
                                zip64LocatorSource = Unit.INSTANCE;
                            }
                            catch (Throwable t$iv) {
                                try {
                                    thrown$iv3 = t$iv;
                                    zip64LocatorSource = null;
                                    break block72;
                                }
                                catch (Throwable t$iv3) {
                                    throw t$iv3;
                                }
                                finally {
                                    block73: {
                                        try {
                                            Closeable closeable = $this$use$iv2;
                                            if (closeable != null) {
                                                closeable.close();
                                            }
                                        }
                                        catch (Throwable t$iv3) {
                                            if (thrown$iv3 == null) {
                                                thrown$iv3 = t$iv3;
                                                break block73;
                                            }
                                            ExceptionsKt.addSuppressed((Throwable)thrown$iv3, (Throwable)t$iv3);
                                        }
                                    }
                                }
                            }
                            try {
                                Closeable closeable = $this$use$iv2;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv) {
                                thrown$iv3 = t$iv;
                            }
                        }
                        BufferedSource result$iv2 = zip64LocatorSource;
                        Throwable throwable = thrown$iv3;
                        if (throwable != null) {
                            throw throwable;
                        }
                    }
                    entries2 = new ArrayList();
                    Closeable $this$use$iv4 = Okio.buffer(fileHandle.source(record.getCentralDirectoryOffset()));
                    boolean $i$f$use3 = false;
                    thrown$iv2 = null;
                    try {
                        BufferedSource source3 = (BufferedSource)$this$use$iv4;
                        boolean bl = false;
                        long l = record.getEntryCount();
                        for (long i = 0L; i < l; ++i) {
                            ZipEntry entry2 = ZipFilesKt.readCentralDirectoryZipEntry(source3);
                            if (entry2.getOffset() >= record.getCentralDirectoryOffset()) {
                                throw new IOException("bad zip: local file header offset >= central directory offset");
                            }
                            if (!((Boolean)predicate.invoke((Object)entry2)).booleanValue()) continue;
                            ((Collection)entries2).add(entry2);
                        }
                        unit = Unit.INSTANCE;
                    }
                    catch (Throwable t$iv) {
                        try {
                            thrown$iv2 = t$iv;
                            unit = null;
                            break block74;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            block75: {
                                try {
                                    Closeable closeable = $this$use$iv4;
                                    if (closeable != null) {
                                        closeable.close();
                                    }
                                }
                                catch (Throwable t$iv4) {
                                    if (thrown$iv2 == null) {
                                        thrown$iv2 = t$iv4;
                                        break block75;
                                    }
                                    ExceptionsKt.addSuppressed((Throwable)thrown$iv2, (Throwable)t$iv4);
                                }
                            }
                        }
                    }
                    try {
                        Closeable closeable = $this$use$iv4;
                        if (closeable != null) {
                            closeable.close();
                        }
                    }
                    catch (Throwable t$iv) {
                        thrown$iv2 = t$iv;
                    }
                }
                result$iv = unit;
                Throwable throwable = thrown$iv2;
                if (throwable != null) {
                    throw throwable;
                }
                Map<Path, ZipEntry> index = ZipFilesKt.buildIndex(entries2);
                zipFileSystem = new ZipFileSystem(zipPath, fileSystem, index, comment);
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    var39_60 = null;
                    break block76;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    block77: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv5) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv5;
                                break block77;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv5);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable == null) return zipFileSystem;
                closeable.close();
                return zipFileSystem;
            }
            catch (Throwable fileHandle) {
                // empty catch block
            }
            return zipFileSystem;
        }
        Object result$iv3 = var39_60;
        Throwable throwable = thrown$iv;
        if (throwable == null) throw new KotlinNothingValueException();
        throw throwable;
    }

    public static /* synthetic */ ZipFileSystem openZip$default(Path path, FileSystem fileSystem, Function1 function1, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            function1 = openZip.1.INSTANCE;
        }
        return ZipFilesKt.openZip(path, fileSystem, (Function1<? super ZipEntry, Boolean>)function1);
    }

    private static final Map<Path, ZipEntry> buildIndex(List<ZipEntry> entries2) {
        Path root = Path.Companion.get$default(Path.Companion, "/", false, 1, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)root, (Object)new ZipEntry(root, true, null, 0L, 0L, 0L, 0, 0L, 0, 0, null, null, null, null, null, null, 65532, null))};
        Map result2 = MapsKt.mutableMapOf((Pair[])pairArray);
        Iterable $this$sortedBy$iv = entries2;
        boolean $i$f$sortedBy = false;
        block0: for (ZipEntry entry2 : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ZipEntry it = (ZipEntry)a;
                boolean bl = false;
                Comparable comparable = it.getCanonicalPath();
                it = (ZipEntry)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getCanonicalPath());
            }
        })) {
            ZipEntry replaced = result2.put(entry2.getCanonicalPath(), entry2);
            if (replaced != null) continue;
            ZipEntry child = entry2;
            while (child.getCanonicalPath().parent() != null) {
                Path parentPath;
                ZipEntry parentEntry = (ZipEntry)result2.get(parentPath);
                if (parentEntry != null) {
                    ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                    continue block0;
                }
                parentEntry = new ZipEntry(parentPath, true, null, 0L, 0L, 0L, 0, 0L, 0, 0, null, null, null, null, null, null, 65532, null);
                result2.put(parentPath, parentEntry);
                ((Collection)parentEntry.getChildren()).add(child.getCanonicalPath());
                child = parentEntry;
            }
        }
        return result2;
    }

    @NotNull
    public static final ZipEntry readCentralDirectoryZipEntry(@NotNull BufferedSource $this$readCentralDirectoryZipEntry) throws IOException {
        Intrinsics.checkNotNullParameter((Object)$this$readCentralDirectoryZipEntry, (String)"<this>");
        int signature = $this$readCentralDirectoryZipEntry.readIntLe();
        if (signature != 33639248) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(33639248) + " but was " + ZipFilesKt.getHex(signature));
        }
        $this$readCentralDirectoryZipEntry.skip(4L);
        int bitFlag = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(bitFlag));
        }
        int compressionMethod = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int dosLastModifiedTime = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int dosLastModifiedDate = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        long crc = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef compressedSize = new Ref.LongRef();
        compressedSize.element = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        Ref.LongRef size = new Ref.LongRef();
        size.element = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        int nameSize = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int extraSize = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        int commentByteCount = $this$readCentralDirectoryZipEntry.readShortLe() & 0xFFFF;
        $this$readCentralDirectoryZipEntry.skip(8L);
        Ref.LongRef offset = new Ref.LongRef();
        offset.element = (long)$this$readCentralDirectoryZipEntry.readIntLe() & 0xFFFFFFFFL;
        String name = $this$readCentralDirectoryZipEntry.readUtf8(nameSize);
        if (StringsKt.contains$default((CharSequence)name, (char)'\u0000', (boolean)false, (int)2, null)) {
            throw new IOException("bad zip: filename contains 0x00");
        }
        BufferedSource $this$readCentralDirectoryZipEntry_u24lambda_u245 = $this$readCentralDirectoryZipEntry;
        boolean bl = false;
        long result2 = 0L;
        if (size.element == 0xFFFFFFFFL) {
            result2 += (long)8;
        }
        if (compressedSize.element == 0xFFFFFFFFL) {
            result2 += (long)8;
        }
        if (offset.element == 0xFFFFFFFFL) {
            result2 += (long)8;
        }
        long requiredZip64ExtraSize = result2;
        Ref.ObjectRef ntfsLastModifiedAtFiletime = new Ref.ObjectRef();
        Ref.ObjectRef ntfsLastAccessedAtFiletime = new Ref.ObjectRef();
        Ref.ObjectRef ntfsCreatedAtFiletime = new Ref.ObjectRef();
        Ref.BooleanRef hasZip64Extra = new Ref.BooleanRef();
        ZipFilesKt.readExtra($this$readCentralDirectoryZipEntry, extraSize, (Function2<? super Integer, ? super Long, Unit>)((Function2)new Function2<Integer, Long, Unit>(hasZip64Extra, requiredZip64ExtraSize, size, $this$readCentralDirectoryZipEntry, compressedSize, offset, (Ref.ObjectRef<Long>)ntfsLastModifiedAtFiletime, (Ref.ObjectRef<Long>)ntfsLastAccessedAtFiletime, (Ref.ObjectRef<Long>)ntfsCreatedAtFiletime){
            final /* synthetic */ Ref.BooleanRef $hasZip64Extra;
            final /* synthetic */ long $requiredZip64ExtraSize;
            final /* synthetic */ Ref.LongRef $size;
            final /* synthetic */ BufferedSource $this_readCentralDirectoryZipEntry;
            final /* synthetic */ Ref.LongRef $compressedSize;
            final /* synthetic */ Ref.LongRef $offset;
            final /* synthetic */ Ref.ObjectRef<Long> $ntfsLastModifiedAtFiletime;
            final /* synthetic */ Ref.ObjectRef<Long> $ntfsLastAccessedAtFiletime;
            final /* synthetic */ Ref.ObjectRef<Long> $ntfsCreatedAtFiletime;
            {
                this.$hasZip64Extra = $hasZip64Extra;
                this.$requiredZip64ExtraSize = $requiredZip64ExtraSize;
                this.$size = $size;
                this.$this_readCentralDirectoryZipEntry = $receiver;
                this.$compressedSize = $compressedSize;
                this.$offset = $offset;
                this.$ntfsLastModifiedAtFiletime = $ntfsLastModifiedAtFiletime;
                this.$ntfsLastAccessedAtFiletime = $ntfsLastAccessedAtFiletime;
                this.$ntfsCreatedAtFiletime = $ntfsCreatedAtFiletime;
                super(2);
            }

            public final void invoke(int headerId, long dataSize) {
                switch (headerId) {
                    case 1: {
                        if (this.$hasZip64Extra.element) {
                            throw new IOException("bad zip: zip64 extra repeated");
                        }
                        this.$hasZip64Extra.element = true;
                        if (dataSize < this.$requiredZip64ExtraSize) {
                            throw new IOException("bad zip: zip64 extra too short");
                        }
                        this.$size.element = this.$size.element == 0xFFFFFFFFL ? this.$this_readCentralDirectoryZipEntry.readLongLe() : this.$size.element;
                        this.$compressedSize.element = this.$compressedSize.element == 0xFFFFFFFFL ? this.$this_readCentralDirectoryZipEntry.readLongLe() : 0L;
                        this.$offset.element = this.$offset.element == 0xFFFFFFFFL ? this.$this_readCentralDirectoryZipEntry.readLongLe() : 0L;
                        break;
                    }
                    case 10: {
                        if (dataSize < 4L) {
                            throw new IOException("bad zip: NTFS extra too short");
                        }
                        this.$this_readCentralDirectoryZipEntry.skip(4L);
                        ZipFilesKt.access$readExtra(this.$this_readCentralDirectoryZipEntry, (int)(dataSize - 4L), (Function2)new Function2<Integer, Long, Unit>(this.$ntfsLastModifiedAtFiletime, this.$this_readCentralDirectoryZipEntry, this.$ntfsLastAccessedAtFiletime, this.$ntfsCreatedAtFiletime){
                            final /* synthetic */ Ref.ObjectRef<Long> $ntfsLastModifiedAtFiletime;
                            final /* synthetic */ BufferedSource $this_readCentralDirectoryZipEntry;
                            final /* synthetic */ Ref.ObjectRef<Long> $ntfsLastAccessedAtFiletime;
                            final /* synthetic */ Ref.ObjectRef<Long> $ntfsCreatedAtFiletime;
                            {
                                this.$ntfsLastModifiedAtFiletime = $ntfsLastModifiedAtFiletime;
                                this.$this_readCentralDirectoryZipEntry = $receiver;
                                this.$ntfsLastAccessedAtFiletime = $ntfsLastAccessedAtFiletime;
                                this.$ntfsCreatedAtFiletime = $ntfsCreatedAtFiletime;
                                super(2);
                            }

                            public final void invoke(int attributeId, long attributeSize) {
                                if (attributeId == 1) {
                                    if (this.$ntfsLastModifiedAtFiletime.element != null) {
                                        throw new IOException("bad zip: NTFS extra attribute tag 0x0001 repeated");
                                    }
                                    if (attributeSize != 24L) {
                                        throw new IOException("bad zip: NTFS extra attribute tag 0x0001 size != 24");
                                    }
                                    this.$ntfsLastModifiedAtFiletime.element = this.$this_readCentralDirectoryZipEntry.readLongLe();
                                    this.$ntfsLastAccessedAtFiletime.element = this.$this_readCentralDirectoryZipEntry.readLongLe();
                                    this.$ntfsCreatedAtFiletime.element = this.$this_readCentralDirectoryZipEntry.readLongLe();
                                }
                            }
                        });
                    }
                }
            }
        }));
        if (requiredZip64ExtraSize > 0L && !hasZip64Extra.element) {
            throw new IOException("bad zip: zip64 extra required but absent");
        }
        String comment = $this$readCentralDirectoryZipEntry.readUtf8(commentByteCount);
        Path canonicalPath = Path.Companion.get$default(Path.Companion, "/", false, 1, null).resolve(name);
        boolean isDirectory = StringsKt.endsWith$default((String)name, (String)"/", (boolean)false, (int)2, null);
        return new ZipEntry(canonicalPath, isDirectory, comment, crc, compressedSize.element, size.element, compressionMethod, offset.element, dosLastModifiedDate, dosLastModifiedTime, (Long)ntfsLastModifiedAtFiletime.element, (Long)ntfsLastAccessedAtFiletime.element, (Long)ntfsCreatedAtFiletime.element, null, null, null, 57344, null);
    }

    private static final EocdRecord readEocdRecord(BufferedSource $this$readEocdRecord) throws IOException {
        long totalEntryCount;
        int diskNumber = $this$readEocdRecord.readShortLe() & 0xFFFF;
        int diskWithCentralDir = $this$readEocdRecord.readShortLe() & 0xFFFF;
        long entryCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        if (entryCount != (totalEntryCount = (long)($this$readEocdRecord.readShortLe() & 0xFFFF)) || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new IOException("unsupported zip: spanned");
        }
        $this$readEocdRecord.skip(4L);
        long centralDirectoryOffset = (long)$this$readEocdRecord.readIntLe() & 0xFFFFFFFFL;
        int commentByteCount = $this$readEocdRecord.readShortLe() & 0xFFFF;
        return new EocdRecord(entryCount, centralDirectoryOffset, commentByteCount);
    }

    private static final EocdRecord readZip64EocdRecord(BufferedSource $this$readZip64EocdRecord, EocdRecord regularRecord) throws IOException {
        $this$readZip64EocdRecord.skip(12L);
        int diskNumber = $this$readZip64EocdRecord.readIntLe();
        int diskWithCentralDirStart = $this$readZip64EocdRecord.readIntLe();
        long entryCount = $this$readZip64EocdRecord.readLongLe();
        long totalEntryCount = $this$readZip64EocdRecord.readLongLe();
        if (entryCount != totalEntryCount || diskNumber != 0 || diskWithCentralDirStart != 0) {
            throw new IOException("unsupported zip: spanned");
        }
        $this$readZip64EocdRecord.skip(8L);
        long centralDirectoryOffset = $this$readZip64EocdRecord.readLongLe();
        return new EocdRecord(entryCount, centralDirectoryOffset, regularRecord.getCommentByteCount());
    }

    private static final void readExtra(BufferedSource $this$readExtra, int extraSize, Function2<? super Integer, ? super Long, Unit> block) {
        long dataSize;
        for (long remaining = (long)extraSize; remaining != 0L; remaining -= dataSize) {
            if (remaining < 4L) {
                throw new IOException("bad zip: truncated header in extra field");
            }
            int headerId = $this$readExtra.readShortLe() & 0xFFFF;
            dataSize = (long)$this$readExtra.readShortLe() & 0xFFFFL;
            if ((remaining -= (long)4) < dataSize) {
                throw new IOException("bad zip: truncated value in extra field");
            }
            $this$readExtra.require(dataSize);
            long sizeBefore = $this$readExtra.getBuffer().size();
            block.invoke((Object)headerId, (Object)dataSize);
            long fieldRemaining = dataSize + $this$readExtra.getBuffer().size() - sizeBefore;
            if (fieldRemaining < 0L) {
                throw new IOException("unsupported zip: too many bytes processed for " + headerId);
            }
            if (fieldRemaining <= 0L) continue;
            $this$readExtra.getBuffer().skip(fieldRemaining);
        }
    }

    public static final void skipLocalHeader(@NotNull BufferedSource $this$skipLocalHeader) {
        Intrinsics.checkNotNullParameter((Object)$this$skipLocalHeader, (String)"<this>");
        ZipFilesKt.readOrSkipLocalHeader($this$skipLocalHeader, null);
    }

    @NotNull
    public static final ZipEntry readLocalHeader(@NotNull BufferedSource $this$readLocalHeader, @NotNull ZipEntry centralDirectoryZipEntry) {
        Intrinsics.checkNotNullParameter((Object)$this$readLocalHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)centralDirectoryZipEntry, (String)"centralDirectoryZipEntry");
        ZipEntry zipEntry = ZipFilesKt.readOrSkipLocalHeader($this$readLocalHeader, centralDirectoryZipEntry);
        Intrinsics.checkNotNull((Object)zipEntry);
        return zipEntry;
    }

    private static final ZipEntry readOrSkipLocalHeader(BufferedSource $this$readOrSkipLocalHeader, ZipEntry centralDirectoryZipEntry) {
        int signature = $this$readOrSkipLocalHeader.readIntLe();
        if (signature != 67324752) {
            throw new IOException("bad zip: expected " + ZipFilesKt.getHex(67324752) + " but was " + ZipFilesKt.getHex(signature));
        }
        $this$readOrSkipLocalHeader.skip(2L);
        int bitFlag = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        if ((bitFlag & 1) != 0) {
            throw new IOException("unsupported zip: general purpose bit flag=" + ZipFilesKt.getHex(bitFlag));
        }
        $this$readOrSkipLocalHeader.skip(18L);
        long fileNameLength = (long)$this$readOrSkipLocalHeader.readShortLe() & 0xFFFFL;
        int extraSize = $this$readOrSkipLocalHeader.readShortLe() & 0xFFFF;
        $this$readOrSkipLocalHeader.skip(fileNameLength);
        if (centralDirectoryZipEntry == null) {
            $this$readOrSkipLocalHeader.skip(extraSize);
            return null;
        }
        Ref.ObjectRef extendedLastModifiedAtSeconds = new Ref.ObjectRef();
        Ref.ObjectRef extendedLastAccessedAtSeconds = new Ref.ObjectRef();
        Ref.ObjectRef extendedCreatedAtSeconds = new Ref.ObjectRef();
        ZipFilesKt.readExtra($this$readOrSkipLocalHeader, extraSize, (Function2<? super Integer, ? super Long, Unit>)((Function2)new Function2<Integer, Long, Unit>($this$readOrSkipLocalHeader, (Ref.ObjectRef<Integer>)extendedLastModifiedAtSeconds, (Ref.ObjectRef<Integer>)extendedLastAccessedAtSeconds, (Ref.ObjectRef<Integer>)extendedCreatedAtSeconds){
            final /* synthetic */ BufferedSource $this_readOrSkipLocalHeader;
            final /* synthetic */ Ref.ObjectRef<Integer> $extendedLastModifiedAtSeconds;
            final /* synthetic */ Ref.ObjectRef<Integer> $extendedLastAccessedAtSeconds;
            final /* synthetic */ Ref.ObjectRef<Integer> $extendedCreatedAtSeconds;
            {
                this.$this_readOrSkipLocalHeader = $receiver;
                this.$extendedLastModifiedAtSeconds = $extendedLastModifiedAtSeconds;
                this.$extendedLastAccessedAtSeconds = $extendedLastAccessedAtSeconds;
                this.$extendedCreatedAtSeconds = $extendedCreatedAtSeconds;
                super(2);
            }

            public final void invoke(int headerId, long dataSize) {
                if (headerId == 21589) {
                    long requiredSize;
                    if (dataSize < 1L) {
                        throw new IOException("bad zip: extended timestamp extra too short");
                    }
                    int flags = this.$this_readOrSkipLocalHeader.readByte() & 0xFF;
                    boolean hasLastModifiedAtMillis = (flags & 1) == 1;
                    boolean hasLastAccessedAtMillis = (flags & 2) == 2;
                    boolean hasCreatedAtMillis = (flags & 4) == 4;
                    BufferedSource $this$invoke_u24lambda_u240 = this.$this_readOrSkipLocalHeader;
                    boolean bl = false;
                    long result2 = 1L;
                    if (hasLastModifiedAtMillis) {
                        result2 += 4L;
                    }
                    if (hasLastAccessedAtMillis) {
                        result2 += 4L;
                    }
                    if (hasCreatedAtMillis) {
                        result2 += 4L;
                    }
                    if (dataSize < (requiredSize = result2)) {
                        throw new IOException("bad zip: extended timestamp extra too short");
                    }
                    if (hasLastModifiedAtMillis) {
                        this.$extendedLastModifiedAtSeconds.element = this.$this_readOrSkipLocalHeader.readIntLe();
                    }
                    if (hasLastAccessedAtMillis) {
                        this.$extendedLastAccessedAtSeconds.element = this.$this_readOrSkipLocalHeader.readIntLe();
                    }
                    if (hasCreatedAtMillis) {
                        this.$extendedCreatedAtSeconds.element = this.$this_readOrSkipLocalHeader.readIntLe();
                    }
                }
            }
        }));
        return centralDirectoryZipEntry.copy$okio((Integer)extendedLastModifiedAtSeconds.element, (Integer)extendedLastAccessedAtSeconds.element, (Integer)extendedCreatedAtSeconds.element);
    }

    public static final long filetimeToEpochMillis(long filetime) {
        return filetime / (long)10000 - 11644473600000L;
    }

    @Nullable
    public static final Long dosDateTimeToEpochMillis(int date, int time) {
        if (time == -1) {
            return null;
        }
        return _ZlibJvmKt.datePartsToEpochMillis(1980 + (date >> 9 & 0x7F), date >> 5 & 0xF, date & 0x1F, time >> 11 & 0x1F, time >> 5 & 0x3F, (time & 0x1F) << 1);
    }

    private static final String getHex(int $this$hex) {
        StringBuilder stringBuilder = new StringBuilder().append("0x");
        String string = Integer.toString($this$hex, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return stringBuilder.append(string).toString();
    }

    public static final /* synthetic */ void access$readExtra(BufferedSource $receiver, int extraSize, Function2 block) {
        ZipFilesKt.readExtra($receiver, extraSize, (Function2<? super Integer, ? super Long, Unit>)block);
    }
}

