/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.ArtifactRequestExecutorService;
import com.intellij.ml.llm.matterhorn.ProjectFileStructure$;
import com.intellij.ml.llm.matterhorn.ProjectFileStructureCreateFileChange;
import com.intellij.ml.llm.matterhorn.ProjectFileStructureFileChanges;
import com.intellij.ml.llm.matterhorn.ProjectStructureBinaryFile;
import com.intellij.ml.llm.matterhorn.ProjectStructureFile;
import com.intellij.ml.llm.matterhorn.ProjectStructureFolder;
import com.intellij.ml.llm.matterhorn.ProjectStructureFolder$;
import com.intellij.ml.llm.matterhorn.ProjectStructureItem;
import com.intellij.ml.llm.matterhorn.RootExecutionContextKt;
import com.intellij.ml.llm.matterhorn.helpers.ProjectStateHelper;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 22\u00020\u0001:\u000223B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tB%\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0004\u0010\u000eJ\u001a\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u0014J\u0006\u0010\u001e\u001a\u00020\u0000J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0000J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0012J\u001a\u0010&\u001a\u00020\u00002\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00140(J$\u0010*\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00140(H\u0002J%\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0001\u00a2\u0006\u0002\b1R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00064"}, d2={"Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure;", "", "root", "Lcom/intellij/ml/llm/matterhorn/ProjectStructureFolder;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/ProjectStructureFolder;)V", "()V", "changes", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructureFileChanges;", "(Lcom/intellij/ml/llm/matterhorn/ProjectFileStructureFileChanges;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILcom/intellij/ml/llm/matterhorn/ProjectStructureFolder;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getRoot", "()Lcom/intellij/ml/llm/matterhorn/ProjectStructureFolder;", "dump", "", "filterHiddenFolders", "", "topLevelFolderName", "toString", "apply", "", "project", "Lcom/intellij/openapi/project/Project;", "projectRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "deleteRemainingFiles", "copy", "isIgnored", "file", "append", "structure", "appendInternal", "folder", "path", "filter", "f", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/matterhorn/ProjectStructureItem;", "filterFolder", "write$Self", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "Companion", "$serializer", "core"})
@SourceDebugExtension(value={"SMAP\nProjectFileStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectFileStructure.kt\ncom/intellij/ml/llm/matterhorn/ProjectFileStructure\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,399:1\n113#2:400\n96#3:401\n14#4:402\n*S KotlinDebug\n*F\n+ 1 ProjectFileStructure.kt\ncom/intellij/ml/llm/matterhorn/ProjectFileStructure\n*L\n195#1:400\n195#1:401\n242#1:402\n*E\n"})
public final class ProjectFileStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProjectStructureFolder root;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<String> ignoreFolders;
    @NotNull
    private static final List<String> ignoreFiles;
    @NotNull
    private static final Map<String, String> extensionToLanguage;
    @NotNull
    public static final String SEPARATOR = "### All Project Files Content";

    public ProjectFileStructure(@NotNull ProjectStructureFolder root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
    }

    @NotNull
    public final ProjectStructureFolder getRoot() {
        return this.root;
    }

    public ProjectFileStructure() {
        this(new ProjectStructureFolder("/", null, 2, null));
    }

    public ProjectFileStructure(@NotNull ProjectFileStructureFileChanges changes) {
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        this();
        changes.apply(this);
    }

    @NotNull
    public final String dump(boolean filterHiddenFolders, @NotNull String topLevelFolderName) {
        Intrinsics.checkNotNullParameter((Object)topLevelFolderName, (String)"topLevelFolderName");
        StringBuilder projectDirectoryStructure = new StringBuilder();
        StringBuilder fileContents = new StringBuilder();
        if (((CharSequence)topLevelFolderName).length() > 0) {
            projectDirectoryStructure.append("- " + topLevelFolderName + "/\n");
        }
        String initialIndent = ((CharSequence)topLevelFolderName).length() > 0 ? "  " : "";
        ProjectFileStructure.Companion.dumpProjectDirectoryStructure(this.root, projectDirectoryStructure, filterHiddenFolders, initialIndent);
        ProjectFileStructure.Companion.dumpProjectDirectoryFiles(this.root, topLevelFolderName, fileContents, filterHiddenFolders);
        return "\n" + projectDirectoryStructure + "\n\n### All Project Files Content\n" + fileContents + "\n";
    }

    public static /* synthetic */ String dump$default(ProjectFileStructure projectFileStructure, boolean bl, String string, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            string = "";
        }
        return projectFileStructure.dump(bl, string);
    }

    @NotNull
    public String toString() {
        return ProjectFileStructure.dump$default(this, false, null, 2, null);
    }

    public final void apply(@NotNull Project project, @NotNull VirtualFile projectRoot, boolean deleteRemainingFiles) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        logger.info("<-------------> Start applying session for root: " + projectRoot.getPath() + " <-------------> ");
        ProjectFileStructure.Companion.apply(project, this.root, projectRoot, deleteRemainingFiles);
        logger.info("<-------------> Finish applying session for root: " + projectRoot.getPath() + " <-------------> ");
    }

    public static /* synthetic */ void apply$default(ProjectFileStructure projectFileStructure, Project project, VirtualFile virtualFile, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        projectFileStructure.apply(project, virtualFile, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProjectFileStructure copy() {
        void this_$iv;
        Json json = (Json)Json.Default;
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String string$iv = $this$encodeToString$iv.encodeToString((SerializationStrategy)Companion.serializer(), (Object)this);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (ProjectFileStructure)this_$iv.decodeFromString((DeserializationStrategy)Companion.serializer(), string$iv);
    }

    public final boolean isIgnored(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.isDirectory() && ignoreFolders.contains(file.getName()) || VirtualFileUtil.isFile((VirtualFile)file) && ignoreFiles.contains(file.getName());
    }

    public final void append(@NotNull ProjectFileStructure structure) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        this.appendInternal(structure.root, ".");
    }

    public final void appendInternal(@NotNull ProjectStructureFolder folder, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        for (ProjectStructureItem child : folder.getChildren()) {
            if (child instanceof ProjectStructureFolder) {
                this.appendInternal((ProjectStructureFolder)child, path + "/" + ((ProjectStructureFolder)child).getName());
            }
            if (!(child instanceof ProjectStructureFile)) continue;
            new ProjectFileStructureCreateFileChange(path + "/" + ((ProjectStructureFile)child).getName(), ((ProjectStructureFile)child).getContent(), "").applyChange(this);
        }
    }

    @NotNull
    public final ProjectFileStructure filter(@NotNull Function1<? super ProjectStructureItem, Boolean> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return new ProjectFileStructure(this.filterFolder(this.root, f));
    }

    private final ProjectStructureFolder filterFolder(ProjectStructureFolder folder, Function1<? super ProjectStructureItem, Boolean> f) {
        List items = new ArrayList();
        for (ProjectStructureItem item : folder.getChildren()) {
            if (((Boolean)f.invoke((Object)item)).booleanValue()) continue;
            if (item instanceof ProjectStructureFile) {
                items.add(item);
            }
            if (!(item instanceof ProjectStructureFolder)) continue;
            items.add(this.filterFolder((ProjectStructureFolder)item, f));
        }
        return new ProjectStructureFolder(folder.getName(), items);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(ProjectFileStructure self, CompositeEncoder output2, SerialDescriptor serialDesc) {
        output2.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)ProjectStructureFolder$.serializer.INSTANCE, (Object)self.root);
    }

    public /* synthetic */ ProjectFileStructure(int seen0, ProjectStructureFolder root, SerializationConstructorMarker serializationConstructorMarker) {
        if (1 != (1 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.root = root;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectFileStructure.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProjectFileStructure.logger = logger;
        Object[] objectArray = new String[]{".git", ".idea", "node_modules", "build", "dist", "logs", "tmp"};
        ignoreFolders = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"package-lock.json", ".DS_Store"};
        ignoreFiles = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"kt", (Object)"kotlin"), TuplesKt.to((Object)"java", (Object)"java"), TuplesKt.to((Object)"py", (Object)"python"), TuplesKt.to((Object)"js", (Object)"javascript"), TuplesKt.to((Object)"css", (Object)"css"), TuplesKt.to((Object)"cpp", (Object)"cpp"), TuplesKt.to((Object)"cs", (Object)"csharp"), TuplesKt.to((Object)"rb", (Object)"ruby"), TuplesKt.to((Object)"go", (Object)"go"), TuplesKt.to((Object)"rs", (Object)"rust"), TuplesKt.to((Object)"html", (Object)"html"), TuplesKt.to((Object)"md", (Object)"markdown"), TuplesKt.to((Object)"json", (Object)"json"), TuplesKt.to((Object)"yaml", (Object)"yaml"), TuplesKt.to((Object)"yml", (Object)"yaml"), TuplesKt.to((Object)"ts", (Object)"typescript"), TuplesKt.to((Object)"tsx", (Object)"tsx")};
        extensionToLanguage = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t*\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\fJ*\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\u00020\u0019*\u00020\u0017H\u0002J0\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\n2\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u00192\b\b\u0002\u0010 \u001a\u00020\u0010H\u0002J.\u0010!\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00102\n\u0010\u001c\u001a\u00060\u001dj\u0002`\u001e2\b\b\u0002\u0010\u001f\u001a\u00020\u0019H\u0002J\"\u0010#\u001a\u00020\t2\n\u0010\u001c\u001a\u00060$j\u0002`%2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u0010J\"\u0010(\u001a\u00020\t2\n\u0010\u001c\u001a\u00060$j\u0002`%2\u0006\u0010'\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*J\f\u00100\u001a\b\u0012\u0004\u0012\u00020201R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u000e\u0010/\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "forEachFile", "", "Lcom/intellij/ml/llm/matterhorn/ProjectStructureFolder;", "processor", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/matterhorn/ProjectStructureFile;", "ignoreFolders", "", "", "ignoreFiles", "apply", "project", "Lcom/intellij/openapi/project/Project;", "folder", "projectFolder", "Lcom/intellij/openapi/vfs/VirtualFile;", "deleteRemainingFiles", "", "isHiddenFolder", "dumpProjectDirectoryStructure", "accumulator", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "filterHiddenFolders", "indent", "dumpProjectDirectoryFiles", "folderPath", "appendFileTo", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "file", "filePath", "appendBinaryFileTo", "binaryFile", "Lcom/intellij/ml/llm/matterhorn/ProjectStructureBinaryFile;", "extensionToLanguage", "", "getExtensionToLanguage", "()Ljava/util/Map;", "SEPARATOR", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/matterhorn/ProjectFileStructure;", "core"})
    @SourceDebugExtension(value={"SMAP\nProjectFileStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectFileStructure.kt\ncom/intellij/ml/llm/matterhorn/ProjectFileStructure$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n31#2,2:400\n1#3:402\n*S KotlinDebug\n*F\n+ 1 ProjectFileStructure.kt\ncom/intellij/ml/llm/matterhorn/ProjectFileStructure$Companion\n*L\n299#1:400,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public final void forEachFile(@NotNull ProjectStructureFolder $this$forEachFile, @NotNull Function1<? super ProjectStructureFile, Unit> processor) {
            Intrinsics.checkNotNullParameter((Object)$this$forEachFile, (String)"<this>");
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            for (ProjectStructureItem child : $this$forEachFile.getChildren()) {
                if (child instanceof ProjectStructureFolder) {
                    this.forEachFile((ProjectStructureFolder)child, processor);
                    continue;
                }
                if (!(child instanceof ProjectStructureFile)) continue;
                processor.invoke((Object)child);
            }
        }

        private final void apply(Project project, ProjectStructureFolder folder, VirtualFile projectFolder, boolean deleteRemainingFiles) {
            Object name;
            Logger logger = this.getLogger();
            String string = projectFolder.getPath();
            boolean bl = projectFolder.exists();
            String string2 = projectFolder.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            Path path = Paths.get(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            Iterator<ProjectStructureItem> iterator = path;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            logger.info("[Inner]Start applying: " + string + " is exist (by VFS) = " + bl + ", is exist (by NIO) = " + Files.exists((Path)((Object)iterator), Arrays.copyOf(linkOptionArray, linkOptionArray.length)));
            iterator = ArrayIteratorKt.iterator((Object[])projectFolder.getChildren());
            while (iterator.hasNext()) {
                VirtualFile projectFolderChild = (VirtualFile)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)projectFolderChild.getName(), (String)"getName(...)");
                if (ignoreFiles.contains(name) || ignoreFolders.contains(name)) continue;
                Intrinsics.checkNotNull((Object)projectFolderChild);
                if (this.isHiddenFolder(projectFolderChild) || folder.getChild((String)name) != null && (!VirtualFileUtil.isFile((VirtualFile)projectFolderChild) || !(folder.getChild((String)name) instanceof ProjectStructureFolder)) && (!projectFolderChild.isDirectory() || !(folder.getChild((String)name) instanceof ProjectStructureFile)) || !deleteRemainingFiles && !ProjectStateHelper.INSTANCE.getMatterhornProjectFolders().contains(name)) continue;
                this.getLogger().info("[Inner]Deleting child: " + projectFolderChild.getPath());
                projectFolderChild.delete((Object)this);
            }
            for (ProjectStructureItem child : folder.getChildren()) {
                Object object;
                VirtualFile newProjectFile;
                block9: {
                    block8: {
                        LinkOption[] linkOptionArray2;
                        Object object2;
                        if (child instanceof ProjectStructureFolder) {
                            this.getLogger().info("[Inner]Creating sub-folder for folder: " + projectFolder.getPath() + ", name = " + ((ProjectStructureFolder)child).getName());
                            Logger logger2 = this.getLogger();
                            String string3 = projectFolder.getPath();
                            String string4 = ((ProjectStructureFolder)child).getName();
                            VirtualFile virtualFile = projectFolder.findChild(((ProjectStructureFolder)child).getName());
                            Object object3 = virtualFile != null ? Boolean.valueOf(virtualFile.isValid()) : "not-valid";
                            String string5 = projectFolder.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
                            name = string5;
                            object2 = new String[]{((ProjectStructureFolder)child).getName()};
                            Path path2 = Paths.get((String)name, (String[])Arrays.copyOf(object2, ((VirtualFile[])object2).length));
                            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                            name = path2;
                            object2 = new LinkOption[]{};
                            logger2.info("[Inner#1] " + string3 + "/" + string4 + " is exist (by VFS) = " + object3 + ", is exist (by NIO) = " + Files.exists((Path)name, (LinkOption[])Arrays.copyOf(object2, ((VirtualFile[])object2).length)));
                            VirtualFile newProjectFolder = VirtualFileUtil.findOrCreateDirectory((VirtualFile)projectFolder, (String)((ProjectStructureFolder)child).getName());
                            Logger logger3 = this.getLogger();
                            String string6 = newProjectFolder.getPath();
                            boolean bl2 = newProjectFolder.exists();
                            String string7 = newProjectFolder.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getPath(...)");
                            Path path3 = Paths.get(string7, new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"get(...)");
                            object2 = path3;
                            linkOptionArray2 = new LinkOption[]{};
                            logger3.info("[Inner#2] " + string6 + " is exist (by VFS) = " + bl2 + ", is exist (by NIO) = " + Files.exists((Path)object2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)));
                            object2 = new VirtualFile[]{newProjectFolder};
                            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])object2);
                            Logger logger4 = this.getLogger();
                            String string8 = newProjectFolder.getPath();
                            boolean bl3 = newProjectFolder.exists();
                            String string9 = newProjectFolder.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getPath(...)");
                            Path path4 = Paths.get(string9, new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"get(...)");
                            object2 = path4;
                            linkOptionArray2 = new LinkOption[]{};
                            logger4.info("[Inner#3] " + string8 + " is exist (by VFS) = " + bl3 + ", is exist (by NIO) = " + Files.exists((Path)object2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)));
                            com.intellij.ml.llm.matterhorn.ProjectFileStructure$Companion.apply$default(this, project, (ProjectStructureFolder)child, newProjectFolder, false, 8, null);
                            continue;
                        }
                        if (child instanceof ProjectStructureFile) {
                            this.getLogger().info("[Inner]Creating file for folder: " + projectFolder.getPath() + ", name = " + ((ProjectStructureFile)child).getName());
                            newProjectFile = VirtualFileUtil.findOrCreateFile((VirtualFile)projectFolder, (String)((ProjectStructureFile)child).getName());
                            object2 = new VirtualFile[]{newProjectFile};
                            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])object2);
                            Logger logger5 = this.getLogger();
                            String string10 = newProjectFile.getPath();
                            boolean bl4 = newProjectFile.exists();
                            String string11 = newProjectFile.getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getPath(...)");
                            Path path5 = Paths.get(string11, new String[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"get(...)");
                            object2 = path5;
                            linkOptionArray2 = new LinkOption[]{};
                            logger5.info("[Inner] " + string10 + " is exist (by VFS) = " + bl4 + ", is exist (by NIO) = " + Files.exists((Path)object2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)));
                            this.getLogger().info("[Inner]Set contect for file for folder: " + projectFolder.getPath() + ", name = " + ((ProjectStructureFile)child).getName());
                            byte[] byArray = ((ProjectStructureFile)child).getContent().getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                            newProjectFile.setBinaryContent(byArray, -1L, -1L, (Object)child);
                            this.getLogger().info("[Inner]Finish Set contect for file for folder: " + projectFolder.getPath() + ", name = " + ((ProjectStructureFile)child).getName());
                            continue;
                        }
                        if (!(child instanceof ProjectStructureBinaryFile)) continue;
                        this.getLogger().info("[Inner]Creating file for folder: " + projectFolder.getPath() + ", name = " + ((ProjectStructureBinaryFile)child).getName());
                        newProjectFile = VirtualFileUtil.findOrCreateFile((VirtualFile)projectFolder, (String)((ProjectStructureBinaryFile)child).getName());
                        Logger logger6 = this.getLogger();
                        String string12 = newProjectFile.getPath();
                        boolean bl5 = newProjectFile.exists();
                        String string13 = newProjectFile.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getPath(...)");
                        Path path6 = Paths.get(string13, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"get(...)");
                        object2 = path6;
                        linkOptionArray2 = new LinkOption[]{};
                        logger6.info("[Inner] " + string12 + " is exist (by VFS) = " + bl5 + ", is exist (by NIO) = " + Files.exists((Path)object2, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)));
                        this.getLogger().info("[Inner]Set contect for file for folder: " + projectFolder.getPath() + ", name = " + ((ProjectStructureBinaryFile)child).getName());
                        object2 = new VirtualFile[]{newProjectFile};
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])object2);
                        ComponentManager $this$service$iv = (ComponentManager)project;
                        boolean $i$f$service = false;
                        Class<ArtifactRequestExecutorService> serviceClass$iv = ArtifactRequestExecutorService.class;
                        Object object4 = $this$service$iv.getService(serviceClass$iv);
                        if (object4 == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        ArtifactRequestExecutorService service = (ArtifactRequestExecutorService)object4;
                        object = ((ProjectStructureBinaryFile)child).getMediaContentId();
                        if (object == null) break block8;
                        String it = object;
                        boolean bl6 = false;
                        byte[] byArray = RootExecutionContextKt.findMediaFile(service.getProject(), it);
                        object = byArray;
                        if (byArray != null) break block9;
                    }
                    object = new byte[0];
                }
                Object binaryContent = object;
                newProjectFile.setBinaryContent((byte[])binaryContent, -1L, -1L, (Object)child);
                this.getLogger().info("[Inner]Finish Set contect for file for folder: " + projectFolder.getPath() + ", name = " + ((ProjectStructureBinaryFile)child).getName());
            }
            this.getLogger().info("[Inner]Finish applying: " + projectFolder.getPath());
        }

        static /* synthetic */ void apply$default(Companion companion, Project project, ProjectStructureFolder projectStructureFolder, VirtualFile virtualFile, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = true;
            }
            companion.apply(project, projectStructureFolder, virtualFile, bl);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isHiddenFolder(VirtualFile $this$isHiddenFolder) {
            if (!$this$isHiddenFolder.isDirectory()) return false;
            String string = $this$isHiddenFolder.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)".", (boolean)false, (int)2, null)) return false;
            return true;
        }

        private final void dumpProjectDirectoryStructure(ProjectStructureFolder folder, StringBuilder accumulator, boolean filterHiddenFolders, String indent) {
            for (ProjectStructureItem child : folder.getChildren()) {
                StringBuilder stringBuilder;
                if (filterHiddenFolders && StringsKt.startsWith$default((String)child.getName(), (String)".", (boolean)false, (int)2, null)) continue;
                if (child instanceof ProjectStructureFolder) {
                    StringBuilder stringBuilder2 = accumulator.append(indent + "- " + ((ProjectStructureFolder)child).getName() + "/");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
                    this.dumpProjectDirectoryStructure((ProjectStructureFolder)child, accumulator, filterHiddenFolders, indent + "  ");
                    stringBuilder = Unit.INSTANCE;
                    continue;
                }
                StringBuilder stringBuilder3 = accumulator.append(indent + "- " + child.getName());
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
                StringBuilder stringBuilder4 = stringBuilder3.append('\n');
                stringBuilder = stringBuilder4;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
            }
        }

        static /* synthetic */ void dumpProjectDirectoryStructure$default(Companion companion, ProjectStructureFolder projectStructureFolder, StringBuilder stringBuilder, boolean bl, String string, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                string = "";
            }
            companion.dumpProjectDirectoryStructure(projectStructureFolder, stringBuilder, bl, string);
        }

        private final void dumpProjectDirectoryFiles(ProjectStructureFolder folder, String folderPath, StringBuilder accumulator, boolean filterHiddenFolders) {
            for (ProjectStructureItem child : folder.getChildren()) {
                String path;
                String string = path = ((CharSequence)folderPath).length() == 0 ? child.getName() : folderPath + "/" + child.getName();
                if (child instanceof ProjectStructureFolder) {
                    if (filterHiddenFolders && StringsKt.startsWith$default((String)((ProjectStructureFolder)child).getName(), (String)".", (boolean)false, (int)2, null)) continue;
                    this.dumpProjectDirectoryFiles((ProjectStructureFolder)child, path, accumulator, filterHiddenFolders);
                    continue;
                }
                if (child instanceof ProjectStructureFile) {
                    Intrinsics.checkNotNullExpressionValue((Object)accumulator.append('\n'), (String)"append(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)accumulator.append('\n'), (String)"append(...)");
                    this.appendFileTo(accumulator, (ProjectStructureFile)child, path);
                    continue;
                }
                if (!(child instanceof ProjectStructureBinaryFile)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)accumulator.append('\n'), (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)accumulator.append('\n'), (String)"append(...)");
                this.appendBinaryFileTo(accumulator, path, (ProjectStructureBinaryFile)child);
            }
        }

        static /* synthetic */ void dumpProjectDirectoryFiles$default(Companion companion, ProjectStructureFolder projectStructureFolder, String string, StringBuilder stringBuilder, boolean bl, int n, Object object) {
            if ((n & 8) != 0) {
                bl = false;
            }
            companion.dumpProjectDirectoryFiles(projectStructureFolder, string, stringBuilder, bl);
        }

        public final void appendFileTo(@NotNull Appendable accumulator, @NotNull ProjectStructureFile file, @NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)accumulator, (String)"accumulator");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            String[] stringArray = new String[]{"."};
            String extension = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)file.getName(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            Map<String, String> map = this.getExtensionToLanguage();
            String string = extension.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String string2 = map.get(string);
            if (string2 == null) {
                string2 = "";
            }
            String language = string2;
            Appendable appendable = accumulator.append("FILE: " + filePath);
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
            if (StringsKt.contains$default((CharSequence)file.getContent(), (CharSequence)"```", (boolean)false, (int)2, null)) {
                Appendable appendable2 = accumulator.append("````" + language);
                Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append(...)");
                Appendable appendable3 = accumulator.append(file.getContent());
                Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
                Appendable appendable4 = accumulator.append("````");
                Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append(...)");
                Appendable appendable5 = appendable4.append('\n');
                v8 = appendable5;
                Intrinsics.checkNotNullExpressionValue((Object)appendable5, (String)"append(...)");
            } else {
                Appendable appendable6 = accumulator.append("```" + language);
                Intrinsics.checkNotNullExpressionValue((Object)appendable6, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable6.append('\n'), (String)"append(...)");
                Appendable appendable7 = accumulator.append(file.getContent());
                Intrinsics.checkNotNullExpressionValue((Object)appendable7, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)appendable7.append('\n'), (String)"append(...)");
                Appendable appendable8 = accumulator.append("```");
                Intrinsics.checkNotNullExpressionValue((Object)appendable8, (String)"append(...)");
                Appendable appendable9 = appendable8.append('\n');
                v8 = appendable9;
                Intrinsics.checkNotNullExpressionValue((Object)appendable9, (String)"append(...)");
            }
        }

        public final void appendBinaryFileTo(@NotNull Appendable accumulator, @NotNull String filePath, @NotNull ProjectStructureBinaryFile binaryFile) {
            Intrinsics.checkNotNullParameter((Object)accumulator, (String)"accumulator");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)binaryFile, (String)"binaryFile");
            Appendable appendable = accumulator.append("FILE: " + filePath + ", description: " + binaryFile.getDescription());
            Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        }

        @NotNull
        public final Map<String, String> getExtensionToLanguage() {
            return extensionToLanguage;
        }

        @NotNull
        public final KSerializer<ProjectFileStructure> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

