/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn;

import com.intellij.ml.llm.matterhorn.AgentContext;
import com.intellij.ml.llm.matterhorn.AgentSessionHistory;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.ExecutionContext;
import com.intellij.ml.llm.matterhorn.FileWithLine;
import com.intellij.ml.llm.matterhorn.run.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020%0$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0016R(\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0012\u001a\u0004\u0018\u00010\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R \u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lcom/intellij/ml/llm/matterhorn/SimpleExecutionAgentContext;", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "agentContext", "Lcom/intellij/ml/llm/matterhorn/AgentContext;", "executionContext", "Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "<init>", "(Lcom/intellij/ml/llm/matterhorn/AgentContext;Lcom/intellij/ml/llm/matterhorn/ExecutionContext;)V", "getExecutionContext", "()Lcom/intellij/ml/llm/matterhorn/ExecutionContext;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "value", "currentDir", "getCurrentDir", "setCurrentDir", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "Lcom/intellij/ml/llm/matterhorn/FileWithLine;", "currentScreenPosition", "getCurrentScreenPosition", "()Lcom/intellij/ml/llm/matterhorn/FileWithLine;", "setCurrentScreenPosition", "(Lcom/intellij/ml/llm/matterhorn/FileWithLine;)V", "executionEnvironment", "Lcom/intellij/ml/llm/matterhorn/run/ExecutionEnvironment;", "getExecutionEnvironment", "()Lcom/intellij/ml/llm/matterhorn/run/ExecutionEnvironment;", "pushChange", "", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "popChange", "getChanges", "()Ljava/util/List;", "sessionHistory", "Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "getSessionHistory", "()Lcom/intellij/ml/llm/matterhorn/AgentSessionHistory;", "ej-core"})
public final class SimpleExecutionAgentContext
implements ExecutionAgentContext {
    @NotNull
    private final AgentContext agentContext;
    @NotNull
    private final ExecutionContext executionContext;

    public SimpleExecutionAgentContext(@NotNull AgentContext agentContext, @NotNull ExecutionContext executionContext) {
        Intrinsics.checkNotNullParameter((Object)agentContext, (String)"agentContext");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        this.agentContext = agentContext;
        this.executionContext = executionContext;
    }

    @Override
    @NotNull
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.getExecutionContext().getRoot().getService().getProject();
    }

    @Override
    @NotNull
    public VirtualFile getProjectDir() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.getProject());
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile getCurrentDir() {
        return this.agentContext.getCurrentDir();
    }

    @Override
    public void setCurrentDir(@NotNull VirtualFile value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.agentContext.setCurrentDir(value);
    }

    @Override
    @Nullable
    public FileWithLine getCurrentScreenPosition() {
        return this.agentContext.getCurrentScreenPosition();
    }

    @Override
    public void setCurrentScreenPosition(@Nullable FileWithLine value) {
        this.agentContext.setCurrentScreenPosition(value);
    }

    @Override
    @NotNull
    public ExecutionEnvironment getExecutionEnvironment() {
        return this.agentContext.getExecutionEnvironment(this.getExecutionContext().getRoot());
    }

    @Override
    public void pushChange(@NotNull List<? extends Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        this.agentContext.pushChange(changes);
    }

    @Override
    @NotNull
    public List<Change> popChange() {
        return this.agentContext.popChange();
    }

    @Override
    @NotNull
    public List<List<Change>> getChanges() {
        return this.agentContext.getChanges();
    }

    @Override
    @NotNull
    public AgentSessionHistory getSessionHistory() {
        return this.agentContext.getSessionHistory();
    }
}

