/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.Result;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.ActionUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.FindFileAgentAction;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.ml.llm.matterhorn.run.PathConverter;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/FindFileAgentAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ej-core"})
public final class FindFileAgentAction
implements AgentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments;
    @NotNull
    private final String docstring;
    @NotNull
    public static final String FILE_NAME_ARGUMENT = "file_name";
    @NotNull
    public static final String DIR_ARGUMENT = "dir";

    public FindFileAgentAction() {
        this.name = "find_file";
        Object[] objectArray = new Argument[]{new Argument(FILE_NAME_ARGUMENT, ArgumentType.STRING, "the name of the file to search for", false, false, 24, null), new Argument(DIR_ARGUMENT, ArgumentType.STRING, "the directory to search in (if not provided, searches in the current directory)", true, false, 16, null)};
        this.arguments = CollectionsKt.listOf((Object[])objectArray);
        this.docstring = "finds all files with the given name in dir. If dir is not provided, searches in the current directory";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest var1_1, @NotNull ExecutionAgentContext var2_2, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var10_4 = $completion;
        if ((var10_4.label & -2147483648) != 0) {
            var10_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ FindFileAgentAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                StepMetadataKt.emitMetadata("Find in directory", StepType.Info, context);
                $continuation.L$0 = context;
                $continuation.label = 1;
                v0 = this.getInputParams((ActionRequest)request, (Continuation<? super Map<String, ParameterValue>>)$continuation);
                if (v0 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl23
            }
            case 1: {
                context = (ExecutionAgentContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                params = (Map)v0;
                v1 = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)params.get("file_name"));
                if (v1 == null) {
                    return "ERROR: File name parameter required.";
                }
                fileName = v1;
                v2 = (ParameterValue)params.get("dir");
                v3 = dirPath = v2 != null ? ActionUtilsKt.tryGetNonEmptyStringValue(v2) : null;
                if (dirPath == null) {
                    v4 = context.getCurrentDir();
                } else {
                    directory = AgentUtilsKt.locateDirectory(dirPath, context.getCurrentDir(), context.getExecutionEnvironment().getPathConverter());
                    if (directory instanceof Result.Err) {
                        return ((Result.Err)directory).getMessage();
                    }
                    if (directory instanceof Result.Ok) {
                        v4 = (VirtualFile)((Result.Ok)directory).getValue();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                searchDir = v4;
                if (!VfsUtilCore.isAncestor((VirtualFile)context.getProjectDir(), (VirtualFile)searchDir, (boolean)false)) {
                    return "ERROR: Target directory is outside of the project directory";
                }
                $continuation.L$0 = null;
                $continuation.label = 2;
                v5 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(com.intellij.openapi.vfs.VirtualFile java.lang.String com.intellij.ml.llm.matterhorn.ExecutionAgentContext ), ()Ljava/lang/String;)((VirtualFile)searchDir, (String)fileName, (ExecutionAgentContext)context), (Continuation)$continuation);
                if (v5 == var11_6) {
                    return var11_6;
                }
                ** GOTO lbl52
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl52:
                // 2 sources

                return v5;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return AgentAction.DefaultImpls.getCustomSignature(this);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }

    private static final String execute$lambda$0(VirtualFile $searchDir, String $fileName, ExecutionAgentContext $context) {
        return Companion.findInDirectory($searchDir, $fileName, $context.getProject(), $context.getExecutionEnvironment().getPathConverter());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/FindFileAgentAction$Companion;", "", "<init>", "()V", "FILE_NAME_ARGUMENT", "", "DIR_ARGUMENT", "findInDirectory", "searchDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileName", "project", "Lcom/intellij/openapi/project/Project;", "pathConverter", "Lcom/intellij/ml/llm/matterhorn/run/PathConverter;", "ej-core"})
    @SourceDebugExtension(value={"SMAP\nFindFileAgentAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindFileAgentAction.kt\ncom/intellij/ml/llm/matterhorn/actions/FindFileAgentAction$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1557#2:92\n1628#2,3:93\n*S KotlinDebug\n*F\n+ 1 FindFileAgentAction.kt\ncom/intellij/ml/llm/matterhorn/actions/FindFileAgentAction$Companion\n*L\n43#1:92\n43#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @RequiresReadLock
        @NotNull
        public final String findInDirectory(@NotNull VirtualFile searchDir, @NotNull String fileName, @NotNull Project project, @NotNull PathConverter pathConverter) {
            String string;
            Intrinsics.checkNotNullParameter((Object)searchDir, (String)"searchDir");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)pathConverter, (String)"pathConverter");
            List matches = new ArrayList();
            VfsUtilCore.iterateChildrenRecursively((VirtualFile)searchDir, null, arg_0 -> Companion.findInDirectory$lambda$0(fileName, matches, arg_0));
            Path path = searchDir.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
            ExecutionPath searchPath = pathConverter.convertLocalPathToExecutionPath(new LocalPath(path));
            if (matches.isEmpty()) {
                string = "No matches found for \"" + fileName + "\" in " + searchPath;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int numMatches = matches.size();
                Iterable iterable = matches;
                boolean $i$f$map = false;
                void var11_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Path path2 = it.toNioPath();
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toNioPath(...)");
                    collection.add(pathConverter.convertLocalPathToExecutionPath(new LocalPath(path2)).toString());
                }
                String matchList = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                string = "Found " + numMatches + " matches for \"" + fileName + "\" in " + searchPath + ":\n" + matchList;
            }
            return string;
        }

        private static final boolean findInDirectory$lambda$0(String $fileName, List $matches, VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!file.isDirectory() && Intrinsics.areEqual((Object)file.getName(), (Object)$fileName)) {
                $matches.add(file);
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

