/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.actions;

import com.intellij.ml.llm.matterhorn.AgentAction;
import com.intellij.ml.llm.matterhorn.Argument;
import com.intellij.ml.llm.matterhorn.ExecutionAgentContext;
import com.intellij.ml.llm.matterhorn.Result;
import com.intellij.ml.llm.matterhorn.StepMetadataKt;
import com.intellij.ml.llm.matterhorn.StepType;
import com.intellij.ml.llm.matterhorn.actions.ActionRequest;
import com.intellij.ml.llm.matterhorn.actions.ActionUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.AgentUtilsKt;
import com.intellij.ml.llm.matterhorn.actions.GetFileStructureAction;
import com.intellij.ml.llm.matterhorn.actions.StringUtilKt;
import com.intellij.ml.llm.matterhorn.llm.ArgumentType;
import com.intellij.ml.llm.matterhorn.llm.ParameterValue;
import com.intellij.ml.llm.matterhorn.relevance.extractors.ElementProvider;
import com.intellij.ml.llm.matterhorn.relevance.extractors.ExtractorUtilsKt;
import com.intellij.ml.llm.matterhorn.relevance.extractors.FormatHierarchyParams;
import com.intellij.ml.llm.matterhorn.run.ExecutionPath;
import com.intellij.ml.llm.matterhorn.run.LocalPath;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u001c\u0010\u0015\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0083@\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/GetFileStructureAction;", "Lcom/intellij/ml/llm/matterhorn/AgentAction;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "arguments", "", "Lcom/intellij/ml/llm/matterhorn/Argument;", "getArguments", "()Ljava/util/List;", "docstring", "getDocstring", "execute", "request", "Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;", "context", "Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;", "(Lcom/intellij/ml/llm/matterhorn/actions/ActionRequest;Lcom/intellij/ml/llm/matterhorn/ExecutionAgentContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "format", "elements", "Lcom/intellij/psi/PsiElement;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "ej-core"})
public final class GetFileStructureAction
implements AgentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final List<Argument> arguments = CollectionsKt.listOf((Object)new Argument("file", ArgumentType.STRING, "the path to the file", false, false, 24, null));
    @NotNull
    private final String docstring;
    public static final int SMALL_FILE_LIMIT = 200;
    @NotNull
    public static final String FAIL_STRUCTURE_MESSAGE = "It's not possible to display the file structure; either the file type is not supported, or parsing failed.";
    @NotNull
    public static final String GET_FILE_STRUCTURE_ACTION_NAME = "get_file_structure";
    @NotNull
    public static final String FILE_ARGUMENT = "file";

    public GetFileStructureAction() {
        this.name = GET_FILE_STRUCTURE_ACTION_NAME;
        this.docstring = "Displaying the code structure of the specified file by listing definitions for all symbols (classes, methods, functions) , along with import statements.\nIf [Tag: FileCode] or [Tag: FileStructure] is not provided for the file, it's important to explore its structure before opening or editing it. \nFor each symbol, input-output parameters and line ranges will be provided. This information will help you navigate the file more effectively and ensure you don't overlook any part of the code.";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @NotNull
    public String getDocstring() {
        return this.docstring;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object execute(@NotNull ActionRequest var1_1, @NotNull ExecutionAgentContext var2_2, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var20_4 = $completion;
        if ((var20_4.label & -2147483648) != 0) {
            var20_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ GetFileStructureAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var21_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                StepMetadataKt.emitMetadata("Get structure", StepType.Info, context);
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.label = 1;
                v0 = this.getInputParams((ActionRequest)request, (Continuation<? super Map<String, ParameterValue>>)$continuation);
                if (v0 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (GetFileStructureAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                params = (Map)v0;
                v1 = ActionUtilsKt.tryGetNonEmptyStringValue((ParameterValue)params.get("file"));
                if (v1 == null) {
                    return "ERROR: File parameter required.";
                }
                fileName = v1;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.label = 2;
                v2 = AgentUtilsKt.smartLocateFile$default(fileName, context, false, (Continuation)$continuation, 4, null);
                if (v2 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl42
            }
            case 2: {
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (GetFileStructureAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl42:
                // 2 sources

                if ((res = (Result)v2) instanceof Result.Err) {
                    return ((Result.Err)res).getMessage();
                }
                if (!(res instanceof Result.Ok)) {
                    throw new NoWhenBranchMatchedException();
                }
                file = (VirtualFile)((Result.Ok)res).getValue();
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = file;
                $continuation.label = 3;
                v3 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$0(com.intellij.ml.llm.matterhorn.ExecutionAgentContext com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/psi/PsiFile;)((ExecutionAgentContext)context, (VirtualFile)file), (Continuation)$continuation);
                if (v3 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl61
            }
            case 3: {
                file = (VirtualFile)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (GetFileStructureAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl61:
                // 2 sources

                v4 = (PsiFile)v3;
                if (v4 == null) {
                    return "ERROR: Could not find PSI for file";
                }
                psiFile = v4;
                if (!VfsUtilCore.isAncestor((VirtualFile)context.getProjectDir(), (VirtualFile)psiFile.getVirtualFile(), (boolean)false)) {
                    return "ERROR: Target file is outside of the project directory";
                }
                v5 = context.getExecutionEnvironment().getPathConverter();
                v6 = file.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toNioPath(...)");
                filePath = v5.convertLocalPathToExecutionPath(new LocalPath(v6));
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = file;
                $continuation.L$3 = psiFile;
                $continuation.L$4 = filePath;
                $continuation.label = 4;
                v7 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$1(com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/openapi/editor/Document;)((VirtualFile)file), (Continuation)$continuation);
                if (v7 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl89
            }
            case 4: {
                filePath = (ExecutionPath)$continuation.L$4;
                psiFile = (PsiFile)$continuation.L$3;
                file = (VirtualFile)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (GetFileStructureAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v7 = $result;
lbl89:
                // 2 sources

                v8 = document = (Document)v7;
                v9 = documentLineCount = v8 != null ? v8.getLineCount() : 0;
                if (documentLineCount >= 200) break;
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 5;
                v10 = AgentUtilsKt.printScreen$default(context.getProject(), file, 1, 200, context.getExecutionEnvironment().getPathConverter(), null, (Continuation)$continuation, 32, null);
                if (v10 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl105
            }
            case 5: {
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl105:
                // 2 sources

                fullFile = (String)v10;
                return "Since the requested file is small, we will display the entire content.\n\n" + fullFile;
            }
        }
        fileNameToStructure = "[File: " + filePath + " (" + documentLineCount + " lines total)]";
        $continuation.L$0 = this;
        $continuation.L$1 = context;
        $continuation.L$2 = psiFile;
        $continuation.L$3 = filePath;
        $continuation.L$4 = fileNameToStructure;
        $continuation.label = 6;
        v11 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$2(com.intellij.psi.PsiFile ), ()Ljava/lang/String;)((PsiFile)psiFile), (Continuation)$continuation);
        if (v11 == var21_6) {
            return var21_6;
        }
        ** GOTO lbl126
        {
            case 6: {
                fileNameToStructure = (String)$continuation.L$4;
                filePath = (ExecutionPath)$continuation.L$3;
                psiFile = (PsiFile)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (GetFileStructureAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl126:
                // 2 sources

                importStatementsTagged = StringsKt.isBlank((CharSequence)(importStatements = (String)v11)) != false ? "" : "##### Imports\n" + importStatements;
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = filePath;
                $continuation.L$3 = fileNameToStructure;
                $continuation.L$4 = importStatementsTagged;
                $continuation.label = 7;
                v12 = CoroutinesKt.smartReadAction((Project)context.getProject(), (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, execute$lambda$3(com.intellij.psi.PsiFile ), ()Ljava/util/List;)((PsiFile)psiFile), (Continuation)$continuation);
                if (v12 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl145
            }
            case 7: {
                importStatementsTagged = (String)$continuation.L$4;
                fileNameToStructure = (String)$continuation.L$3;
                filePath = (ExecutionPath)$continuation.L$2;
                context = (ExecutionAgentContext)$continuation.L$1;
                this = (GetFileStructureAction)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl145:
                // 2 sources

                elements = (List)v12;
                $continuation.L$0 = context;
                $continuation.L$1 = filePath;
                $continuation.L$2 = fileNameToStructure;
                $continuation.L$3 = importStatementsTagged;
                $continuation.L$4 = null;
                $continuation.label = 8;
                v13 = this.format(elements, (Continuation<? super String>)$continuation);
                if (v13 == var21_6) {
                    return var21_6;
                }
                ** GOTO lbl163
            }
            case 8: {
                importStatementsTagged = (String)$continuation.L$3;
                fileNameToStructure = (String)$continuation.L$2;
                filePath = (ExecutionPath)$continuation.L$1;
                context = (ExecutionAgentContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl163:
                // 2 sources

                if (var17_20 = StringsKt.isBlank((CharSequence)(fileStructure = (String)v13))) {
                    v14 = "It's not possible to display the file structure; either the file type is not supported, or parsing failed.";
                } else if (!var17_20) {
                    v14 = "##### Structure\n" + fileStructure;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                fileStructureTagged = v14;
                formatOfFileStructure = StringsKt.isBlank((CharSequence)fileStructure) == true ? "" : "##### Annotation \nEach line contains information about a single symbol (class, method, function) and its parent symbols. For each symbol, the start and end lines are provided. To view the code of a specific symbol, add the start line number to the open command following the file path.";
                context.getSessionHistory().markViewedFile(filePath);
                var18_23 = new String[]{"#### File structure [Tag: FileStructure]", fileNameToStructure, StringUtilKt.nullIfEmpty((String)importStatementsTagged), StringUtilKt.nullIfEmpty(fileStructureTagged), formatOfFileStructure};
                return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])var18_23), (CharSequence)"\n\n", null, null, (int)0, null, null, (int)62, null);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @RequiresReadLock
    private final Object format(List<? extends PsiElement> var1_1, Continuation<? super String> $completion) {
        if (!($completion instanceof format.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ GetFileStructureAction this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GetFileStructureAction.access$format(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                builder = new StringBuilder();
                $continuation.L$0 = builder;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, format$lambda$5(java.util.List java.lang.StringBuilder ), ()Lkotlin/Unit;)((List)elements, (StringBuilder)builder), (Continuation)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                builder = (StringBuilder)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                v1 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toString(...)");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @NotNull
    public String getCustomSignature() {
        return AgentAction.DefaultImpls.getCustomSignature(this);
    }

    @Override
    @Nullable
    public Object getInputParams(@NotNull ActionRequest $this$getInputParams, @NotNull Continuation<? super Map<String, ParameterValue>> $completion) {
        return AgentAction.DefaultImpls.getInputParams(this, $this$getInputParams, $completion);
    }

    @Override
    @Nullable
    public Object reviewActionRequest(@NotNull ActionRequest request2, @NotNull ExecutionAgentContext context2, @NotNull Continuation<? super String> $completion) {
        return AgentAction.DefaultImpls.reviewActionRequest(this, request2, context2, $completion);
    }

    private static final PsiFile execute$lambda$0(ExecutionAgentContext $context, VirtualFile $file) {
        return PsiManager.getInstance((Project)$context.getProject()).findFile($file);
    }

    private static final Document execute$lambda$1(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    private static final String execute$lambda$2(PsiFile $psiFile) {
        return ElementProvider.Companion.getImportStatements($psiFile);
    }

    private static final List execute$lambda$3(PsiFile $psiFile) {
        return ElementProvider.Companion.extractElements($psiFile);
    }

    private static final Unit format$lambda$5$lambda$4(StringBuilder $builder, PsiElement psiElement, String text) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (((CharSequence)text).length() > 0) {
            StringBuilder stringBuilder = $builder.append(text);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append(...)");
        }
        return Unit.INSTANCE;
    }

    private static final Unit format$lambda$5(List $elements, StringBuilder $builder) {
        ExtractorUtilsKt.formatHierarchy($elements, new FormatHierarchyParams(true, null, 2, null), (Function2<? super PsiElement, ? super String, Unit>)((Function2)(arg_0, arg_1) -> GetFileStructureAction.format$lambda$5$lambda$4($builder, arg_0, arg_1)));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$format(GetFileStructureAction $this, List elements, Continuation $completion) {
        return $this.format(elements, (Continuation<? super String>)$completion);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/matterhorn/actions/GetFileStructureAction$Companion;", "", "<init>", "()V", "SMALL_FILE_LIMIT", "", "FAIL_STRUCTURE_MESSAGE", "", "GET_FILE_STRUCTURE_ACTION_NAME", "FILE_ARGUMENT", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

