/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.matterhorn.services;

import com.intellij.ml.llm.matterhorn.services.search.AbstractProjectSearcher;
import com.intellij.ml.llm.matterhorn.services.search.ClassProjectSearcher;
import com.intellij.ml.llm.matterhorn.services.search.FileProjectSearcher;
import com.intellij.ml.llm.matterhorn.services.search.SearchQuery;
import com.intellij.ml.llm.matterhorn.services.search.SearchResultItem;
import com.intellij.ml.llm.matterhorn.services.search.SymbolProjectSearcher;
import com.intellij.ml.llm.matterhorn.services.search.TextProjectSearcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "search", "", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchResultItem;", "query", "Lcom/intellij/ml/llm/matterhorn/services/search/SearchQuery;", "searchType", "Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$SearchType;", "(Lcom/intellij/ml/llm/matterhorn/services/search/SearchQuery;Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$SearchType;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "detectSearchTypes", "dispose", "", "SearchType", "Companion", "ej-core"})
@SourceDebugExtension(value={"SMAP\nProjectSearchEverywhereService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSearchEverywhereService.kt\ncom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n774#2:53\n865#2,2:54\n1#3:56\n*S KotlinDebug\n*F\n+ 1 ProjectSearchEverywhereService.kt\ncom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService\n*L\n47#1:53\n47#1:54,2\n*E\n"})
public final class ProjectSearchEverywhereService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public ProjectSearchEverywhereService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final Object search(@NotNull SearchQuery query, @NotNull SearchType searchType, @NotNull Continuation<? super List<SearchResultItem>> $completion) {
        AbstractProjectSearcher searcher = ProjectSearchEverywhereService.Companion.getSearcher(this.project, searchType);
        return searcher.search(query, this, $completion);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SearchType> detectSearchTypes(@NotNull SearchQuery query) {
        Collection collection;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        SearchType[] $this$filter$iv = (SearchType[])SearchType.getEntries();
        boolean $i$f$filter = false;
        SearchType[] searchTypeArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            SearchType it = (SearchType)((Object)element$iv$iv);
            boolean bl = false;
            if (!ProjectSearchEverywhereService.Companion.getSearcher(this.project, it).detectSearchQuery(query)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredTypes = (List)destination$iv$iv;
        Collection collection2 = filteredTypes;
        if (collection2.isEmpty()) {
            boolean bl = false;
            searchTypeArray = new SearchType[]{SearchType.FILES, SearchType.CLASSES, SearchType.SYMBOLS, SearchType.TEXT};
            collection = CollectionsKt.listOf((Object[])searchTypeArray);
        } else {
            collection = collection2;
        }
        return (List)collection;
    }

    public void dispose() {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$Companion;", "", "<init>", "()V", "getSearcher", "Lcom/intellij/ml/llm/matterhorn/services/search/AbstractProjectSearcher;", "project", "Lcom/intellij/openapi/project/Project;", "searchType", "Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$SearchType;", "ej-core"})
    public static final class Companion {
        private Companion() {
        }

        private final AbstractProjectSearcher getSearcher(Project project, SearchType searchType) {
            return switch (WhenMappings.$EnumSwitchMapping$0[searchType.ordinal()]) {
                case 1 -> new FileProjectSearcher(project, false);
                case 2 -> new FileProjectSearcher(project, true);
                case 3 -> new ClassProjectSearcher(project);
                case 4 -> new SymbolProjectSearcher(project);
                case 5 -> new TextProjectSearcher(project);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[SearchType.values().length];
                try {
                    nArray[SearchType.FILES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SearchType.FILES_OR_DIRECTORIES.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SearchType.CLASSES.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SearchType.SYMBOLS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[SearchType.TEXT.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/ml/llm/matterhorn/services/ProjectSearchEverywhereService$SearchType;", "", "<init>", "(Ljava/lang/String;I)V", "FILES", "FILES_OR_DIRECTORIES", "CLASSES", "SYMBOLS", "TEXT", "ej-core"})
    public static final class SearchType
    extends Enum<SearchType> {
        public static final /* enum */ SearchType FILES = new SearchType();
        public static final /* enum */ SearchType FILES_OR_DIRECTORIES = new SearchType();
        public static final /* enum */ SearchType CLASSES = new SearchType();
        public static final /* enum */ SearchType SYMBOLS = new SearchType();
        public static final /* enum */ SearchType TEXT = new SearchType();
        private static final /* synthetic */ SearchType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SearchType[] values() {
            return (SearchType[])$VALUES.clone();
        }

        public static SearchType valueOf(String value) {
            return Enum.valueOf(SearchType.class, value);
        }

        @NotNull
        public static EnumEntries<SearchType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = searchTypeArray = new SearchType[]{SearchType.FILES, SearchType.FILES_OR_DIRECTORIES, SearchType.CLASSES, SearchType.SYMBOLS, SearchType.TEXT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

